LOCAL_PATH:= $(call my-dir)

include $(CLEAR_VARS)

LOCAL_C_INCLUDES += $(LOCAL_PATH)/../include
LOCAL_C_INCLUDES += $(LOCAL_PATH)/../include/zbar
LOCAL_C_INCLUDES += $(LOCAL_PATH)/../lib/libiconv
LOCAL_C_INCLUDES += external/jpeg


LOCAL_SRC_FILES += config.c \
                   error.c \
                   symbol.c \
                   image.c \
                   convert.c \
                   processor.c \
                   processor/lock.c \
                   refcnt.c \
                   window.c \
                   video.c \
                   img_scanner.c \
                   scanner.c \
                   decoder.c \
		   svg.c

####################### ignore_s #######################

ifdef ENABLE_EAN
    LOCAL_SRC_FILES += decoder/ean.c
endif

ifdef ENABLE_CODE128
    LOCAL_SRC_FILES += decoder/code128.c
endif

ifdef ENABLE_CODE39
    LOCAL_SRC_FILES += decoder/code39.c
endif

ifdef ENABLE_I25
    LOCAL_SRC_FILES += decoder/i25.c
endif

ifdef ENABLE_PDF417
    LOCAL_SRC_FILES += decoder/pdf417.c
endif
####################### ignore_e #######################

#ifdef ENABLE_QRCODE
    LOCAL_SRC_FILES += decoder/qr_finder.c \
                       qrcode/qrdec.c \
                       qrcode/qrdectxt.c \
                       qrcode/rs.c \
                       qrcode/isaac.c \
                       qrcode/bch15_5.c \
                       qrcode/binarize.c \
                       qrcode/util.c
#endif

ifdef WIN32
####################### ignore_s #######################
    LOCAL_SRC_FILES += processor/win.c
    #LOCAL_SRC_FILES += libzbar.rc
    #zbar_libzbar_la_CPPFLAGS += -mthreads
    #zbar_libzbar_la_LDFLAGS += -mthreads
    # FIXME broken
    #zbar_libzbar_la_LIBADD += libzbar-rc.lo
####################### ignore_e #######################
else
    LOCAL_SRC_FILES += processor/posix.c
endif

####################### ignore_s #######################
ifeq ($(L_OS_TARGET), 1)
ifdef HAVE_V4L1
    LOCAL_SRC_FILES += video/v4l1.c
    ifdef HAVE_V4L2
        LOCAL_SRC_FILES += video/v4l2.c
    endif
endif
else
LOCAL_SRC_FILES += video/v4l1.c
LOCAL_SRC_FILES += video/v4l2.c
endif

ifdef WIN32
    ifdef HAVE_VIDEO
        LOCAL_SRC_FILES += video/vfw.c
        #zbar_libzbar_la_LIBADD += -lvfw32
    endif
endif
####################### ignore_e #######################
ifeq ($(L_OS_TARGET), 1)
ifndef HAVE_VIDEO
    LOCAL_SRC_FILES += video/null.c
endif
endif
####################### ignore_s #######################
#ifdef HAVE_JPEG
    LOCAL_SRC_FILES += jpeg.c
#endif
####################### ignore_e #######################

ifdef HAVE_X
####################### ignore_s #######################
    LOCAL_SRC_FILES +=  processor/x.c \
                        window/x.c \
                        window/ximage.c

    #zbar_libzbar_la_CPPFLAGS += $(X_CFLAGS)
    #zbar_libzbar_la_LDFLAGS += $(X_LIBS)
    #zbar_libzbar_la_LIBADD += $(X_PRE_LIBS) -lX11 $(X_EXTRA_LIBS)
    ifdef HAVE_XV
        LOCAL_SRC_FILES += window/xv.c
        #zbar_libzbar_la_LIBADD += $(XV_LIBS)
    endif
####################### ignore_e #######################
else
    ifdef WIN32
####################### ignore_s #######################
        LOCAL_SRC_FILES += window/win.c \
                           window/dib.c
        #                  window/vfw.c -lvfw32
        #zbar_libzbar_la_LIBADD += -lgdi32 -lwinmm
####################### ignore_e #######################
    else
        LOCAL_SRC_FILES += processor/null.c \
                           window/null.c
    endif
endif


LOCAL_SHARED_LIBRARIES += libutils \
                          libcutils \
						  libjpeg

LOCAL_C_INCLUDES += system/core/include/cutils
LOCAL_C_INCLUDES += system/core/include/utils

LOCAL_STATIC_LIBRARIES += libiconv

LOCAL_CFLAGS := -I$(LOCAL_PATH) -I$(LOCAL_PATH)/libiconv
LOCAL_LDLIBS := -llog -ljpeg

ifneq ($(L_OS_TARGET),1)
LOCAL_LDLIBS += -lpthread
endif

LOCAL_MODULE := libzbar
LOCAL_MODULE_TAGS := optional
LOCAL_MODULE_OWNER := lge
LOCAL_MODULE_PATH := $(TARGET_FACTORY_RAMDISK_OUT)/vendor/factory_lib

include $(BUILD_SHARED_LIBRARY)

