#ifndef __MQRSPEC_H__
#define __MQRSPEC_H__

#include "qrencode.h"

#define MQRSPEC_WIDTH_MAX 17

extern int MQRspec_getDataLengthBit(int version, QRecLevel level);
extern int MQRspec_getDataLength(int version, QRecLevel level);
extern int MQRspec_getECCLength(int version, QRecLevel level);
extern int MQRspec_getMinimumVersion(int size, QRecLevel level);
extern int MQRspec_getWidth(int version);
extern int MQRspec_getRemainder(int version);
extern int MQRspec_lengthIndicator(QRencodeMode mode, int version);
extern int MQRspec_maximumWords(QRencodeMode mode, int version);
extern unsigned int MQRspec_getVersionPattern(int version);
extern unsigned int MQRspec_getFormatInfo(int mask, int version, QRecLevel level);
extern unsigned char *MQRspec_newFrame(int version);
extern void MQRspec_clearCache(void);

#define MQRSPEC_MODEID_NUM       0
#define MQRSPEC_MODEID_AN        1
#define MQRSPEC_MODEID_8         2
#define MQRSPEC_MODEID_KANJI     3

#endif /* __MQRSPEC_H__ */
