
/*
Copyright Â© 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, European Research Consortium 
for Informatics and Mathematics, Keio University). All 
Rights Reserved. This work is distributed under the W3CÂ® Software License [1] in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even 
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 

[1] http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231
*/



   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
function getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/html/HTMLFrameElement09";
   }

var docsLoaded = -1000000;
var builder = null;

//
//   This function is called by the testing framework before
//      running the test suite.
//
//   If there are no configuration exceptions, asynchronous
//        document loading is started.  Otherwise, the status
//        is set to complete and the exception is immediately
//        raised when entering the body of the test.
//
function setUpPage() {
   setUpPageStatus = 'running';
   try {
     //
     //   creates test document builder, may throw exception
     //
     builder = createConfiguredBuilder();

      docsLoaded = 0;
      
      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      docsLoaded += preload(docRef, "doc", "frame2");
        
       if (docsLoaded == 1) {
         // WebKit fix: corrected variable name from 'setUpPage':
         // <http://bugs.webkit.org/show_bug.cgi?id=21506>
          setUpPageStatus = 'complete';
       }
    } catch(ex) {
        catchInitializationError(builder, ex);
         // WebKit fix: corrected variable name from 'setUpPage':
         // <http://bugs.webkit.org/show_bug.cgi?id=21506>
        setUpPageStatus = 'complete';
    }
}



//
//   This method is called on the completion of 
//      each asychronous load started in setUpTests.
//
//   When every synchronous loaded document has completed,
//      the page status is changed which allows the
//      body of the test to be executed.
function loadComplete() {
    if (++docsLoaded == 1) {
        setUpPageStatus = 'complete';
    }
}


/**
* 
    The contentDocument attribute specifies the document this frame contains,
    if there is any and it is available, or null otherwise.

    Retrieve the contentDocument attribute of the first FRAME element
    and examine its TITLE value.  

* @author NIST
* @author Rick Rivello
* @see http://www.w3.org/TR/DOM-Level-2-HTML/html#ID-78799536
*/
function HTMLFrameElement09() {
   var success;
    if(checkInitialization(builder, "HTMLFrameElement09") != null) return;
    var testNode;
      var cd;
      var vtitle;
      var doc;
      
      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "frame2");
      testNode = doc.getElementById("Frame1");
      cd = testNode.contentDocument;

      vtitle = cd.title;

      assertEquals("titleLink","NIST DOM HTML Test - FRAMESET",vtitle);
       
}




function runTest() {
   HTMLFrameElement09();
}
