/* Code to save the iptables state, in human readable-form. */
/* (C) 1999 by Paul 'Rusty' Russell <rusty@rustcorp.com.au> and
 * (C) 2000-2002 by Harald Welte <laforge@gnumonks.org>
 *
 * This code is distributed under the terms of GNU GPL v2
 *
 */
#include <getopt.h>
#include <sys/errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <netdb.h>
#include "libiptc/libiptc.h"
#include "iptables.h"
#include "iptables-multi.h"

#ifndef NO_SHARED_LIBS
#include <dlfcn.h>
#endif

static int show_binary = 0, show_counters = 0;




static int for_save_table()
{
	int ret = 1;
	FILE *procfile = NULL;
	char tablename[] ="filter";
	const char *returnvalue =NULL;
	time_t now = time(NULL);
	const char *target_name;

	procfile = fopen("/data/ip_tables_save_temp", "w+");
	if (!procfile)
		return ret;


	struct iptc_handle *h;
	const char *chain = NULL;

	h = iptc_init(tablename);
	if (h == NULL) {
		xtables_load_ko(xtables_modprobe_program, false);
		h = iptc_init(tablename);
	}
	if (!h)
		xtables_error(OTHER_PROBLEM, "Cannot initialize: %s\n",
			   iptc_strerror(errno));

		printf("# for_save_table...LGE \n");

		/* Dump out chain names first,
		 * thereby preventing dependency conflicts */

		for (chain = iptc_first_chain(h);
		     chain;
		     chain = iptc_next_chain(h)) {
			const struct ipt_entry *e;

			printf(":%s\n ", chain);
			if(!strcmp(chain,"OUTPUT")){

				/* Dump out rules */
				e = iptc_first_rule(chain, h);
				while(e) {
						target_name = iptc_get_target(e, h);
						
						if(!strcmp(target_name,"DROP")){
							printf("target :%s\n ", target_name);
							printf("out_iface :%s\n ", e->ip.outiface);
							fprintf(procfile,"%s\t%s\n", target_name, e->ip.outiface);
							
						}
						e = iptc_next_rule(e, h);
				}
			}	
		}

	//fputs(returnvalue, procfile);

	iptc_free(h);

	fclose(procfile);
	return ret;
}


#ifdef IPTABLES_MULTI
int
iptables_ds_save_main(int argc, char *argv[])
#else
int
main(int argc, char *argv[])
#endif
{
	const char *tablename = NULL;
	int c;


	if (optind < argc) {
		fprintf(stderr, "Unknown arguments found on commandline\n");
		exit(1);
	}

	c = for_save_table();
	
	return c;
}
