/*****************************************************************************
	Copyright(c) 2013 FCI Inc. All Rights Reserved

	File name : fc8080_bb.h

	Description : baseband header file

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

	History :
	----------------------------------------------------------------------
*******************************************************************************/

#ifndef __FC8080_BB_H__
#define __FC8080_BB_H__

#ifdef __cplusplus
extern "C" {
#endif

extern fci_s32 fc8080_reset(HANDLE handle);
extern fci_s32 fc8080_probe(HANDLE handle);
extern fci_s32 fc8080_init(HANDLE handle);
extern fci_s32 fc8080_deinit(HANDLE handle);
extern fci_s32 fc8080_scan_status(HANDLE handle);
extern fci_s32 fc8080_channel_select(HANDLE handle, fci_u8 subch_id, fci_u8 buf_id);
extern fci_s32 fc8080_video_select(HANDLE handle, fci_u8 subch_id, fci_u8 buf_id,
				fci_u8 cdi_id);
extern fci_s32 fc8080_audio_select(HANDLE handle, fci_u8 subch_id, fci_u8 buf_id);
extern fci_s32 fc8080_data_select(HANDLE handle, fci_u8 subch_id, fci_u8 buf_id);
extern fci_s32 fc8080_channel_deselect(HANDLE handle, fci_u8 subch_id, fci_u8 buf_id);
extern fci_s32 fc8080_video_deselect(HANDLE handle, fci_u8 subch_id, fci_u8 buf_id,
					fci_u8 cdi_id);
extern fci_s32 fc8080_audio_deselect(HANDLE handle, fci_u8 subch_id, fci_u8 buf_id);
extern fci_s32 fc8080_data_deselect(HANDLE handle, fci_u8 subch_id, fci_u8 buf_id);

#ifdef __cplusplus
}
#endif

#endif /* __FC8080_BB_H__ */

