#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {2296, 2317, 2315, 2306, 2292},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{1173, 372, 100, 72, 66},
				{1143, 375, 102, 74, 67},
				{1146, 374, 102, 73, 67},
				{1115, 374, 105, 75, 67},
				{1093, 370, 109, 77, 68},
				{1082, 363, 115, 81, 70},
				{1078, 361, 125, 86, 74},
				{1076, 358, 124, 93, 79},
				{1078, 358, 112, 86, 75},
				{1087, 362, 103, 76, 69},
				{1112, 369, 104, 77, 68},
				{1152, 381, 106, 79, 70},
				{1231, 396, 110, 81, 73},
				{1408, 412, 114, 81, 73},
				{1676, 423, 119, 79, 70},
				{2028, 429, 124, 80, 70},
				{2558, 440, 126, 83, 71},
				{3238, 468, 132, 87, 75},
				{4006, 506, 156, 98, 83},
				{4613, 531, 169, 108, 91},
				{5063, 539, 168, 113, 95},
				{5583, 548, 168, 119, 100},
				{6102, 558, 167, 124, 104},
				{6798, 574, 168, 126, 108},
				{7657, 582, 169, 128, 112},
				{8505, 594, 177, 132, 117},
				{9798, 712, 198, 143, 124},
				{11537, 1025, 231, 159, 134},
				{14084, 1762, 284, 186, 155},
				{17364, 3140, 503, 287, 266},
	}
};

static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4322, 4322, 4318, 4312, 4303},
				{4170, 4229, 4242, 4242, 4238},
				{4077, 4166, 4184, 4183, 4180},
				{4000, 4108, 4129, 4129, 4126},
				{3932, 4052, 4077, 4077, 4074},
				{3875, 3996, 4028, 4029, 4027},
				{3825, 3945, 3982, 3984, 3983},
				{3781, 3899, 3934, 3940, 3940},
				{3740, 3859, 3884, 3891, 3892},
				{3702, 3824, 3846, 3850, 3851},
				{3669, 3797, 3818, 3822, 3823},
				{3640, 3775, 3796, 3800, 3801},
				{3613, 3757, 3778, 3782, 3782},
				{3588, 3738, 3764, 3765, 3761},
				{3561, 3713, 3748, 3746, 3735},
				{3531, 3679, 3721, 3721, 3711},
				{3495, 3634, 3684, 3686, 3673},
				{3456, 3593, 3662, 3670, 3662},
				{3419, 3551, 3633, 3641, 3634},
				{3391, 3515, 3602, 3615, 3605},
				{3372, 3487, 3570, 3587, 3581},
				{3351, 3460, 3538, 3557, 3548},
				{3330, 3428, 3502, 3525, 3516},
				{3304, 3390, 3458, 3482, 3478},
				{3272, 3349, 3412, 3435, 3432},
				{3236, 3303, 3364, 3385, 3385},
				{3192, 3254, 3315, 3334, 3333},
				{3139, 3202, 3263, 3279, 3275},
				{3089, 3147, 3202, 3212, 3202},
				{3044, 3083, 3120, 3121, 3107},
				{3000, 3000, 3000, 3000, 3000}
	}
};

struct bms_battery_data LGE_BL_59UH_2440mAh_TOCAD_data = {
	.fcc				= 2440,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut			= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 158
};
