/*
 * Copyright 2012 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */
#include "PathOpsExtendedTest.h"

#define TEST(name) { name, #name }

static void skpcheeseandburger_com225(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(555, 468);
    path.lineTo(555, 362);
    path.lineTo(872, 362);
    path.lineTo(872, 468);
    path.lineTo(555, 468);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(859.11792f, 397.320343f);
    pathB.cubicTo(855.523071f, 399.691284f, 853.721191f, 402.40863f, 853.721191f, 405.552216f);
    pathB.cubicTo(853.721191f, 407.911163f, 854.727478f, 410.115387f, 857.043518f, 412.252716f);
    pathB.cubicTo(859.920532f, 414.916138f, 862.704773f, 417.086426f, 864.679382f, 418.852386f);
    pathB.cubicTo(866.382446f, 420.371765f, 867.19104f, 422.108795f, 867.19104f, 423.506378f);
    pathB.cubicTo(867.19104f, 424.551605f, 866.741821f, 425.539886f, 865.935242f, 426.281616f);
    pathB.cubicTo(865.250366f, 426.910553f, 864.662415f, 427.339813f, 864.139282f, 427.4646f);
    pathB.cubicTo(863.536377f, 427.605347f, 862.259521f, 426.491272f, 860.366821f, 424.208191f);
    pathB.cubicTo(858.345276f, 421.770355f, 857.317017f, 419.733856f, 857.317017f, 417.98587f);
    pathB.cubicTo(857.317017f, 417.198212f, 857.942993f, 415.930389f, 857.942993f, 415.930389f);
    pathB.cubicTo(857.942993f, 415.930389f, 852.106018f, 421.296173f, 852.279663f, 422.549042f);
    pathB.cubicTo(852.462402f, 423.890747f, 853.669312f, 425.703613f, 855.876465f, 428.252258f);
    pathB.cubicTo(858.038818f, 430.754944f, 859.4953f, 431.840088f, 860.190125f, 431.594513f);
    pathB.cubicTo(862.571045f, 430.754944f, 865.48999f, 429.237549f, 868.44397f, 427.018372f);
    pathB.cubicTo(870.505371f, 425.470032f, 871.582581f, 423.534332f, 871.582581f, 421.001678f);
    pathB.cubicTo(871.582581f, 417.945923f, 870.056213f, 415.171692f, 867.015381f, 412.640045f);
    pathB.cubicTo(863.683105f, 409.872803f, 861.445923f, 408.027954f, 860.551514f, 407.140503f);
    pathB.cubicTo(858.660767f, 405.264709f, 857.765259f, 403.50174f, 857.765259f, 402.187988f);
    pathB.cubicTo(857.765259f, 401.141785f, 858.339355f, 400.394073f, 859.476318f, 399.925873f);
    pathB.cubicTo(860.004395f, 399.704254f, 861.270264f, 400.515869f, 863.156006f, 402.36969f);
    pathB.cubicTo(865.094727f, 404.28241f, 866.203796f, 405.565186f, 866.383484f, 406.130219f);
    pathB.cubicTo(868.250244f, 404.305359f, 869.179688f, 403.397919f, 871.046509f, 401.58902f);
    pathB.cubicTo(868.26825f, 399.296967f, 864.431824f, 394.705841f, 863.156006f, 394.600037f);
    pathB.cubicTo(863.145996f, 394.600037f, 863.136108f, 394.59903f, 863.126099f, 394.59903f);
    pathB.cubicTo(862.352417f, 394.598022f, 859.909607f, 396.79425f, 859.11792f, 397.320343f);
    pathB.moveTo(832.164246f, 394.307526f);
    pathB.cubicTo(832.451721f, 394.425323f, 832.598511f, 394.486206f, 832.886963f, 394.605011f);
    pathB.cubicTo(834.078979f, 395.474518f, 834.674927f, 395.90979f, 835.867859f, 396.781281f);
    pathB.cubicTo(836.502808f, 397.325348f, 836.863159f, 398.000183f, 836.863159f, 398.964539f);
    pathB.lineTo(836.863159f, 419.740845f);
    pathB.cubicTo(836.863159f, 420.876923f, 836.319092f, 422.17868f, 835.055298f, 423.617188f);
    pathB.cubicTo(836.39502f, 424.512665f, 837.063843f, 424.961884f, 838.39856f, 425.864349f);
    pathB.cubicTo(839.477661f, 426.578125f, 841.37439f, 427.27594f, 842.275879f, 427.443634f);
    pathB.cubicTo(842.999634f, 427.574402f, 843.82019f, 427.513519f, 844.354309f, 427.216034f);
    pathB.cubicTo(846.956787f, 425.765503f, 848.689819f, 423.588257f, 848.58606f, 423.483429f);
    pathB.cubicTo(848.58606f, 423.483429f, 846.877991f, 423.327698f, 845.971558f, 422.807587f);
    pathB.cubicTo(845.253784f, 422.284485f, 844.892395f, 422.022949f, 844.171631f, 421.502838f);
    pathB.cubicTo(843.361023f, 420.915833f, 842.907837f, 420.308899f, 842.907837f, 419.350525f);
    pathB.lineTo(842.907837f, 399.445709f);
    pathB.cubicTo(842.907837f, 398.053101f, 843.272217f, 397.417175f, 843.812256f, 397.518005f);
    pathB.cubicTo(844.170654f, 397.583893f, 844.711731f, 398.122986f, 845.432495f, 398.782837f);
    pathB.cubicTo(846.116333f, 399.402771f, 846.459717f, 399.709259f, 847.14856f, 400.3302f);
    pathB.cubicTo(844.986206f, 402.099152f, 843.988892f, 403.926025f, 843.988892f, 405.932556f);
    pathB.cubicTo(843.988892f, 410.209229f, 848.272583f, 410.951935f, 849.576355f, 408.394348f);
    pathB.cubicTo(849.871826f, 407.816345f, 850.421875f, 406.214081f, 850.387939f, 406.196106f);
    pathB.cubicTo(850.387939f, 406.196106f, 849.305786f, 406.771118f, 848.495239f, 406.615387f);
    pathB.cubicTo(846.96582f, 406.316895f, 846.153198f, 405.46637f, 846.153198f, 403.89505f);
    pathB.cubicTo(846.153198f, 401.796661f, 848.50116f, 399.09729f, 852.279663f, 396.270142f);
    pathB.cubicTo(851.014893f, 395.315796f, 847.723511f, 391.546265f, 846.875f, 391.546265f);
    pathB.cubicTo(846.330933f, 391.546265f, 843.988892f, 394.403351f, 843.273193f, 394.972382f);
    pathB.cubicTo(840.889282f, 392.886963f, 839.700317f, 391.850739f, 837.312378f, 389.786285f);
    pathB.cubicTo(835.257935f, 391.589203f, 834.225708f, 392.491638f, 832.164246f, 394.307526f);
    pathB.moveTo(818.860107f, 392.707275f);
    pathB.cubicTo(819.857361f, 393.382111f, 822.302124f, 395.764038f, 824.387573f, 397.051819f);
    pathB.cubicTo(822.57666f, 398.249756f, 820.582092f, 399.687286f, 818.860107f, 400.827332f);
    pathB.lineTo(818.860107f, 392.707275f);
    pathB.close();
    pathB.moveTo(810.69812f, 391.096039f);
    pathB.cubicTo(810.69812f, 391.096039f, 812.786499f, 394.093903f, 812.786499f, 394.965393f);
    pathB.lineTo(812.786499f, 415.743713f);
    pathB.cubicTo(812.786499f, 417.753265f, 811.881042f, 418.497986f, 810.974609f, 419.769806f);
    pathB.cubicTo(813.948486f, 421.160431f, 815.437988f, 421.864197f, 818.404846f, 423.283783f);
    pathB.cubicTo(819.948181f, 423.95462f, 822.417969f, 424.592529f, 823.937317f, 423.782928f);
    pathB.cubicTo(827.905518f, 421.663544f, 831.53125f, 417.600525f, 832.255005f, 415.191681f);
    pathB.cubicTo(833.882263f, 409.877808f, 823.095825f, 411.495026f, 823.119751f, 411.518982f);
    pathB.cubicTo(823.119751f, 411.518982f, 832.000488f, 411.874359f, 830.537964f, 416.29776f);
    pathB.cubicTo(829.888123f, 418.253418f, 827.278564f, 420.292908f, 825.385864f, 419.55719f);
    pathB.cubicTo(821.14209f, 417.915985f, 818.861023f, 417.414856f, 818.861023f, 414.970032f);
    pathB.lineTo(818.861023f, 403.096436f);
    pathB.cubicTo(822.126404f, 399.132233f, 831.289673f, 395.897797f, 831.356567f, 395.657227f);
    pathB.cubicTo(831.356567f, 395.657227f, 823.022888f, 387.594055f, 821.763062f, 387.476257f);
    pathB.cubicTo(821.755066f, 387.47525f, 821.746094f, 387.47525f, 821.737061f, 387.47525f);
    pathB.cubicTo(820.793701f, 387.47525f, 810.72406f, 390.967255f, 810.69812f, 391.096039f);
    pathB.moveTo(624.254211f, 390.498077f);
    pathB.cubicTo(625.252502f, 390.893402f, 627.708252f, 392.592468f, 629.796692f, 393.307251f);
    pathB.cubicTo(627.978821f, 395.006317f, 625.980225f, 397.000916f, 624.254211f, 398.618134f);
    pathB.lineTo(624.254211f, 390.498077f);
    pathB.close();
    pathB.moveTo(627.160217f, 384.460449f);
    pathB.cubicTo(626.286743f, 384.51535f, 616.076233f, 390.993225f, 616.086243f, 391.141968f);
    pathB.cubicTo(616.086243f, 391.141968f, 618.173645f, 393.561798f, 618.173645f, 394.437317f);
    pathB.lineTo(618.173645f, 415.216614f);
    pathB.cubicTo(618.173645f, 417.222168f, 617.265198f, 418.219482f, 616.355774f, 419.742859f);
    pathB.cubicTo(619.331665f, 420.307892f, 620.824097f, 420.599396f, 623.802979f, 421.198364f);
    pathB.cubicTo(625.346313f, 421.437958f, 627.818115f, 421.39801f, 629.342468f, 420.166138f);
    pathB.cubicTo(633.340576f, 416.939667f, 636.982361f, 411.871368f, 637.714111f, 409.263855f);
    pathB.cubicTo(639.348267f, 403.500732f, 628.508911f, 408.111816f, 628.52887f, 408.126801f);
    pathB.cubicTo(628.52887f, 408.126801f, 637.468506f, 405.998444f, 635.985046f, 410.844147f);
    pathB.cubicTo(635.332153f, 412.984467f, 632.705688f, 415.748718f, 630.801941f, 415.541077f);
    pathB.cubicTo(626.537292f, 415.072876f, 624.257202f, 415.202667f, 624.257202f, 412.755859f);
    pathB.cubicTo(624.257202f, 408.007019f, 624.255188f, 405.636078f, 624.255188f, 400.884247f);
    pathB.cubicTo(627.525574f, 396.016602f, 636.801636f, 390.283447f, 636.801636f, 389.97995f);
    pathB.cubicTo(636.801636f, 389.97995f, 628.360168f, 384.458435f, 627.18219f, 384.458435f);
    pathB.cubicTo(627.174194f, 384.460449f, 627.167236f, 384.460449f, 627.160217f, 384.460449f);
    pathB.moveTo(796.530396f, 416.438538f);
    pathB.cubicTo(795.892517f, 416.365662f, 794.527832f, 415.589996f, 792.348572f, 414.036652f);
    pathB.lineTo(792.348572f, 391.425476f);
    pathB.cubicTo(792.348572f, 390.465118f, 792.530273f, 390.047852f, 792.89563f, 390.088776f);
    pathB.cubicTo(793.075317f, 390.109741f, 793.3479f, 390.317383f, 793.804077f, 390.629852f);
    pathB.cubicTo(795.113831f, 391.585205f, 795.768738f, 392.059387f, 797.077515f, 393.018738f);
    pathB.cubicTo(797.983948f, 393.648651f, 798.348267f, 394.219666f, 798.348267f, 394.742767f);
    pathB.lineTo(798.348267f, 413.253998f);
    pathB.cubicTo(798.348267f, 415.391327f, 797.783264f, 416.451508f, 796.728088f, 416.451508f);
    pathB.cubicTo(796.664185f, 416.4505f, 796.598267f, 416.446533f, 796.530396f, 416.438538f);
    pathB.moveTo(795.165771f, 383.714722f);
    pathB.cubicTo(794.022705f, 383.851471f, 783.959961f, 388.652252f, 783.880127f, 388.873871f);
    pathB.cubicTo(783.880127f, 388.873871f, 785.054077f, 389.871155f, 785.522339f, 390.606873f);
    pathB.cubicTo(786.000488f, 391.361603f, 786.246094f, 391.9935f, 786.246094f, 392.427765f);
    pathB.lineTo(786.246094f, 411.987183f);
    pathB.cubicTo(786.246094f, 413.733185f, 784.160645f, 416.428558f, 784.246521f, 416.759979f);
    pathB.cubicTo(784.258484f, 416.79892f, 785.432495f, 417.14032f, 785.793823f, 417.350952f);
    pathB.cubicTo(786.739258f, 417.937958f, 787.213379f, 418.228455f, 788.161804f, 418.821442f);
    pathB.cubicTo(789.342773f, 419.554199f, 790.619568f, 419.956482f, 791.892395f, 420.098236f);
    pathB.cubicTo(794.533813f, 420.390747f, 796.717102f, 419.337555f, 798.349304f, 416.999573f);
    pathB.lineTo(798.349304f, 425.212463f);
    pathB.cubicTo(797.94696f, 425.47702f, 797.750305f, 425.609772f, 797.356018f, 425.874329f);
    pathB.cubicTo(795.259583f, 423.619202f, 792.806824f, 422.286499f, 789.985657f, 421.984009f);
    pathB.cubicTo(785.157959f, 421.463898f, 780.409119f, 428.344086f, 780.423096f, 428.346069f);
    pathB.cubicTo(780.423096f, 428.346069f, 783.340088f, 424.960907f, 785.889709f, 425.218445f);
    pathB.cubicTo(789.25592f, 425.565857f, 793.166199f, 430.745972f, 793.805115f, 430.790894f);
    pathB.cubicTo(793.940857f, 430.798889f, 795.918457f, 429.091797f, 798.454102f, 427.383728f);
    pathB.cubicTo(801.049683f, 425.635742f, 804.230225f, 423.886749f, 806.619141f, 423.980591f);
    pathB.cubicTo(805.621826f, 423.586243f, 805.048828f, 423.074127f, 804.804199f, 422.609924f);
    pathB.cubicTo(804.616577f, 422.25354f, 804.616577f, 421.539764f, 804.616577f, 420.31488f);
    pathB.cubicTo(804.623535f, 411.732605f, 804.623535f, 403.147339f, 804.623535f, 394.562073f);
    pathB.cubicTo(804.623535f, 392.464691f, 805.970215f, 391.000183f, 805.984192f, 390.896362f);
    pathB.cubicTo(805.984192f, 390.896362f, 796.785034f, 383.7117f, 795.219666f, 383.7117f);
    pathB.cubicTo(795.19873f, 383.712708f, 795.181763f, 383.712708f, 795.165771f, 383.714722f);
    pathB.moveTo(648.092285f, 387.883545f);
    pathB.cubicTo(649.095581f, 388.312805f, 651.55835f, 390.099762f, 653.655701f, 390.884399f);
    pathB.cubicTo(651.831848f, 392.522583f, 649.82428f, 394.447296f, 648.092285f, 396.003601f);
    pathB.lineTo(648.092285f, 387.883545f);
    pathB.close();
    pathB.moveTo(651.009277f, 381.943756f);
    pathB.cubicTo(650.147766f, 381.983704f, 639.893372f, 388.105164f, 639.899353f, 388.254913f);
    pathB.cubicTo(639.899353f, 388.254913f, 641.987793f, 390.744659f, 641.987793f, 391.617157f);
    pathB.lineTo(641.987793f, 412.399475f);
    pathB.cubicTo(641.987793f, 414.409027f, 641.082336f, 415.369354f, 640.169861f, 416.864807f);
    pathB.cubicTo(643.155762f, 417.53064f, 644.650208f, 417.87207f, 647.638062f, 418.573853f);
    pathB.cubicTo(649.188416f, 418.865356f, 651.666138f, 418.908295f, 653.19751f, 417.725311f);
    pathB.cubicTo(657.204651f, 414.633636f, 660.859375f, 409.690125f, 661.590088f, 407.106567f);
    pathB.cubicTo(663.231262f, 401.397339f, 652.356934f, 405.644073f, 652.375916f, 405.663025f);
    pathB.cubicTo(652.375916f, 405.663025f, 661.338562f, 403.835175f, 659.857056f, 408.632935f);
    pathB.cubicTo(659.199219f, 410.748291f, 656.568726f, 413.424713f, 654.656982f, 413.151184f);
    pathB.cubicTo(650.381348f, 412.536224f, 648.092285f, 412.591125f, 648.092285f, 410.146332f);
    pathB.lineTo(648.092285f, 398.270721f);
    pathB.cubicTo(651.374634f, 393.5159f, 660.66571f, 388.09021f, 660.674683f, 387.791718f);
    pathB.cubicTo(660.674683f, 387.791718f, 652.188232f, 381.941772f, 651.022278f, 381.942749f);
    pathB.cubicTo(651.01825f, 381.942749f, 651.013245f, 381.942749f, 651.009277f, 381.943756f);
    pathB.moveTo(761.636353f, 385.965851f);
    pathB.cubicTo(761.927856f, 386.056702f, 762.071594f, 386.098633f, 762.363098f, 386.189453f);
    pathB.cubicTo(763.570007f, 386.938171f, 764.175964f, 387.311554f, 765.376892f, 388.066254f);
    pathB.cubicTo(766.019775f, 388.546417f, 766.384155f, 389.184326f, 766.384155f, 390.147675f);
    pathB.lineTo(766.384155f, 410.924011f);
    pathB.cubicTo(766.384155f, 412.057037f, 765.836121f, 413.410736f, 764.559326f, 414.979034f);
    pathB.cubicTo(765.911987f, 415.738739f, 766.579834f, 416.12207f, 767.934509f, 416.887756f);
    pathB.cubicTo(769.029602f, 417.495728f, 770.944336f, 418.000854f, 771.85675f, 418.075714f);
    pathB.cubicTo(772.58551f, 418.134613f, 773.413086f, 417.987854f, 773.950195f, 417.638458f);
    pathB.cubicTo(776.583618f, 415.917419f, 778.332642f, 413.564453f, 778.237793f, 413.473633f);
    pathB.cubicTo(778.237793f, 413.473633f, 776.507812f, 413.497559f, 775.596313f, 413.066315f);
    pathB.cubicTo(774.866577f, 412.61908f, 774.497253f, 412.39447f, 773.771484f, 411.951233f);
    pathB.cubicTo(772.947876f, 411.444092f, 772.493652f, 410.877075f, 772.493652f, 409.919708f);
    pathB.lineTo(772.493652f, 390.013885f);
    pathB.cubicTo(772.493652f, 388.618286f, 772.860046f, 387.949432f, 773.407104f, 387.995361f);
    pathB.cubicTo(773.771484f, 388.026306f, 774.318542f, 388.509491f, 775.049316f, 389.09848f);
    pathB.cubicTo(775.742065f, 389.646515f, 776.088501f, 389.923065f, 776.77533f, 390.470123f);
    pathB.cubicTo(774.590088f, 392.45871f, 773.589783f, 394.385376f, 773.589783f, 396.395935f);
    pathB.cubicTo(773.589783f, 400.673584f, 777.907349f, 401.008026f, 779.237122f, 398.292694f);
    pathB.cubicTo(779.539551f, 397.684723f, 780.089661f, 396.027557f, 780.058716f, 396.01358f);
    pathB.cubicTo(780.058716f, 396.01358f, 778.970581f, 396.694427f, 778.149963f, 396.618561f);
    pathB.cubicTo(776.598633f, 396.4758f, 775.775024f, 395.709106f, 775.775024f, 394.13681f);
    pathB.cubicTo(775.775024f, 392.042419f, 778.149963f, 389.103455f, 781.973389f, 385.892975f);
    pathB.cubicTo(780.697571f, 385.06839f, 777.326416f, 381.676208f, 776.506775f, 381.719147f);
    pathB.cubicTo(775.908813f, 381.747101f, 773.588806f, 384.868744f, 772.860046f, 385.506622f);
    pathB.cubicTo(770.451172f, 383.664795f, 769.248291f, 382.749359f, 766.843384f, 380.929504f);
    pathB.cubicTo(764.758972f, 382.934052f, 763.716736f, 383.940338f, 761.636353f, 385.965851f);
    pathB.moveTo(672.996521f, 379.821411f);
    pathB.cubicTo(672.123047f, 379.891266f, 669.7052f, 382.898132f, 668.887573f, 383.64682f);
    pathB.cubicTo(665.239868f, 386.999084f, 663.41095f, 390.213562f, 663.41095f, 393.356171f);
    pathB.cubicTo(663.41095f, 395.715118f, 664.439209f, 397.642792f, 666.785156f, 399.150208f);
    pathB.cubicTo(669.702148f, 401.02002f, 672.547302f, 402.439575f, 674.545837f, 403.655487f);
    pathB.cubicTo(676.261902f, 404.697693f, 677.105469f, 406.231049f, 677.105469f, 407.625671f);
    pathB.cubicTo(677.105469f, 408.671875f, 676.651245f, 409.777954f, 675.825684f, 410.7453f);
    pathB.cubicTo(675.12384f, 411.569885f, 674.538879f, 412.145905f, 673.997803f, 412.417419f);
    pathB.cubicTo(673.38385f, 412.724915f, 672.080078f, 411.958221f, 670.166382f, 410.198242f);
    pathB.cubicTo(668.113892f, 408.319458f, 667.062683f, 406.55249f, 667.062683f, 404.808502f);
    pathB.cubicTo(667.062683f, 404.020844f, 667.701599f, 402.580322f, 667.701599f, 402.580322f);
    pathB.cubicTo(667.701599f, 402.580322f, 661.773804f, 409.542358f, 661.951477f, 410.7453f);
    pathB.cubicTo(662.13916f, 412.037079f, 663.368042f, 413.524536f, 665.60321f, 415.469208f);
    pathB.cubicTo(667.791443f, 417.368927f, 669.261963f, 418.074738f, 669.983704f, 417.630493f);
    pathB.cubicTo(672.412537f, 416.138062f, 675.369446f, 413.822021f, 678.385254f, 410.790222f);
    pathB.cubicTo(680.485657f, 408.677856f, 681.587769f, 406.446686f, 681.587769f, 403.917023f);
    pathB.cubicTo(681.587769f, 400.859283f, 680.007446f, 398.490356f, 676.923767f, 396.806244f);
    pathB.cubicTo(673.540588f, 394.957428f, 671.257507f, 393.71756f, 670.351074f, 393.075653f);
    pathB.cubicTo(668.434326f, 391.71698f, 667.518921f, 390.193604f, 667.518921f, 388.88385f);
    pathB.cubicTo(667.518921f, 387.837646f, 668.101929f, 386.934204f, 669.25592f, 386.156525f);
    pathB.cubicTo(669.796997f, 385.788147f, 671.085815f, 386.257355f, 672.997498f, 387.592072f);
    pathB.cubicTo(674.966125f, 388.968689f, 676.104187f, 389.951019f, 676.284851f, 390.465118f);
    pathB.cubicTo(678.186584f, 388.130127f, 679.136963f, 386.966125f, 681.035706f, 384.646118f);
    pathB.cubicTo(678.244507f, 383.133728f, 674.247375f, 379.819397f, 673.044434f, 379.819397f);
    pathB.cubicTo(673.027466f, 379.819397f, 673.011475f, 379.820404f, 672.996521f, 379.821411f);
    pathB.moveTo(732.95459f, 384.60318f);
    pathB.cubicTo(733.246094f, 384.680054f, 733.391846f, 384.720001f, 733.689331f, 384.794861f);
    pathB.cubicTo(735.072937f, 385.500641f, 735.769714f, 385.856049f, 737.162354f, 386.563812f);
    pathB.cubicTo(737.891113f, 386.938171f, 738.164612f, 387.642975f, 738.164612f, 388.6073f);
    pathB.lineTo(738.164612f, 408.510132f);
    pathB.cubicTo(738.164612f, 410.257141f, 737.709412f, 411.893341f, 736.064209f, 413.416718f);
    pathB.cubicTo(737.635498f, 414.235321f, 738.419189f, 414.651611f, 739.991455f, 415.475189f);
    pathB.cubicTo(740.997742f, 416.034241f, 742.186707f, 416.344696f, 743.098145f, 416.379639f);
    pathB.cubicTo(743.830872f, 416.410583f, 744.476807f, 416.175964f, 745.019836f, 415.851532f);
    pathB.cubicTo(746.476318f, 414.977051f, 748.58075f, 413.571442f, 749.225647f, 413.079285f);
    pathB.cubicTo(751.012573f, 414.253296f, 751.907043f, 414.845276f, 753.69696f, 416.028229f);
    pathB.cubicTo(754.703247f, 416.610229f, 755.706543f, 416.84082f, 756.528076f, 416.892761f);
    pathB.cubicTo(757.259827f, 416.93866f, 757.996582f, 416.807892f, 758.537659f, 416.494446f);
    pathB.cubicTo(760.814758f, 415.174713f, 762.185425f, 413.509552f, 762.552734f, 412.830719f);
    pathB.cubicTo(761.637329f, 412.681976f, 759.633789f, 411.58786f, 759.263428f, 411.387207f);
    pathB.cubicTo(758.607544f, 410.994873f, 758.279114f, 410.803223f, 757.621216f, 410.413879f);
    pathB.cubicTo(756.983276f, 410.020538f, 756.616943f, 409.301788f, 756.616943f, 408.343445f);
    pathB.lineTo(756.616943f, 388.351746f);
    pathB.cubicTo(756.616943f, 387.387421f, 757.164978f, 386.548859f, 758.627502f, 385.067383f);
    pathB.cubicTo(755.523804f, 383.05484f, 753.97052f, 382.057556f, 750.862854f, 380.078949f);
    pathB.cubicTo(749.001038f, 382.112457f, 748.069641f, 383.130707f, 746.207825f, 385.174194f);
    pathB.cubicTo(746.501343f, 385.292999f, 746.647095f, 385.353912f, 746.939575f, 385.472687f);
    pathB.cubicTo(747.996765f, 386.183472f, 748.525879f, 386.538879f, 749.587036f, 387.257629f);
    pathB.cubicTo(750.224915f, 387.724823f, 750.498474f, 388.351746f, 750.498474f, 389.223267f);
    pathB.lineTo(750.498474f, 407.822327f);
    pathB.cubicTo(750.498474f, 408.694824f, 750.339722f, 409.955658f, 749.951416f, 410.847137f);
    pathB.cubicTo(749.550049f, 411.761566f, 749.039978f, 411.585876f, 748.487915f, 411.560913f);
    pathB.cubicTo(747.393799f, 411.503998f, 746.385498f, 410.53067f, 745.473083f, 410.022552f);
    pathB.cubicTo(744.760254f, 409.627228f, 744.380981f, 409.013275f, 744.380981f, 407.965088f);
    pathB.lineTo(744.380981f, 386.840363f);
    pathB.cubicTo(744.380981f, 385.791138f, 744.833191f, 384.763916f, 745.657776f, 383.839508f);
    pathB.cubicTo(742.656921f, 382.101501f, 741.161499f, 381.234985f, 738.162659f, 379.525909f);
    pathB.cubicTo(736.083191f, 381.548431f, 735.039978f, 382.562683f, 732.95459f, 384.60318f);
    pathB.moveTo(692.546936f, 385.171204f);
    pathB.cubicTo(693.552246f, 385.667358f, 696.018005f, 387.607025f, 698.122375f, 388.521454f);
    pathB.cubicTo(696.293518f, 390.043854f, 694.281982f, 391.844757f, 692.546936f, 393.294281f);
    pathB.lineTo(692.546936f, 385.171204f);
    pathB.close();
    pathB.moveTo(695.4729f, 379.417084f);
    pathB.cubicTo(694.635376f, 379.426086f, 684.32605f, 384.880707f, 684.322083f, 385.025452f);
    pathB.cubicTo(684.322083f, 385.025452f, 686.422485f, 387.645966f, 686.422485f, 388.521454f);
    pathB.lineTo(686.422485f, 409.300781f);
    pathB.cubicTo(686.422485f, 411.312347f, 685.51001f, 412.21579f, 684.595581f, 413.65033f);
    pathB.cubicTo(687.592468f, 414.504852f, 689.089905f, 414.945099f, 692.088745f, 415.833557f);
    pathB.cubicTo(693.645081f, 416.221893f, 696.128784f, 416.420563f, 697.667114f, 415.334412f);
    pathB.cubicTo(701.67926f, 412.494293f, 705.344971f, 407.783386f, 706.077698f, 405.240753f);
    pathB.cubicTo(707.721924f, 399.638367f, 696.822632f, 403.198273f, 696.845581f, 403.216248f);
    pathB.cubicTo(696.845581f, 403.216248f, 705.825134f, 401.960388f, 704.337708f, 406.658325f);
    pathB.cubicTo(703.683838f, 408.733765f, 701.044373f, 411.241455f, 699.129639f, 410.847137f);
    pathB.cubicTo(694.843018f, 409.968628f, 692.545959f, 409.876801f, 692.545959f, 407.432983f);
    pathB.lineTo(692.545959f, 395.563354f);
    pathB.cubicTo(695.838318f, 391.012177f, 705.134338f, 386.160522f, 705.162292f, 385.873993f);
    pathB.cubicTo(705.162292f, 385.873993f, 696.635925f, 379.416107f, 695.473938f, 379.417084f);
    pathB.cubicTo(695.474915f, 379.417084f, 695.473938f, 379.417084f, 695.4729f, 379.417084f);
    pathB.moveTo(570.463562f, 420.81601f);
    pathB.lineTo(570.463562f, 402.922729f);
    pathB.cubicTo(571.039551f, 402.800934f, 571.327087f, 402.743042f, 571.901123f, 402.625244f);
    pathB.lineTo(571.901123f, 423.142029f);
    pathB.cubicTo(570.911804f, 422.823578f, 570.463562f, 422.123779f, 570.463562f, 420.81601f);
    pathB.moveTo(570.463562f, 384.062134f);
    pathB.cubicTo(571.039551f, 384.149963f, 571.327087f, 384.198883f, 571.901123f, 384.290741f);
    pathB.lineTo(571.901123f, 401.580048f);
    pathB.cubicTo(571.327087f, 401.695862f, 571.039551f, 401.756744f, 570.463562f, 401.874542f);
    pathB.lineTo(570.463562f, 384.062134f);
    pathB.close();
    pathB.moveTo(573.880676f, 376.556f);
    pathB.cubicTo(572.483093f, 376.996246f, 561.476013f, 385.624451f, 561.482971f, 385.70929f);
    pathB.cubicTo(561.482971f, 385.70929f, 563.637268f, 388.554413f, 563.637268f, 389.688446f);
    pathB.lineTo(563.637268f, 398.423462f);
    pathB.cubicTo(556.411682f, 399.838043f, 555.429382f, 404.307373f, 555.418396f, 405.679993f);
    pathB.lineTo(555.418396f, 405.724915f);
    pathB.cubicTo(555.42041f, 405.94455f, 555.448364f, 406.073334f, 555.477295f, 406.083313f);
    pathB.cubicTo(555.477295f, 406.083313f, 558.070862f, 404.250458f, 563.637268f, 403.222229f);
    pathB.lineTo(563.637268f, 404.797516f);
    pathB.cubicTo(556.993713f, 406.233063f, 555.191772f, 412.494293f, 555.569153f, 412.614105f);
    pathB.cubicTo(555.569153f, 412.614105f, 561.572815f, 410.21521f, 563.637268f, 409.598267f);
    pathB.lineTo(563.637268f, 424.00354f);
    pathB.cubicTo(563.637268f, 426.357483f, 563.36676f, 427.901855f, 562.291565f, 429.70874f);
    pathB.cubicTo(565.448181f, 430.067139f, 567.028442f, 430.256805f, 570.192017f, 430.653137f);
    pathB.cubicTo(571.99292f, 430.893707f, 574.782166f, 430.669098f, 576.403381f, 429.136719f);
    pathB.cubicTo(580.960571f, 424.828125f, 586.135681f, 419.346527f, 586.135681f, 416.115082f);
    pathB.lineTo(586.135681f, 406.511566f);
    pathB.cubicTo(586.135681f, 405.377533f, 586.047791f, 404.608856f, 586.678711f, 403.271149f);
    pathB.cubicTo(584.151062f, 404.98819f, 582.888245f, 405.851715f, 580.362549f, 407.587738f);
    pathB.cubicTo(579.281433f, 408.320465f, 579.192566f, 409.2948f, 579.192566f, 410.955933f);
    pathB.lineTo(579.192566f, 421.869202f);
    pathB.cubicTo(579.192566f, 423.180969f, 577.746033f, 423.273804f, 577.392639f, 423.266815f);
    pathB.cubicTo(575.636658f, 423.228882f, 574.153259f, 423.295776f, 573.071106f, 423.077148f);
    pathB.lineTo(573.071106f, 384.663086f);
    pathB.cubicTo(575.230408f, 385.379852f, 576.309509f, 385.742249f, 578.473816f, 386.473999f);
    pathB.cubicTo(579.373291f, 386.996094f, 579.553955f, 387.490234f, 579.553955f, 388.013336f);
    pathB.cubicTo(581.861023f, 384.848785f, 583.015991f, 383.267487f, 585.325073f, 380.114899f);
    pathB.cubicTo(581.680298f, 379.229431f, 575.865295f, 376.520081f, 574.157227f, 376.521057f);
    pathB.cubicTo(574.047424f, 376.522064f, 573.955566f, 376.533051f, 573.880676f, 376.556f);
    pathB.moveTo(593.447083f, 375.096527f);
    pathB.cubicTo(592.363953f, 375.804291f, 591.821899f, 376.772644f, 591.821899f, 377.908691f);
    pathB.lineTo(591.821899f, 419.46933f);
    pathB.cubicTo(591.821899f, 420.517517f, 591.187012f, 422.018951f, 589.921143f, 423.991577f);
    pathB.cubicTo(591.2948f, 424.412842f, 591.982605f, 424.622467f, 593.354248f, 425.050751f);
    pathB.cubicTo(594.53125f, 425.462036f, 595.525513f, 425.555878f, 596.427979f, 425.404144f);
    pathB.cubicTo(597.150757f, 425.279358f, 597.785645f, 424.914978f, 598.326721f, 424.475739f);
    pathB.cubicTo(600.935242f, 422.385315f, 602.846985f, 419.809753f, 602.759094f, 419.749847f);
    pathB.cubicTo(602.759094f, 419.749847f, 601.582153f, 419.935516f, 600.59082f, 419.831696f);
    pathB.cubicTo(600.0448f, 419.74585f, 599.774231f, 419.700928f, 599.233154f, 419.615082f);
    pathB.cubicTo(598.416565f, 419.484314f, 597.965332f, 418.860382f, 597.965332f, 417.988861f);
    pathB.lineTo(597.965332f, 396.857147f);
    pathB.cubicTo(597.965332f, 395.376678f, 598.326721f, 394.617004f, 598.867798f, 394.528137f);
    pathB.cubicTo(599.232178f, 394.466248f, 599.773254f, 394.731812f, 600.59082f, 395.124115f);
    pathB.cubicTo(601.601074f, 395.589325f, 602.111206f, 395.819946f, 603.123474f, 396.288116f);
    pathB.cubicTo(603.93811f, 396.686432f, 603.93512f, 397.38324f, 603.93512f, 398.169891f);
    pathB.cubicTo(603.93512f, 405.971497f, 603.93512f, 413.768127f, 603.93811f, 421.569702f);
    pathB.cubicTo(603.93811f, 425.325256f, 601.109924f, 430.634155f, 601.133911f, 430.656128f);
    pathB.cubicTo(601.133911f, 430.656128f, 605.184937f, 427.222015f, 607.017822f, 424.414825f);
    pathB.cubicTo(609.118164f, 421.201355f, 610.280212f, 417.987854f, 610.280212f, 415.109802f);
    pathB.lineTo(610.280212f, 394.593048f);
    pathB.cubicTo(610.280212f, 393.890228f, 610.823242f, 393.112579f, 611.728699f, 392.020447f);
    pathB.cubicTo(608.827698f, 390.960266f, 604.000977f, 387.703857f, 602.759094f, 387.967407f);
    pathB.cubicTo(602.120239f, 388.104187f, 599.957947f, 391.29071f, 597.965332f, 393.27829f);
    pathB.lineTo(597.965332f, 374.422668f);
    pathB.cubicTo(597.965332f, 373.461334f, 598.326721f, 372.440063f, 598.867798f, 371.567566f);
    pathB.cubicTo(596.701538f, 372.96817f, 595.616394f, 373.677948f, 593.447083f, 375.096527f);
    pathB.moveTo(718.054138f, 409.318756f);
    pathB.cubicTo(717.461182f, 408.789673f, 716.867188f, 408.178711f, 716.867188f, 407.218353f);
    pathB.lineTo(716.867188f, 387.053986f);
    pathB.cubicTo(716.867188f, 385.305969f, 717.323425f, 385.566528f, 718.328674f, 386.013763f);
    pathB.cubicTo(719.645386f, 386.859314f, 720.307251f, 387.284576f, 721.622009f, 388.135132f);
    pathB.cubicTo(722.266907f, 388.4935f, 722.903809f, 388.934753f, 722.903809f, 389.721405f);
    pathB.lineTo(722.903809f, 407.794373f);
    pathB.cubicTo(722.903809f, 408.66687f, 722.746094f, 410.490753f, 722.259888f, 410.758301f);
    pathB.cubicTo(722.125122f, 410.83017f, 721.950439f, 410.862122f, 721.746826f, 410.862122f);
    pathB.cubicTo(720.655701f, 410.864105f, 718.747925f, 409.936707f, 718.054138f, 409.318756f);
    pathB.moveTo(711.928711f, 364.782227f);
    pathB.cubicTo(711.195923f, 365.134613f, 710.648865f, 365.834412f, 710.648865f, 366.794769f);
    pathB.lineTo(710.648865f, 407.392059f);
    pathB.cubicTo(710.648865f, 409.397614f, 708.519531f, 411.37323f, 708.547485f, 411.684692f);
    pathB.cubicTo(708.550476f, 411.745605f, 711.838867f, 413.067322f, 713.849365f, 414.368073f);
    pathB.cubicTo(717.766663f, 416.906738f, 720.162537f, 415.845551f, 722.354797f, 414.073608f);
    pathB.cubicTo(724.059875f, 412.69397f, 726.55957f, 410.981903f, 730.675537f, 410.124359f);
    pathB.cubicTo(729.75708f, 409.143066f, 729.213013f, 407.993042f, 729.213013f, 406.683289f);
    pathB.cubicTo(729.213013f, 399.630402f, 729.209045f, 396.103455f, 729.209045f, 389.047546f);
    pathB.cubicTo(729.209045f, 387.648956f, 730.577698f, 385.292023f, 730.583679f, 385.149261f);
    pathB.cubicTo(730.583679f, 385.149261f, 720.888306f, 378.762207f, 719.609497f, 378.947906f);
    pathB.cubicTo(719.275085f, 378.996826f, 717.872498f, 381.118164f, 716.868225f, 381.896851f);
    pathB.lineTo(716.868225f, 365.046783f);
    pathB.cubicTo(716.868225f, 363.740021f, 716.960083f, 363.043213f, 717.597961f, 362);
    pathB.cubicTo(715.331848f, 363.104095f, 714.19873f, 363.657166f, 711.928711f, 364.782227f);
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpeverytechpro_blogspot_com100(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(1074.29285f, 627.292786f);
    path.quadTo(1074.58582f, 627, 1075, 627);
    path.lineTo(1117, 627);
    path.quadTo(1124.04163f, 627, 1129.02246f, 631.9776f);
    path.quadTo(1134, 636.958374f, 1134, 644);
    path.lineTo(1134, 645);
    path.quadTo(1134, 652.041626f, 1129.02246f, 657.0224f);
    path.quadTo(1124.04163f, 662, 1117, 662);
    path.lineTo(1075, 662);
    path.quadTo(1074.58582f, 662, 1074.29285f, 661.707214f);
    path.quadTo(1074, 661.414185f, 1074, 661);
    path.lineTo(1074, 628);
    path.quadTo(1074, 627.585815f, 1074.29285f, 627.292786f);
    path.close();
    path.moveTo(1076, 629);
    path.lineTo(1117, 629);
    path.cubicTo(1125.2843f, 629, 1132, 635.715698f, 1132, 644);
    path.lineTo(1132, 645);
    path.cubicTo(1132, 653.284302f, 1125.2843f, 660, 1117, 660);
    path.lineTo(1076, 660);
    path.lineTo(1076, 629);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(1074, 627);
    pathB.lineTo(1075, 628);
    pathB.lineTo(1116.5f, 644.5f);
    pathB.lineTo(1134, 627);
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpflite_com41(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(301.464081f, 424);
    path.lineTo(296, 433.46405f);
    path.lineTo(296, 433.810822f);
    path.lineTo(303.25589f, 438);
    path.lineTo(304.729736f, 438);
    path.lineTo(311, 427.139557f);
    path.lineTo(311, 426.305237f);
    path.lineTo(307.007202f, 424);
    path.lineTo(301.464081f, 424);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(302.849854f, 421.599762f);
    pathB.lineTo(311.510101f, 426.599762f);
    pathB.lineTo(304.510101f, 438.724121f);
    pathB.lineTo(295.849854f, 433.724121f);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpilkoora_com37(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(818, 157);
    path.cubicTo(818, 148.715729f, 824.715698f, 142, 833, 142);
    path.lineTo(909, 142);
    path.lineTo(909, 143);
    path.lineTo(833, 143);
    path.cubicTo(825.268005f, 143, 819, 149.268005f, 819, 157);
    path.lineTo(819, 926);
    path.lineTo(818, 926);
    path.lineTo(818, 157);
    path.close();
    path.moveTo(1184, 926);
    path.lineTo(1185, 926);
    path.lineTo(1185, 157);
    path.cubicTo(1185, 148.715729f, 1178.2843f, 142, 1170, 142);
    path.lineTo(1093, 142);
    path.lineTo(1093, 143);
    path.lineTo(1170, 143);
    path.cubicTo(1177.73193f, 143, 1184, 149.268005f, 1184, 157);
    path.lineTo(1184, 926);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(1185, 142);
    pathB.lineTo(1001.5f, 325.5f);
    pathB.lineTo(1001.5f, 782.5f);
    pathB.lineTo(1185, 966);
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpmm4everfriends_com43(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(540.74231f, 215.922546f);
    path.cubicTo(540.893127f, 215.391159f, 541.443909f, 215.090134f, 541.972473f, 215.250168f);
    path.lineTo(581.213318f, 227.131104f);
    path.cubicTo(581.741882f, 227.291153f, 582.048157f, 227.851654f, 581.897339f, 228.383041f);
    path.lineTo(576.708923f, 246.663925f);
    path.cubicTo(576.558167f, 247.195297f, 576.007324f, 247.496338f, 575.47876f, 247.336288f);
    path.lineTo(536.237915f, 235.455353f);
    path.cubicTo(535.709351f, 235.295319f, 535.403137f, 234.734802f, 535.553894f, 234.20343f);
    path.lineTo(540.74231f, 215.922546f);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(541.015381f, 214.960388f);
    pathB.lineTo(582.17041f, 227.420883f);
    pathB.lineTo(576.435852f, 247.626068f);
    pathB.lineTo(535.280823f, 235.165573f);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpmtrk_uz27(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(33, 787);
    path.lineTo(33, 412);
    path.lineTo(1233, 412);
    path.lineTo(1233, 787);
    path.quadTo(1233, 793.213196f, 1228.60803f, 797.607971f);
    path.quadTo(1224.21326f, 802, 1218, 802);
    path.lineTo(48, 802);
    path.quadTo(41.7867966f, 802, 37.3919983f, 797.607971f);
    path.quadTo(33, 793.213196f, 33, 787);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(33, 412);
    pathB.lineTo(1233, 412);
    pathB.lineTo(1233, 787);
    pathB.quadTo(1233, 793.213196f, 1228.60791f, 797.608032f);
    pathB.quadTo(1224.21313f, 802, 1218, 802);
    pathB.lineTo(48, 802);
    pathB.quadTo(41.7867432f, 802, 37.3919678f, 797.608032f);
    pathB.quadTo(33, 793.213196f, 33, 787);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpfrauen_magazin_com83(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(808, 886);
    path.cubicTo(805.581055f, 886, 803.563293f, 887.717773f, 803.100037f, 890);
    path.lineTo(1122.90002f, 890);
    path.cubicTo(1122.43677f, 887.717773f, 1120.41895f, 886, 1118, 886);
    path.lineTo(808, 886);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(808, 886);
    pathB.lineTo(1118, 886);
    pathB.cubicTo(1120.76147f, 886, 1123, 888.238586f, 1123, 891);
    pathB.lineTo(1123, 1521);
    pathB.cubicTo(1123, 1523.20911f, 1120.76147f, 1525, 1118, 1525);
    pathB.lineTo(808, 1525);
    pathB.cubicTo(805.238586f, 1525, 803, 1523.20911f, 803, 1521);
    pathB.lineTo(803, 891);
    pathB.cubicTo(803, 888.238586f, 805.238586f, 886, 808, 886);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

#define TRY_BROKEN_TESTS 0
#if TRY_BROKEN_TESTS
static void skpi_gino_com16(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(184, 734);
    path.quadTo(133.051727f, 734, 97.0258636f, 770.025879f);
    path.quadTo(61, 806.051758f, 61, 857);
    path.quadTo(61, 895.835083f, 81.9317017f, 926);
    path.lineTo(286.068298f, 926);
    path.quadTo(307, 895.835083f, 307, 857);
    path.quadTo(307, 806.051758f, 270.974121f, 770.025879f);
    path.quadTo(234.948273f, 734, 184, 734);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(185, 734);
    pathB.cubicTo(252.93103f, 734, 308, 789.06897f, 308, 857);
    pathB.cubicTo(308, 924.93103f, 252.93103f, 980, 185, 980);
    pathB.lineTo(184, 980);
    pathB.cubicTo(116.068977f, 980, 61, 924.93103f, 61, 857);
    pathB.cubicTo(61, 789.06897f, 116.068977f, 734, 184, 734);
    pathB.lineTo(185, 734);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skppchappy_com_au102(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(363, 493);
    path.cubicTo(360.790863f, 493, 359, 494.790863f, 359, 497);
    path.lineTo(359, 656);
    path.cubicTo(359, 658.209106f, 360.790863f, 660, 363, 660);
    path.lineTo(623.001709f, 660);
    path.cubicTo(624.657776f, 659.999023f, 626, 658.65625f, 626, 657);
    path.lineTo(626, 496);
    path.cubicTo(626, 494.343872f, 624.657959f, 493.00116f, 623.002075f, 493);
    path.lineTo(363, 493);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(362, 494);
    pathB.lineTo(623, 494);
    pathB.cubicTo(624.65686f, 494, 626, 494.895416f, 626, 496);
    pathB.lineTo(626, 657);
    pathB.cubicTo(626, 658.65686f, 624.65686f, 660, 623, 660);
    pathB.lineTo(362, 660);
    pathB.cubicTo(360.34314f, 660, 359, 658.65686f, 359, 657);
    pathB.lineTo(359, 496);
    pathB.cubicTo(359, 494.895416f, 360.34314f, 494, 362, 494);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpsciality_com161(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(656, 728);
    path.cubicTo(653.790833f, 728, 652, 729.790833f, 652, 732);
    path.lineTo(652, 789);
    path.cubicTo(652, 791.209106f, 653.790833f, 793, 656, 793);
    path.lineTo(769.001282f, 793);
    path.cubicTo(770.657532f, 792.999268f, 772, 791.656433f, 772, 790);
    path.lineTo(772, 731);
    path.cubicTo(772, 729.34314f, 770.65686f, 728, 769, 728);
    path.lineTo(656, 728);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(655, 729);
    pathB.lineTo(769, 729);
    pathB.cubicTo(770.65686f, 729, 772, 729.895447f, 772, 731);
    pathB.lineTo(772, 790);
    pathB.cubicTo(772, 791.65686f, 770.65686f, 793, 769, 793);
    pathB.lineTo(655, 793);
    pathB.cubicTo(653.34314f, 793, 652, 791.65686f, 652, 790);
    pathB.lineTo(652, 731);
    pathB.cubicTo(652, 729.895447f, 653.34314f, 729, 655, 729);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}
#endif

static void skpsudoestenegocios_com186(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(0, 495);
    path.lineTo(1.23685242e-14f, 293);
    path.lineTo(44, 293);
    path.quadTo(45.6568527f, 293, 46.8288002f, 294.171204f);
    path.quadTo(48, 295.34314f, 48, 297);
    path.lineTo(48, 491);
    path.quadTo(48, 492.65686f, 46.8288002f, 493.828796f);
    path.quadTo(45.6568527f, 495, 44, 495);
    path.lineTo(0, 495);
    path.close();
    path.moveTo(1, 294);
    path.lineTo(44, 294);
    path.cubicTo(45.6568565f, 294, 47, 295.34314f, 47, 297);
    path.lineTo(47, 491);
    path.cubicTo(47, 492.65686f, 45.6568565f, 494, 44, 494);
    path.lineTo(1, 494);
    path.lineTo(1, 294);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(48, 495);
    pathB.lineTo(24, 471);
    pathB.lineTo(24, 317);
    pathB.lineTo(48, 293);
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpthesuburbanite_com213(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(863.439026f, 692);
    path.lineTo(863.283264f, 692);
    path.lineTo(802, 708.420837f);
    path.lineTo(802, 718.773621f);
    path.lineTo(866, 701.624817f);
    path.lineTo(866, 701.557922f);
    path.lineTo(863.439026f, 692);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(783.256775f, 713.443054f);
    pathB.lineTo(863.428589f, 691.96106f);
    pathB.lineTo(866.016724f, 701.620361f);
    pathB.lineTo(785.84491f, 723.102356f);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skphostloco_com11(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(6.66133815e-16f, 648);
    path.lineTo(25.8522835f, 648);
    path.quadTo(27.5087376f, 647.999634f, 28.6807098f, 646.82843f);
    path.quadTo(29.8518829f, 645.656433f, 29.8522835f, 644);
    path.lineTo(29.8522835f, 467);
    path.quadTo(29.8518829f, 465.343536f, 28.6807098f, 464.17157f);
    path.quadTo(27.5087376f, 463.000397f, 25.8522835f, 463);
    path.lineTo(2.22044605e-16f, 463);
    path.lineTo(6.66133815e-16f, 648);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(0, 463);
    pathB.lineTo(30, 463);
    pathB.lineTo(30, 648);
    pathB.lineTo(0, 648);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpsergeychunkevich_com8(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(0, 926);
    path.lineTo(0, 0);
    path.lineTo(1265, 0);
    path.lineTo(1265, 926);
    path.lineTo(0, 926);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(37, 374);
    pathB.lineTo(37, 535);
    pathB.cubicTo(37, 536.65686f, 35.6568565f, 538, 34, 538);
    pathB.lineTo(1.02866934e-14f, 538);
    pathB.lineTo(6.12303177e-17f, 371);
    pathB.lineTo(34, 371);
    pathB.cubicTo(35.6568565f, 371, 37, 372.34314f, 37, 374);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skptracksflow_com9(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(16, 56);
    path.lineTo(32, 56);
    path.lineTo(32, 72);
    path.lineTo(16, 72);
    path.lineTo(16, 56);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kEvenOdd_FillType);
    pathB.moveTo(31.65625f, 70.0555649f);
    pathB.lineTo(31.65625f, 70.0554962f);
    pathB.lineTo(26.9727192f, 65.3615341f);
    pathB.cubicTo(27.6210003f, 64.4029694f, 28.0048752f, 63.2470932f, 28.0048752f, 62.0027809f);
    pathB.cubicTo(28.0048752f, 58.6875305f, 25.3199062f, 56, 22.0046558f, 56);
    pathB.cubicTo(18.6894073f, 56, 16.0031872f, 58.6875305f, 16.0031872f, 62.0027809f);
    pathB.cubicTo(16.0031872f, 65.3180008f, 18.6913433f, 68.0055618f, 22.0066261f, 68.0055618f);
    pathB.cubicTo(23.2509995f, 68.0055618f, 24.4072189f, 67.6187515f, 25.3657818f, 66.9704056f);
    pathB.lineTo(30.0599365f, 71.65625f);
    pathB.lineTo(30.0600014f, 71.65625f);
    pathB.cubicTo(30.2668133f, 71.875f, 30.5524693f, 71.9992828f, 30.868f, 71.9992828f);
    pathB.cubicTo(31.4994049f, 71.9992828f, 32.0014687f, 71.4909363f, 32.0014687f, 70.8595276f);
    pathB.cubicTo(32.0015335f, 70.5439072f, 31.875f, 70.2623444f, 31.65625f, 70.0555649f);
    pathB.close();
    pathB.moveTo(18.0054054f, 62.0027809f);
    pathB.cubicTo(18.0054054f, 59.7925949f, 19.7970943f, 58.0009079f, 22.0072823f, 58.0009079f);
    pathB.cubicTo(24.2174377f, 58.0009079f, 26.0091248f, 59.7925949f, 26.0091248f, 62.0027809f);
    pathB.cubicTo(26.0091248f, 64.2129364f, 24.2174377f, 66.0046234f, 22.0072803f, 66.0046234f);
    pathB.cubicTo(19.7970943f, 66.0045929f, 18.0054054f, 64.2129059f, 18.0054054f, 62.0027809f);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpautobutler_dk29(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(0, 926);
    path.lineTo(0, 0);
    path.lineTo(1265, 0);
    path.lineTo(1265, 926);
    path.lineTo(0, 926);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(21, 162);
    pathB.lineTo(21, 301);
    pathB.lineTo(8.57224448e-15f, 301);
    pathB.lineTo(6.12303177e-17f, 162);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skponlinecollege_org144(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(179, 407);
    path.cubicTo(177.34314f, 407, 176, 408.34314f, 176, 410);
    path.lineTo(176, 436);
    path.cubicTo(176, 437.65686f, 177.34314f, 439, 179, 439);
    path.lineTo(337.002289f, 439);
    path.cubicTo(338.105835f, 438.998779f, 339, 438.103821f, 339, 437);
    path.lineTo(339, 409);
    path.cubicTo(339, 407.896362f, 338.10611f, 407.001526f, 337.002838f, 407);
    path.lineTo(179, 407);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(179, 408);
    pathB.lineTo(337, 408);
    pathB.cubicTo(338.65686f, 408, 340, 408.895416f, 340, 410);
    pathB.lineTo(340, 436);
    pathB.cubicTo(340, 437.65686f, 338.65686f, 439, 337, 439);
    pathB.lineTo(179, 439);
    pathB.cubicTo(177.895432f, 439, 177, 437.65686f, 177, 436);
    pathB.lineTo(177, 410);
    pathB.cubicTo(177, 408.895416f, 177.895432f, 408, 179, 408);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpnational_com_au81(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(807, 817);
    path.quadTo(806.585876f, 817.000122f, 806.292908f, 817.292908f);
    path.quadTo(806.000122f, 817.585876f, 806, 818);
    path.lineTo(806, 881);
    path.lineTo(1111, 881);
    path.lineTo(1111, 818);
    path.quadTo(1110.99988f, 817.585876f, 1110.70715f, 817.292908f);
    path.quadTo(1110.41406f, 817.000122f, 1110, 817);
    path.lineTo(807, 817);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(807, 817);
    pathB.lineTo(1110, 817);
    pathB.cubicTo(1110.55225f, 817, 1111, 817.447693f, 1111, 818);
    pathB.lineTo(1111, 880);
    pathB.lineTo(806, 880);
    pathB.lineTo(806, 818);
    pathB.cubicTo(806, 817.447693f, 806.447693f, 817, 807, 817);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skprentacheat_com30(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(967, 263);
    path.quadTo(966.585876f, 263.000092f, 966.292908f, 263.292908f);
    path.quadTo(966.000122f, 263.585876f, 966, 264);
    path.lineTo(966, 301);
    path.lineTo(1214, 301);
    path.lineTo(1214, 264);
    path.quadTo(1213.99988f, 263.585876f, 1213.70715f, 263.292908f);
    path.quadTo(1213.41406f, 263.000092f, 1213, 263);
    path.lineTo(967, 263);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(967, 263);
    pathB.lineTo(1213, 263);
    pathB.cubicTo(1213.55225f, 263, 1214, 263.447723f, 1214, 264);
    pathB.lineTo(1214, 300);
    pathB.lineTo(966, 300);
    pathB.lineTo(966, 264);
    pathB.cubicTo(966, 263.447723f, 966.447693f, 263, 967, 263);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpbreakmystyle_com10(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(271.032867f, -5.32907052e-15f);
    path.lineTo(56.9671326f, -5.16253706e-15f);
    path.quadTo(52.7835083f, 3.69968891f, 48.7416f, 7.74160004f);
    path.quadTo(1, 55.4831848f, 1, 123);
    path.quadTo(1, 190.516815f, 48.7416f, 238.258392f);
    path.quadTo(96.4831848f, 286, 164, 286);
    path.quadTo(231.516815f, 286, 279.258392f, 238.258392f);
    path.quadTo(327, 190.516815f, 327, 123);
    path.quadTo(327, 55.4831848f, 279.258392f, 7.74160004f);
    path.quadTo(275.216431f, 3.69964004f, 271.032867f, -5.32907052e-15f);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(327, 123);
    pathB.quadTo(327, 190.516815f, 279.258392f, 238.258392f);
    pathB.quadTo(231.516815f, 286, 164, 286);
    pathB.quadTo(96.4831848f, 286, 48.7416f, 238.258392f);
    pathB.quadTo(1, 190.516815f, 1, 123);
    pathB.quadTo(1, 55.4831848f, 48.7416f, 7.74160004f);
    pathB.quadTo(96.4831848f, -40, 164, -40);
    pathB.quadTo(231.516815f, -40, 279.258392f, 7.74160004f);
    pathB.quadTo(327, 55.4831848f, 327, 123);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpsd_graphic_net104(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(475.421448f, 836.985962f);
    path.lineTo(461.280975f, 841.990662f);
    path.cubicTo(466.80899f, 857.609802f, 458.62854f, 874.752991f, 443.009399f, 880.281006f);
    path.cubicTo(435.199829f, 883.044983f, 427.009247f, 882.381897f, 420.080048f, 879.075378f);
    path.lineTo(413.620056f, 892.613037f);
    path.quadTo(430.419983f, 900.629761f, 447.96701f, 894.43811f);
    path.quadTo(448.00708f, 894.42395f, 448.014038f, 894.421509f);
    path.quadTo(448.043976f, 894.410889f, 448.061066f, 894.404846f);
    path.quadTo(465.596313f, 888.179932f, 473.613037f, 871.379944f);
    path.quadTo(477.351227f, 863.546143f, 478, 855.549866f);
    path.lineTo(478, 848.804321f);
    path.quadTo(477.528076f, 842.93811f, 475.421448f, 836.985962f);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(405.592621f, 909.435547f);
    pathB.lineTo(390.578583f, 867.014099f);
    pathB.lineTo(433, 852.000061f);
    pathB.lineTo(490.435486f, 879.40741f);
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

#if TRY_BROKEN_TESTS
/* this cubic/quad pair
 c = 430,280 430,278.895416 473.876068,278 528,278
 q = 430,280 430.009796,277.101196 458.703552,275.050262
 only intersect at the shared point (430,280)
 they sort backwards because the tangent from pt[0] to control pt[1]
 c' = (0.00000000000000000, -1.1045837402343750)
 q' = (0.0097961425781250000, -2.8988037109375000)
 suggests that the quad is counterclockwise of the cubic, when the reverse is true
 the angle code is fooled because the control pt[1] of both the quad and cubic
 is far away from cubic cntl [2] and quad pt [2].
 Maybe in angle setup, this instability can be detected to suppress sorting on the initial tangent
 Or the error term can be passed to NearRay that is magnified by the distance from the next ctrl?
 */
static void skpnaoxrane_ru23(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(458.703552f, 275.050262f);
    path.quadTo(487.41687f, 273.000702f, 528, 273);
    path.lineTo(529, 273);
    path.quadTo(530.242371f, 273.000305f, 531.121338f, 273.878693f);
    path.quadTo(531.999695f, 274.75766f, 532, 276);
    path.lineTo(532, 378);
    path.quadTo(531.990173f, 380.898804f, 503.296448f, 382.949738f);
    path.quadTo(474.58313f, 384.999298f, 434, 385);
    path.lineTo(433, 385);
    path.quadTo(431.75766f, 384.999695f, 430.878693f, 384.121307f);
    path.quadTo(430.000305f, 383.24234f, 430, 382);
    path.lineTo(430, 280);
    path.quadTo(430.009796f, 277.101196f, 458.703552f, 275.050262f);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(528, 278);
    pathB.lineTo(529, 278);
    pathB.cubicTo(530.65686f, 278, 532, 278, 532, 278);
    pathB.lineTo(532, 378);
    pathB.cubicTo(532, 379.104584f, 488.123932f, 380, 434, 380);
    pathB.lineTo(433, 380);
    pathB.cubicTo(431.34314f, 380, 430, 380, 430, 380);
    pathB.lineTo(430, 280);
    pathB.cubicTo(430, 278.895416f, 473.876068f, 278, 528, 278);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

/* didn't investigate thoroughly, but looks to be missorting quad and cubic
    {{468.507751,560.724426}, {467.275146,552.856262}, {465.84668,547.288391}}
    {{463.779907,542.671143}, {464.829529,542.672974}, {466.946289,550.755676}, {468.507751,560.724426}}
    decision maker is case 14 leftLessThanRight
 */
static void skptcmevents_org23(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(465.503998f, 546);
    path.lineTo(347, 546);
    path.lineTo(347, 632);
    path.lineTo(469.104248f, 632);
    path.quadTo(470.79007f, 627.638672f, 471.833496f, 621.036255f);
    path.quadTo(474.902588f, 601.562866f, 470.591064f, 574.024353f);
    path.lineTo(468.507751f, 560.724426f);
    path.quadTo(467.275146f, 552.856262f, 465.84668f, 547.288391f);
    path.quadTo(465.670349f, 546.601501f, 465.503998f, 546);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(363.052246f, 542.495361f);
    pathB.lineTo(463.779907f, 542.671143f);
    pathB.cubicTo(464.829529f, 542.672974f, 466.946289f, 550.755676f, 468.507751f, 560.724426f);
    pathB.lineTo(470.591064f, 574.024353f);
    pathB.cubicTo(476.26178f, 610.226624f, 471.498932f, 639.557922f, 459.953003f, 639.537781f);
    pathB.lineTo(368.727936f, 639.378601f);
    pathB.cubicTo(351.933868f, 639.349304f, 337.053741f, 631.244324f, 335.492249f, 621.275574f);
    pathB.lineTo(325.968597f, 560.475708f);
    pathB.cubicTo(324.407104f, 550.506958f, 341.01001f, 542.456909f, 363.052246f, 542.495361f);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpredbullskatearcade_es16(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(936.765625f, 458.965302f);
    path.cubicTo(937.028442f, 453.863251f, 933.145813f, 449.864502f, 928.093445f, 450.033905f);
    path.lineTo(661.882263f, 458.958862f);
    path.lineTo(661.875366f, 458.959106f);
    path.cubicTo(656.828369f, 459.13205f, 652.525085f, 463.399719f, 652.258545f, 468.496124f);
    path.lineTo(652.258179f, 468.503662f);
    path.lineTo(649.021729f, 531.322754f);
    path.cubicTo(648.75885f, 536.424805f, 652.641479f, 540.423523f, 657.693848f, 540.25415f);
    path.lineTo(923.905029f, 531.329163f);
    path.cubicTo(928.955017f, 531.159851f, 933.262268f, 526.890442f, 933.528809f, 521.791565f);
    path.lineTo(933.529175f, 521.784363f);
    path.lineTo(936.765625f, 458.965302f);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(661.882263f, 458.958862f);
    pathB.lineTo(928.093445f, 450.033905f);
    pathB.cubicTo(929.103882f, 450, 929.709961f, 454.108612f, 929.447144f, 459.210663f);
    pathB.lineTo(926.210693f, 522.029724f);
    pathB.cubicTo(926.079224f, 524.58075f, 925.153442f, 526.676208f, 924.143066f, 526.710083f);
    pathB.lineTo(657.931885f, 535.635071f);
    pathB.cubicTo(652.879456f, 535.804443f, 648.890259f, 533.873779f, 649.021729f, 531.322754f);
    pathB.lineTo(652.258179f, 468.503662f);
    pathB.cubicTo(652.520996f, 463.401611f, 656.829834f, 459.128235f, 661.882263f, 458.958862f);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpfinanzasdigital_com9(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(156, 126);
    path.quadTo(154.343552f, 126.000397f, 153.17157f, 127.17157f);
    path.quadTo(152.000397f, 128.343552f, 152, 130);
    path.lineTo(152, 174);
    path.lineTo(1114, 174);
    path.lineTo(1114, 130);
    path.quadTo(1113.99963f, 128.343552f, 1112.82837f, 127.17157f);
    path.quadTo(1111.65649f, 126.000397f, 1110, 126);
    path.lineTo(156, 126);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(156, 126);
    pathB.lineTo(1110, 126);
    pathB.cubicTo(1111.65686f, 126, 1113, 127.790863f, 1113, 130);
    pathB.lineTo(1113, 174);
    pathB.lineTo(153, 174);
    pathB.lineTo(153, 130);
    pathB.cubicTo(153, 127.790863f, 154.34314f, 126, 156, 126);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}
#endif

static void skppartainasdemo250_org56(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(182.000015f, 645);
    path.lineTo(182, 640);
    path.cubicTo(174.322327f, 640, 166.644669f, 637.071045f, 160.786804f, 631.213196f);
    path.cubicTo(149.071075f, 619.497437f, 149.071075f, 600.502563f, 160.786804f, 588.786804f);
    path.lineTo(157.251266f, 585.251221f);
    path.quadTo(147, 595.502502f, 147.000015f, 610);
    path.quadTo(147, 624.482605f, 157.230255f, 634.727722f);
    path.quadTo(157.251251f, 634.748779f, 157.251282f, 634.748779f);
    path.quadTo(157.282852f, 634.780334f, 157.272263f, 634.769775f);
    path.quadTo(167.517334f, 645, 182.000015f, 645);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(182, 659.497498f);
    pathB.lineTo(206.748749f, 634.748718f);
    pathB.lineTo(182.000015f, 610);
    pathB.lineTo(132.502533f, 610);
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpmlk_com326(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(154, 670);
    path.cubicTo(151.238571f, 670, 149, 672.238586f, 149, 675);
    path.lineTo(149, 710.001465f);
    path.cubicTo(149.000809f, 712.209961f, 150.791367f, 714, 153, 714);
    path.lineTo(189, 714);
    path.cubicTo(191.209137f, 714, 193, 712.209167f, 193, 710);
    path.lineTo(193, 675);
    path.cubicTo(193, 672.238586f, 190.761429f, 670, 188, 670);
    path.lineTo(154, 670);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(154, 671);
    pathB.lineTo(188, 671);
    pathB.cubicTo(190.761429f, 671, 193, 672.790833f, 193, 675);
    pathB.lineTo(193, 710);
    pathB.cubicTo(193, 712.761414f, 190.761429f, 715, 188, 715);
    pathB.lineTo(154, 715);
    pathB.cubicTo(151.238571f, 715, 149, 712.761414f, 149, 710);
    pathB.lineTo(149, 675);
    pathB.cubicTo(149, 672.790833f, 151.238571f, 671, 154, 671);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpcyclist_friends_gr52(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(50, 182);
    path.lineTo(1215, 182);
    path.lineTo(1215, 202);
    path.quadTo(1214.99951f, 204.070572f, 1213.53552f, 205.535538f);
    path.quadTo(1212.07056f, 206.999496f, 1210, 207);
    path.lineTo(55, 207);
    path.quadTo(52.9294319f, 206.999496f, 51.4644661f, 205.535538f);
    path.quadTo(50.0004997f, 204.070572f, 50, 202);
    path.lineTo(50, 182);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(50, 183);
    pathB.lineTo(1215, 183);
    pathB.lineTo(1215, 202);
    pathB.cubicTo(1215, 204.761429f, 1212.76147f, 207, 1210, 207);
    pathB.lineTo(55, 207);
    pathB.cubicTo(52.238575f, 207, 50, 204.761429f, 50, 202);
    pathB.lineTo(50, 183);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

/* cubic ends just above opp line */
static void skpwww_fj_p_com_22(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(172, 201);
    path.lineTo(172, 202);
    path.lineTo(220, 202);
    path.cubicTo(221.65686f, 202, 223, 200.65686f, 223, 199);
    path.cubicTo(223, 200.104568f, 221.65686f, 201, 220, 201);
    path.lineTo(172, 201);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(161, 202);
    pathB.lineTo(161, 199);
    pathB.lineTo(223, 199.000015f);
    pathB.lineTo(223, 202);
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

#define TRY_SEPT_BROKEN_TESTS 0
#if TRY_SEPT_BROKEN_TESTS
// pair of lines are not quite coincident, so sorting line/cubic fails (i think)
static void skpwww_lavoixdunord_fr_11(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(806, 57);
    path.cubicTo(806, 55.3431473f, 807.34314f, 54, 809, 54);
    path.lineTo(930, 54);
    path.cubicTo(931.65686f, 54, 933, 55.3431473f, 933, 57);
    path.lineTo(933, 91);
    path.cubicTo(933, 92.6568527f, 931.65686f, 94, 930, 94);
    path.lineTo(809, 94);
    path.cubicTo(807.34314f, 94, 806, 92.6568527f, 806, 91);
    path.lineTo(806, 57);
    path.close();
    path.moveTo(808, 58);
    path.cubicTo(808, 56.8954315f, 808.895447f, 56, 810, 56);
    path.lineTo(929, 56);
    path.cubicTo(930.104553f, 56, 931, 56.8954315f, 931, 58);
    path.lineTo(931, 90);
    path.cubicTo(931, 91.1045685f, 930.104553f, 92, 929, 92);
    path.lineTo(810, 92);
    path.cubicTo(808.895447f, 92, 808, 91.1045685f, 808, 90);
    path.lineTo(808, 58);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(806, 54);
    pathB.lineTo(808, 56);
    pathB.lineTo(935.02002f, 56.0200005f);
    pathB.lineTo(933, 54);
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

// pair of curves have nearly the same initial tangent but are sorting by
// that alone sorts them incorrectly. Need to detect that tangents are nearly
// identical and not reliable by themselves
static void skppptv_com_62(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(173, 5342);
    path.quadTo(171.343536f, 5342.00049f, 170.17157f, 5343.17139f);
    path.quadTo(169.000397f, 5344.34375f, 169, 5346);
    path.lineTo(169, 5372);
    path.lineTo(234, 5372);
    path.lineTo(234, 5346);
    path.quadTo(233.999603f, 5344.34375f, 232.82843f, 5343.17139f);
    path.quadTo(231.656464f, 5342.00049f, 230, 5342);
    path.lineTo(173, 5342);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(173, 5342);
    pathB.lineTo(230, 5342);
    pathB.cubicTo(231.65686f, 5342, 233, 5343.79102f, 233, 5346);
    pathB.lineTo(233, 5372);
    pathB.lineTo(169, 5372);
    pathB.lineTo(169, 5346);
    pathB.cubicTo(169, 5343.79102f, 170.790863f, 5342, 173, 5342);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

// nearly identical to lavoixdunord -- to not-quite-coincident lines
static void skpwww_booking_com_68(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(90, 187);
    path.cubicTo(90, 185.34314f, 91.3431473f, 184, 93, 184);
    path.lineTo(588, 184);
    path.cubicTo(589.65686f, 184, 591, 185.34314f, 591, 187);
    path.lineTo(591, 218);
    path.cubicTo(591, 219.65686f, 589.65686f, 221, 588, 221);
    path.lineTo(93, 221);
    path.cubicTo(91.3431473f, 221, 90, 219.65686f, 90, 218);
    path.lineTo(90, 187);
    path.close();
    path.moveTo(92, 188);
    path.cubicTo(92, 186.895432f, 92.8954315f, 186, 94, 186);
    path.lineTo(587, 186);
    path.cubicTo(588.104553f, 186, 589, 186.895432f, 589, 188);
    path.lineTo(589, 217);
    path.cubicTo(589, 218.104568f, 588.104553f, 219, 587, 219);
    path.lineTo(94, 219);
    path.cubicTo(92.8954315f, 219, 92, 218.104568f, 92, 217);
    path.lineTo(92, 188);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(90, 184);
    pathB.lineTo(92, 186);
    pathB.lineTo(593.02002f, 186.020004f);
    pathB.lineTo(591, 184);
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

// visually looks like lavoixdunord and www_booking_com
static void skpwww_despegar_com_mx_272(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(635, 1788);
    path.cubicTo(635, 1786.34314f, 636.34314f, 1785, 638, 1785);
    path.lineTo(832, 1785);
    path.cubicTo(833.65686f, 1785, 835, 1786.34314f, 835, 1788);
    path.lineTo(835, 1812);
    path.cubicTo(835, 1813.65686f, 833.65686f, 1815, 832, 1815);
    path.lineTo(638, 1815);
    path.cubicTo(636.34314f, 1815, 635, 1813.65686f, 635, 1812);
    path.lineTo(635, 1788);
    path.close();
    path.moveTo(637, 1789);
    path.cubicTo(637, 1787.89539f, 637.895447f, 1787, 639, 1787);
    path.lineTo(831, 1787);
    path.cubicTo(832.104553f, 1787, 833, 1787.89539f, 833, 1789);
    path.lineTo(833, 1811);
    path.cubicTo(833, 1812.10461f, 832.104553f, 1813, 831, 1813);
    path.lineTo(639, 1813);
    path.cubicTo(637.895447f, 1813, 637, 1812.10461f, 637, 1811);
    path.lineTo(637, 1789);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(835, 1785);
    pathB.lineTo(833, 1787);
    pathB.lineTo(832.97998f, 1817.02002f);
    pathB.lineTo(835, 1815);
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}
#endif

static void skpwww_joomla_org_23(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(320, 347);
    path.cubicTo(320, 344.238586f, 322.238586f, 342, 325, 342);
    path.lineTo(416, 342);
    path.cubicTo(418.761414f, 342, 421, 344.238586f, 421, 347);
    path.cubicTo(421, 344.790863f, 418.761414f, 343, 416, 343);
    path.lineTo(325, 343);
    path.cubicTo(322.238586f, 343, 320, 344.790863f, 320, 347);
    path.close();
    path.moveTo(320, 378);
    path.cubicTo(320, 380.761414f, 322.238586f, 383, 325, 383);
    path.lineTo(416, 383);
    path.cubicTo(418.761414f, 383, 421, 380.761414f, 421, 378);
    path.cubicTo(421, 380.209137f, 418.761414f, 382, 416, 382);
    path.lineTo(325, 382);
    path.cubicTo(322.238586f, 382, 320, 380.209137f, 320, 378);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(320, 383);
    pathB.lineTo(320, 378);
    pathB.lineTo(421, 378.000031f);
    pathB.lineTo(421, 383);
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpwww_macrumors_com_131(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(136, 14089);
    path.lineTo(136, 14056);
    path.lineTo(778, 14056);
    path.lineTo(778, 14089);
    path.quadTo(777.999573f, 14090.6562f, 776.82843f, 14091.8281f);
    path.quadTo(775.656433f, 14093, 774, 14093);
    path.lineTo(140, 14093);
    path.quadTo(138.343552f, 14093, 137.17157f, 14091.8281f);
    path.quadTo(136.000397f, 14090.6562f, 136, 14089);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(136, 14057);
    pathB.lineTo(778, 14057);
    pathB.lineTo(778, 14089);
    pathB.cubicTo(778, 14091.209f, 776.209167f, 14093, 774, 14093);
    pathB.lineTo(140, 14093);
    pathB.cubicTo(137.790863f, 14093, 136, 14091.209f, 136, 14089);
    pathB.lineTo(136, 14057);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpwww_leadpages_net_84(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(377.1716f, 5910.17139f);
    path.cubicTo(376.447723f, 5910.89551f, 376, 5911.89551f, 376, 5913);
    path.lineTo(376, 5972);
    path.cubicTo(376, 5974.20898f, 377.790863f, 5976, 380, 5976);
    path.cubicTo(378.34314f, 5976, 377, 5974.20898f, 377, 5972);
    path.lineTo(377, 5913);
    path.cubicTo(377, 5912.17139f, 377.335785f, 5911.42188f, 377.878693f, 5910.87891f);
    path.lineTo(377.1716f, 5910.17139f);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(376, 5909);
    pathB.lineTo(378.481873f, 5909);
    pathB.lineTo(379.999878f, 5976);
    pathB.lineTo(376, 5976);
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpwww_briian_com_34(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(843, 216);
    path.cubicTo(843, 213.238571f, 845.238586f, 211, 848, 211);
    path.lineTo(1191, 211);
    path.cubicTo(1193.76147f, 211, 1196, 213.238571f, 1196, 216);
    path.lineTo(1196, 779);
    path.cubicTo(1196, 781.761414f, 1193.76147f, 784, 1191, 784);
    path.lineTo(848, 784);
    path.cubicTo(845.238586f, 784, 843, 781.761414f, 843, 779);
    path.lineTo(843, 216);
    path.close();
    path.moveTo(844, 217);
    path.cubicTo(844, 214.238571f, 846.238586f, 212, 849, 212);
    path.lineTo(1190, 212);
    path.cubicTo(1192.76147f, 212, 1195, 214.238571f, 1195, 217);
    path.lineTo(1195, 778);
    path.cubicTo(1195, 779.65686f, 1192.76147f, 781, 1190, 781);
    path.lineTo(849, 781);
    path.cubicTo(846.238586f, 781, 844, 779.65686f, 844, 778);
    path.lineTo(844, 217);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(843, 784);
    pathB.lineTo(843, 779);
    pathB.lineTo(1196, 779.000061f);
    pathB.lineTo(1196, 784);
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}


static void skpwww_sciality_com_100(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(162, 468);
    path.cubicTo(159.790863f, 468, 158, 469.790863f, 158, 472);
    path.lineTo(158, 528);
    path.cubicTo(158, 530.209106f, 159.790863f, 532, 162, 532);
    path.lineTo(275, 532);
    path.cubicTo(277.209137f, 532, 279, 530.209106f, 279, 528);
    path.lineTo(279, 472);
    path.cubicTo(279, 469.790863f, 277.209137f, 468, 275, 468);
    path.lineTo(162, 468);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(275, 468);
    pathB.cubicTo(276.65686f, 468, 278, 469.34314f, 278, 471);
    pathB.lineTo(278, 529);
    pathB.cubicTo(278, 530.65686f, 276.65686f, 532, 275, 532);
    pathB.lineTo(161, 532);
    pathB.cubicTo(159.34314f, 532, 158, 530.65686f, 158, 529);
    pathB.lineTo(158, 471);
    pathB.cubicTo(158, 469.34314f, 159.34314f, 468, 161, 468);
    pathB.lineTo(275, 468);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

#if TRY_SEPT_BROKEN_TESTS
static void skpwww_sciality_com_101(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(162, 468);
    path.cubicTo(159.790863f, 468, 158, 469.790863f, 158, 472);
    path.lineTo(158, 528);
    path.cubicTo(158, 530.209106f, 159.790863f, 532, 162, 532);
    path.lineTo(275.009186f, 532);
    path.cubicTo(276.661774f, 531.994995f, 278, 530.653748f, 278, 529);
    path.lineTo(278, 471);
    path.cubicTo(278, 469.346375f, 276.662079f, 468.005249f, 275.009705f, 468);
    path.lineTo(162, 468);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(161, 469);
    pathB.lineTo(275, 469);
    pathB.cubicTo(276.65686f, 469, 278, 469.895416f, 278, 471);
    pathB.lineTo(278, 529);
    pathB.cubicTo(278, 530.65686f, 276.65686f, 532, 275, 532);
    pathB.lineTo(161, 532);
    pathB.cubicTo(159.34314f, 532, 158, 530.65686f, 158, 529);
    pathB.lineTo(158, 471);
    pathB.cubicTo(158, 469.895416f, 159.34314f, 469, 161, 469);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}
#endif

static void skpwww_meb_gov_tr_5(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(137.34314f, 145.34314f);
    path.quadTo(139.687088f, 143.000793f, 143, 143);
    path.lineTo(242, 143);
    path.quadTo(245.312912f, 143.000793f, 247.65686f, 145.34314f);
    path.quadTo(249.999207f, 147.687088f, 250, 151);
    path.lineTo(250, 177);
    path.lineTo(135, 177);
    path.lineTo(135, 151);
    path.quadTo(135.000793f, 147.687088f, 137.34314f, 145.34314f);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(135, 143);
    pathB.lineTo(250, 143);
    pathB.lineTo(250, 177);
    pathB.lineTo(135, 177);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

#if TRY_SEPT_BROKEN_TESTS
static void skpwww_meb_gov_tr_6(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(143, 143);
    path.quadTo(139.687088f, 143.000793f, 137.34314f, 145.34314f);
    path.quadTo(135.000793f, 147.687088f, 135, 151);
    path.lineTo(135, 177);
    path.lineTo(250, 177);
    path.lineTo(250, 151);
    path.quadTo(249.999207f, 147.687088f, 247.65686f, 145.34314f);
    path.quadTo(245.312912f, 143.000793f, 242, 143);
    path.lineTo(143, 143);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(143, 143);
    pathB.lineTo(242, 143);
    pathB.cubicTo(245.865997f, 143, 249, 146.581726f, 249, 151);
    pathB.lineTo(249, 177);
    pathB.lineTo(135, 177);
    pathB.lineTo(135, 151);
    pathB.cubicTo(135, 146.581726f, 138.581726f, 143, 143, 143);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}
#endif

static void skpgithub_io_25(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(1001.87866f, 14.8786793f);
    path.quadTo(1002.75745f, 14.0001001f, 1004, 14);
    path.lineTo(1105, 14);
    path.quadTo(1106.24255f, 14.0001001f, 1107.12134f, 14.8786793f);
    path.quadTo(1107.99988f, 15.7574596f, 1108, 17);
    path.lineTo(1108, 41);
    path.quadTo(1107.99988f, 42.2425423f, 1107.12134f, 43.1213188f);
    path.quadTo(1106.24255f, 43.9999008f, 1105, 44);
    path.lineTo(1004, 44);
    path.quadTo(1002.75745f, 43.9999008f, 1001.87866f, 43.1213188f);
    path.quadTo(1001.00012f, 42.2425423f, 1001, 41);
    path.lineTo(1001, 17);
    path.quadTo(1001.00012f, 15.7574596f, 1001.87866f, 14.8786793f);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(1005, 16);
    pathB.lineTo(1104, 16);
    pathB.cubicTo(1105.10461f, 16, 1106, 16.8954296f, 1106, 18);
    pathB.lineTo(1106, 40);
    pathB.cubicTo(1106, 41.1045685f, 1105.10461f, 42, 1104, 42);
    pathB.lineTo(1005, 42);
    pathB.cubicTo(1003.89545f, 42, 1003, 41.1045685f, 1003, 40);
    pathB.lineTo(1003, 18);
    pathB.cubicTo(1003, 16.8954296f, 1003.89545f, 16, 1005, 16);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpgithub_io_26(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(1001.87866f, 14.8786793f);
    path.quadTo(1002.75745f, 14.0001001f, 1004, 14);
    path.lineTo(1105, 14);
    path.quadTo(1106.24255f, 14.0001001f, 1107.12134f, 14.8786793f);
    path.quadTo(1107.99988f, 15.7574596f, 1108, 17);
    path.lineTo(1108, 41);
    path.quadTo(1107.99988f, 42.2425423f, 1107.12134f, 43.1213188f);
    path.quadTo(1106.24255f, 43.9999008f, 1105, 44);
    path.lineTo(1004, 44);
    path.quadTo(1002.75745f, 43.9999008f, 1001.87866f, 43.1213188f);
    path.quadTo(1001.00012f, 42.2425423f, 1001, 41);
    path.lineTo(1001, 17);
    path.quadTo(1001.00012f, 15.7574596f, 1001.87866f, 14.8786793f);
    path.close();
    path.moveTo(1003, 18);
    path.cubicTo(1003, 16.8954296f, 1003.89545f, 16, 1005, 16);
    path.lineTo(1104, 16);
    path.cubicTo(1105.10461f, 16, 1106, 16.8954296f, 1106, 18);
    path.lineTo(1106, 40);
    path.cubicTo(1106, 41.1045685f, 1105.10461f, 42, 1104, 42);
    path.lineTo(1005, 42);
    path.cubicTo(1003.89545f, 42, 1003, 41.1045685f, 1003, 40);
    path.lineTo(1003, 18);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(1108, 14);
    pathB.lineTo(1106, 16);
    pathB.lineTo(1105.97998f, 46.0200005f);
    pathB.lineTo(1108, 44);
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

static void skpskpicture14(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(0, 994);
    path.lineTo(0, 0);
    path.lineTo(512, 0);
    path.lineTo(512, 994);
    path.lineTo(0, 994);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kWinding_FillType);
    pathB.moveTo(-317, 168);
    pathB.quadTo(-317, 166.757385f, -316.121338f, 165.878662f);
    pathB.quadTo(-315.242645f, 165, -314, 165);
    pathB.lineTo(320, 165);
    pathB.quadTo(321.242615f, 165, 322.121338f, 165.878662f);
    pathB.quadTo(323, 166.757385f, 323, 168);
    pathB.lineTo(323, 193);
    pathB.lineTo(-317, 193);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}

#if TRY_SEPT_BROKEN_TESTS
static void skpskpicture15(skiatest::Reporter* reporter) {
    SkPath path;
    path.setFillType(SkPath::kEvenOdd_FillType);
    path.moveTo(0, 193);
    path.lineTo(323, 193);
    path.lineTo(323, 168);
    path.quadTo(323, 166.757385f, 322.121338f, 165.878662f);
    path.quadTo(321.242615f, 165, 320, 165);
    path.lineTo(0, 165);
    path.lineTo(0, 193);
    path.close();
    SkPath pathB;
    pathB.setFillType(SkPath::kInverseWinding_FillType);
    pathB.moveTo(-314, 165);
    pathB.lineTo(320, 165);
    pathB.cubicTo(321.65686f, 165, 323, 166.34314f, 323, 168);
    pathB.lineTo(323, 192);
    pathB.lineTo(-317, 192);
    pathB.lineTo(-317, 168);
    pathB.cubicTo(-317, 166.34314f, -315.65686f, 165, -314, 165);
    pathB.close();
    testPathOp(reporter, path, pathB, kIntersect_PathOp);
}
#endif

static void (*firstTest)(skiatest::Reporter* ) = 0;

static struct TestDesc tests[] = {
    TEST(skpskpicture14),
#if TRY_SEPT_BROKEN_TESTS
    TEST(skpskpicture15),
    TEST(skpwww_meb_gov_tr_6),
    TEST(skpwww_sciality_com_101),
    TEST(skpwww_booking_com_68),  // similar to lavoixdunord
    TEST(skpwww_despegar_com_mx_272),  // similar to lavoixdunord
    TEST(skpwww_lavoixdunord_fr_11),  // not quite coincident, sorting line/cubic fails
    TEST(skppptv_com_62),  // cubic have nearly identical tangents, sort incorrectly
#endif
#if TRY_BROKEN_TESTS
    TEST(skppchappy_com_au102),
    TEST(skpsciality_com161),
    TEST(skpi_gino_com16),
    TEST(skpnaoxrane_ru23),  // see test for failure evaluation
    TEST(skptcmevents_org23),  // see test for (partial) failure evaluation
    TEST(skpredbullskatearcade_es16),  // cubic have nearly identical tangents, sort incorrectly
    TEST(skpfinanzasdigital_com9),  // cubic/quad tangents too close to sort
#endif
    TEST(skpgithub_io_26),
    TEST(skpgithub_io_25),
    TEST(skpwww_meb_gov_tr_5),
    TEST(skpwww_sciality_com_100),
    TEST(skpwww_joomla_org_23),
    TEST(skpwww_macrumors_com_131),
    TEST(skpwww_briian_com_34),
    TEST(skpwww_leadpages_net_84),
    TEST(skpwww_fj_p_com_22),
    TEST(skppartainasdemo250_org56),
    TEST(skpsd_graphic_net104),
    TEST(skpbreakmystyle_com10),
    TEST(skpnational_com_au81),
    TEST(skprentacheat_com30),
    TEST(skptracksflow_com9),
    TEST(skpautobutler_dk29),
    TEST(skponlinecollege_org144),
    TEST(skphostloco_com11),
    TEST(skpsergeychunkevich_com8),
    TEST(skpmlk_com326),
    TEST(skpcyclist_friends_gr52),
    TEST(skpfrauen_magazin_com83),
    TEST(skpthesuburbanite_com213),
    TEST(skpsudoestenegocios_com186),
    TEST(skpmtrk_uz27),
    TEST(skpilkoora_com37),
    TEST(skpmm4everfriends_com43),
    TEST(skpflite_com41),
    TEST(skpcheeseandburger_com225),
    TEST(skpeverytechpro_blogspot_com100),
};

static const size_t testCount = SK_ARRAY_COUNT(tests);

static bool runReverse = false;
static void (*stopTest)(skiatest::Reporter* ) = 0;

static void PathOpsSkpTest(skiatest::Reporter* reporter) {
#if DEBUG_SHOW_TEST_NAME
    strncpy(DEBUG_FILENAME_STRING, "", DEBUG_FILENAME_STRING_LENGTH);
#endif
    RunTestSet(reporter, tests, testCount, firstTest, stopTest, runReverse);
}

#include "TestClassDef.h"

DEFINE_TESTCLASS_SHORT(PathOpsSkpTest)
