/*
***************************************************************************
** SkFontHost_android_hy_fonthost.cpp
***************************************************************************
**
** 2013.10.08 Android KK
**
** Mobile Communication R&D Center, Hanyang
** Sangmin, Lee (TMSword) ( Mobile Communication R&D Center / Senior Researcher )
**
** This code is a program that changes the font.
**
***************************************************************************
*/
// CAPP_FONTS_HYFONTS Global Font Manager

#ifdef ON_CAPP_FONTS  // This added to disable CAPP_FONTS to  avoid crash for fonts added in system_fonts.xml without serif on TOP.
#ifdef CAPP_FONTS
static bool
isInitFontManager()
{
    if( !getInstance() )
    {
        HyLogef( "gFontManager is null" );
        return false;
    }
    return true;
}

void
SkFontHost::SelectDefaultTypeface( uint32_t fontIndex )
{
    if( isInitFontManager() )
        getInstance()->saveFontIndex( fontIndex );
}

SkTypeface *
SkFontHost::CreateDefaultTypeface( SkTypeface::Style style )
{
    const char * defaultFamilyName = getInstance()->getDefaultFamilyName();
    return SkFontHost::CreateTypeface( NULL, defaultFamilyName, style );
}


SkTypeface *
SkFontHost::GetDefaultTypeface( SkTypeface::Style style )
{
    if( isInitFontManager() )
        return getInstance()->getDefaultTypeface( style ); // cached.
    return NULL;
}

void
SkFontHost::UpdateDownloadFonts()
{
    if( isInitFontManager() )
        getInstance()->loadPreData( NULL, false );
}

void
SkFontHost::UpdateDefaulTypeface()
{
    if( isInitFontManager() )
        getInstance()->updateDefaultNormal();
}

uint32_t
SkFontHost::GetDefaultTypefaceIndex()
{
    if( isInitFontManager() )
        return getInstance()->getCurrentFontIndex();
    return 0;
}

uint32_t
SkFontHost::GetNumAllFonts()
{
    if( isInitFontManager() )
        return getInstance()->getFamilyCount();
    return 0;
}

uint32_t
SkFontHost::GetNumEmbeddedFonts()
{
    if( isInitFontManager() )
        return getInstance()->getEmbeddedFamilyCount();
    return 0;
}

const char *
SkFontHost::GetDownloadFontName( uint32_t fontIndex )
{
    if( isInitFontManager() )
        return getInstance()->getDownloadFontName( fontIndex );
    return NULL;
}

const char *
SkFontHost::GetDownloadFontAppName( uint32_t fontIndex )
{
    if( isInitFontManager() )
        return getInstance()->getDownloadFontAppName( fontIndex );
    return NULL;
}

const char *
SkFontHost::GetFontWebFaceName( uint32_t fontIndex )
{
    if( isInitFontManager() )
        return getInstance()->getFontWebFaceName( fontIndex );
    return NULL;
}

const char *
SkFontHost::GetFontFullPath( uint32_t fontIndex )
{
    if( isInitFontManager() )
        return getInstance()->getFontFullPath( fontIndex );
    return NULL;
}

const char *
SkFontHost::GetDownloadFontSrcPath()
{
    return SYSTEM_DL_FONTAPP_SRC_DIR;
}

const char *
SkFontHost::GetDownloadFontDstPath()
{
    return SYSTEM_DL_FONTAPP_DST_DIR;
}

uint32_t
SkFontHost::GetSystemDefaultTypefaceIndex()
{
    return SYSTEM_DEFAULT_FAMILY_INDEX;
}

uint32_t
SkFontHost::GetNumNewFonts()
{
    if( isInitFontManager() )
        return getInstance()->getNumNewFonts();
    return 0;
}

const char *
SkFontHost::GetNewFontAppName( uint32_t fontIndex )
{
    if( isInitFontManager() )
        return getInstance()->getNewFontAppName( fontIndex );
    return NULL;
}

uint32_t
SkFontHost::GetCheckNewFont( uint32_t fontIndex )
{
    if( isInitFontManager() )
        return getInstance()->getCheckNewFont( fontIndex );
    return 0;
}

bool
SkFontHost::AddNewFont( uint32_t fontIndex )
{
    if( isInitFontManager() )
        return getInstance()->addNewFont( fontIndex );
    return false;
}

void
SkFontHost::SaveNewFont()
{
    if( isInitFontManager() )
        getInstance()->saveNewFont();
}

uint32_t
SkFontHost::UpdateFontManager()
{
    if( isInitFontManager() )
    {
        LoadState state = getInstance()->updateFontManager();
        switch( state )
        {
        case load_restart: return ( uint32_t )STATE_DL_FONTAPP_RESTART;
        default: return ( uint32_t )getInstance()->searchFontApps();
        }
    }
    return STATE_DL_FONTAPP_KEEP;
}

//                                                                        
#if defined( CAPP_FONTS ) && defined( CAPP_FONTS_HINTING ) && !defined( CAPP_FONTS_JP )
bool
SkFontHost::IsRobotoTypefaceIndex()
{
    if( isInitFontManager() )
        return getInstance()->isRobotoTypefaceIndex();
    return false;
}

#endif
// CAPP_FONTS_HINTING_HYFONTS_END
#endif
// CAPP_FONTS_HYFONTS_END

#endif /* ON_CAPP_FONTS */
