# Copyright (c) 2011 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'chromium_code': 1,
  },
  'targets': [
    {
      'target_name': 'net_base',
      'type': '<(library)',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
        '../build/temp_gyp/googleurl.gyp:googleurl',
        '../crypto/crypto.gyp:crypto',
        '../sdch/sdch.gyp:sdch',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/zlib/zlib.gyp:zlib',
        'net_resources',
        'ssl_false_start_blacklist_process#host',
      ],
      'sources': [
        'base/address_family.h',
        'base/address_list.cc',
        'base/address_list.h',
        'base/address_list_net_log_param.cc',
        'base/address_list_net_log_param.h',
        'base/asn1_util.cc',
        'base/auth.cc',
        'base/auth.h',
        'base/backoff_entry.cc',
        'base/backoff_entry.h',
        'base/bandwidth_metrics.cc',
        'base/bandwidth_metrics.h',
        'base/cache_type.h',
        'base/capturing_net_log.cc',
        'base/capturing_net_log.h',
        'base/cert_database.cc',
        'base/cert_database.h',
        'base/cert_database_mac.cc',
        'base/cert_database_nss.cc',
        'base/cert_database_openssl.cc',
        'base/cert_database_win.cc',
        'base/cert_status_flags.cc',
        'base/cert_status_flags.h',
        'base/cert_verifier.cc',
        'base/cert_verifier.h',
        'base/cert_verify_result.cc',
        'base/cert_verify_result.h',
        'base/completion_callback.h',
        'base/connection_type_histograms.cc',
        'base/connection_type_histograms.h',
        'base/cookie_monster.cc',
        'base/cookie_monster.h',
        'base/cookie_options.h',
        'base/cookie_policy.h',
        'base/cookie_store.cc',
        'base/cookie_store.h',
        'base/crypto_module.h',
        'base/crypto_module_nss.cc',
        'base/crypto_module_openssl.cc',
        'base/data_url.cc',
        'base/data_url.h',
        'base/directory_lister.cc',
        'base/directory_lister.h',
        'base/dns_reload_timer.cc',
        'base/dns_reload_timer.h',
        'base/dnssec_chain_verifier.cc',
        'base/dnssec_chain_verifier.h',
        'base/dnssec_keyset.cc',
        'base/dnssec_keyset.h',
        'base/dns_util.cc',
        'base/dns_util.h',
        'base/dnsrr_resolver.cc',
        'base/dnsrr_resolver.h',
        'base/escape.cc',
        'base/escape.h',
        'base/escape_icu.cc',
        'base/ev_root_ca_metadata.cc',
        'base/ev_root_ca_metadata.h',
        'base/file_stream.h',
        'base/file_stream_posix.cc',
        'base/file_stream_win.cc',
        'base/filter.cc',
        'base/filter.h',
        'base/gzip_filter.cc',
        'base/gzip_filter.h',
        'base/gzip_header.cc',
        'base/gzip_header.h',
        'base/host_cache.cc',
        'base/host_cache.h',
        'base/host_mapping_rules.cc',
        'base/host_mapping_rules.h',
        'base/host_port_pair.cc',
        'base/host_port_pair.h',
        'base/host_resolver.cc',
        'base/host_resolver.h',
        'base/host_resolver_impl.cc',
        'base/host_resolver_impl.h',
        'base/host_resolver_proc.cc',
        'base/host_resolver_proc.h',
        'base/io_buffer.cc',
        'base/io_buffer.h',
        'base/ip_endpoint.cc',
        'base/ip_endpoint.h',
        'base/keygen_handler.cc',
        'base/keygen_handler.h',
        'base/keygen_handler_mac.cc',
        'base/keygen_handler_nss.cc',
        'base/keygen_handler_openssl.cc',
        'base/keygen_handler_win.cc',
        'base/listen_socket.cc',
        'base/listen_socket.h',
        'base/load_flags.h',
        'base/load_flags_list.h',
        'base/load_states.h',
        'base/mapped_host_resolver.cc',
        'base/mapped_host_resolver.h',
        'base/mime_sniffer.cc',
        'base/mime_sniffer.h',
        'base/mime_util.cc',
        'base/mime_util.h',
        # TODO(eroman): move this into its own test-support target.
        'base/mock_host_resolver.cc',
        'base/mock_host_resolver.h',
        'base/net_error_list.h',
        'base/net_errors.cc',
        'base/net_errors.h',
        'base/net_errors_posix.cc',
        'base/net_errors_win.cc',
        'base/net_log.cc',
        'base/net_log.h',
        'base/net_log_event_type_list.h',
        'base/net_log_source_type_list.h',
        'base/net_module.cc',
        'base/net_module.h',
        'base/net_switches.cc',
        'base/net_switches.h',
        'base/net_util.cc',
        'base/net_util.h',
        'base/net_util_posix.cc',
        'base/net_util_win.cc',
        'base/network_change_notifier.cc',
        'base/network_change_notifier.h',
        'base/network_change_notifier_linux.cc',
        'base/network_change_notifier_linux.h',
        'base/network_change_notifier_mac.cc',
        'base/network_change_notifier_mac.h',
        'base/network_change_notifier_netlink_linux.cc',
        'base/network_change_notifier_netlink_linux.h',
        'base/network_change_notifier_win.cc',
        'base/network_change_notifier_win.h',
        'base/network_config_watcher_mac.cc',
        'base/network_config_watcher_mac.h',
        'base/network_delegate.cc',
        'base/network_delegate.h',
        'base/nss_memio.c',
        'base/nss_memio.h',
        'base/openssl_memory_private_key_store.cc',
        'base/openssl_private_key_store.h',
        'base/pem_tokenizer.cc',
        'base/pem_tokenizer.h',
        'base/platform_mime_util.h',
        # TODO(tc): gnome-vfs? xdgmime? /etc/mime.types?
        'base/platform_mime_util_linux.cc',
        'base/platform_mime_util_mac.cc',
        'base/platform_mime_util_win.cc',
        'base/registry_controlled_domain.cc',
        'base/registry_controlled_domain.h',
        'base/scoped_cert_chain_context.h',
        'base/sdch_filter.cc',
        'base/sdch_filter.h',
        'base/sdch_manager.cc',
        'base/sdch_manager.h',
        'base/ssl_cert_request_info.cc',
        'base/ssl_cert_request_info.h',
        'base/ssl_cipher_suite_names.cc',
        'base/ssl_cipher_suite_names.h',
        'base/ssl_client_auth_cache.cc',
        'base/ssl_client_auth_cache.h',
        'base/ssl_config_service.cc',
        'base/ssl_config_service.h',
        'base/ssl_config_service_defaults.cc',
        'base/ssl_config_service_defaults.h',
        'base/ssl_false_start_blacklist.cc',
        'base/ssl_info.cc',
        'base/ssl_info.h',
        'base/static_cookie_policy.cc',
        'base/static_cookie_policy.h',
        'base/test_root_certs.cc',
        'base/test_root_certs.h',
        'base/test_root_certs_mac.cc',
        'base/test_root_certs_nss.cc',
        'base/test_root_certs_openssl.cc',
        'base/test_root_certs_win.cc',
        'base/transport_security_state.cc',
        'base/transport_security_state.h',
        'base/sys_addrinfo.h',
        'base/sys_byteorder.h',
        'base/upload_data.cc',
        'base/upload_data.h',
        'base/upload_data_stream.cc',
        'base/upload_data_stream.h',
        'base/winsock_init.cc',
        'base/winsock_init.h',
        'base/winsock_util.cc',
        'base/winsock_util.h',
        'base/x509_certificate.cc',
        'base/x509_certificate.h',
        'base/x509_certificate_mac.cc',
        'base/x509_certificate_nss.cc',
        'base/x509_certificate_openssl.cc',
        'base/x509_certificate_win.cc',
        'base/x509_cert_types.cc',
        'base/x509_cert_types.h',
        'base/x509_cert_types_mac.cc',
        'base/x509_openssl_util.cc',
        'base/x509_openssl_util.h',
        'third_party/mozilla_security_manager/nsKeygenHandler.cpp',
        'third_party/mozilla_security_manager/nsKeygenHandler.h',
        'third_party/mozilla_security_manager/nsNSSCertificateDB.cpp',
        'third_party/mozilla_security_manager/nsNSSCertificateDB.h',
        'third_party/mozilla_security_manager/nsNSSCertTrust.cpp',
        'third_party/mozilla_security_manager/nsNSSCertTrust.h',
        'third_party/mozilla_security_manager/nsPKCS12Blob.cpp',
        'third_party/mozilla_security_manager/nsPKCS12Blob.h',
      ],
      'export_dependent_settings': [
        '../base/base.gyp:base',
      ],
      'actions': [
        {
          'action_name': 'ssl_false_start_blacklist',
          'inputs': [
            '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)ssl_false_start_blacklist_process<(EXECUTABLE_SUFFIX)',
            'base/ssl_false_start_blacklist.txt',
          ],
          'outputs': [
            '<(SHARED_INTERMEDIATE_DIR)/net/base/ssl_false_start_blacklist_data.cc',
          ],
          'action':
            ['<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)ssl_false_start_blacklist_process<(EXECUTABLE_SUFFIX)',
             'base/ssl_false_start_blacklist.txt',
              '<(SHARED_INTERMEDIATE_DIR)/net/base/ssl_false_start_blacklist_data.cc',
            ],
          'message': 'Generating SSL False Start blacklist',
          'process_outputs_as_sources': 1,
        },
      ],
      'conditions': [
        [ 'OS == "linux" or OS == "freebsd" or OS == "openbsd"', {
            'dependencies': [
              '../build/linux/system.gyp:gconf',
              '../build/linux/system.gyp:gdk',
              '../build/linux/system.gyp:libresolv',
            ],
            'conditions': [
              ['use_openssl==1', {
                'dependencies': [
                  '../third_party/openssl/openssl.gyp:openssl',
                ],
              }, {  # else: not using openssl. Use NSS.
                'dependencies': [
                  '../build/linux/system.gyp:nss',
                ],
              }],
            ],
          },
          {  # else: OS is not in the above list
            'sources!': [
              'base/cert_database_nss.cc',
              'base/crypto_module_nss.cc',
              'base/keygen_handler_nss.cc',
              'base/test_root_certs_nss.cc',
              'base/x509_certificate_nss.cc',
              'third_party/mozilla_security_manager/nsKeygenHandler.cpp',
              'third_party/mozilla_security_manager/nsKeygenHandler.h',
              'third_party/mozilla_security_manager/nsNSSCertificateDB.cpp',
              'third_party/mozilla_security_manager/nsNSSCertificateDB.h',
              'third_party/mozilla_security_manager/nsNSSCertTrust.cpp',
              'third_party/mozilla_security_manager/nsNSSCertTrust.h',
              'third_party/mozilla_security_manager/nsPKCS12Blob.cpp',
              'third_party/mozilla_security_manager/nsPKCS12Blob.h',
            ],
          },
        ],
        [ 'use_openssl==1', {
            'sources!': [
              'base/cert_database_nss.cc',
              'base/crypto_module_nss.cc',
              'base/dnssec_keyset.cc',
              'base/dnssec_keyset.h',
              'base/keygen_handler_nss.cc',
              'base/nss_memio.c',
              'base/nss_memio.h',
              'base/test_root_certs_nss.cc',
              'base/x509_certificate_nss.cc',
              'third_party/mozilla_security_manager/nsKeygenHandler.cpp',
              'third_party/mozilla_security_manager/nsKeygenHandler.h',
              'third_party/mozilla_security_manager/nsNSSCertificateDB.cpp',
              'third_party/mozilla_security_manager/nsNSSCertificateDB.h',
              'third_party/mozilla_security_manager/nsNSSCertTrust.cpp',
              'third_party/mozilla_security_manager/nsNSSCertTrust.h',
              'third_party/mozilla_security_manager/nsPKCS12Blob.cpp',
              'third_party/mozilla_security_manager/nsPKCS12Blob.h',
            ],
          },
          {  # else: not using openssl.
            'sources!': [
              'base/cert_database_openssl.cc',
              'base/crypto_module_openssl.cc',
              'base/keygen_handler_openssl.cc',
              'base/openssl_memory_private_key_store.cc',
              'base/openssl_private_key_store.h',
              'base/test_root_certs_openssl.cc',
              'base/x509_certificate_openssl.cc',
              'base/x509_openssl_util.cc',
              'base/x509_openssl_util.h',
             ],
          },
        ],
        [ 'OS == "win"', {
            'dependencies': [
              '../third_party/nss/nss.gyp:nss',
              'tld_cleanup',
            ],
          },
          {  # else: OS != "win"
            'dependencies': [
              '../third_party/libevent/libevent.gyp:libevent',
            ],
            'sources!': [
              'base/winsock_init.cc',
              'base/winsock_util.cc',
            ],
          },
        ],
        [ 'OS == "mac"', {
            'dependencies': [
              '../third_party/nss/nss.gyp:nss',
            ],
            'link_settings': {
              'libraries': [
                '$(SDKROOT)/System/Library/Frameworks/Security.framework',
                '$(SDKROOT)/System/Library/Frameworks/SystemConfiguration.framework',
                '$(SDKROOT)/usr/lib/libresolv.dylib',
              ]
            },
          },
        ],
      ],
    },
    {
      'target_name': 'net',
      'type': '<(library)',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../build/temp_gyp/googleurl.gyp:googleurl',
        '../crypto/crypto.gyp:crypto',
        '../sdch/sdch.gyp:sdch',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/zlib/zlib.gyp:zlib',
        'net_base',
        'net_resources',
      ],
      'sources': [
        'disk_cache/addr.cc',
        'disk_cache/addr.h',
        'disk_cache/backend_impl.cc',
        'disk_cache/backend_impl.h',
        'disk_cache/bitmap.cc',
        'disk_cache/bitmap.h',
        'disk_cache/block_files.cc',
        'disk_cache/block_files.h',
        'disk_cache/cache_util.h',
        'disk_cache/cache_util_posix.cc',
        'disk_cache/cache_util_win.cc',
        'disk_cache/disk_cache.h',
        'disk_cache/disk_format.cc',
        'disk_cache/disk_format.h',
        'disk_cache/entry_impl.cc',
        'disk_cache/entry_impl.h',
        'disk_cache/errors.h',
        'disk_cache/eviction.cc',
        'disk_cache/eviction.h',
        'disk_cache/experiments.h',
        'disk_cache/net_log_parameters.cc',
        'disk_cache/net_log_parameters.h',
        'disk_cache/file.cc',
        'disk_cache/file.h',
        'disk_cache/file_block.h',
        'disk_cache/file_lock.cc',
        'disk_cache/file_lock.h',
        'disk_cache/file_posix.cc',
        'disk_cache/file_win.cc',
        'disk_cache/hash.cc',
        'disk_cache/hash.h',
        'disk_cache/histogram_macros.h',
        'disk_cache/in_flight_backend_io.cc',
        'disk_cache/in_flight_backend_io.h',
        'disk_cache/in_flight_io.cc',
        'disk_cache/in_flight_io.h',
        'disk_cache/mapped_file.h',
        'disk_cache/mapped_file_posix.cc',
        'disk_cache/mapped_file_win.cc',
        'disk_cache/mem_backend_impl.cc',
        'disk_cache/mem_backend_impl.h',
        'disk_cache/mem_entry_impl.cc',
        'disk_cache/mem_entry_impl.h',
        'disk_cache/mem_rankings.cc',
        'disk_cache/mem_rankings.h',
        'disk_cache/rankings.cc',
        'disk_cache/rankings.h',
        'disk_cache/sparse_control.cc',
        'disk_cache/sparse_control.h',
        'disk_cache/stats.cc',
        'disk_cache/stats.h',
        'disk_cache/stats_histogram.cc',
        'disk_cache/stats_histogram.h',
        'disk_cache/storage_block-inl.h',
        'disk_cache/storage_block.h',
        'disk_cache/trace.cc',
        'disk_cache/trace.h',
        'ftp/ftp_auth_cache.cc',
        'ftp/ftp_auth_cache.h',
        'ftp/ftp_ctrl_response_buffer.cc',
        'ftp/ftp_ctrl_response_buffer.h',
        'ftp/ftp_directory_listing_parser.cc',
        'ftp/ftp_directory_listing_parser.h',
        'ftp/ftp_directory_listing_parser_ls.cc',
        'ftp/ftp_directory_listing_parser_ls.h',
        'ftp/ftp_directory_listing_parser_netware.cc',
        'ftp/ftp_directory_listing_parser_netware.h',
        'ftp/ftp_directory_listing_parser_vms.cc',
        'ftp/ftp_directory_listing_parser_vms.h',
        'ftp/ftp_directory_listing_parser_windows.cc',
        'ftp/ftp_directory_listing_parser_windows.h',
        'ftp/ftp_network_layer.cc',
        'ftp/ftp_network_layer.h',
        'ftp/ftp_network_session.cc',
        'ftp/ftp_network_session.h',
        'ftp/ftp_network_transaction.cc',
        'ftp/ftp_network_transaction.h',
        'ftp/ftp_request_info.h',
        'ftp/ftp_response_info.cc',
        'ftp/ftp_response_info.h',
        'ftp/ftp_server_type_histograms.cc',
        'ftp/ftp_server_type_histograms.h',
        'ftp/ftp_transaction.h',
        'ftp/ftp_transaction_factory.h',
        'ftp/ftp_util.cc',
        'ftp/ftp_util.h',
        'http/des.cc',
        'http/des.h',
        'http/disk_cache_based_ssl_host_info.cc',
        'http/disk_cache_based_ssl_host_info.h',
        'http/http_alternate_protocols.cc',
        'http/http_alternate_protocols.h',
        'http/http_atom_list.h',
        'http/http_auth.cc',
        'http/http_auth.h',
        'http/http_auth_cache.cc',
        'http/http_auth_cache.h',
        'http/http_auth_controller.cc',
        'http/http_auth_controller.h',
        'http/http_auth_filter.cc',
        'http/http_auth_filter.h',
        'http/http_auth_filter_win.h',
        'http/http_auth_gssapi_posix.cc',
        'http/http_auth_gssapi_posix.h',
        'http/http_auth_handler.cc',
        'http/http_auth_handler.h',
        'http/http_auth_handler_basic.cc',
        'http/http_auth_handler_basic.h',
        'http/http_auth_handler_digest.cc',
        'http/http_auth_handler_digest.h',
        'http/http_auth_handler_factory.cc',
        'http/http_auth_handler_factory.h',
        'http/http_auth_handler_negotiate.h',
        'http/http_auth_handler_negotiate.cc',
        'http/http_auth_handler_ntlm.cc',
        'http/http_auth_handler_ntlm.h',
        'http/http_auth_handler_ntlm_portable.cc',
        'http/http_auth_handler_ntlm_win.cc',
        'http/http_auth_sspi_win.cc',
        'http/http_auth_sspi_win.h',
        'http/http_basic_stream.cc',
        'http/http_basic_stream.h',
        'http/http_byte_range.cc',
        'http/http_byte_range.h',
        'http/http_cache.cc',
        'http/http_cache.h',
        'http/http_cache_transaction.cc',
        'http/http_cache_transaction.h',
        'http/http_chunked_decoder.cc',
        'http/http_chunked_decoder.h',
        'http/http_net_log_params.cc',
        'http/http_net_log_params.h',
        'http/http_network_layer.cc',
        'http/http_network_layer.h',
        'http/http_network_session.cc',
        'http/http_network_session.h',
        'http/http_network_session_peer.cc',
        'http/http_network_session_peer.h',
        'http/http_network_transaction.cc',
        'http/http_network_transaction.h',
        'http/http_request_headers.cc',
        'http/http_request_headers.h',
        'http/http_request_info.cc',
        'http/http_request_info.h',
        'http/http_response_body_drainer.cc',
        'http/http_response_body_drainer.h',
        'http/http_response_headers.cc',
        'http/http_response_headers.h',
        'http/http_response_info.cc',
        'http/http_response_info.h',
        'http/http_stream.h',
        'http/http_stream_factory.cc',
        'http/http_stream_factory.h',
        'http/http_stream_factory_impl.cc',
        'http/http_stream_factory_impl.h',
        'http/http_stream_factory_impl_job.cc',
        'http/http_stream_factory_impl_job.h',
        'http/http_stream_factory_impl_request.cc',
        'http/http_stream_factory_impl_request.h',
        'http/http_stream_parser.cc',
        'http/http_stream_parser.h',
        'http/http_transaction.h',
        'http/http_transaction_factory.h',
        'http/url_security_manager.h',
        'http/url_security_manager.cc',
        'http/url_security_manager_posix.cc',
        'http/url_security_manager_win.cc',
        'http/http_proxy_client_socket.cc',
        'http/http_proxy_client_socket.h',
        'http/http_proxy_client_socket_pool.cc',
        'http/http_proxy_client_socket_pool.h',
        'http/http_proxy_utils.cc',
        'http/http_proxy_utils.h',
        'http/http_util.cc',
        'http/http_util_icu.cc',
        'http/http_util.h',
        'http/http_vary_data.cc',
        'http/http_vary_data.h',
        'http/http_version.h',
        'http/md4.cc',
        'http/md4.h',
        'http/partial_data.cc',
        'http/partial_data.h',
        'http/proxy_client_socket.h',
        'ocsp/nss_ocsp.cc',
        'ocsp/nss_ocsp.h',
        'proxy/init_proxy_resolver.cc',
        'proxy/init_proxy_resolver.h',
        'proxy/multi_threaded_proxy_resolver.cc',
        'proxy/multi_threaded_proxy_resolver.h',
        'proxy/polling_proxy_config_service.cc',
        'proxy/polling_proxy_config_service.h',
        'proxy/proxy_bypass_rules.cc',
        'proxy/proxy_bypass_rules.h',
        'proxy/proxy_config.cc',
        'proxy/proxy_config.h',
        'proxy/proxy_config_service.h',
        'proxy/proxy_config_service_fixed.cc',
        'proxy/proxy_config_service_fixed.h',
        'proxy/proxy_config_service_linux.cc',
        'proxy/proxy_config_service_linux.h',
        'proxy/proxy_config_service_mac.cc',
        'proxy/proxy_config_service_mac.h',
        'proxy/proxy_config_service_win.cc',
        'proxy/proxy_config_service_win.h',
        'proxy/proxy_info.cc',
        'proxy/proxy_info.h',
        'proxy/proxy_list.cc',
        'proxy/proxy_list.h',
        'proxy/proxy_resolver.h',
        'proxy/proxy_resolver_js_bindings.cc',
        'proxy/proxy_resolver_js_bindings.h',
        'proxy/proxy_resolver_mac.cc',
        'proxy/proxy_resolver_mac.h',
        'proxy/proxy_resolver_request_context.h',
        'proxy/proxy_resolver_script.h',
        'proxy/proxy_resolver_script_data.cc',
        'proxy/proxy_resolver_script_data.h',
        'proxy/proxy_resolver_v8.cc',
        'proxy/proxy_resolver_v8.h',
        'proxy/proxy_resolver_winhttp.cc',
        'proxy/proxy_resolver_winhttp.h',
        'proxy/proxy_retry_info.h',
        'proxy/proxy_script_fetcher.h',
        'proxy/proxy_script_fetcher_impl.cc',
        'proxy/proxy_script_fetcher_impl.h',
        'proxy/proxy_server.cc',
        'proxy/proxy_server_mac.cc',
        'proxy/proxy_server.h',
        'proxy/proxy_service.cc',
        'proxy/proxy_service.h',
        'proxy/sync_host_resolver_bridge.cc',
        'proxy/sync_host_resolver_bridge.h',
        'socket/client_socket.cc',
        'socket/client_socket.h',
        'socket/client_socket_factory.cc',
        'socket/client_socket_factory.h',
        'socket/client_socket_handle.cc',
        'socket/client_socket_handle.h',
        'socket/client_socket_pool.h',
        'socket/client_socket_pool.cc',
        'socket/client_socket_pool_base.cc',
        'socket/client_socket_pool_base.h',
        'socket/client_socket_pool_histograms.cc',
        'socket/client_socket_pool_histograms.h',
        'socket/client_socket_pool_manager.cc',
        'socket/client_socket_pool_manager.h',
        'socket/dns_cert_provenance_checker.cc',
        'socket/dns_cert_provenance_checker.h',
        'socket/nss_ssl_util.cc',
        'socket/nss_ssl_util.h',
        'socket/server_socket.h',
        'socket/socket.h',
        'socket/socks5_client_socket.cc',
        'socket/socks5_client_socket.h',
        'socket/socks_client_socket.cc',
        'socket/socks_client_socket.h',
        'socket/socks_client_socket_pool.cc',
        'socket/socks_client_socket_pool.h',
        'socket/ssl_client_socket.cc',
        'socket/ssl_client_socket.h',
        'socket/ssl_client_socket_mac.cc',
        'socket/ssl_client_socket_mac.h',
        'socket/ssl_client_socket_nss.cc',
        'socket/ssl_client_socket_nss.h',
        'socket/ssl_client_socket_openssl.cc',
        'socket/ssl_client_socket_openssl.h',
        'socket/ssl_client_socket_pool.cc',
        'socket/ssl_client_socket_pool.h',
        'socket/ssl_client_socket_win.cc',
        'socket/ssl_client_socket_win.h',
        'socket/ssl_error_params.cc',
        'socket/ssl_error_params.h',
        'socket/ssl_server_socket.h',
        'socket/ssl_server_socket_nss.cc',
        'socket/ssl_server_socket_nss.h',
        'socket/ssl_server_socket_openssl.cc',
        'socket/ssl_host_info.cc',
        'socket/ssl_host_info.h',
        'socket/tcp_client_socket.cc',
        'socket/tcp_client_socket.h',
        'socket/tcp_client_socket_libevent.cc',
        'socket/tcp_client_socket_libevent.h',
        'socket/tcp_client_socket_win.cc',
        'socket/tcp_client_socket_win.h',
        'socket/tcp_server_socket.h',
        'socket/tcp_server_socket_libevent.cc',
        'socket/tcp_server_socket_libevent.h',
        'socket/tcp_server_socket_win.cc',
        'socket/tcp_server_socket_win.h',
        'socket/transport_client_socket_pool.cc',
        'socket/transport_client_socket_pool.h',
        'socket_stream/socket_stream.cc',
        'socket_stream/socket_stream.h',
        'socket_stream/socket_stream_job.cc',
        'socket_stream/socket_stream_job.h',
        'socket_stream/socket_stream_job_manager.cc',
        'socket_stream/socket_stream_job_manager.h',
        'socket_stream/socket_stream_metrics.cc',
        'socket_stream/socket_stream_metrics.h',
        'spdy/spdy_bitmasks.h',
        'spdy/spdy_frame_builder.cc',
        'spdy/spdy_frame_builder.h',
        'spdy/spdy_framer.cc',
        'spdy/spdy_framer.h',
        'spdy/spdy_http_stream.cc',
        'spdy/spdy_http_stream.h',
        'spdy/spdy_http_utils.cc',
        'spdy/spdy_http_utils.h',
        'spdy/spdy_io_buffer.cc',
        'spdy/spdy_io_buffer.h',
        'spdy/spdy_protocol.h',
        'spdy/spdy_proxy_client_socket.cc',
        'spdy/spdy_proxy_client_socket.h',
        'spdy/spdy_session.cc',
        'spdy/spdy_session.h',
        'spdy/spdy_session_pool.cc',
        'spdy/spdy_session_pool.h',
        'spdy/spdy_settings_storage.cc',
        'spdy/spdy_settings_storage.h',
        'spdy/spdy_stream.cc',
        'spdy/spdy_stream.h',
        'udp/datagram_client_socket.h',
        'udp/datagram_server_socket.h',
        'udp/datagram_socket.h',
        'udp/udp_client_socket.cc',
        'udp/udp_client_socket.h',
        'udp/udp_server_socket.cc',
        'udp/udp_server_socket.h',
        'udp/udp_socket.h',
        'udp/udp_socket_libevent.cc',
        'udp/udp_socket_libevent.h',
        'udp/udp_socket_win.cc',
        'udp/udp_socket_win.h',
        'url_request/https_prober.h',
        'url_request/https_prober.cc',
        'url_request/url_request.cc',
        'url_request/url_request.h',
        'url_request/url_request_about_job.cc',
        'url_request/url_request_about_job.h',
        'url_request/url_request_context.cc',
        'url_request/url_request_context.h',
        'url_request/url_request_context_getter.cc',
        'url_request/url_request_context_getter.h',
        'url_request/url_request_context_storage.cc',
        'url_request/url_request_context_storage.h',
        'url_request/url_request_data_job.cc',
        'url_request/url_request_data_job.h',
        'url_request/url_request_error_job.cc',
        'url_request/url_request_error_job.h',
        'url_request/url_request_file_dir_job.cc',
        'url_request/url_request_file_dir_job.h',
        'url_request/url_request_file_job.cc',
        'url_request/url_request_file_job.h',
        'url_request/url_request_filter.cc',
        'url_request/url_request_filter.h',
        'url_request/url_request_ftp_job.cc',
        'url_request/url_request_ftp_job.h',
        'url_request/url_request_http_job.cc',
        'url_request/url_request_http_job.h',
        'url_request/url_request_job.cc',
        'url_request/url_request_job.h',
        'url_request/url_request_job_manager.cc',
        'url_request/url_request_job_manager.h',
        'url_request/url_request_job_tracker.cc',
        'url_request/url_request_job_tracker.h',
        'url_request/url_request_netlog_params.cc',
        'url_request/url_request_netlog_params.h',
        'url_request/url_request_redirect_job.cc',
        'url_request/url_request_redirect_job.h',
        'url_request/url_request_simple_job.cc',
        'url_request/url_request_simple_job.h',
        'url_request/url_request_status.h',
        'url_request/url_request_test_job.cc',
        'url_request/url_request_test_job.h',
        'url_request/url_request_throttler_entry.cc',
        'url_request/url_request_throttler_entry.h',
        'url_request/url_request_throttler_entry_interface.h',
        'url_request/url_request_throttler_header_adapter.h',
        'url_request/url_request_throttler_header_adapter.cc',
        'url_request/url_request_throttler_header_interface.h',
        'url_request/url_request_throttler_manager.cc',
        'url_request/url_request_throttler_manager.h',
        'url_request/view_cache_helper.cc',
        'url_request/view_cache_helper.h',
        'websockets/websocket.cc',
        'websockets/websocket.h',
        'websockets/websocket_frame_handler.cc',
        'websockets/websocket_frame_handler.h',
        'websockets/websocket_handshake.cc',
        'websockets/websocket_handshake.h',
        'websockets/websocket_handshake_draft75.cc',
        'websockets/websocket_handshake_draft75.h',
        'websockets/websocket_handshake_handler.cc',
        'websockets/websocket_handshake_handler.h',
        'websockets/websocket_job.cc',
        'websockets/websocket_job.h',
        'websockets/websocket_net_log_params.cc',
        'websockets/websocket_net_log_params.h',
        'websockets/websocket_throttle.cc',
        'websockets/websocket_throttle.h',
      ],
      'export_dependent_settings': [
        '../base/base.gyp:base',
      ],
      'conditions': [
        ['javascript_engine=="v8"', {
          'dependencies': [
            '../v8/tools/gyp/v8.gyp:v8',
          ],
        }],
        ['chromeos==1', {
          'sources!': [
             'proxy/proxy_config_service_linux.cc',
             'proxy/proxy_config_service_linux.h',
          ],
        }],
        ['use_openssl==1', {
            'sources!': [
              'ocsp/nss_ocsp.cc',
              'ocsp/nss_ocsp.h',
              'socket/dns_cert_provenance_check.cc',
              'socket/dns_cert_provenance_check.h',
              'socket/nss_ssl_util.cc',
              'socket/nss_ssl_util.h',
              'socket/ssl_client_socket_nss.cc',
              'socket/ssl_client_socket_nss.h',
              'socket/ssl_server_socket_nss.cc',
              'socket/ssl_server_socket_nss.h',
            ],
          },
          {  # else !use_openssl: remove the unneeded files
            'sources!': [
              'socket/ssl_client_socket_openssl.cc',
              'socket/ssl_client_socket_openssl.h',
              'socket/ssl_server_socket_openssl.cc',
            ],
          },
        ],
        [ 'OS == "linux" or OS == "freebsd" or OS == "openbsd"', {
            'dependencies': [
              '../build/linux/system.gyp:gconf',
              '../build/linux/system.gyp:gdk',
            ],
            'conditions': [
              ['use_openssl==1', {
                'dependencies': [
                  '../third_party/openssl/openssl.gyp:openssl',
                ],
              },
              {  # else use_openssl==0, use NSS
                'dependencies': [
                  '../build/linux/system.gyp:nss',
                ],
              }],
            ],
          },
          {  # else: OS is not in the above list
            'sources!': [
              'ocsp/nss_ocsp.cc',
              'ocsp/nss_ocsp.h',
            ],
          },
        ],
        [ 'OS == "win"', {
            'sources!': [
              'http/http_auth_handler_ntlm_portable.cc',
              'socket/tcp_client_socket_libevent.cc',
              'socket/tcp_server_socket_libevent.cc',
              'udp/udp_socket_libevent.cc',
            ],
            'dependencies': [
              '../third_party/nss/nss.gyp:nss',
              'third_party/nss/ssl.gyp:ssl',
              'tld_cleanup',
            ],
          },
          {  # else: OS != "win"
            'dependencies': [
              '../third_party/libevent/libevent.gyp:libevent',
            ],
            'sources!': [
              'proxy/proxy_resolver_winhttp.cc',
            ],
          },
        ],
        [ 'OS == "mac"', {
            'dependencies': [
              '../third_party/nss/nss.gyp:nss',
              'third_party/nss/ssl.gyp:ssl',
            ],
            'link_settings': {
              'libraries': [
                '$(SDKROOT)/System/Library/Frameworks/Security.framework',
                '$(SDKROOT)/System/Library/Frameworks/SystemConfiguration.framework',
              ]
            },
          },
        ],
      ],
    },
    {
      'target_name': 'net_unittests',
      'type': 'executable',
      'dependencies': [
        'net',
        'net_test_support',
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../crypto/crypto.gyp:crypto',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        '../third_party/zlib/zlib.gyp:zlib',
      ],
      'msvs_guid': 'E99DA267-BE90-4F45-88A1-6919DB2C7567',
      'sources': [
        'base/address_list_unittest.cc',
        'base/backoff_entry_unittest.cc',
        'base/cert_database_nss_unittest.cc',
        'base/cert_verifier_unittest.cc',
        'base/cookie_monster_unittest.cc',
        'base/data_url_unittest.cc',
        'base/directory_lister_unittest.cc',
        'base/dnssec_unittest.cc',
        'base/dns_util_unittest.cc',
        'base/dnsrr_resolver_unittest.cc',
        'base/escape_unittest.cc',
        'base/file_stream_unittest.cc',
        'base/filter_unittest.cc',
        'base/gzip_filter_unittest.cc',
        'base/host_cache_unittest.cc',
        'base/host_mapping_rules_unittest.cc',
        'base/host_resolver_impl_unittest.cc',
        'base/ip_endpoint_unittest.cc',
        'base/keygen_handler_unittest.cc',
        'base/listen_socket_unittest.cc',
        'base/listen_socket_unittest.h',
        'base/mapped_host_resolver_unittest.cc',
        'base/mime_sniffer_unittest.cc',
        'base/mime_util_unittest.cc',
        'base/mock_filter_context.cc',
        'base/mock_filter_context.h',
        'base/net_log_unittest.cc',
        'base/net_log_unittest.h',
        'base/net_util_unittest.cc',
        'base/pem_tokenizer_unittest.cc',
        'base/registry_controlled_domain_unittest.cc',
        'base/run_all_unittests.cc',
        'base/sdch_filter_unittest.cc',
        'base/ssl_cipher_suite_names_unittest.cc',
        'base/ssl_client_auth_cache_unittest.cc',
        'base/ssl_config_service_unittest.cc',
        'base/ssl_false_start_blacklist_unittest.cc',
        'base/static_cookie_policy_unittest.cc',
        'base/transport_security_state_unittest.cc',
        'base/test_certificate_data.h',
        'base/test_completion_callback_unittest.cc',
        'base/upload_data_stream_unittest.cc',
        'base/x509_certificate_unittest.cc',
        'base/x509_cert_types_mac_unittest.cc',
        'disk_cache/addr_unittest.cc',
        'disk_cache/backend_unittest.cc',
        'disk_cache/bitmap_unittest.cc',
        'disk_cache/block_files_unittest.cc',
        'disk_cache/cache_util_unittest.cc',
        'disk_cache/disk_cache_test_base.cc',
        'disk_cache/disk_cache_test_base.h',
        'disk_cache/entry_unittest.cc',
        'disk_cache/mapped_file_unittest.cc',
        'disk_cache/storage_block_unittest.cc',
        'ftp/ftp_auth_cache_unittest.cc',
        'ftp/ftp_ctrl_response_buffer_unittest.cc',
        'ftp/ftp_directory_listing_parser_ls_unittest.cc',
        'ftp/ftp_directory_listing_parser_netware_unittest.cc',
        'ftp/ftp_directory_listing_parser_unittest.cc',
        'ftp/ftp_directory_listing_parser_vms_unittest.cc',
        'ftp/ftp_directory_listing_parser_windows_unittest.cc',
        'ftp/ftp_network_transaction_unittest.cc',
        'ftp/ftp_util_unittest.cc',
        'http/des_unittest.cc',
        'http/http_alternate_protocols_unittest.cc',
        'http/http_auth_cache_unittest.cc',
        'http/http_auth_controller_unittest.cc',
        'http/http_auth_filter_unittest.cc',
        'http/http_auth_gssapi_posix_unittest.cc',
        'http/http_auth_handler_basic_unittest.cc',
        'http/http_auth_handler_digest_unittest.cc',
        'http/http_auth_handler_factory_unittest.cc',
        'http/http_auth_handler_mock.cc',
        'http/http_auth_handler_mock.h',
        'http/http_auth_handler_negotiate_unittest.cc',
        'http/http_auth_handler_unittest.cc',
        'http/http_auth_sspi_win_unittest.cc',
        'http/http_auth_unittest.cc',
        'http/http_byte_range_unittest.cc',
        'http/http_cache_unittest.cc',
        'http/http_chunked_decoder_unittest.cc',
        'http/http_network_layer_unittest.cc',
        'http/http_network_transaction_unittest.cc',
        'http/http_proxy_client_socket_pool_unittest.cc',
        'http/http_request_headers_unittest.cc',
        'http/http_response_body_drainer_unittest.cc',
        'http/http_response_headers_unittest.cc',
        'http/http_stream_factory_impl_unittest.cc',
        'http/http_transaction_unittest.cc',
        'http/http_transaction_unittest.h',
        'http/http_util_unittest.cc',
        'http/http_vary_data_unittest.cc',
        'http/mock_allow_url_security_manager.cc',
        'http/mock_allow_url_security_manager.h',
        'http/mock_gssapi_library_posix.cc',
        'http/mock_gssapi_library_posix.h',
        'http/mock_sspi_library_win.h',
        'http/mock_sspi_library_win.cc',
        'http/url_security_manager_unittest.cc',
        'proxy/init_proxy_resolver_unittest.cc',
        'proxy/multi_threaded_proxy_resolver_unittest.cc',
        'proxy/proxy_bypass_rules_unittest.cc',
        'proxy/proxy_config_service_linux_unittest.cc',
        'proxy/proxy_config_service_win_unittest.cc',
        'proxy/proxy_config_unittest.cc',
        'proxy/proxy_list_unittest.cc',
        'proxy/proxy_resolver_js_bindings_unittest.cc',
        'proxy/proxy_resolver_v8_unittest.cc',
        'proxy/proxy_script_fetcher_impl_unittest.cc',
        'proxy/proxy_server_unittest.cc',
        'proxy/proxy_service_unittest.cc',
        'proxy/sync_host_resolver_bridge_unittest.cc',
        'socket/client_socket_pool_base_unittest.cc',
        'socket/deterministic_socket_data_unittest.cc',
        'socket/socks5_client_socket_unittest.cc',
        'socket/socks_client_socket_pool_unittest.cc',
        'socket/socks_client_socket_unittest.cc',
        'socket/ssl_client_socket_unittest.cc',
        'socket/ssl_client_socket_pool_unittest.cc',
        'socket/ssl_server_socket_unittest.cc',
        'socket/tcp_server_socket_unittest.cc',
        'socket/transport_client_socket_pool_unittest.cc',
        'socket/transport_client_socket_unittest.cc',
        'socket_stream/socket_stream_metrics_unittest.cc',
        'socket_stream/socket_stream_unittest.cc',
        'spdy/spdy_framer_test.cc',
        'spdy/spdy_http_stream_unittest.cc',
        'spdy/spdy_network_transaction_unittest.cc',
        'spdy/spdy_protocol_test.cc',
        'spdy/spdy_proxy_client_socket_unittest.cc',
        'spdy/spdy_session_unittest.cc',
        'spdy/spdy_stream_unittest.cc',
        'spdy/spdy_test_util.cc',
        'spdy/spdy_test_util.h',
        'test/python_utils_unittest.cc',
        'tools/dump_cache/url_to_filename_encoder.cc',
        'tools/dump_cache/url_to_filename_encoder.h',
        'tools/dump_cache/url_to_filename_encoder_unittest.cc',
        'tools/dump_cache/url_utilities.h',
        'tools/dump_cache/url_utilities.cc',
        'tools/dump_cache/url_utilities_unittest.cc',
        'udp/udp_socket_unittest.cc',
        'url_request/url_request_job_tracker_unittest.cc',
        'url_request/url_request_throttler_unittest.cc',
        'url_request/url_request_unittest.cc',
        'url_request/view_cache_helper_unittest.cc',
        'websockets/websocket_frame_handler_unittest.cc',
        'websockets/websocket_handshake_draft75_unittest.cc',
        'websockets/websocket_handshake_handler_unittest.cc',
        'websockets/websocket_handshake_unittest.cc',
        'websockets/websocket_job_unittest.cc',
        'websockets/websocket_net_log_params_unittest.cc',
        'websockets/websocket_throttle_unittest.cc',
        'websockets/websocket_unittest.cc',
      ],
      'conditions': [
        ['chromeos==1', {
          'sources!': [
             'proxy/proxy_config_service_linux_unittest.cc',
          ],
        }],
        [ 'OS == "linux" or OS == "freebsd" or OS == "openbsd"', {
            'dependencies': [
              '../build/linux/system.gyp:gtk',
              '../build/linux/system.gyp:nss',
            ],
          },
          {  # else: OS is not in the above list
            'sources!': [
              'base/cert_database_nss_unittest.cc',
            ],
          }
        ],
        [ 'OS == "linux"', {
          'conditions': [
            ['linux_use_tcmalloc==1', {
              'dependencies': [
                '../base/allocator/allocator.gyp:allocator',
              ],
            }],
          ],
        }],
        [ 'use_openssl==1', {
            # When building for OpenSSL, we need to exclude NSS specific tests.
            # TODO(bulach): Add equivalent tests when the underlying
            #               functionality is ported to OpenSSL.
            'sources!': [
              'base/cert_database_nss_unittest.cc',
              'base/dnssec_unittest.cc',
            ],
          },
          { # else, remove openssl specific tests
            'sources!': [
              'base/x509_openssl_util_unittest.cc',
            ],
          }
        ],
        [ 'OS == "win"', {
            'sources!': [
              'http/http_auth_gssapi_posix_unittest.cc',
            ],
            # This is needed to trigger the dll copy step on windows.
            # TODO(mark): Specifying this here shouldn't be necessary.
            'dependencies': [
              '../third_party/icu/icu.gyp:icudata',
            ],
          },
        ],
      ],
    },
    {
      'target_name': 'net_perftests',
      'type': 'executable',
      'dependencies': [
        'net',
        'net_test_support',
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../base/base.gyp:test_support_perf',
        '../testing/gtest.gyp:gtest',
      ],
      'msvs_guid': 'AAC78796-B9A2-4CD9-BF89-09B03E92BF73',
      'sources': [
        'base/cookie_monster_perftest.cc',
        'disk_cache/disk_cache_perftest.cc',
        'proxy/proxy_resolver_perftest.cc',
      ],
      'conditions': [
        # This is needed to trigger the dll copy step on windows.
        # TODO(mark): Specifying this here shouldn't be necessary.
        [ 'OS == "win"', {
            'dependencies': [
              '../third_party/icu/icu.gyp:icudata',
            ],
          },
        ],
      ],
    },
    {
      'target_name': 'stress_cache',
      'type': 'executable',
      'dependencies': [
        'net',
        'net_test_support',
        '../base/base.gyp:base',
      ],
      'sources': [
        'disk_cache/stress_cache.cc',
      ],
    },
    {
      'target_name': 'tld_cleanup',
      'type': 'executable',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../build/temp_gyp/googleurl.gyp:googleurl',
      ],
      'msvs_guid': 'E13045CD-7E1F-4A41-9B18-8D288B2E7B41',
      'sources': [
        'tools/tld_cleanup/tld_cleanup.cc',
      ],
    },
    {
      'target_name': 'crash_cache',
      'type': 'executable',
      'dependencies': [
        'net',
        'net_test_support',
        '../base/base.gyp:base',
      ],
      'msvs_guid': 'B0EE0599-2913-46A0-A847-A3EC813658D3',
      'sources': [
        'tools/crash_cache/crash_cache.cc',
      ],
    },
    {
      'target_name': 'run_testserver',
      'type': 'executable',
      'dependencies': [
        'net',
        'net_test_support',
        '../base/base.gyp:base',
        '../testing/gtest.gyp:gtest',
      ],
      'msvs_guid': '506F2468-6B1D-48E2-A67C-9D9C6BAC0EC5',
      'sources': [
        'tools/testserver/run_testserver.cc',
      ],
    },
    {
      'target_name': 'net_test_support',
      'type': '<(library)',
      'dependencies': [
        'net',
        '../base/base.gyp:base',
        '../base/base.gyp:test_support_base',
        '../testing/gtest.gyp:gtest',
      ],
      'sources': [
        'base/cert_test_util.cc',
        'base/cert_test_util.h',
        'base/cookie_monster_store_test.cc',
        'base/cookie_monster_store_test.h',
        'base/net_test_suite.cc',
        'base/net_test_suite.h',
        'base/test_completion_callback.cc',
        'base/test_completion_callback.h',
        'disk_cache/disk_cache_test_util.cc',
        'disk_cache/disk_cache_test_util.h',
        'proxy/mock_proxy_resolver.cc',
        'proxy/mock_proxy_resolver.h',
        'proxy/proxy_config_service_common_unittest.cc',
        'proxy/proxy_config_service_common_unittest.h',
        'socket/socket_test_util.cc',
        'socket/socket_test_util.h',
        'test/python_utils.cc',
        'test/python_utils.h',
        'test/test_server.cc',
        'test/test_server_posix.cc',
        'test/test_server_win.cc',
        'test/test_server.h',
        'url_request/url_request_test_util.cc',
        'url_request/url_request_test_util.h',
      ],
      'conditions': [
        ['inside_chromium_build==1', {
          'dependencies': [
            '../chrome/app/policy/cloud_policy_codegen.gyp:cloud_policy_proto_compile',
            '../chrome/browser/sync/protocol/sync_proto.gyp:sync_proto',
            '../third_party/protobuf/protobuf.gyp:py_proto',
          ],
        }],
        ['OS == "linux" or OS == "freebsd" or OS == "openbsd"', {
          'conditions': [
            ['use_openssl==1', {
              'dependencies': [
                '../third_party/openssl/openssl.gyp:openssl',
              ],
            }, {
              'dependencies': [
                '../build/linux/system.gyp:nss',
              ],
            }],
          ],
        }],
        ['OS == "linux"', {
          'conditions': [
            ['linux_use_tcmalloc==1', {
              'dependencies': [
                '../base/allocator/allocator.gyp:allocator',
              ],
            }],
          ],
        }],
      ],
    },
    {
      'target_name': 'net_resources',
      'type': 'none',
      'msvs_guid': '8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942',
      'variables': {
        'grit_out_dir': '<(SHARED_INTERMEDIATE_DIR)/net',
      },
      'actions': [
        {
          'action_name': 'net_resources',
          'variables': {
            'grit_grd_file': 'base/net_resources.grd',
          },
          'includes': [ '../build/grit_action.gypi' ],
        },
      ],
      'includes': [ '../build/grit_target.gypi' ],
    },
    {
      'target_name': 'fetch_client',
      'type': 'executable',
      'dependencies': [
        'net',
        '../base/base.gyp:base',
        '../testing/gtest.gyp:gtest',
      ],
      'msvs_guid': 'DABB8796-B9A2-4CD9-BF89-09B03E92B123',
      'sources': [
        'tools/fetch/fetch_client.cc',
      ],
    },
    {
      'target_name': 'fetch_server',
      'type': 'executable',
      'dependencies': [
        'net',
        '../base/base.gyp:base',
        '../testing/gtest.gyp:gtest',
      ],
      'msvs_guid': 'DABB8796-B9A2-4CD9-BF89-09B03E92B124',
      'sources': [
        'tools/fetch/fetch_server.cc',
        'tools/fetch/http_listen_socket.cc',
        'tools/fetch/http_listen_socket.h',
        'tools/fetch/http_server.cc',
        'tools/fetch/http_server.h',
        'tools/fetch/http_server_request_info.cc',
        'tools/fetch/http_server_request_info.h',
        'tools/fetch/http_server_response_info.cc',
        'tools/fetch/http_server_response_info.h',
        'tools/fetch/http_session.cc',
        'tools/fetch/http_session.h',
      ],
    },
    {
      'target_name': 'http_server',
      'type': '<(library)',
      'dependencies': [
        'net',
        '../base/base.gyp:base',
        '../testing/gtest.gyp:gtest',
      ],
      'msvs_guid': 'FCB894A4-CC6C-48C2-B495-52C80527E9BE',
      'sources': [
        'server/http_server.cc',
        'server/http_server.h',
        'server/http_server_request_info.cc',
        'server/http_server_request_info.h',
      ],
    },
    {
      'target_name': 'dnssec_chain_verify',
      'type': 'executable',
      'dependencies': [
        'net_base',
      ],
      'sources': [
        'tools/dnssec_chain_verify/dnssec_chain_verify.cc',
      ]
    },
    {
      'target_name': 'ssl_false_start_blacklist_process',
      'type': 'executable',
      'toolsets': ['host'],
      'include_dirs': [
        '..',
      ],
      'sources': [
        'base/ssl_false_start_blacklist_process.cc',
      ],
    },
  ],
  'conditions': [
     ['OS=="linux"', {
       'targets': [
         {
           'target_name': 'flip_in_mem_edsm_server',
           'type': 'executable',
           'cflags': [
             '-Wno-deprecated',
           ],
           'dependencies': [
             '../base/base.gyp:base',
             'net.gyp:net',
             '../third_party/openssl/openssl.gyp:openssl',
           ],
           'sources': [
             'tools/dump_cache/url_to_filename_encoder.cc',
             'tools/dump_cache/url_to_filename_encoder.h',
             'tools/dump_cache/url_utilities.h',
             'tools/dump_cache/url_utilities.cc',

             'tools/flip_server/acceptor_thread.h',
             'tools/flip_server/acceptor_thread.cc',
             'tools/flip_server/balsa_enums.h',
             'tools/flip_server/balsa_frame.cc',
             'tools/flip_server/balsa_frame.h',
             'tools/flip_server/balsa_headers.cc',
             'tools/flip_server/balsa_headers.h',
             'tools/flip_server/balsa_headers_token_utils.cc',
             'tools/flip_server/balsa_headers_token_utils.h',
             'tools/flip_server/balsa_visitor_interface.h',
             'tools/flip_server/buffer_interface.h',
             'tools/flip_server/constants.h',
             'tools/flip_server/create_listener.cc',
             'tools/flip_server/create_listener.h',
             'tools/flip_server/epoll_server.cc',
             'tools/flip_server/epoll_server.h',
             'tools/flip_server/flip_config.cc',
             'tools/flip_server/flip_config.h',
             'tools/flip_server/flip_in_mem_edsm_server.cc',
             'tools/flip_server/http_interface.cc',
             'tools/flip_server/http_interface.h',
             'tools/flip_server/http_message_constants.cc',
             'tools/flip_server/http_message_constants.h',
             'tools/flip_server/loadtime_measurement.h',
             'tools/flip_server/mem_cache.h',
             'tools/flip_server/mem_cache.cc',
             'tools/flip_server/porting.txt',
             'tools/flip_server/output_ordering.cc',
             'tools/flip_server/output_ordering.h',
             'tools/flip_server/ring_buffer.cc',
             'tools/flip_server/ring_buffer.h',
             'tools/flip_server/simple_buffer.cc',
             'tools/flip_server/simple_buffer.h',
             'tools/flip_server/sm_connection.cc',
             'tools/flip_server/sm_connection.h',
             'tools/flip_server/sm_interface.h',
             'tools/flip_server/split.h',
             'tools/flip_server/split.cc',
             'tools/flip_server/spdy_ssl.cc',
             'tools/flip_server/spdy_ssl.h',
             'tools/flip_server/spdy_interface.cc',
             'tools/flip_server/spdy_interface.h',
             'tools/flip_server/spdy_util.cc',
             'tools/flip_server/spdy_util.h',
             'tools/flip_server/streamer_interface.cc',
             'tools/flip_server/streamer_interface.h',
             'tools/flip_server/string_piece_utils.h',
             'tools/flip_server/thread.h',
             'tools/flip_server/url_to_filename_encoder.h',
             'tools/flip_server/url_utilities.h',
           ],
         },
       ]
     }],
    ['OS=="win"', {
      'targets': [
        {
          # TODO(port): dump_cache is still Windows-specific.
          'target_name': 'dump_cache',
          'type': 'executable',
          'dependencies': [
            'net',
            'net_test_support',
            '../base/base.gyp:base',
          ],
          'sources': [
            'tools/dump_cache/cache_dumper.cc',
            'tools/dump_cache/cache_dumper.h',
            'tools/dump_cache/dump_cache.cc',
            'tools/dump_cache/dump_files.cc',
            'tools/dump_cache/upgrade.cc',
            'tools/dump_cache/url_to_filename_encoder.cc',
            'tools/dump_cache/url_to_filename_encoder.h',
            'tools/dump_cache/url_utilities.h',
            'tools/dump_cache/url_utilities.cc',
          ],
        },
      ],
    }],
  ],
}

# Local Variables:
# tab-width:2
# indent-tabs-mode:nil
# End:
# vim: set expandtab tabstop=2 shiftwidth=2:
