{
  'includes': ['../../build/toolchain.gypi'],
  'variables' : {

    'variables' : {
        'v8_build' : 'shared',
        'product_name%': '',
    },
    'v8_build': '<(v8_build)',
    'conditions': [
      ['v8_build=="shared"', {
        #SWE use prebuilt
        'product_name': 'swev8',
      },],
    ],
  },

  'conditions': [
    ['use_system_v8==0 and v8_build=="shared"', {
      'targets' : [
      {
        'target_name': 'v8',
        'type': 'none',
        'link_settings': {
          'libraries': [
          '-L<(SHARED_LIB_DIR)/',
          '-lswev8',
          ]
        },
        'target_conditions': [
          ['_toolset == "target"', {
            'conditions' : [
              ['target_arch == "arm" and arm_version==7 and clang == 0', {
                'copies': [
                  {
                    'destination': '<(SHARED_LIB_DIR)',
                    'files': [
                      '../../../v8/lib/target/libswev8.so'
                    ],
                  },
                ],
              },],
              ['target_arch == "arm" and arm_version==7 and clang == 1', {
                'copies': [
                  {
                    'destination': '<(SHARED_LIB_DIR)',
                    'files': [
                      '../../../v8/lib/target/experimental/libswev8.so'
                    ],
                  },
                ],
              },],
            ]
          }, {
            'conditions' : [
              ['host_arch == "x64" and host_os=="linux"', {
                'copies': [
                {
                  'destination': '<(SHARED_LIB_DIR)/host',
                  'files': [
                    '../../../v8/lib/host/libswev8.so'
                  ],
                },
                ],
              }],
            ],
          },
          ],
        ],

        'conditions': [
          ['want_separate_host_toolset==1', {
            'toolsets': ['host', 'target'],
          }, {
            'toolsets': ['target'],
          }],
        ],

        'direct_dependent_settings': {
          'defines': [
            'V8_SHARED',
            'USING_V8_SHARED',
          ],
          'include_dirs': [
            '../../../v8/include',
          ],
        },


      },
      {
        'target_name': 'd8',
        'type': 'none',
        'dependencies': [
          'v8',
        ],

        'conditions': [
          ['want_separate_host_toolset==1', {
            'toolsets': ['host'],
          }, {
            'toolsets': ['target'],
          }],
          ['host_arch == "x64" and host_os=="linux"', {
            'copies': [
            {
              'destination': '<(PRODUCT_DIR)',
              'files': [
                '../../../v8/bin/host/d8'
              ],
            },
            ],
          }],
        ],
      }
      ]
    }]
  ]
}
