# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

# This Android makefile is used to build WebView in the Android build system.
# gyp autogenerates most of the real makefiles, which we just include here if
# we are doing a WebView build. For other builds, this makefile does nothing,
# which prevents the Android build system from mistakenly loading any other
# Android.mk that may exist in the Chromium tree.

CHROMIUM_DIR := $(call my-dir)

# Assume that if the gyp autogenerated makefile exists, we are doing the
# WebView build using the Android build system.
ifneq (,$(wildcard $(CHROMIUM_DIR)/GypAndroid.$(HOST_OS)-$(TARGET_ARCH).mk))

# Don't include anything if the product is using a prebuilt webviewchromium.
#ifneq ($(PRODUCT_PREBUILT_WEBVIEWCHROMIUM),yes)

# We default to release for the Android build system. Developers working on
# WebView code can build with "make GYP_CONFIGURATION=Debug".
GYP_CONFIGURATION := Release

include $(CHROMIUM_DIR)/GypAndroid.$(HOST_OS)-$(TARGET_ARCH).mk
include $(CHROMIUM_DIR)/android_webview/Android.mk

else

#Android.mk for ninja build
LOCAL_PATH := $(call my-dir)

_ace_build_intermediate_dir := $(call intermediates-dir-for, ACE,build)/out
#_ace_build_intermediate_dir := $(CHROMIUM_DIR)/out
_ace_built_out 				:= $(_ace_build_intermediate_dir)/Release/swe_test_apk/swe_res
_ace_built_jar_out 			:= $(_ace_built_out)/jar
_ace_built_lib_out 			:= $(_ace_built_out)/lib

ifeq ($(ace_open_lib),true) # WEB_NON_QCOM_SUPPORT : Open lib support
    # Force to build with open lib
    TARGET_HW := nonqcom
else
    # Build device according to chipset config
    ifneq ($(BOARD_USES_QCOM_HARDWARE),)
        TARGET_HW := qcom
    else
        TARGET_HW := nonqcom
    endif
endif

ENABLE_XGETZIP := false
#used built libraries
_ace_additional_shared_libraries := \
	libicui18n.cr \
	libicuuc.cr

ifeq ($(TARGET_HW),qcom) # WEB_NON_QCOM_SUPPORT : Open lib support
_ace_additional_shared_libraries += \
	libstlport_sh_521 \
	libswenetxt_plugin \
	libsweadrenoext_plugin \
	libsweskia \
	libswev8
endif

##################### ACE build ############################
include $(CLEAR_VARS)
LOCAL_MODULE := advanced_chromium_engine
LOCAL_MODULE_TAGS := optional
LOCAL_MODULE_CLASS := ACE
LOCAL_MODULE_SUFFIX := -stamp
LOCAL_UNINSTALLABLE_MODULE := true
LOCAL_JAVA_LIBRARIES := framework com.lge.frameworks # java library dependency

include $(BUILD_SYSTEM)/base_rules.mk

$(LOCAL_BUILT_MODULE): ace_ninja_build
$(LOCAL_BUILT_MODULE): $(LOCAL_PATH)/Android.mk
	$(hide) echo "ACE timestamp: $@"
	$(hide) mkdir -p $(dir $@)
	$(hide) touch $@

.PHONY: ace_ninja_build

$(_ace_build_intermediate_dir):
	  $(hide) mkdir -p $@

ACE_STAMP := $(abspath $(_ace_build_intermediate_dir)/gclient-stamp)

ifneq ($(force-gclient),)
$(shell rm $(ACE_STAMP))
endif

ace_ninja_build: ACE_PATH           := $(abspath $(LOCAL_PATH)/tools/depot_tools):$$PATH
ace_ninja_build: ACE_PATH           := $(ACE_PATH):$(abspath $(LOCAL_PATH)/tools/apache-ant-1.9.2/bin)
ace_ninja_build: ACE_OUT            := $(abspath $(_ace_build_intermediate_dir))
ace_ninja_build: ACE_ENV            := LGE_ANDROID_JAR_DEPS="$(abspath $(call java-lib-deps,$(LOCAL_JAVA_LIBRARIES),))"
ace_ninja_build: ACE_ENV            += LGE_ANDROID_FLOATING_JAR_DEPS="$(abspath $(call java-lib-deps,com.lge.app.floating,))"
ace_ninja_build: ACE_ENV            += GYP_GENERATOR_FLAGS="output_dir=$(ACE_OUT)" GYP_GENERATORS=ninja ANDROID_MK_BUILD=true
ace_ninja_build: ACE_SRC_PATH       := $(LOCAL_PATH)
ace_ninja_build: $(call java-lib-deps,$(LOCAL_JAVA_LIBRARIES),) $(_ace_build_intermediate_dir)
	$(hide) echo "## building advanced chromium engine ##"
	$(hide) cd $(ACE_SRC_PATH); \
			export PATH=$(ACE_PATH) $(ACE_ENV) && \
			export TARGET_HW=$(TARGET_HW) && # WEB_NON_QCOM_SUPPORT : Open lib support \
			export TARGET_COUNTRY=$(TARGET_COUNTRY) && \
			unset TARGET_PRODUCT && \
			unset CHROME_SRC && \
			source build/android/envsetup.sh && \
			if [ ! -f $(ACE_STAMP) ]; then gclient runhooks && touch $(ACE_STAMP);fi && \
			ninja -C $(ACE_OUT)/Release swe_test_apk && \
			ninja -j1 -C $(ACE_OUT)/Release swe_res
	$(hide) find $(ACE_OUT)/Release/lib/ -name "*.so" -exec mv -f {} $(TARGET_OUT_SHARED_LIBRARIES_UNSTRIPPED)/ \;
	$(hide) echo "## building advanced chromium engine done ##"


##################### swe_engine.jar ###################
include $(CLEAR_VARS)
LOCAL_MODULE := swe_engine
LOCAL_MODULE_CLASS := JAVA_LIBRARIES
LOCAL_MODULE_OWNER := lge
LOCAL_MODULE_TAGS := optional
LOCAL_MODULE_SUFFIX := .jar
LOCAL_PREBUILT_MODULE_FILE := $(_ace_built_jar_out)/swe_engine.jar
$(_ace_built_jar_out)/swe_engine.jar: ace_ninja_build
LOCAL_UNINSTALLABLE_MODULE := true # don't wanna system.img
include $(BUILD_PREBUILT)

##################### liblgewebviewchromium.so ###################
include $(CLEAR_VARS)
LOCAL_MODULE           := liblgewebviewchromium
LOCAL_MODULE_TAGS      := optional
LOCAL_MODULE_OWNER     := lge
LOCAL_MODULE_CLASS     := SHARED_LIBRARIES
LOCAL_MODULE_SUFFIX    := .so
#LOCAL_MODULE_PATH      := $(TARGET_OUT_VENDOR_SHARED_LIBRARIES)
LOCAL_MODULE_PATH      := $($(TARGET_2ND_ARCH_VAR_PREFIX)TARGET_OUT_VENDOR_SHARED_LIBRARIES)
LOCAL_REQUIRED_MODULES := swe_engine $(_ace_additional_shared_libraries)
LOCAL_PREBUILT_MODULE_FILE := $(_ace_built_lib_out)/liblgewebviewchromium.so
$(_ace_built_lib_out)/liblgewebviewchromium.so: ace_ninja_build
include $(BUILD_PREBUILT)

define ace_shared_library_prebuilt

include $(CLEAR_VARS)
LOCAL_MODULE           := $(1)
LOCAL_MODULE_TAGS      := optional
LOCAL_MODULE_OWNER     := lge
LOCAL_MODULE_CLASS     := SHARED_LIBRARIES
LOCAL_MODULE_SUFFIX    := .so
#LOCAL_MODULE_PATH      := $(TARGET_OUT_VENDOR_SHARED_LIBRARIES)
LOCAL_MODULE_PATH      := $($(TARGET_2ND_ARCH_VAR_PREFIX)TARGET_OUT_VENDOR_SHARED_LIBRARIES)
LOCAL_PREBUILT_MODULE_FILE := $(_ace_built_lib_out)/$(1).so
$(_ace_built_lib_out)/$(1).so: ace_ninja_build
include $(BUILD_PREBUILT)
endef

# Install additional libraries
$(eval $(foreach LIB,$(_ace_additional_shared_libraries),$(call ace_shared_library_prebuilt,$(LIB))))

#endif

ifneq ($(BUILD_UT),)
include $(LOCAL_PATH)/Android-UT.mk
endif

endif
