#include <stdlib.h>
#include <string.h>

#include "rscode.h"

typedef unsigned char data_t;

struct _RS {
  int mm;              /*                 */
  int nn;              /*                                 */
  data_t *alpha_to;     /*                  */
  data_t *index_of;     /*                      */
  data_t *genpoly;      /*                      */
  int nroots;     /*                                                      */
  int fcr;        /*                                    */
  int prim;       /*                               */
  int iprim;      /*                               */
  int pad;        /*                                  */
  int gfpoly;
  struct _RS *next;
};

static RS *rslist = NULL;

int modnn(RS *rs, int x){
  while (x >= rs->nn) {
    x -= rs->nn;
    x = (x >> rs->mm) + (x & rs->nn);
  }
  return x;
}


#define MODNN(x) modnn(rs,x)

#define MM (rs->mm)
#define NN (rs->nn)
#define ALPHA_TO (rs->alpha_to)
#define INDEX_OF (rs->index_of)
#define GENPOLY (rs->genpoly)
#define NROOTS (rs->nroots)
#define FCR (rs->fcr)
#define PRIM (rs->prim)
#define IPRIM (rs->iprim)
#define PAD (rs->pad)
#define A0 (NN)

static RS *init_rs_char(int symsize, int gfpoly, int fcr, int prim, int nroots, int pad)
{
  RS *rs;

  int i, j, sr,root,iprim;

  rs = NULL;
  if(symsize < 0 || symsize > (int)(8*sizeof(data_t))){
    goto done;
  }

  if(fcr < 0 || fcr >= (1<<symsize))
    goto done;
  if(prim <= 0 || prim >= (1<<symsize))
    goto done;
  if(nroots < 0 || nroots >= (1<<symsize))
    goto done; /*                                           */
  if(pad < 0 || pad >= ((1<<symsize) -1 - nroots))
    goto done; /*                  */

  rs = (RS *)calloc(1,sizeof(RS));
  if(rs == NULL)
    goto done;

  rs->mm = symsize;
  rs->nn = (1<<symsize)-1;
  rs->pad = pad;

  rs->alpha_to = (data_t *)malloc(sizeof(data_t)*(rs->nn+1));
  if(rs->alpha_to == NULL){
    free(rs);
    rs = NULL;
    goto done;
  }
  rs->index_of = (data_t *)malloc(sizeof(data_t)*(rs->nn+1));
  if(rs->index_of == NULL){
    free(rs->alpha_to);
    free(rs);
    rs = NULL;
    goto done;
  }

  rs->index_of[0] = A0; /*                  */
  rs->alpha_to[A0] = 0; /*                 */
  sr = 1;
  for(i=0;i<rs->nn;i++){
    rs->index_of[sr] = i;
    rs->alpha_to[i] = sr;
    sr <<= 1;
    if(sr & (1<<symsize))
      sr ^= gfpoly;
    sr &= rs->nn;
  }
  if(sr != 1){
    free(rs->alpha_to);
    free(rs->index_of);
    free(rs);
    rs = NULL;
    goto done;
  }

  rs->genpoly = (data_t *)malloc(sizeof(data_t)*(nroots+1));
  if(rs->genpoly == NULL){
    free(rs->alpha_to);
    free(rs->index_of);
    free(rs);
    rs = NULL;
    goto done;
  }
  rs->fcr = fcr;
  rs->prim = prim;
  rs->nroots = nroots;
  rs->gfpoly = gfpoly;

  for(iprim=1;(iprim % prim) != 0;iprim += rs->nn)
    ;
  rs->iprim = iprim / prim;

  rs->genpoly[0] = 1;
  for (i = 0,root=fcr*prim; i < nroots; i++,root += prim) {
    rs->genpoly[i+1] = 1;

    for (j = i; j > 0; j--){
      if (rs->genpoly[j] != 0)
        rs->genpoly[j] = rs->genpoly[j-1] ^ rs->alpha_to[modnn(rs,rs->index_of[rs->genpoly[j]] + root)];
      else
        rs->genpoly[j] = rs->genpoly[j-1];
    }
    rs->genpoly[0] = rs->alpha_to[modnn(rs,rs->index_of[rs->genpoly[0]] + root)];
  }
  for (i = 0; i <= nroots; i++)
    rs->genpoly[i] = rs->index_of[rs->genpoly[i]];
 done:;

  return rs;
}

RS *init_rs(int symsize, int gfpoly, int fcr, int prim, int nroots, int pad)
{
  RS *rs;

  for(rs = rslist; rs != NULL; rs = rs->next) {
    if(rs->pad != pad) continue;
    if(rs->nroots != nroots) continue;
    if(rs->mm != symsize) continue;
    if(rs->gfpoly != gfpoly) continue;
    if(rs->fcr != fcr) continue;
    if(rs->prim != prim) continue;

    goto DONE;
  }

  rs = init_rs_char(symsize, gfpoly, fcr, prim, nroots, pad);
  if(rs == NULL) goto DONE;
  rs->next = rslist;
  rslist = rs;

DONE:
  return rs;
}


void free_rs_char(RS *rs)
{
  free(rs->alpha_to);
  free(rs->index_of);
  free(rs->genpoly);
  free(rs);
}

void free_rs_cache(void)
{
  RS *rs, *next;

  rs = rslist;
  while(rs != NULL) {
    next = rs->next;
    free_rs_char(rs);
    rs = next;
  }
  rslist = NULL;

}

#undef A0
#define A0 (NN)

void encode_rs_char(RS *rs, const data_t *data, data_t *parity)
{
  int i, j;
  data_t feedback;

  memset(parity,0,NROOTS*sizeof(data_t));

  for(i=0;i<NN-NROOTS-PAD;i++){
    feedback = INDEX_OF[data[i] ^ parity[0]];
    if(feedback != A0){
      for(j=1;j<NROOTS;j++)
  parity[j] ^= ALPHA_TO[MODNN(feedback + GENPOLY[NROOTS-j])];
    }
    /*       */
    memmove(&parity[0],&parity[1],sizeof(data_t)*(NROOTS-1));
    if(feedback != A0)
      parity[NROOTS-1] = ALPHA_TO[MODNN(feedback + GENPOLY[0])];
    else
      parity[NROOTS-1] = 0;
  }
}
