#ifndef _UI_FBINPUTREADER_H
#define _UI_FBINPUTREADER_H

#include "fb_event_hub.h"

/*
 * Maximum number of pointers supported per motion event.
 * Smallest number of pointers is 1.
 * (We want at least 10 but some touch controllers obstensibly configured for 10 pointers
 * will occasionally emit 11.  There is not much harm making this constant bigger.)
 */
#define MAX_KEY 8

#define SW_HEADPHONE_INSERT 0x02
#define SW_MICROPHONE_INSERT 0x04
#define SW_ADVANCED_HEADPHONE_INSERT  0x11
#define SW_AUX_ACCESSORY_INSERT 0x12

#define TOUCH_RELEASE 0
#define TOUCH_DOWN 1
#define TOUCH_MOVE 3

#define CONVERT_COORDINATE(value, ssize, tsize)    ((value * ssize) / tsize)


/* Represents the state of a single input device. */
struct InputDevice {
    int32_t mId;
    uint32_t mClasses;

    void (*process)(const struct RawEvent* rawEvent);
};

/* Keeps track of the state of keyboard protocol. */
struct KeyboardInput {
    struct KeyDown {
        int32_t keyCode;
        int32_t scanCode;
    };

    int32_t mCurrentHidUsage; // most recent HID usage seen this packet, or 0 if none
    int32_t mOrientation; // orientation for dpad keys

    struct KeyDown mKeyDowns[512];
    int32_t mKeyDownsCount;

    // Immutable configuration parameters.
    struct Parameters {
        Bool hasAssociatedDisplay;
        Bool orientationAware;
    } mParameters;
};


/* Raw data for a collection of pointers including a pointer id mapping table. */
struct Pointer {
    uint32_t id;
    int32_t x;
    int32_t y;
    int32_t pressure;
    int32_t touchMajor;
    int32_t touchMinor;
    int32_t toolMajor;
    int32_t toolMinor;
    int32_t orientation;
    int32_t distance;
    int32_t tiltX;
    int32_t tiltY;
};

struct RawPointerData {
    uint32_t pointerCount;
    struct Pointer pointers[MAX_POINTERS];
    uint32_t idToIndex[MAX_POINTERS];
    uint32_t touchingIdBits;
};


/* Keeps track of the state of MultiTouch protocol. */
struct MultiTouchMotionAccumulator {
    int32_t mAbsMTPositionX;
    int32_t mAbsMTPositionY;
    int32_t mAbsMTTouchMajor;
    int32_t mAbsMTTouchMinor;
    int32_t mAbsMTWidthMajor;
    int32_t mAbsMTWidthMinor;
    int32_t mAbsMTOrientation;
    int32_t mAbsMTTrackingId;
    int32_t mAbsMTPressure;
    int32_t mAbsMTDistance;
    int32_t mAbsMTToolType;

    Bool mInUse;
    Bool mHaveAbsMTTouchMinor;
    Bool mHaveAbsMTWidthMinor;
    Bool mHaveAbsMTToolType;

    uint32_t mIsValidBits;
};

struct KeyboardAccumulator {
    int32_t keyCode;
    int32_t value;
    Bool flag;
};

struct KeyboardMap {
    int32_t keyCode;
    char    name[64];
};

struct SwitchMap {
    int32_t switchCode;
    char    name[64];
};

#endif
