#ifndef HI258_REG_H
#define HI258_REG_H

#include "msm_sensor.h"

static struct msm_camera_i2c_reg_conf hi258_recommend_settings[] = {
{0x03, 0x00},
{0x01, 0x09}, //sleep on
{0x01, 0x03}, //sleep off
{0x01, 0x09}, //sleep on
// PAGE 20
{0x03, 0x20}, // page 20
{0x10, 0x0c}, // AE off 60hz

// PAGE 22
{0x03, 0x22}, // page 22
{0x10, 0x69}, // AWB off

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x08, 0x0f}, //131002
{0x09, 0x07}, //131002 pad strength 77->07
{0x0a, 0x00}, //131002 pad strength 07->00

//PLL Setting
{0x03, 0x00},
{0xd0, 0x05}, //PLL pre_div 1/6 = 4 Mhz
{0xd1, 0x30}, //PLL maim_div
{0xd2, 0x05}, //isp_div[1:0] mipi_4x_div[3:2]  mipi_1x_div[4] pll_bias_opt[7:5] //Full&Pre2 0x01, Sub&Pre1 0x05
{0xd3, 0x20}, //isp_clk_inv[0]  mipi_4x_inv[1]  mipi_1x_inv[2]
{0xd0, 0x85},
{0xd0, 0x85},
{0xd0, 0x85},
{0xd0, 0x95},

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},


///// PAGE 20 /////
{0x03, 0x20}, //page 20
{0x10, 0x0c}, //AE off 60hz

///// PAGE 22 /////
{0x03, 0x22}, //page 22
{0x10, 0x69}, //AWB off

///// Initial Start /////
///// PAGE 0 Start /////
{0x03, 0x00}, //page 0
{0x10, 0x91}, //Sub1/2+Bin
{0x11, 0x90}, //Windowing On + 1Frame Skip
{0xd2, 0x05}, //Full&Pre2 0x01, Sub&Pre1 0x05
{0x12, 0x04}, //Rinsing edge 0x04 // Falling edge 0x00
{0x14, 0x05},

{0x20, 0x00}, //Row H
{0x21, 0x02}, //Row L
{0x22, 0x00}, //Col H
{0x23, 0x04}, //Col L

{0x24, 0x04}, //Window height_H //= 1200
{0x25, 0xb0}, //Window height_L //
{0x26, 0x06}, //Window width_H  //= 1600
{0x27, 0x40}, //Window wight_L

{0x28, 0x04}, //Full row start y-flip
{0x29, 0x01}, //Pre1 row start no-flip
{0x2a, 0x02}, //Pre1 row start y-flip

{0x2b, 0x04}, //Full wid start x-flip
{0x2c, 0x04}, //Pre2 wid start no-flip
{0x2d, 0x02}, //Pre2 wid start x-flip

{0x30, 0x00},
{0x31, 0x00},
{0x32, 0x04},
{0x33, 0xc0},
{0x34, 0x04},
{0x35, 0xc0},

{0x36, 0x00},
{0x37, 0x00},
{0x38, 0x06},
{0x39, 0x50},
{0x3a, 0x06},
{0x3b, 0x50},

{0x40, 0x01}, //Hblank 296 (oneline 1920)
{0x41, 0x28},
{0x42, 0x00}, //Vblank 4
{0x43, 0x04},

///// BLC /////
{0x80, 0x2e},
{0x81, 0x7e},
{0x82, 0x90},
{0x83, 0x00},
{0x84, 0xcc}, //20130604 0x0c->0xcc
{0x85, 0x00},
{0x86, 0x00},
{0x87, 0x0f},
{0x88, 0x34},
{0x8a, 0x0b},
{0x8e, 0x80}, //Pga Blc Hold

{0x90, 0x11}, //BLC_TIME_TH_ON
{0x91, 0x11}, //BLC_TIME_TH_OFF
{0x92, 0xb8}, //BLC_AG_TH_ON
{0x93, 0xb0}, //BLC_AG_TH_OFF
{0x96, 0xdc}, //BLC Outdoor Th On
{0x97, 0xfe}, //BLC Outdoor Th Off
{0x98, 0x38},

//OutDoor  BLC
{0x99, 0x43}, //R,Gr,B,Gb Offset

//Dark BLC
{0xa0, 0x01}, //R,Gr,B,Gb Offset

//Normal BLC
{0xa8, 0x43}, //R,Gr,B,Gb Offset
///// PAGE 0 END /////

///// PAGE 2 START /////
{0x03, 0x02},
{0x10, 0x00},
{0x13, 0x00},
{0x14, 0x00},
{0x18, 0xcc},
{0x19, 0x01}, // pmos switch on (for cfpn)
{0x1A, 0x39}, //20130604 0x09->0xcc
{0x1B, 0x00},
{0x1C, 0x1a}, // for ncp
{0x1D, 0x14}, // for ncp
{0x1E, 0x30}, // for ncp
{0x1F, 0x10},

{0x20, 0x77},
{0x21, 0xde},
{0x22, 0xa7},
{0x23, 0x30},
{0x24, 0x77},
{0x25, 0x10},
{0x26, 0x10},
{0x27, 0x3c},
{0x2b, 0x80},
{0x2c, 0x02},
{0x2d, 0x58},
{0x2e, 0x11},//20130604 0xde->0x11
{0x2f, 0x11},//20130604 0xa7->0x11

{0x30, 0x00},
{0x31, 0x99},
{0x32, 0x00},
{0x33, 0x00},
{0x34, 0x22},
{0x36, 0x75},
{0x38, 0x88},
{0x39, 0x88},
{0x3d, 0x03},
{0x3f, 0x02},

{0x49, 0xc1},//20130604 0x87->0xd1 --> mode Change Issue modify -> 0xc1
{0x4a, 0x10},

{0x50, 0x21},
{0x53, 0xb1},
{0x54, 0x10},
{0x55, 0x1c}, // for ncp
{0x56, 0x11},
{0x58, 0x3a},//20130604 add
{0x59, 0x38},//20130604 add
{0x5d, 0xa2},
{0x5e, 0x5a},

{0x60, 0x87},
{0x61, 0x98},
{0x62, 0x88},
{0x63, 0x96},
{0x64, 0x88},
{0x65, 0x96},
{0x67, 0x3f},
{0x68, 0x3f},
{0x69, 0x3f},

{0x72, 0x89},
{0x73, 0x95},
{0x74, 0x89},
{0x75, 0x95},
{0x7C, 0x84},
{0x7D, 0xaf},

{0x80, 0x01},
{0x81, 0x7a},
{0x82, 0x13},
{0x83, 0x24},
{0x84, 0x78},
{0x85, 0x7c},

{0x92, 0x44},
{0x93, 0x59},
{0x94, 0x78},
{0x95, 0x7c},

{0xA0, 0x02},
{0xA1, 0x74},
{0xA4, 0x74},
{0xA5, 0x02},
{0xA8, 0x85},
{0xA9, 0x8c},
{0xAC, 0x10},
{0xAD, 0x16},

{0xB0, 0x99},
{0xB1, 0xa3},
{0xB4, 0x9b},
{0xB5, 0xa2},
{0xB8, 0x9b},
{0xB9, 0x9f},
{0xBC, 0x9b},
{0xBD, 0x9f},

{0xc4, 0x29},
{0xc5, 0x40},
{0xc6, 0x5c},
{0xc7, 0x72},
{0xc8, 0x2a},
{0xc9, 0x3f},
{0xcc, 0x5d},
{0xcd, 0x71},

{0xd0, 0x10},
{0xd1, 0x14},
{0xd2, 0x20},
{0xd3, 0x00},
{0xd4, 0x11}, //DCDC_TIME_TH_ON
{0xd5, 0x11}, //DCDC_TIME_TH_OFF
{0xd6, 0xb8}, //DCDC_AG_TH_ON
{0xd7, 0xb0}, //DCDC_AG_TH_OFF
{0xdc, 0x00},
{0xdd, 0xa3},
{0xde, 0x00},
{0xdf, 0x84},

{0xe0, 0xa4},
{0xe1, 0xa4},
{0xe2, 0xa4},
{0xe3, 0xa4},
{0xe4, 0xa4},
{0xe5, 0x01},
{0xe8, 0x00},
{0xe9, 0x00},
{0xea, 0x77},

{0xF0, 0x00},
{0xF1, 0x00},
{0xF2, 0x00},

///// PAGE 2 END /////


///// PAGE 10 START /////
{0x03, 0x10}, //page 10
{0x10, 0x03}, //S2D enable _ YUYV Order 
{0x11, 0x03},
{0x12, 0x30},
{0x13, 0x03},

{0x20, 0x00},
{0x21, 0x40},
{0x22, 0x0f},
{0x24, 0x20},
{0x25, 0x10},
{0x26, 0x01},
{0x27, 0x02},
{0x28, 0x11},

{0x40, 0x00},
{0x41, 0x00}, //D-YOffset Th
{0x42, 0x00}, //Cb Offset
{0x43, 0x00}, //Cr Offset
{0x44, 0x80},
{0x45, 0x80},
{0x46, 0xf0},
{0x48, 0x80},
{0x4a, 0x80},

{0x50, 0xa0}, //D-YOffset AG

{0x60, 0x4b},//20150119_SCH //4f},
{0x61, 0x90},//84},//88}, //9a}, //Sat B STEVE
{0x62, 0xb0},//86},//88}, //96}, //Sat R STEVE
{0x63, 0x80}, //Auto-De Color

{0x66, 0x42},
{0x67, 0x22},

{0x6a, 0x77}, //White Protection Offset Dark/Indoor
{0x72, 0x72}, //20150115_SCH //84},
{0x74, 0x07}, //White Protection Offset Outdoor
{0x75, 0x60}, //Sat over th
{0x76, 0x01}, // 0x05}, //  STEVE White Protection Enable
{0x78, 0xff}, //Sat over ratio
///// PAGE 10 END /////

///// PAGE 11 START /////
{0x03, 0x11}, //page 11

//LPF Auto Control
{0x20, 0x00},
{0x21, 0x00},
{0x26, 0x6a}, //pga_dark1_min (on)
{0x27, 0x68}, //pga_dark1_max (off)
{0x28, 0x0f},
{0x29, 0x10},
{0x2b, 0x30},
{0x2c, 0x32},

//GBGR
{0x70, 0x2b},
{0x74, 0x30},
{0x75, 0x18},
{0x76, 0x30},
{0x77, 0xff},
{0x78, 0xa0},
{0x79, 0xff}, //Dark GbGr Th
{0x7a, 0x30},
{0x7b, 0x20},
{0x7c, 0xf4}, //Dark Dy Th B[7:4]
{0x7d, 0x02},
{0x7e, 0xb0},
{0x7f, 0x10},
///// PAGE 11 END /////

///// PAGE 12 START /////
{0x03, 0x12}, //page 12

//YC2D
{0x10, 0x03}, //Y DPC Enable
{0x11, 0x08}, //
{0x12, 0x10}, //0x30 -> 0x10
{0x20, 0x53}, //Y_lpf_enable
{0x21, 0x03}, //C_lpf_enable_on
{0x22, 0xe6}, //YC2D_CrCbY_Dy

{0x23, 0x14}, //Outdoor Dy Th
{0x24, 0x30},//20}, //Indoor Dy Th // For reso Limit 0x20
{0x25, 0x60},//30}, //Dark Dy Th

//Outdoor LPF Flat
{0x30, 0xff}, //Y Hi Th
{0x31, 0x00}, //Y Lo Th
{0x32, 0xf0}, //Std Hi Th //Reso Improve Th Low //50
{0x33, 0x00}, //Std Lo Th
{0x34, 0x00}, //Median ratio

//Indoor LPF Flat
{0x35, 0xff}, //Y Hi Th
{0x36, 0x00}, //Y Lo Th
{0x37, 0xff}, //Std Hi Th //Reso Improve Th Low //50
{0x38, 0x00}, //Std Lo Th
{0x39, 0x00}, //Median ratio

//Dark LPF Flat
{0x3a, 0xff}, //Y Hi Th
{0x3b, 0x00}, //Y Lo Th
{0x3c, 0x93}, //Std Hi Th //Reso Improve Th Low //50
{0x3d, 0x00}, //Std Lo Th
{0x3e, 0x00}, //Median ratio

//Outdoor Cindition
{0x46, 0xa0}, //Out Lum Hi
{0x47, 0x40}, //Out Lum Lo

//Indoor Cindition
{0x4c, 0xb0}, //Indoor Lum Hi
{0x4d, 0x40}, //Indoor Lum Lo

//Dark Cindition
{0x52, 0xb0}, //Dark Lum Hi
{0x53, 0x50}, //Dark Lum Lo

//C-Filter
{0x70, 0x10}, //Outdoor(2:1) AWM Th Horizontal
{0x71, 0x0a}, //Outdoor(2:1) Diff Th Vertical
{0x72, 0x20},//10}, //Indoor,Dark1 AWM Th Horizontal
{0x73, 0x0a}, //Indoor,Dark1 Diff Th Vertical
{0x74, 0x20},//18}, //Dark(2:3) AWM Th Horizontal
{0x75, 0x0f}, //Dark(2:3) Diff Th Vertical

//DPC
{0x90, 0x3d}, //don't touch register_SCH //7d},
{0x91, 0x34},
{0x99, 0x14}, //don't touch register_SCH //28},
{0x9c, 0x0a}, //20131107 Flat DPC value 0x14 -> 0x00 -> 0x0a
{0x9d, 0x15},
{0x9e, 0x28},
{0x9f, 0x28},
{0xb0, 0x0e}, //Zipper noise Detault change (0x75->0x0e)
{0xb8, 0x44},
{0xb9, 0x15},
///// PAGE 12 END /////

///// PAGE 13 START /////
{0x03, 0x13}, //page 13

{0x80, 0xfd}, //Sharp2D enable _ YUYV Order
{0x81, 0x07}, //Sharp2D Clip/Limit
{0x82, 0x73}, //Sharp2D Filter
{0x83, 0x00}, //Sharp2D Low Clip
{0x85, 0x00},

{0x92, 0x33}, //Sharp2D Slop n/p
{0x93, 0x30}, //Sharp2D LClip
{0x94, 0x02}, //Sharp2D HiClip1 Th
{0x95, 0xf0}, //Sharp2D HiClip2 Th
{0x96, 0x1e}, //Sharp2D HiClip2 Resolution
{0x97, 0x40},
{0x98, 0x80},
{0x99, 0x40},

//Sharp Lclp
{0xa2, 0x03}, //Outdoor Lclip_N
{0xa3, 0x04}, //Outdoor Lclip_P
{0xa4, 0x02}, //Indoor Lclip_N 0x03 For reso Limit 0x0e
{0xa5, 0x03}, //Indoor Lclip_P 0x0f For reso Limit 0x0f
{0xa6, 0x80}, //Dark Lclip_N
{0xa7, 0x80}, //Dark Lclip_P

//Outdoor Slope
{0xb6, 0x28}, //Lum negative Hi
{0xb7, 0x20}, //Lum negative middle
{0xb8, 0x24}, //Lum negative Low
{0xb9, 0x28}, //Lum postive Hi
{0xba, 0x20}, //Lum postive middle
{0xbb, 0x24}, //Lum postive Low

//Indoor Slope
{0xbc, 0x20}, //Lum negative Hi
{0xbd, 0x20}, //Lum negative middle
{0xbe, 0x20}, //Lum negative Low
{0xbf, 0x20}, //Lum postive Hi
{0xc0, 0x20}, //Lum postive middle
{0xc1, 0x20}, //Lum postive Low

//Dark Slope
{0xc2, 0x14}, //Lum negative Hi
{0xc3, 0x24}, //Lum negative middle
{0xc4, 0x1d}, //Lum negative Low
{0xc5, 0x14}, //Lum postive Hi
{0xc6, 0x24}, //Lum postive middle
{0xc7, 0x1d}, //Lum postive Low
///// PAGE 13 END /////

///// PAGE 14 START /////
{0x03, 0x14}, //page 14
{0x10, 0x09},

{0x20, 0x60},//80}, // //X-Center
{0x21, 0x80},//80}, //Y-Center

//{0x22, 0x78}, //LSC R 1b->15 20130125
//{0x23, 0x68}, //LSC G
//{0x24, 0x68}, //LSC B

//CW//
{0x22, 0x70},//75},///6d},//6c},//6a},//38}, //LSC R 1b->15 20130125
{0x23, 0x4d},//4a},///49},//50},//50},//29}, //LSC G
{0x24, 0x50},//4e},///4e},//4e},//4a},//28}, //LSC B
//{0x22, 0x60},//56}, //LSC R 1b->15 20130125
//{0x23, 0x45},//39}, //LSC G
//{0x24, 0x49},//3f}, //LSC B
//SKh//
//{0x22, 0x5c}, //LSC R 1b->15 20130125
//{0x23, 0x3f}, //LSC G
//{0x24, 0x3b}, //LSC B

{0x25, 0xf0}, //LSC Off
{0x26, 0xf0}, //LSC On
///// PAGE 14 END /////

/////// PAGE 15 START ///////
{0x03, 0x15}, //page 15
{0x10, 0x21},
{0x14, 0x46},
{0x15, 0x36},
{0x16, 0x26},
{0x17, 0x3f},	//CMC SIGN
//CMC
{0x30, 0xcb},
{0x31, 0x40},
{0x32, 0x0b},
{0x33, 0x22},
{0x34, 0xdb},
{0x35, 0x39},
{0x36, 0x0b},
{0x37, 0x5c},
{0x38, 0xe7},
//CMC OFS
{0x40, 0x00},//90},
{0x41, 0x00},//10},
{0x42, 0x00},//00},
{0x43, 0x00},//08},
{0x44, 0x00},//12},
{0x45, 0x00},//9a},
{0x46, 0x00},//9a},
{0x47, 0x00},//04},
{0x48, 0x00},//16},
//CMC POFS
{0x50, 0x00},//04},//00},
{0x51, 0x00},//08},
{0x52, 0x00},//04},//18},
{0x53, 0x00},//04},
{0x54, 0x00},//00},
{0x55, 0x00},//04},
{0x56, 0x00},//02},
{0x57, 0x00},//00},
{0x58, 0x00},//02},

///// PAGE 15 END /////

///// PAGE 16 START /////
{0x03, 0x16}, //page 16 Gamma
{0x10, 0x21}, //31},
{0x18, 0x5a}, //Double_AG 5e->37
{0x19, 0x58}, //Double_AG 5e->36
{0x1a, 0x0e},
{0x1b, 0x01},
{0x1c, 0xdc},
{0x1d, 0xfe},

//Indoor
{0x30, 0x00},
{0x31, 0x08},
{0x32, 0x19},
{0x33, 0x34},
{0x34, 0x64},
{0x35, 0x80},
{0x36, 0x96},
{0x37, 0xa7},
{0x38, 0xb5},
{0x39, 0xc1},
{0x3a, 0xcc},
{0x3b, 0xd5},
{0x3c, 0xde},
{0x3d, 0xe5},
{0x3e, 0xeb},
{0x3f, 0xf0},
{0x40, 0xf6},
{0x41, 0xfa},
{0x42, 0xff},

//Outdoor
{0x50, 0x00},//0x00},
{0x51, 0x08},//0x03},
{0x52, 0x19},//0x10},
{0x53, 0x34},//0x26},
{0x54, 0x64},//0x43},
{0x55, 0x80},//0x5d},
{0x56, 0x96},//0x79},
{0x57, 0xa7},//0x8c},
{0x58, 0xb5},//0x9f},
{0x59, 0xc1},//0xaa},
{0x5a, 0xcc},//0xb6},
{0x5b, 0xd5},//0xc3},
{0x5c, 0xde},//0xce},
{0x5d, 0xe5},//0xd9},
{0x5e, 0xeb},//0xe1},
{0x5f, 0xf0},//0xe9},
{0x60, 0xf6},//0xf0},
{0x61, 0xfa},//0xf4},
{0x62, 0xff},//0xf5},

//Dark
{0x70, 0x00},//0x00},
{0x71, 0x0b},//0x10},
{0x72, 0x1c},//0x1c},
{0x73, 0x3b},//0x2e},
{0x74, 0x6b},//0x4e},
{0x75, 0x88},//0x6c},
{0x76, 0x9e},//0x82},
{0x77, 0xae},//0x96},
{0x78, 0xbc},//0xa7},
{0x79, 0xc7},//0xb6},
{0x7a, 0xd0},//0xc4},
{0x7b, 0xd9},//0xd0},
{0x7c, 0xe1},//0xda},
{0x7d, 0xe7},//0xe2},
{0x7e, 0xec},//0xea},
{0x7f, 0xf1},//0xf0},
{0x80, 0xf6},//0xf6},
{0x81, 0xfa},//0xfa},
{0x82, 0xff},//0xFF},
///// PAGE 16 END /////

///// PAGE 17 START /////
{0x03, 0x17}, //page 17
{0xc1, 0x00},
{0xC4, 0x3e},
{0xC5, 0x34},
{0xc6, 0x02},
{0xc7, 0x20},
///// PAGE 17 END /////

///// PAGE 18 START /////
{0x03, 0x18}, //page 18
{0x10, 0x00},	//Scale Off
{0x11, 0x00},
{0x12, 0x58},
{0x13, 0x01},
{0x14, 0x0b},
{0x15, 0x00},
{0x16, 0x00},
{0x17, 0x00},
{0x18, 0x00},
{0x19, 0x00},
{0x1a, 0x00},
{0x1b, 0x00},
{0x1c, 0x00},
{0x1d, 0x00},
{0x1e, 0x00},
{0x1f, 0x00},
{0x20, 0x05},	//zoom wid
{0x21, 0x00},
{0x22, 0x01},	//zoom hgt
{0x23, 0xe0},
{0x24, 0x00},	//zoom start x
{0x25, 0x00},
{0x26, 0x00},	//zoom start y
{0x27, 0x00},
{0x28, 0x05},	//zoom end x
{0x29, 0x00},
{0x2a, 0x01},	//zoom end y
{0x2b, 0xe0},
{0x2c, 0x0a},	//zoom step vert
{0x2d, 0x00},
{0x2e, 0x0a},	//zoom step horz
{0x2f, 0x00},
{0x30, 0x44},	//zoom fifo

///// PAGE 18 END /////

{0x03, 0x19}, //Page 0x19
{0x10, 0x7e},//7f}, //mcmc_ctl1 MCMC Enable B:[0]
{0x11, 0x7f}, //mcmc_ctl2
{0x12, 0x1e}, //mcmc_delta1
{0x13, 0x72}, //mcmc_center1
{0x14, 0x1e}, //mcmc_delta2
{0x15, 0xec}, //mcmc_center2
{0x16, 0x9e}, //mcmc_delta3
{0x17, 0x56}, //mcmc_center3
{0x18, 0x9e}, //mcmc_delta4
{0x19, 0x36}, //mcmc_center4
{0x1a, 0x1e}, //mcmc_delta5
{0x1b, 0x52}, //mcmc_center5
{0x1c, 0x1e}, //mcmc_delta6
{0x1d, 0xa4}, //mcmc_center6
{0x1e, 0x40}, //mcmc_sat_gain1
{0x1f, 0x58}, //mcmc_sat_gain2
{0x20, 0x40}, //mcmc_sat_gain3
{0x21, 0x40}, //mcmc_sat_gain4
{0x22, 0x40}, //mcmc_sat_gain5
{0x23, 0x50}, //mcmc_sat_gain6
{0x24, 0x00}, //mcmc_hue_angle1
{0x25, 0x00}, //mcmc_hue_angle2
{0x26, 0x00}, //mcmc_hue_angle3
{0x27, 0x00}, //mcmc_hue_angle4
{0x28, 0x00}, //mcmc_hue_angle5
{0x29, 0x00}, //mcmc_hue_angle6
{0x53, 0x10}, //mcmc_ctl3
{0x6c, 0xff}, //mcmc_lum_ctl1 sat hue offset
{0x6d, 0x3f}, //mcmc_lum_ctl2 gain
{0x6e, 0x00}, //mcmc_lum_ctl3 hue
{0x6f, 0x00}, //mcmc_lum_ctl4 rgb offset
{0x70, 0x00}, //mcmc_lum_ctl5 rgb scale
{0x71, 0x3f}, //mcmc_lum_gain_wgt_th1 R1 magenta
{0x72, 0x3f}, //mcmc_lum_gain_wgt_th2 R1
{0x73, 0x3f}, //mcmc_lum_gain_wgt_th3 R1
{0x74, 0x3f}, //mcmc_lum_gain_wgt_th4 R1
{0x75, 0x30}, //mcmc_rg1_lum_sp1      R1
{0x76, 0x50}, //mcmc_rg1_lum_sp2      R1
{0x77, 0x80}, //mcmc_rg1_lum_sp3      R1
{0x78, 0xb0}, //mcmc_rg1_lum_sp4      R1
{0x79, 0x3f}, //mcmc_lum_gain_wgt_th1 R2 bright green
{0x7a, 0x3f}, //mcmc_lum_gain_wgt_th2 R2
{0x7b, 0x3f}, //mcmc_lum_gain_wgt_th3 R2
{0x7c, 0x3f}, //mcmc_lum_gain_wgt_th4 R2
{0x7d, 0x28}, //mcmc_rg2_lum_sp1      R2
{0x7e, 0x50}, //mcmc_rg2_lum_sp2      R2
{0x7f, 0x80}, //mcmc_rg2_lum_sp3      R2
{0x80, 0xb0}, //mcmc_rg2_lum_sp4      R2
{0x81, 0x28}, //mcmc_lum_gain_wgt_th1 R3 dark green
{0x82, 0x3f}, //mcmc_lum_gain_wgt_th2 R3
{0x83, 0x3f}, //mcmc_lum_gain_wgt_th3 R3
{0x84, 0x3f}, //mcmc_lum_gain_wgt_th4 R3
{0x85, 0x28}, //mcmc_rg3_lum_sp1      R3
{0x86, 0x50}, //mcmc_rg3_lum_sp2      R3
{0x87, 0x80}, //mcmc_rg3_lum_sp3      R3
{0x88, 0xb0}, //mcmc_rg3_lum_sp4      R3
{0x89, 0x1a}, //mcmc_lum_gain_wgt_th1 R4 skin
{0x8a, 0x28}, //mcmc_lum_gain_wgt_th2 R4
{0x8b, 0x3f}, //mcmc_lum_gain_wgt_th3 R4
{0x8c, 0x3f}, //mcmc_lum_gain_wgt_th4 R4
{0x8d, 0x10}, //mcmc_rg3_lum_sp1      R4
{0x8e, 0x30}, //mcmc_rg3_lum_sp2      R4
{0x8f, 0x60}, //mcmc_rg3_lum_sp3      R4
{0x90, 0x90}, //mcmc_rg3_lum_sp4      R4
{0x91, 0x1a}, //mcmc_rg5_gain_wgt_th1 R5 cyan
{0x92, 0x28}, //mcmc_rg5_gain_wgt_th2 R5
{0x93, 0x3f}, //mcmc_rg5_gain_wgt_th3 R5
{0x94, 0x3f}, //mcmc_rg5_gain_wgt_th4 R5
{0x95, 0x28}, //mcmc_rg5_lum_sp1      R5
{0x96, 0x50}, //mcmc_rg5_lum_sp2      R5
{0x97, 0x80}, //mcmc_rg5_lum_sp3      R5
{0x98, 0xb0}, //mcmc_rg5_lum_sp4      R5
{0x99, 0x1a}, //mcmc_rg6_gain_wgt_th1 R6 blue
{0x9a, 0x28}, //mcmc_rg6_gain_wgt_th2 R6
{0x9b, 0x3f}, //mcmc_rg6_gain_wgt_th3 R6
{0x9c, 0x3f}, //mcmc_rg6_gain_wgt_th4 R6
{0x9d, 0x28}, //mcmc_rg6_lum_sp1      R6
{0x9e, 0x50}, //mcmc_rg6_lum_sp2      R6
{0x9f, 0x80}, //mcmc_rg6_lum_sp3      R6
{0xa0, 0xb0}, //mcmc_rg6_lum_sp4      R6

{0xe5, 0x80}, //add 20120709 Bit[7] On MCMC --> YC2D_LPF

/////// PAGE 20 START ///////
{0x03, 0x20},
{0x10, 0x0c},
{0x11, 0x0c}, //131002 14 -> 0c
{0x18, 0x30},
{0x20, 0x25}, //8x8 Ae weight 0~7 Outdoor / Weight Outdoor On B[5]
{0x21, 0x30},
{0x22, 0x10},
{0x23, 0x00},

{0x28, 0xf7},
{0x29, 0x0d},
{0x2a, 0xff},
{0x2b, 0x34},//04}, //Adaptive Off,1/100 Flicker

{0x2c, 0x83}, //AE After CI
{0x2d, 0xe3},
{0x2e, 0x13},
{0x2f, 0x0b},

{0x30, 0x78},
{0x31, 0xd7},
{0x32, 0x10},
{0x33, 0x2e},
{0x34, 0x20},
{0x35, 0xd4},
{0x36, 0xfe},
{0x37, 0x32},
{0x38, 0x04},
{0x39, 0x22},
{0x3a, 0xde},
{0x3b, 0x22},
{0x3c, 0xde},
{0x3d, 0xe1},

{0x3e, 0xc9}, //Option of changing Exp max
{0x41, 0x23}, //Option of changing Exp max

{0x50, 0x45},
{0x51, 0x88},

{0x56, 0x1f}, // for tracking
{0x57, 0xa6}, // for tracking
{0x58, 0x1a}, // for tracking
{0x59, 0x7a}, // for tracking

{0x5a, 0x04},
{0x5b, 0x04},

{0x5e, 0xc7},
{0x5f, 0x95},

{0x62, 0x10},
{0x63, 0xc0},
{0x64, 0x10},
{0x65, 0x8a},
{0x66, 0x58},
{0x67, 0x58},

{0x70, 0x40},//3b}, //54->46
{0x71, 0x80},//82}, //_140416 //89}, //81(+4),89(-4)

{0x76, 0x32},
{0x77, 0x81}, //141218 //a2}, //140416 //a1},
{0x78, 0x32}, //141218 //22 //24
{0x79, 0x26}, //141218 //27}, //30}, // Y Target 70 => 25, 72 => 26 //
{0x7a, 0x23}, //23
{0x7b, 0x22}, //22
{0x7d, 0x23},

{0x83, 0x03}, //EXP Normal 30.00 fps 
{0x84, 0x0c}, 
{0x85, 0x00}, 
{0x86, 0x01}, //EXPMin 12500.00 fps
{0x87, 0xe0}, 
{0x88, 0x0c}, //EXP Max 60hz 7.06 fps 
{0x89, 0xf3}, 
{0x8a, 0x00}, 
{0xa5, 0x0c}, //EXP Max 50hz 7.14 fps 
{0xa6, 0xd1}, 
{0xa7, 0x40}, 
{0x8B, 0xea}, //EXP100 
{0x8C, 0x60}, 
{0x8D, 0xc3}, //EXP120 
{0x8E, 0x00}, 
{0x9c, 0x18}, //EXP Limit 961.54 fps 
{0x9d, 0x60}, 
{0x9e, 0x01}, //EXP Unit 
{0x9f, 0xe0}, 
{0xa3, 0x00}, //Outdoor Int 
{0xa4, 0xc3}, 

{0xb0, 0x15},
{0xb1, 0x14},
{0xb2, 0xc0},
{0xb3, 0x15},
{0xb4, 0x16},
{0xb5, 0x3c},
{0xb6, 0x29},
{0xb7, 0x23},
{0xb8, 0x54},
{0xb9, 0x50},
{0xba, 0x4d},
{0xbb, 0x4b},
{0xbc, 0x4a},
{0xbd, 0x49},

{0xc0, 0x10},
{0xc1, 0x40},
{0xc2, 0x40},
{0xc3, 0x40},
{0xc4, 0x04},

{0xc6, 0x80}, //Exp max 1frame target AG

{0xc8, 0x80},
{0xc9, 0x80},
///// PAGE 20 END /////

///// PAGE 21 START /////
{0x03, 0x21}, //page 21

//Indoor Weight
{0x20, 0x00},//11},
{0x21, 0x00},//11},
{0x22, 0x00},//11},
{0x23, 0x00},//11},
{0x24, 0x00},//14},
{0x25, 0x01},//44},
{0x26, 0x10},//44},
{0x27, 0x00},//41},
{0x28, 0x00},//14},
{0x29, 0x12},//44},
{0x2a, 0x21},//44},
{0x2b, 0x00},//41},
{0x2c, 0x01},//14},
{0x2d, 0x27},//47},
{0x2e, 0x72},//74},
{0x2f, 0x10},//41},
{0x30, 0x01},//14},
{0x31, 0x27},//47},
{0x32, 0x72},//74},
{0x33, 0x10},//41},
{0x34, 0x00},//14},
{0x35, 0x12},//44},
{0x36, 0x21},//44},
{0x37, 0x00},//41},
{0x38, 0x00},//14},
{0x39, 0x01},//44},
{0x3a, 0x10},//44},
{0x3b, 0x00},//41},
{0x3c, 0x00},//11},
{0x3d, 0x00},//11},
{0x3e, 0x00},//11},
{0x3f, 0x00},//11},

//Outdoor Weight
{0x40, 0x00},//11},
{0x41, 0x00},//11},
{0x42, 0x00},//11},
{0x43, 0x00},//11},
{0x44, 0x00},//13},
{0x45, 0x01},//33},
{0x46, 0x10},//33},
{0x47, 0x00},//31},
{0x48, 0x00},//13},
{0x49, 0x12},//44},
{0x4a, 0x21},//44},
{0x4b, 0x00},//31},
{0x4c, 0x01},//14},
{0x4d, 0x57},//47},
{0x4e, 0x75},//74},
{0x4f, 0x10},//41},
{0x50, 0x01},//14},
{0x51, 0x57},//47},
{0x52, 0x75},//74},
{0x53, 0x10},//41},
{0x54, 0x00},//14},
{0x55, 0x12},//57},
{0x56, 0x21},//75},
{0x57, 0x00},//41},
{0x58, 0x00},//24},
{0x59, 0x01},//56},
{0x5a, 0x10},//65},
{0x5b, 0x00},//42},
{0x5c, 0x00},//23},
{0x5d, 0x00},//34},
{0x5e, 0x00},//43},
{0x5f, 0x00},//32},


///// PAGE 22 START /////
{0x03, 0x22}, //page 22
{0x10, 0xfd},
{0x11, 0x2e},
{0x19, 0x02},
{0x20, 0x30}, //For AWB Speed
{0x21, 0x80},
{0x22, 0x00},
{0x23, 0x00},
{0x24, 0x01},
{0x25, 0x4f}, //2013-09-13 AWB Hunting

{0x30, 0x80},
{0x31, 0x80},
{0x38, 0x11},
{0x39, 0x34},
{0x40, 0xe4}, //Stb Yth
{0x41, 0x33}, //Stb cdiff
{0x42, 0x22}, //Stb csum
{0x43, 0xf3}, //Unstb Yth
{0x44, 0x55}, //Unstb cdiff
{0x45, 0x33}, //Unstb csum
{0x46, 0x00},
{0x47, 0x09}, //2013-09-13 AWB Hunting
{0x48, 0x00}, //2013-09-13 AWB Hunting
{0x49, 0x0a},

{0x60, 0x04}, //awb_x_start full mode
{0x61, 0xc4}, //awb_x_stop full mode
{0x62, 0x04}, //awb_y_start full mode
{0x63, 0x92}, //awb_y_stop full mode
{0x66, 0x04}, //awb_x_start pxl windowing
{0x67, 0xc4}, //awb_x_stop pxl windowing
{0x68, 0x04}, //awb_y_start pxl windowing
{0x69, 0x92}, //awb_y_stop pxl windowing

{0x80, 0x36}, //r_gain
{0x81, 0x20}, //g_gain
{0x82, 0x2a}, //b_gain

{0x83, 0x56},//58}, //awb_r_gain_max normal
{0x84, 0x21},//25},//22},//16}, //awb_r_gain_min normal
{0x85, 0x3a},//3c},//42},//4f}, //awb_b_gain_max normal
{0x86, 0x15},//15}, //awb_b_gain_min normal

{0x87, 0x46}, //3b->46 awb_r_gain_max middle
{0x88, 0x3b}, //30->3b awb_r_gain_min middle
{0x89, 0x2e}, //29->2c awb_b_gain_max middle
{0x8a, 0x1c}, //18->1b awb_b_gain_min middle

{0x8b, 0x44}, //45}, //3c->45 awb_r_gain_max outdoor
{0x8c, 0x3b}, //32->3b awb_r_gain_min outdoor
{0x8d, 0x2e}, //2a->2c awb_b_gain_max outdoor
{0x8e, 0x22}, //1c}, //1b->1b awb_b_gain_min outdoor

{0x8f, 0x50},//50},//4f}, // 56},// 4d}, //4e awb_slope_th0
{0x90, 0x4a},//4b},//48}, // 4f},// 46}, //4d awb_slope_th1
{0x91, 0x42},//40},//42}, // 49},// 40}, //4c awb_slope_th2
{0x92, 0x3a},//30},//3c}, // 43},// 3a}, //4a awb_slope_th3
{0x93, 0x31},//2a},//31}, // 38},// 2f}, //46 awb_slope_th4
{0x94, 0x28},//26},//23}, // 2a},// 21}, // awb_slope_th5
{0x95, 0x21},//22},//1b}, // 22},// 19}, // awb_slope_th6
{0x96, 0x1c},//1e},//18}, // 1f},// 16}, // awb_slope_th7
{0x97, 0x18},//1b},//15}, // 1c},// 13}, // awb_slope_th8
{0x98, 0x15},//17},//14}, // 1b},// 12}, // awb_slope_th9
{0x99, 0x13},//14},//13}, // 1a},// 11}, // awb_slope_th10
{0x9a, 0x11},//11},//12}, // 19},// 10}, // awb_slope_th11

{0x9b, 0x88},//88}, //awb_slope_delta1
{0x9c, 0x88},//77}, //awb_slope_delta2
{0x9d, 0x48}, //rgain_ofs1
{0x9e, 0x38}, //rgain_ofs2
{0x9f, 0x30}, //rgain_ofs3

{0xa0, 0x70},
{0xa1, 0x54},
{0xa2, 0x6f},
{0xa3, 0xff},

{0xa4, 0x14}, //1536fps
{0xa5, 0x2c}, //698fps
{0xa6, 0xcf}, //148fps

{0xad, 0x2e},
{0xae, 0x2a},

{0xaf, 0x28}, //Low temp Rgain
{0xb0, 0x26}, //Low temp Rgain

{0xb1, 0x08},
{0xb4, 0xbf}, //For Tracking AWB Weight
{0xb8, 0x91}, //(0+,1-)High Cb , (0+,1-)Low Cr
{0xb9, 0xb0},
/////// PAGE 22 END ///////

//// MIPI Setting /////
{0x03, 0x48},
{0x39, 0x4f}, //lvds_bias_ctl    [2:0]mipi_tx_bias   [4:3]mipi_vlp_sel   [6:5]mipi_vcm_sel
{0x10, 0x1c}, //lvds_ctl_1       [5]mipi_pad_disable [4]lvds_en [0]serial_data_len
{0x11, 0x00}, //lvds_ctl_2       [4]mipi continous mode setting
//{0x14, 0x00} //ser_out_ctl_1  [2:0]serial_sout_a_phase   [6:4]serial_cout_a_phase

{0x16, 0x00}, //lvds_inout_ctl1  [0]vs_packet_pos_sel [1]data_neg_sel [4]first_vsync_end_opt
{0x18, 0x80}, //lvds_inout_ctl3
{0x19, 0x00}, //lvds_inout_ctl4
{0x1a, 0xf0}, //lvds_time_ctl
{0x24, 0x1e}, //long_packet_id

//====== MIPI Timing Setting =========
{0x36, 0x01}, //clk_tlpx_time_dp
{0x37, 0x03}, //clk_tlpx_time_dn
{0x34, 0x01}, //clk_prepare_time
{0x32, 0x10}, //clk_zero_time
{0x35, 0x01}, //clk_trail_time
{0x33, 0x0d}, //clk_post_time

{0x1c, 0x0b}, //tlps_time_l_dp
{0x1d, 0x0d}, //tlps_time_l_dn
{0x1e, 0x06}, //hs_zero_time
{0x1f, 0x07}, //hs_trail_time

//long_packet word count
{0x30, 0x06},
{0x31, 0x40}, //long_packet word count

/////// PAGE 20 ///////
{0x03, 0x20},
{0x10, 0x8c}, //9c}, //AE On 50hz

/////// PAGE 22 ///////
{0x03, 0x22},
{0x10, 0xe9}, //AWB On

{0x03, 0x00},
{0x01, 0x00}, //Sleep Off
};

static struct msm_camera_i2c_reg_conf hi258_preview_settings[] = {
	{0x03, 0x00},
	{0x01, 0x09}, //Sleep On

	{0x03, 0x20},
	{0x10, 0x0c},

	{0x03, 0x22},
	{0x10, 0x69},

	{0x03, 0x00},
	{0x10, 0x91}, //Sub1/2+HB
	{0x11, 0x90}, //Fixed off
	{0xd2, 0x05}, //Full&Pre2 0x01, Sub&Pre1 0x05

	{0x20, 0x00},
	{0x21, 0x02},
	{0x22, 0x00},
	{0x23, 0x04},

	{0x03, 0x12},
	{0x22, 0xe6}, //YC2D_CrCbY_Dy

	{0x03, 0x18}, //page 18
	{0x10, 0x00},
	{0x11, 0x00},
	{0x12, 0x58},
	{0x13, 0x01},
	{0x14, 0x0b}, //Cubic
	{0x20, 0x05},
	{0x21, 0x00},
	{0x22, 0x01},
	{0x23, 0xe0},
	{0x24, 0x00},
	{0x25, 0x00},
	{0x26, 0x00},
	{0x27, 0x00},
	{0x28, 0x05},
	{0x29, 0x00},
	{0x2a, 0x01},
	{0x2b, 0xe0},
	{0x2c, 0x0a},
	{0x2d, 0x00},
	{0x2e, 0x0a},
	{0x2f, 0x00},
	{0x30, 0x44},

	{0x03, 0x00}, //Page 0
	{0x40, 0x01}, //Hblank 296
	{0x41, 0x28},
	{0x42, 0x00}, //Vblank 4
	{0x43, 0x04},

	{0x03, 0x20},
	{0x2a, 0xff}, //ae_fine_ctl3
	{0x2b, 0x34}, //ae_fine_ctl4
	{0x88, 0x0c}, //EXP Max 60hz 7.06 fps 
	{0x89, 0xf3}, 
	{0x8a, 0x00},
	{0xa5, 0x0c}, //EXP Max 50hz 7.14 fps 
	{0xa6, 0xd1}, 
	{0xa7, 0x40}, 
	{0x8B, 0xea}, //EXP100
	{0x8C, 0x60},
	{0x8D, 0xc3}, //EXP120
	{0x8E, 0x00},
	{0x9c, 0x18}, //EXP Limit 961.54 fps
	{0x9d, 0x60},
	{0x9e, 0x01}, //EXP Unit
	{0x9f, 0xe0},
	{0xa3, 0x00}, //Outdoor Int
	{0xa4, 0xc3},
	// 192Mbps
	{0x03, 0x48},
	{0x36, 0x01}, //clk_tlpx_time_dp
	{0x37, 0x03}, //clk_tlpx_time_dn
	{0x34, 0x01}, //141121_SCH //02}, //clk_prepare_time
	{0x32, 0x10}, //clk_zero_time
	{0x35, 0x01}, //141121_SCH //02}, //clk_trail_time
	{0x33, 0x0d}, //clk_post_time
	{0x1c, 0x0b}, //141121_SCH //01}, //tlps_time_l_dp
	{0x1d, 0x0d}, //141121_SCH //0d}, //tlps_time_l_dn
	{0x1e, 0x06}, //hs_zero_time
	{0x1f, 0x07}, //141121_SCH //08}, //hs_trail_time //Demo RX timing margin 0x07 -> 0x08
	{0x30, 0x06},
	{0x31, 0x40}, //long_packet word count

	{0x03, 0x20},
	{0x10, 0x8c}, //AE On 60hz

	{0x03, 0x22},
	{0x10, 0xe9}, //AWB On

	{0x03, 0x00},
	{0x01, 0x00}, //Sleep Off
};

static struct msm_camera_i2c_reg_conf hi258_capture_settings[] = {
	{0x03, 0x00},
	{0x01, 0x09}, //Sleep On

	{0x03, 0x20},
	{0x10, 0x0c},

	{0x03, 0x22},
	{0x10, 0x69},

	{0x03, 0x00},
	{0x10, 0x00},//Full
	{0x11, 0x90}, //Fixed off
	{0xd2, 0x01}, //isp_div[1:0] mipi_4x_div[3:2]

	{0x20, 0x00},
	{0x21, 0x06},
	{0x22, 0x00},
	{0x23, 0x04},

	{0x03, 0x12},
	{0x22, 0x00}, //YC2D_CrCbY_Dy

	{0x03, 0x18}, //page 18
	{0x10, 0x00},
	{0x11, 0x00},
	{0x12, 0x58},
	{0x13, 0x01},
	{0x14, 0x00}, //Cubic Off

	{0x03, 0x20},
	{0x2a, 0xff}, //ae_fine_ctl3
	{0x2b, 0x34}, //ae_fine_ctl4
	// 384Mbps
	{0x03, 0x48},
	{0x36, 0x01}, //clk_tlpx_time_dp
	{0x37, 0x05}, //clk_tlpx_time_dn
	{0x34, 0x03}, //clk_prepare_time
	{0x32, 0x15}, //clk_zero_time
	{0x35, 0x03}, //clk_trail_time
	{0x33, 0x0d}, //clk_post_time
	{0x1c, 0x08}, //tlps_time_l_dp
	{0x1d, 0x0c}, //tlps_time_l_dn
	{0x1e, 0x06}, //hs_zero_time
	{0x1f, 0x0a}, //hs_trail_time
	{0x30, 0x0c},
	{0x31, 0x80}, //long_packet word count

	{0x03, 0x00},
	{0x01, 0x00}, //Sleep Off
};

static struct msm_camera_i2c_reg_conf hi258_HDvideo_settings[] = {
	{0x03, 0x00},
	{0x01, 0x09}, //sleep on
	{0x01, 0x03}, //sleep off
	{0x01, 0x09}, //sleep on
	// PAGE 20
	{0x03, 0x20}, // page 20
	{0x10, 0x0c}, // AE off 60hz

	// PAGE 22
	{0x03, 0x22}, // page 22
	{0x10, 0x69}, // AWB off

	{0x03, 0x00}, //Dummy 750us
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},

	{0x08, 0x0f}, //131002
	{0x09, 0x07}, //131002 pad strength 77->07
	{0x0a, 0x00}, //131002 pad strength 07->00

	//PLL Setting
	{0x03, 0x00},
	{0xd0, 0x05}, //PLL pre_div B[3:0] 24/(5+1) = 4 Mhz
	{0xd1, 0x30}, //PLL maim_div B[6:2] 4 * 12 = 48 Mhz
	{0xd2, 0x01}, //isp_div[1:0] mipi_4x_div[3:2]  mipi_1x_div[4] pll_bias_opt[7:5]
	{0xd3, 0x20}, //isp_clk_inv[0]	mipi_4x_inv[1]	mipi_1x_inv[2]
	{0xd0, 0x85},
	{0xd0, 0x85},
	{0xd0, 0x85},
	{0xd0, 0x95},

	{0x03, 0x00}, //Dummy 750us
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},


	///// PAGE 20 /////
	{0x03, 0x20}, //page 20
	{0x10, 0x0c}, //AE off 60hz

	///// PAGE 22 /////
	{0x03, 0x22}, //page 22
	{0x10, 0x69}, //AWB off

	///// Initial Start /////
	///// PAGE 0 Start /////
	{0x03, 0x00}, //page 0
	{0x10, 0x40}, //en_pxl_windowing
	{0x11, 0x94}, //Windowing On + 1Frame Skip + Fixed frame rate
	{0xd2, 0x01}, //Full&Pre2 0x01, Sub&Pre1 0x05
	{0x12, 0x04}, //Rinsing edge 0x04 // Falling edge 0x00
	{0x14, 0x05},

	{0x20, 0x00}, //Row H
	{0x21, 0x80}, //Row L
	{0x22, 0x00}, //Col H
	{0x23, 0x30}, //Col L

	{0x24, 0x02}, //Window height_H //= 720
	{0x25, 0xd0}, //Window height_L //
	{0x26, 0x05}, //Window width_H	//= 1280
	{0x27, 0x00}, //Window wight_L

	{0x28, 0x04}, //Full row start y-flip
	{0x29, 0x01}, //Pre1 row start no-flip
	{0x2a, 0x02}, //Pre1 row start y-flip

	{0x2b, 0x04}, //Full wid start x-flip
	{0x2c, 0x04}, //Pre2 wid start no-flip
	{0x2d, 0x02}, //Pre2 wid start x-flip

	{0x30, 0x00}, //pxl_row_start_h (1216-976)/2 = 120
	{0x31, 0x78}, //pxl_row_start_l
	{0x32, 0x04}, //pxl_row_stop_h // 1096
	{0x33, 0x48}, //pxl_row_stop_l
	{0x34, 0x03}, //pxl_row_height_h // height 976
	{0x35, 0xd0}, //pxl_row_height_l

	{0x36, 0x00},
	{0x37, 0x78},//120
	{0x38, 0x05},
	{0x39, 0xd8}, //1496
	{0x3a, 0x05},
	{0x3b, 0x60},// width = 1376

	{0x40, 0x01}, //Hblank 296 (oneline 1680)
	{0x41, 0x28},
	{0x42, 0x00}, //Vblank 4
	{0x43, 0x04},

	///// BLC /////
	{0x80, 0x2e},
	{0x81, 0x7e},
	{0x82, 0x90},
	{0x83, 0x00},
	{0x84, 0xcc}, //20130604 0x0c->0xcc
	{0x85, 0x00},
	{0x86, 0x00},
	{0x87, 0x0f},
	{0x88, 0x34},
	{0x8a, 0x0b},
	{0x8e, 0x80}, //Pga Blc Hold

	{0x90, 0x0c}, //BLC_TIME_TH_ON
	{0x91, 0x0c}, //BLC_TIME_TH_OFF
	{0x92, 0xb8}, //BLC_AG_TH_ON
	{0x93, 0xb0}, //BLC_AG_TH_OFF
	{0x96, 0xdc}, //BLC Outdoor Th On
	{0x97, 0xfe}, //BLC Outdoor Th Off
	{0x98, 0x38},

	//OutDoor  BLC
	{0x99, 0x43}, //R,Gr,B,Gb Offset

	//Dark BLC
	{0xa0, 0x01}, //R,Gr,B,Gb Offset

	//Normal BLC
	{0xa8, 0x43}, //R,Gr,B,Gb Offset
	///// PAGE 0 END /////

	///// PAGE 2 START /////
	{0x03, 0x02},
	{0x10, 0x00},
	{0x13, 0x00},
	{0x14, 0x00},
	{0x18, 0xcc},
	{0x19, 0x01}, // pmos switch on (for cfpn)
	{0x1A, 0x39}, //20130604 0x09->0xcc
	{0x1B, 0x00},
	{0x1C, 0x1a}, // for ncp
	{0x1D, 0x14}, // for ncp
	{0x1E, 0x30}, // for ncp
	{0x1F, 0x10},

	{0x20, 0x77},
	{0x21, 0xde},
	{0x22, 0xa7},
	{0x23, 0x30},
	{0x24, 0x77},
	{0x25, 0x10},
	{0x26, 0x10},
	{0x27, 0x3c},
	{0x2b, 0x80},
	{0x2c, 0x02},
	{0x2d, 0x58},
	{0x2e, 0x11},//20130604 0xde->0x11
	{0x2f, 0x11},//20130604 0xa7->0x11

	{0x30, 0x00},
	{0x31, 0x99},
	{0x32, 0x00},
	{0x33, 0x00},
	{0x34, 0x22},
	{0x36, 0x75},
	{0x38, 0x88},
	{0x39, 0x88},
	{0x3d, 0x03},
	{0x3f, 0x02},

	{0x49, 0xc1},//20130604 0x87->0xd1 --> mode Change Issue modify -> 0xc1
	{0x4a, 0x10},

	{0x50, 0x21},
	{0x53, 0xb1},
	{0x54, 0x10},
	{0x55, 0x1c}, // for ncp
	{0x56, 0x11},
	{0x58, 0x3a},//20130604 add
	{0x59, 0x38},//20130604 add
	{0x5d, 0xa2},
	{0x5e, 0x5a},

	{0x60, 0x87},
	{0x61, 0x98},
	{0x62, 0x88},
	{0x63, 0x96},
	{0x64, 0x88},
	{0x65, 0x96},
	{0x67, 0x3f},
	{0x68, 0x3f},
	{0x69, 0x3f},

	{0x72, 0x89},
	{0x73, 0x95},
	{0x74, 0x89},
	{0x75, 0x95},
	{0x7C, 0x84},
	{0x7D, 0xaf},

	{0x80, 0x01},
	{0x81, 0x7a},
	{0x82, 0x13},
	{0x83, 0x24},
	{0x84, 0x78},
	{0x85, 0x7c},

	{0x92, 0x44},
	{0x93, 0x59},
	{0x94, 0x78},
	{0x95, 0x7c},

	{0xA0, 0x02},
	{0xA1, 0x74},
	{0xA4, 0x74},
	{0xA5, 0x02},
	{0xA8, 0x85},
	{0xA9, 0x8c},
	{0xAC, 0x10},
	{0xAD, 0x16},

	{0xB0, 0x99},
	{0xB1, 0xa3},
	{0xB4, 0x9b},
	{0xB5, 0xa2},
	{0xB8, 0x9b},
	{0xB9, 0x9f},
	{0xBC, 0x9b},
	{0xBD, 0x9f},

	{0xc4, 0x29},
	{0xc5, 0x40},
	{0xc6, 0x5c},
	{0xc7, 0x72},
	{0xc8, 0x2a},
	{0xc9, 0x3f},
	{0xcc, 0x5d},
	{0xcd, 0x71},

	{0xd0, 0x10},
	{0xd1, 0x14},
	{0xd2, 0x20},
	{0xd3, 0x00},
	{0xd4, 0x0c}, //DCDC_TIME_TH_ON
	{0xd5, 0x0c}, //DCDC_TIME_TH_OFF
	{0xd6, 0xb8}, //DCDC_AG_TH_ON
	{0xd7, 0xb0}, //DCDC_AG_TH_OFF
	{0xdc, 0x00},
	{0xdd, 0xa3},
	{0xde, 0x00},
	{0xdf, 0x84},

	{0xe0, 0xa4},
	{0xe1, 0xa4},
	{0xe2, 0xa4},
	{0xe3, 0xa4},
	{0xe4, 0xa4},
	{0xe5, 0x01},
	{0xe8, 0x00},
	{0xe9, 0x00},
	{0xea, 0x77},

	{0xF0, 0x00},
	{0xF1, 0x00},
	{0xF2, 0x00},

	///// PAGE 2 END /////


	///// PAGE 10 START /////
	{0x03, 0x10}, //page 10
	{0x10, 0x03}, //S2D enable _ YUYV Order 
	{0x11, 0x03},
	{0x12, 0x30},
	{0x13, 0x03},

	{0x20, 0x00},
	{0x21, 0x40},
	{0x22, 0x0f},
	{0x24, 0x20},
	{0x25, 0x10},
	{0x26, 0x01},
	{0x27, 0x02},
	{0x28, 0x11},

	{0x40, 0x00},
	{0x41, 0x00}, //D-YOffset Th
	{0x42, 0x00}, //Cb Offset
	{0x43, 0x00}, //Cr Offset
	{0x44, 0x80},
	{0x45, 0x80},
	{0x46, 0xf0},
	{0x48, 0x80},
	{0x4a, 0x80},

	{0x50, 0xa0}, //D-YOffset AG

	{0x60, 0x4b},//20150119_SCH //4f},
	{0x61, 0x90},//84},//88}, //9a}, //Sat B STEVE
	{0x62, 0xb0},//86},//88}, //96}, //Sat R STEVE
	{0x63, 0x80}, //Auto-De Color

	{0x66, 0x42},
	{0x67, 0x22},

	{0x6a, 0x77}, //White Protection Offset Dark/Indoor
	{0x72, 0x72}, //20150115_SCH //84},
	{0x74, 0x07}, //White Protection Offset Outdoor
	{0x75, 0x60}, //Sat over th
	{0x76, 0x01}, // 0x05}, //	STEVE White Protection Enable
	{0x78, 0xff}, //Sat over ratio
	///// PAGE 10 END /////

	///// PAGE 11 START /////
	{0x03, 0x11}, //page 11

	//LPF Auto Control
	{0x20, 0x00},
	{0x21, 0x00},
	{0x26, 0x6a}, //pga_dark1_min (on)
	{0x27, 0x68}, //pga_dark1_max (off)
	{0x28, 0x0f},
	{0x29, 0x10},
	{0x2b, 0x30},
	{0x2c, 0x32},

	//GBGR
	{0x70, 0x2b},
	{0x74, 0x30},
	{0x75, 0x18},
	{0x76, 0x30},
	{0x77, 0xff},
	{0x78, 0xa0},
	{0x79, 0xff}, //Dark GbGr Th
	{0x7a, 0x30},
	{0x7b, 0x20},
	{0x7c, 0xf4}, //Dark Dy Th B[7:4]
	{0x7d, 0x02},
	{0x7e, 0xb0},
	{0x7f, 0x10},
	///// PAGE 11 END /////

	///// PAGE 12 START /////
	{0x03, 0x12}, //page 12

	//YC2D
	{0x10, 0x03}, //Y DPC Enable
	{0x11, 0x08}, //
	{0x12, 0x10}, //0x30 -> 0x10
	{0x20, 0x53}, //Y_lpf_enable
	{0x21, 0x03}, //C_lpf_enable_on
	{0x22, 0xe6}, //YC2D_CrCbY_Dy

	{0x23, 0x14}, //Outdoor Dy Th
	{0x24, 0x30},//20}, //Indoor Dy Th // For reso Limit 0x20
	{0x25, 0x60},//30}, //Dark Dy Th

	//Outdoor LPF Flat
	{0x30, 0xff}, //Y Hi Th
	{0x31, 0x00}, //Y Lo Th
	{0x32, 0xf0}, //Std Hi Th //Reso Improve Th Low //50
	{0x33, 0x00}, //Std Lo Th
	{0x34, 0x00}, //Median ratio

	//Indoor LPF Flat
	{0x35, 0xff}, //Y Hi Th
	{0x36, 0x00}, //Y Lo Th
	{0x37, 0xff}, //Std Hi Th //Reso Improve Th Low //50
	{0x38, 0x00}, //Std Lo Th
	{0x39, 0x00}, //Median ratio

	//Dark LPF Flat
	{0x3a, 0xff}, //Y Hi Th
	{0x3b, 0x00}, //Y Lo Th
	{0x3c, 0x93}, //Std Hi Th //Reso Improve Th Low //50
	{0x3d, 0x00}, //Std Lo Th
	{0x3e, 0x00}, //Median ratio

	//Outdoor Cindition
	{0x46, 0xa0}, //Out Lum Hi
	{0x47, 0x40}, //Out Lum Lo

	//Indoor Cindition
	{0x4c, 0xb0}, //Indoor Lum Hi
	{0x4d, 0x40}, //Indoor Lum Lo

	//Dark Cindition
	{0x52, 0xb0}, //Dark Lum Hi
	{0x53, 0x50}, //Dark Lum Lo

	//C-Filter
	{0x70, 0x10}, //Outdoor(2:1) AWM Th Horizontal
	{0x71, 0x0a}, //Outdoor(2:1) Diff Th Vertical
	{0x72, 0x20},//10}, //Indoor,Dark1 AWM Th Horizontal
	{0x73, 0x0a}, //Indoor,Dark1 Diff Th Vertical
	{0x74, 0x20},//18}, //Dark(2:3) AWM Th Horizontal
	{0x75, 0x0f}, //Dark(2:3) Diff Th Vertical

	//DPC
	{0x90, 0x3d}, //don't touch register_SCH //7d},
	{0x91, 0x34},
	{0x99, 0x14}, //don't touch register_SCH //28},
	{0x9c, 0x0a}, //20131107 Flat DPC value 0x14 -> 0x00 -> 0x0a
	{0x9d, 0x15},
	{0x9e, 0x28},
	{0x9f, 0x28},
	{0xb0, 0x0e}, //Zipper noise Detault change (0x75->0x0e)
	{0xb8, 0x44},
	{0xb9, 0x15},
	///// PAGE 12 END /////

	///// PAGE 13 START /////
	{0x03, 0x13}, //page 13

	{0x80, 0xfd}, //Sharp2D enable _ YUYV Order
	{0x81, 0x07}, //Sharp2D Clip/Limit
	{0x82, 0x73}, //Sharp2D Filter
	{0x83, 0x00}, //Sharp2D Low Clip
	{0x85, 0x00},

	{0x92, 0x33}, //Sharp2D Slop n/p
	{0x93, 0x30}, //Sharp2D LClip
	{0x94, 0x02}, //Sharp2D HiClip1 Th
	{0x95, 0xf0}, //Sharp2D HiClip2 Th
	{0x96, 0x1e}, //Sharp2D HiClip2 Resolution
	{0x97, 0x40},
	{0x98, 0x80},
	{0x99, 0x40},

	//Sharp Lclp
	{0xa2, 0x03}, //Outdoor Lclip_N
	{0xa3, 0x04}, //Outdoor Lclip_P
	{0xa4, 0x02}, //Indoor Lclip_N 0x03 For reso Limit 0x0e
	{0xa5, 0x03}, //Indoor Lclip_P 0x0f For reso Limit 0x0f
	{0xa6, 0x80}, //Dark Lclip_N
	{0xa7, 0x80}, //Dark Lclip_P

	//Outdoor Slope
	{0xb6, 0x28}, //Lum negative Hi
	{0xb7, 0x20}, //Lum negative middle
	{0xb8, 0x24}, //Lum negative Low
	{0xb9, 0x28}, //Lum postive Hi
	{0xba, 0x20}, //Lum postive middle
	{0xbb, 0x24}, //Lum postive Low

	//Indoor Slope
	{0xbc, 0x20}, //Lum negative Hi
	{0xbd, 0x20}, //Lum negative middle
	{0xbe, 0x20}, //Lum negative Low
	{0xbf, 0x20}, //Lum postive Hi
	{0xc0, 0x20}, //Lum postive middle
	{0xc1, 0x20}, //Lum postive Low

	//Dark Slope
	{0xc2, 0x14}, //Lum negative Hi
	{0xc3, 0x24}, //Lum negative middle
	{0xc4, 0x1d}, //Lum negative Low
	{0xc5, 0x14}, //Lum postive Hi
	{0xc6, 0x24}, //Lum postive middle
	{0xc7, 0x1d}, //Lum postive Low
	///// PAGE 13 END /////

	///// PAGE 14 START /////
	{0x03, 0x14}, //page 14
	{0x10, 0x09},

	{0x20, 0x60},//80}, // //X-Center
	{0x21, 0x80},//80}, //Y-Center

	//{0x22, 0x78}, //LSC R 1b->15 20130125
	//{0x23, 0x68}, //LSC G
	//{0x24, 0x68}, //LSC B

	//CW//
	{0x22, 0x70},//75},///6d},//6c},//6a},//38}, //LSC R 1b->15 20130125
	{0x23, 0x4d},//4a},///49},//50},//50},//29}, //LSC G
	{0x24, 0x50},//4e},///4e},//4e},//4a},//28}, //LSC B
	//{0x22, 0x60},//56}, //LSC R 1b->15 20130125
	//{0x23, 0x45},//39}, //LSC G
	//{0x24, 0x49},//3f}, //LSC B
	//SKh//
	//{0x22, 0x5c}, //LSC R 1b->15 20130125
	//{0x23, 0x3f}, //LSC G
	//{0x24, 0x3b}, //LSC B

	{0x25, 0xf0}, //LSC Off
	{0x26, 0xf0}, //LSC On
	///// PAGE 14 END /////

	/////// PAGE 15 START ///////
	{0x03, 0x15}, //page 15
	{0x10, 0x21},
	{0x14, 0x46},
	{0x15, 0x36},
	{0x16, 0x26},
	{0x17, 0x3f},	//CMC SIGN
	//CMC
	{0x30, 0xcb},
	{0x31, 0x40},
	{0x32, 0x0b},
	{0x33, 0x22},
	{0x34, 0xdb},
	{0x35, 0x39},
	{0x36, 0x0b},
	{0x37, 0x5c},
	{0x38, 0xe7},
	//CMC OFS
	{0x40, 0x00},//90},
	{0x41, 0x00},//10},
	{0x42, 0x00},//00},
	{0x43, 0x00},//08},
	{0x44, 0x00},//12},
	{0x45, 0x00},//9a},
	{0x46, 0x00},//9a},
	{0x47, 0x00},//04},
	{0x48, 0x00},//16},
	//CMC POFS
	{0x50, 0x00},//04},//00},
	{0x51, 0x00},//08},
	{0x52, 0x00},//04},//18},
	{0x53, 0x00},//04},
	{0x54, 0x00},//00},
	{0x55, 0x00},//04},
	{0x56, 0x00},//02},
	{0x57, 0x00},//00},
	{0x58, 0x00},//02},

	///// PAGE 15 END /////

	///// PAGE 16 START /////
	{0x03, 0x16}, //page 16 Gamma
	{0x10, 0x21}, //31},
	{0x18, 0x5a}, //Double_AG 5e->37
	{0x19, 0x58}, //Double_AG 5e->36
	{0x1a, 0x0e},
	{0x1b, 0x01},
	{0x1c, 0xdc},
	{0x1d, 0xfe},

	//Indoor
	{0x30, 0x00},
	{0x31, 0x08},
	{0x32, 0x19},
	{0x33, 0x34},
	{0x34, 0x64},
	{0x35, 0x80},
	{0x36, 0x96},
	{0x37, 0xa7},
	{0x38, 0xb5},
	{0x39, 0xc1},
	{0x3a, 0xcc},
	{0x3b, 0xd5},
	{0x3c, 0xde},
	{0x3d, 0xe5},
	{0x3e, 0xeb},
	{0x3f, 0xf0},
	{0x40, 0xf6},
	{0x41, 0xfa},
	{0x42, 0xff},

	//Outdoor
	{0x50, 0x00},//0x00},
	{0x51, 0x08},//0x03},
	{0x52, 0x19},//0x10},
	{0x53, 0x34},//0x26},
	{0x54, 0x64},//0x43},
	{0x55, 0x80},//0x5d},
	{0x56, 0x96},//0x79},
	{0x57, 0xa7},//0x8c},
	{0x58, 0xb5},//0x9f},
	{0x59, 0xc1},//0xaa},
	{0x5a, 0xcc},//0xb6},
	{0x5b, 0xd5},//0xc3},
	{0x5c, 0xde},//0xce},
	{0x5d, 0xe5},//0xd9},
	{0x5e, 0xeb},//0xe1},
	{0x5f, 0xf0},//0xe9},
	{0x60, 0xf6},//0xf0},
	{0x61, 0xfa},//0xf4},
	{0x62, 0xff},//0xf5},

	//Dark
	{0x70, 0x00},//0x00},
	{0x71, 0x0b},//0x10},
	{0x72, 0x1c},//0x1c},
	{0x73, 0x3b},//0x2e},
	{0x74, 0x6b},//0x4e},
	{0x75, 0x88},//0x6c},
	{0x76, 0x9e},//0x82},
	{0x77, 0xae},//0x96},
	{0x78, 0xbc},//0xa7},
	{0x79, 0xc7},//0xb6},
	{0x7a, 0xd0},//0xc4},
	{0x7b, 0xd9},//0xd0},
	{0x7c, 0xe1},//0xda},
	{0x7d, 0xe7},//0xe2},
	{0x7e, 0xec},//0xea},
	{0x7f, 0xf1},//0xf0},
	{0x80, 0xf6},//0xf6},
	{0x81, 0xfa},//0xfa},
	{0x82, 0xff},//0xFF},
	///// PAGE 16 END /////

	///// PAGE 17 START /////
	{0x03, 0x17}, //page 17
	{0xc1, 0x00},
	{0xC4, 0x47},
	{0xC5, 0x3b},
	{0xc6, 0x02},
	{0xc7, 0x20},
	///// PAGE 17 END /////

	///// PAGE 18 START /////
	{0x03, 0x18}, //page 18
	{0x10, 0x00},	//Scale Off
	{0x11, 0x00},
	{0x12, 0x58},
	{0x13, 0x01},
	{0x14, 0x00},
	{0x15, 0x00},
	{0x16, 0x00},
	{0x17, 0x00},
	{0x18, 0x00},
	{0x19, 0x00},
	{0x1a, 0x00},
	{0x1b, 0x00},
	{0x1c, 0x00},
	{0x1d, 0x00},
	{0x1e, 0x00},
	{0x1f, 0x00},
	{0x20, 0x05},	//zoom wid
	{0x21, 0x00},
	{0x22, 0x01},	//zoom hgt
	{0x23, 0xe0},
	{0x24, 0x00},	//zoom start x
	{0x25, 0x00},
	{0x26, 0x00},	//zoom start y
	{0x27, 0x00},
	{0x28, 0x05},	//zoom end x
	{0x29, 0x00},
	{0x2a, 0x01},	//zoom end y
	{0x2b, 0xe0},
	{0x2c, 0x0a},	//zoom step vert
	{0x2d, 0x00},
	{0x2e, 0x0a},	//zoom step horz
	{0x2f, 0x00},
	{0x30, 0x44},	//zoom fifo

	///// PAGE 18 END /////

	{0x03, 0x19}, //Page 0x19
	{0x10, 0x7e},//7f}, //mcmc_ctl1 MCMC Enable B:[0]
	{0x11, 0x7f}, //mcmc_ctl2
	{0x12, 0x1e}, //mcmc_delta1
	{0x13, 0x72}, //mcmc_center1
	{0x14, 0x1e}, //mcmc_delta2
	{0x15, 0xec}, //mcmc_center2
	{0x16, 0x9e}, //mcmc_delta3
	{0x17, 0x56}, //mcmc_center3
	{0x18, 0x9e}, //mcmc_delta4
	{0x19, 0x36}, //mcmc_center4
	{0x1a, 0x1e}, //mcmc_delta5
	{0x1b, 0x52}, //mcmc_center5
	{0x1c, 0x1e}, //mcmc_delta6
	{0x1d, 0xa4}, //mcmc_center6
	{0x1e, 0x40}, //mcmc_sat_gain1
	{0x1f, 0x58}, //mcmc_sat_gain2
	{0x20, 0x40}, //mcmc_sat_gain3
	{0x21, 0x40}, //mcmc_sat_gain4
	{0x22, 0x40}, //mcmc_sat_gain5
	{0x23, 0x50}, //mcmc_sat_gain6
	{0x24, 0x00}, //mcmc_hue_angle1
	{0x25, 0x00}, //mcmc_hue_angle2
	{0x26, 0x00}, //mcmc_hue_angle3
	{0x27, 0x00}, //mcmc_hue_angle4
	{0x28, 0x00}, //mcmc_hue_angle5
	{0x29, 0x00}, //mcmc_hue_angle6
	{0x53, 0x10}, //mcmc_ctl3
	{0x6c, 0xff}, //mcmc_lum_ctl1 sat hue offset
	{0x6d, 0x3f}, //mcmc_lum_ctl2 gain
	{0x6e, 0x00}, //mcmc_lum_ctl3 hue
	{0x6f, 0x00}, //mcmc_lum_ctl4 rgb offset
	{0x70, 0x00}, //mcmc_lum_ctl5 rgb scale
	{0x71, 0x3f}, //mcmc_lum_gain_wgt_th1 R1 magenta
	{0x72, 0x3f}, //mcmc_lum_gain_wgt_th2 R1
	{0x73, 0x3f}, //mcmc_lum_gain_wgt_th3 R1
	{0x74, 0x3f}, //mcmc_lum_gain_wgt_th4 R1
	{0x75, 0x30}, //mcmc_rg1_lum_sp1	  R1
	{0x76, 0x50}, //mcmc_rg1_lum_sp2	  R1
	{0x77, 0x80}, //mcmc_rg1_lum_sp3	  R1
	{0x78, 0xb0}, //mcmc_rg1_lum_sp4	  R1
	{0x79, 0x3f}, //mcmc_lum_gain_wgt_th1 R2 bright green
	{0x7a, 0x3f}, //mcmc_lum_gain_wgt_th2 R2
	{0x7b, 0x3f}, //mcmc_lum_gain_wgt_th3 R2
	{0x7c, 0x3f}, //mcmc_lum_gain_wgt_th4 R2
	{0x7d, 0x28}, //mcmc_rg2_lum_sp1	  R2
	{0x7e, 0x50}, //mcmc_rg2_lum_sp2	  R2
	{0x7f, 0x80}, //mcmc_rg2_lum_sp3	  R2
	{0x80, 0xb0}, //mcmc_rg2_lum_sp4	  R2
	{0x81, 0x28}, //mcmc_lum_gain_wgt_th1 R3 dark green
	{0x82, 0x3f}, //mcmc_lum_gain_wgt_th2 R3
	{0x83, 0x3f}, //mcmc_lum_gain_wgt_th3 R3
	{0x84, 0x3f}, //mcmc_lum_gain_wgt_th4 R3
	{0x85, 0x28}, //mcmc_rg3_lum_sp1	  R3
	{0x86, 0x50}, //mcmc_rg3_lum_sp2	  R3
	{0x87, 0x80}, //mcmc_rg3_lum_sp3	  R3
	{0x88, 0xb0}, //mcmc_rg3_lum_sp4	  R3
	{0x89, 0x1a}, //mcmc_lum_gain_wgt_th1 R4 skin
	{0x8a, 0x28}, //mcmc_lum_gain_wgt_th2 R4
	{0x8b, 0x3f}, //mcmc_lum_gain_wgt_th3 R4
	{0x8c, 0x3f}, //mcmc_lum_gain_wgt_th4 R4
	{0x8d, 0x10}, //mcmc_rg3_lum_sp1	  R4
	{0x8e, 0x30}, //mcmc_rg3_lum_sp2	  R4
	{0x8f, 0x60}, //mcmc_rg3_lum_sp3	  R4
	{0x90, 0x90}, //mcmc_rg3_lum_sp4	  R4
	{0x91, 0x1a}, //mcmc_rg5_gain_wgt_th1 R5 cyan
	{0x92, 0x28}, //mcmc_rg5_gain_wgt_th2 R5
	{0x93, 0x3f}, //mcmc_rg5_gain_wgt_th3 R5
	{0x94, 0x3f}, //mcmc_rg5_gain_wgt_th4 R5
	{0x95, 0x28}, //mcmc_rg5_lum_sp1	  R5
	{0x96, 0x50}, //mcmc_rg5_lum_sp2	  R5
	{0x97, 0x80}, //mcmc_rg5_lum_sp3	  R5
	{0x98, 0xb0}, //mcmc_rg5_lum_sp4	  R5
	{0x99, 0x1a}, //mcmc_rg6_gain_wgt_th1 R6 blue
	{0x9a, 0x28}, //mcmc_rg6_gain_wgt_th2 R6
	{0x9b, 0x3f}, //mcmc_rg6_gain_wgt_th3 R6
	{0x9c, 0x3f}, //mcmc_rg6_gain_wgt_th4 R6
	{0x9d, 0x28}, //mcmc_rg6_lum_sp1	  R6
	{0x9e, 0x50}, //mcmc_rg6_lum_sp2	  R6
	{0x9f, 0x80}, //mcmc_rg6_lum_sp3	  R6
	{0xa0, 0xb0}, //mcmc_rg6_lum_sp4	  R6

	{0xe5, 0x80}, //add 20120709 Bit[7] On MCMC --> YC2D_LPF

	/////// PAGE 20 START ///////
	{0x03, 0x20},
	{0x10, 0x0c},
	{0x11, 0x0c}, //131002 14 -> 0c
	{0x18, 0x30},
	{0x20, 0x25}, //8x8 Ae weight 0~7 Outdoor / Weight Outdoor On B[5]
	{0x21, 0x30},
	{0x22, 0x10},
	{0x23, 0x00},

	{0x28, 0xf7},
	{0x29, 0x0d},
	{0x2a, 0xff},
	{0x2b, 0x34},//04}, //Adaptive Off,1/100 Flicker

	{0x2c, 0x83}, //AE After CI
	{0x2d, 0xe3},
	{0x2e, 0x13},
	{0x2f, 0x0b},

	{0x30, 0x78},
	{0x31, 0xd7},
	{0x32, 0x10},
	{0x33, 0x2e},
	{0x34, 0x20},
	{0x35, 0xd4},
	{0x36, 0xfe},
	{0x37, 0x32},
	{0x38, 0x04},
	{0x39, 0x22},
	{0x3a, 0xde},
	{0x3b, 0x22},
	{0x3c, 0xde},
	{0x3d, 0xe1},

	{0x3e, 0xc9}, //Option of changing Exp max
	{0x41, 0x23}, //Option of changing Exp max

	{0x50, 0x45},
	{0x51, 0x88},

	{0x56, 0x1f}, // for tracking
	{0x57, 0xa6}, // for tracking
	{0x58, 0x1a}, // for tracking
	{0x59, 0x7a}, // for tracking

	{0x5a, 0x04},
	{0x5b, 0x04},

	{0x5e, 0xc7},
	{0x5f, 0x95},

	{0x62, 0x10},
	{0x63, 0xc0},
	{0x64, 0x10},
	{0x65, 0x8a},
	{0x66, 0x58},
	{0x67, 0x58},

	{0x70, 0x40},//3b}, //54->46
	{0x71, 0x80},//82}, //_140416 //89}, //81(+4),89(-4)

	{0x76, 0x32},
	{0x77, 0x81}, //141218 //a2}, //140416 //a1},
	{0x78, 0x32}, //141218 //22 //24
	{0x79, 0x26}, //141218 //27}, //30}, // Y Target 70 => 25, 72 => 26 //
	{0x7a, 0x23}, //23
	{0x7b, 0x22}, //22
	{0x7d, 0x23},

	{0x83, 0x03}, //EXP Normal 30.00 fps
	{0x84, 0x0c},
	{0x85, 0xf0},
	{0x86, 0x01}, //EXPMin 11428.57 fps
	{0x87, 0xA4},
	{0x88, 0x06}, //EXP Max 60hz 15.00 fps
	{0x89, 0x19},
	{0x8a, 0xe0},
	{0xa5, 0x05}, //EXP Max 50hz 16.67 fps
	{0xa6, 0x75},
	{0xa7, 0xd0},
	{0x8B, 0xe8}, //EXP100
	{0x8C, 0xf8},
	{0x8D, 0xc3}, //EXP120
	{0x8E, 0x3c},
	{0x91, 0x03}, //Fixed Time 14.5 fps
	{0x92, 0x28},
	{0x93, 0x02},
	{0x9c, 0x0b}, //EXP Limit 2940.00 fps
	{0x9d, 0x7c},
	{0x9e, 0x01}, //EXP Unit
	{0x9f, 0xA4},
	{0xa3, 0x00}, //Outdoor Int
	{0xa4, 0xc3},

	{0xb0, 0x15},
	{0xb1, 0x14},
	{0xb2, 0xc0},
	{0xb3, 0x15},
	{0xb4, 0x16},
	{0xb5, 0x3c},
	{0xb6, 0x29},
	{0xb7, 0x23},
	{0xb8, 0x54},
	{0xb9, 0x50},
	{0xba, 0x4d},
	{0xbb, 0x4b},
	{0xbc, 0x4a},
	{0xbd, 0x49},

	{0xc0, 0x10},
	{0xc1, 0x40},
	{0xc2, 0x40},
	{0xc3, 0x40},
	{0xc4, 0x04},

	{0xc6, 0x80}, //Exp max 1frame target AG

	{0xc8, 0x80},
	{0xc9, 0x80},
	///// PAGE 20 END /////

	///// PAGE 21 START /////
	{0x03, 0x21}, //page 21

	//Indoor Weight
	{0x20, 0x00},//11},
	{0x21, 0x00},//11},
	{0x22, 0x00},//11},
	{0x23, 0x00},//11},
	{0x24, 0x00},//14},
	{0x25, 0x01},//44},
	{0x26, 0x10},//44},
	{0x27, 0x00},//41},
	{0x28, 0x00},//14},
	{0x29, 0x12},//44},
	{0x2a, 0x21},//44},
	{0x2b, 0x00},//41},
	{0x2c, 0x01},//14},
	{0x2d, 0x27},//47},
	{0x2e, 0x72},//74},
	{0x2f, 0x10},//41},
	{0x30, 0x01},//14},
	{0x31, 0x27},//47},
	{0x32, 0x72},//74},
	{0x33, 0x10},//41},
	{0x34, 0x00},//14},
	{0x35, 0x12},//44},
	{0x36, 0x21},//44},
	{0x37, 0x00},//41},
	{0x38, 0x00},//14},
	{0x39, 0x01},//44},
	{0x3a, 0x10},//44},
	{0x3b, 0x00},//41},
	{0x3c, 0x00},//11},
	{0x3d, 0x00},//11},
	{0x3e, 0x00},//11},
	{0x3f, 0x00},//11},

	//Outdoor Weight
	{0x40, 0x00},//11},
	{0x41, 0x00},//11},
	{0x42, 0x00},//11},
	{0x43, 0x00},//11},
	{0x44, 0x00},//13},
	{0x45, 0x01},//33},
	{0x46, 0x10},//33},
	{0x47, 0x00},//31},
	{0x48, 0x00},//13},
	{0x49, 0x12},//44},
	{0x4a, 0x21},//44},
	{0x4b, 0x00},//31},
	{0x4c, 0x01},//14},
	{0x4d, 0x57},//47},
	{0x4e, 0x75},//74},
	{0x4f, 0x10},//41},
	{0x50, 0x01},//14},
	{0x51, 0x57},//47},
	{0x52, 0x75},//74},
	{0x53, 0x10},//41},
	{0x54, 0x00},//14},
	{0x55, 0x12},//57},
	{0x56, 0x21},//75},
	{0x57, 0x00},//41},
	{0x58, 0x00},//24},
	{0x59, 0x01},//56},
	{0x5a, 0x10},//65},
	{0x5b, 0x00},//42},
	{0x5c, 0x00},//23},
	{0x5d, 0x00},//34},
	{0x5e, 0x00},//43},
	{0x5f, 0x00},//32},


	///// PAGE 22 START /////
	{0x03, 0x22}, //page 22
	{0x10, 0xfd},
	{0x11, 0x2e},
	{0x19, 0x02},
	{0x20, 0x30}, //For AWB Speed
	{0x21, 0x80},
	{0x22, 0x00},
	{0x23, 0x00},
	{0x24, 0x01},
	{0x25, 0x4f}, //2013-09-13 AWB Hunting

	{0x30, 0x80},
	{0x31, 0x80},
	{0x38, 0x11},
	{0x39, 0x34},
	{0x40, 0xe4}, //Stb Yth
	{0x41, 0x33}, //Stb cdiff
	{0x42, 0x22}, //Stb csum
	{0x43, 0xf3}, //Unstb Yth
	{0x44, 0x55}, //Unstb cdiff
	{0x45, 0x33}, //Unstb csum
	{0x46, 0x00},
	{0x47, 0x09}, //2013-09-13 AWB Hunting
	{0x48, 0x00}, //2013-09-13 AWB Hunting
	{0x49, 0x0a},

	{0x60, 0x04}, //awb_x_start full mode
	{0x61, 0xc4}, //awb_x_stop full mode
	{0x62, 0x04}, //awb_y_start full mode
	{0x63, 0x92}, //awb_y_stop full mode
	{0x66, 0x04}, //awb_x_start pxl windowing
	{0x67, 0xc4}, //awb_x_stop pxl windowing
	{0x68, 0x04}, //awb_y_start pxl windowing
	{0x69, 0x92}, //awb_y_stop pxl windowing

	{0x80, 0x36}, //r_gain
	{0x81, 0x20}, //g_gain
	{0x82, 0x2a}, //b_gain

	{0x83, 0x56},//58}, //awb_r_gain_max normal
	{0x84, 0x21},//25},//22},//16}, //awb_r_gain_min normal
	{0x85, 0x3a},//3c},//42},//4f}, //awb_b_gain_max normal
	{0x86, 0x15},//15}, //awb_b_gain_min normal

	{0x87, 0x46}, //3b->46 awb_r_gain_max middle
	{0x88, 0x3b}, //30->3b awb_r_gain_min middle
	{0x89, 0x2e}, //29->2c awb_b_gain_max middle
	{0x8a, 0x1c}, //18->1b awb_b_gain_min middle

	{0x8b, 0x44}, //45}, //3c->45 awb_r_gain_max outdoor
	{0x8c, 0x3b}, //32->3b awb_r_gain_min outdoor
	{0x8d, 0x2e}, //2a->2c awb_b_gain_max outdoor
	{0x8e, 0x22}, //1c}, //1b->1b awb_b_gain_min outdoor

	{0x8f, 0x50},//50},//4f}, // 56},// 4d}, //4e awb_slope_th0
	{0x90, 0x4a},//4b},//48}, // 4f},// 46}, //4d awb_slope_th1
	{0x91, 0x42},//40},//42}, // 49},// 40}, //4c awb_slope_th2
	{0x92, 0x3a},//30},//3c}, // 43},// 3a}, //4a awb_slope_th3
	{0x93, 0x31},//2a},//31}, // 38},// 2f}, //46 awb_slope_th4
	{0x94, 0x28},//26},//23}, // 2a},// 21}, // awb_slope_th5
	{0x95, 0x21},//22},//1b}, // 22},// 19}, // awb_slope_th6
	{0x96, 0x1c},//1e},//18}, // 1f},// 16}, // awb_slope_th7
	{0x97, 0x18},//1b},//15}, // 1c},// 13}, // awb_slope_th8
	{0x98, 0x15},//17},//14}, // 1b},// 12}, // awb_slope_th9
	{0x99, 0x13},//14},//13}, // 1a},// 11}, // awb_slope_th10
	{0x9a, 0x11},//11},//12}, // 19},// 10}, // awb_slope_th11

	{0x9b, 0x88},//88}, //awb_slope_delta1
	{0x9c, 0x88},//77}, //awb_slope_delta2
	{0x9d, 0x48}, //rgain_ofs1
	{0x9e, 0x38}, //rgain_ofs2
	{0x9f, 0x30}, //rgain_ofs3

	{0xa0, 0x70},
	{0xa1, 0x54},
	{0xa2, 0x6f},
	{0xa3, 0xff},

	{0xa4, 0x14}, //1536fps
	{0xa5, 0x2c}, //698fps
	{0xa6, 0xcf}, //148fps

	{0xad, 0x2e},
	{0xae, 0x2a},

	{0xaf, 0x28}, //Low temp Rgain
	{0xb0, 0x26}, //Low temp Rgain

	{0xb1, 0x08},
	{0xb4, 0xbf}, //For Tracking AWB Weight
	{0xb8, 0x91}, //(0+,1-)High Cb , (0+,1-)Low Cr
	{0xb9, 0xb0},
	/////// PAGE 22 END ///////

	//// MIPI Setting /////
	{0x03, 0x48},
	{0x39, 0x4f}, //lvds_bias_ctl	 [2:0]mipi_tx_bias	 [4:3]mipi_vlp_sel	 [6:5]mipi_vcm_sel
	{0x10, 0x1c}, //lvds_ctl_1		 [5]mipi_pad_disable [4]lvds_en [0]serial_data_len
	{0x11, 0x00}, //lvds_ctl_2		 [4]mipi continous mode setting
	//{0x14, 0x00} //ser_out_ctl_1	[2:0]serial_sout_a_phase   [6:4]serial_cout_a_phase

	{0x16, 0x00}, //lvds_inout_ctl1  [0]vs_packet_pos_sel [1]data_neg_sel [4]first_vsync_end_opt
	{0x18, 0x80}, //lvds_inout_ctl3
	{0x19, 0x00}, //lvds_inout_ctl4
	{0x1a, 0xf0}, //lvds_time_ctl
	{0x24, 0x1e}, //long_packet_id

	//====== MIPI Timing Setting =========
	{0x36, 0x01}, //clk_tlpx_time_dp
	{0x37, 0x05}, //clk_tlpx_time_dn
	{0x34, 0x03}, //clk_prepare_time
	{0x32, 0x15}, //clk_zero_time
	{0x35, 0x03}, //clk_trail_time
	{0x33, 0x0d}, //clk_post_time

	{0x1c, 0x08}, //tlps_time_l_dp
	{0x1d, 0x0c}, //tlps_time_l_dn
	{0x1e, 0x06}, //hs_zero_time
	{0x1f, 0x0a}, //hs_trail_time

	//long_packet word count
	{0x30, 0x0a},
	{0x31, 0x00}, //long_packet word count

	/////// PAGE 20 ///////
	{0x03, 0x20},
	{0x10, 0x8c}, //9c}, //AE On 50hz

	/////// PAGE 22 ///////
	{0x03, 0x22},
	{0x10, 0xe9}, //AWB On

	{0x03, 0x00},
	{0x01, 0x00}, //Sleep Off
};

static struct msm_camera_i2c_reg_conf hi258_video_settings[] = {
	{0x03, 0x00},
	{0x01, 0x09}, //sleep on
	{0x01, 0x03}, //sleep off
	{0x01, 0x09}, //sleep on
	// PAGE 20
	{0x03, 0x20}, // page 20
	{0x10, 0x0c}, // AE off 60hz

	// PAGE 22
	{0x03, 0x22}, // page 22
	{0x10, 0x69}, // AWB off

	{0x03, 0x00}, //Dummy 750us
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},

	{0x08, 0x0f}, //131002
	{0x09, 0x07}, //131002 pad strength 77->07
	{0x0a, 0x00}, //131002 pad strength 07->00

	//PLL Setting
	{0x03, 0x00},
	{0xd0, 0x05}, //PLL pre_div 1/6 = 4 Mhz
	{0xd1, 0x30}, //PLL maim_div
	{0xd2, 0x05}, //isp_div[1:0] mipi_4x_div[3:2]  mipi_1x_div[4] pll_bias_opt[7:5] //Full&Pre2 0x01, Sub&Pre1 0x05
	{0xd3, 0x20}, //isp_clk_inv[0]	mipi_4x_inv[1]	mipi_1x_inv[2]
	{0xd0, 0x85},
	{0xd0, 0x85},
	{0xd0, 0x85},
	{0xd0, 0x95},

	{0x03, 0x00}, //Dummy 750us
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},


	///// PAGE 20 /////
	{0x03, 0x20}, //page 20
	{0x10, 0x0c}, //AE off 60hz

	///// PAGE 22 /////
	{0x03, 0x22}, //page 22
	{0x10, 0x69}, //AWB off

	///// Initial Start /////
	///// PAGE 0 Start /////
	{0x03, 0x00}, //page 0
	{0x10, 0x13}, //sub1+pre2
	{0x11, 0x94},
	{0xd2, 0x01}, //Full&Pre2 0x01, Sub&Pre1 0x05
	{0x12, 0x04}, //Rinsing edge 0x04 // Falling edge 0x00
	{0x14, 0x05},

	{0x20, 0x00}, //Row H
	{0x21, 0x02}, //Row L
	{0x22, 0x00}, //Col H
	{0x23, 0x04}, //Col L

	{0x24, 0x04}, //Window height_H //= 1200
	{0x25, 0xb0}, //Window height_L //
	{0x26, 0x06}, //Window width_H	//= 1600
	{0x27, 0x40}, //Window wight_L

	{0x28, 0x04}, //Full row start y-flip
	{0x29, 0x01}, //Pre1 row start no-flip
	{0x2a, 0x02}, //Pre1 row start y-flip

	{0x2b, 0x04}, //Full wid start x-flip
	{0x2c, 0x04}, //Pre2 wid start no-flip
	{0x2d, 0x02}, //Pre2 wid start x-flip

	{0x30, 0x00},
	{0x31, 0x00},
	{0x32, 0x04},
	{0x33, 0xc0},
	{0x34, 0x04},
	{0x35, 0xc0},

	{0x36, 0x00},
	{0x37, 0x00},
	{0x38, 0x06},
	{0x39, 0x50},
	{0x3a, 0x06},
	{0x3b, 0x50},

	{0x40, 0x01}, //Hblank 296 (Oneline 1920)
	{0x41, 0x28},
	{0x42, 0x00}, //Vblank 106
	{0x43, 0x6a},

	///// BLC /////
	{0x80, 0x2e},
	{0x81, 0x7e},
	{0x82, 0x90},
	{0x83, 0x00},
	{0x84, 0xcc}, //20130604 0x0c->0xcc
	{0x85, 0x00},
	{0x86, 0x00},
	{0x87, 0x0f},
	{0x88, 0x34},
	{0x8a, 0x0b},
	{0x8e, 0x80}, //Pga Blc Hold

	{0x90, 0x04}, //BLC_TIME_TH_ON
	{0x91, 0x04}, //BLC_TIME_TH_OFF
	{0x92, 0xb8}, //BLC_AG_TH_ON
	{0x93, 0xb0}, //BLC_AG_TH_OFF
	{0x96, 0xdc}, //BLC Outdoor Th On
	{0x97, 0xfe}, //BLC Outdoor Th Off
	{0x98, 0x38},

	//OutDoor  BLC
	{0x99, 0x43}, //R,Gr,B,Gb Offset

	//Dark BLC
	{0xa0, 0x01}, //R,Gr,B,Gb Offset

	//Normal BLC
	{0xa8, 0x43}, //R,Gr,B,Gb Offset
	///// PAGE 0 END /////

	///// PAGE 2 START /////
	{0x03, 0x02},
	{0x10, 0x00},
	{0x13, 0x00},
	{0x14, 0x00},
	{0x18, 0xcc},
	{0x19, 0x01}, // pmos switch on (for cfpn)
	{0x1A, 0x39}, //20130604 0x09->0xcc
	{0x1B, 0x00},
	{0x1C, 0x1a}, // for ncp
	{0x1D, 0x14}, // for ncp
	{0x1E, 0x30}, // for ncp
	{0x1F, 0x10},

	{0x20, 0x77},
	{0x21, 0xde},
	{0x22, 0xa7},
	{0x23, 0x30},
	{0x24, 0x77},
	{0x25, 0x10},
	{0x26, 0x10},
	{0x27, 0x3c},
	{0x2b, 0x80},
	{0x2c, 0x02},
	{0x2d, 0x58},
	{0x2e, 0x11},//20130604 0xde->0x11
	{0x2f, 0x11},//20130604 0xa7->0x11

	{0x30, 0x00},
	{0x31, 0x99},
	{0x32, 0x00},
	{0x33, 0x00},
	{0x34, 0x22},
	{0x36, 0x75},
	{0x38, 0x88},
	{0x39, 0x88},
	{0x3d, 0x03},
	{0x3f, 0x02},

	{0x49, 0xc1},//20130604 0x87->0xd1 --> mode Change Issue modify -> 0xc1
	{0x4a, 0x10},

	{0x50, 0x21},
	{0x53, 0xb1},
	{0x54, 0x10},
	{0x55, 0x1c}, // for ncp
	{0x56, 0x11},
	{0x58, 0x3a},//20130604 add
	{0x59, 0x38},//20130604 add
	{0x5d, 0xa2},
	{0x5e, 0x5a},

	{0x60, 0x87},
	{0x61, 0x98},
	{0x62, 0x88},
	{0x63, 0x96},
	{0x64, 0x88},
	{0x65, 0x96},
	{0x67, 0x3f},
	{0x68, 0x3f},
	{0x69, 0x3f},

	{0x72, 0x89},
	{0x73, 0x95},
	{0x74, 0x89},
	{0x75, 0x95},
	{0x7C, 0x84},
	{0x7D, 0xaf},

	{0x80, 0x01},
	{0x81, 0x7a},
	{0x82, 0x13},
	{0x83, 0x24},
	{0x84, 0x78},
	{0x85, 0x7c},

	{0x92, 0x44},
	{0x93, 0x59},
	{0x94, 0x78},
	{0x95, 0x7c},

	{0xA0, 0x02},
	{0xA1, 0x74},
	{0xA4, 0x74},
	{0xA5, 0x02},
	{0xA8, 0x85},
	{0xA9, 0x8c},
	{0xAC, 0x10},
	{0xAD, 0x16},

	{0xB0, 0x99},
	{0xB1, 0xa3},
	{0xB4, 0x9b},
	{0xB5, 0xa2},
	{0xB8, 0x9b},
	{0xB9, 0x9f},
	{0xBC, 0x9b},
	{0xBD, 0x9f},

	{0xc4, 0x29},
	{0xc5, 0x40},
	{0xc6, 0x5c},
	{0xc7, 0x72},
	{0xc8, 0x2a},
	{0xc9, 0x3f},
	{0xcc, 0x5d},
	{0xcd, 0x71},

	{0xd0, 0x10},
	{0xd1, 0x14},
	{0xd2, 0x20},
	{0xd3, 0x00},
	{0xd4, 0x04}, //DCDC_TIME_TH_ON
	{0xd5, 0x04}, //DCDC_TIME_TH_OFF
	{0xd6, 0xb8}, //DCDC_AG_TH_ON
	{0xd7, 0xb0}, //DCDC_AG_TH_OFF
	{0xdc, 0x00},
	{0xdd, 0xa3},
	{0xde, 0x00},
	{0xdf, 0x84},

	{0xe0, 0xa4},
	{0xe1, 0xa4},
	{0xe2, 0xa4},
	{0xe3, 0xa4},
	{0xe4, 0xa4},
	{0xe5, 0x01},
	{0xe8, 0x00},
	{0xe9, 0x00},
	{0xea, 0x77},

	{0xF0, 0x00},
	{0xF1, 0x00},
	{0xF2, 0x00},

	///// PAGE 2 END /////


	///// PAGE 10 START /////
	{0x03, 0x10}, //page 10
	{0x10, 0x03}, //S2D enable _ YUYV Order 
	{0x11, 0x03},
	{0x12, 0x30},
	{0x13, 0x03},

	{0x20, 0x00},
	{0x21, 0x40},
	{0x22, 0x0f},
	{0x24, 0x20},
	{0x25, 0x10},
	{0x26, 0x01},
	{0x27, 0x02},
	{0x28, 0x11},

	{0x40, 0x00},
	{0x41, 0x00}, //D-YOffset Th
	{0x42, 0x00}, //Cb Offset
	{0x43, 0x00}, //Cr Offset
	{0x44, 0x80},
	{0x45, 0x80},
	{0x46, 0xf0},
	{0x48, 0x80},
	{0x4a, 0x80},

	{0x50, 0xa0}, //D-YOffset AG

	{0x60, 0x4b},//20150119_SCH //4f},
	{0x61, 0x90},//84},//88}, //9a}, //Sat B STEVE
	{0x62, 0xb0},//86},//88}, //96}, //Sat R STEVE
	{0x63, 0x80}, //Auto-De Color

	{0x66, 0x42},
	{0x67, 0x22},

	{0x6a, 0x77}, //White Protection Offset Dark/Indoor
	{0x72, 0x72}, //20150115_SCH //84},
	{0x74, 0x07}, //White Protection Offset Outdoor
	{0x75, 0x60}, //Sat over th
	{0x76, 0x01}, // 0x05}, //	STEVE White Protection Enable
	{0x78, 0xff}, //Sat over ratio
	///// PAGE 10 END /////

	///// PAGE 11 START /////
	{0x03, 0x11}, //page 11

	//LPF Auto Control
	{0x20, 0x00},
	{0x21, 0x00},
	{0x26, 0x6a}, //pga_dark1_min (on)
	{0x27, 0x68}, //pga_dark1_max (off)
	{0x28, 0x0f},
	{0x29, 0x10},
	{0x2b, 0x30},
	{0x2c, 0x32},

	//GBGR
	{0x70, 0x2b},
	{0x74, 0x30},
	{0x75, 0x18},
	{0x76, 0x30},
	{0x77, 0xff},
	{0x78, 0xa0},
	{0x79, 0xff}, //Dark GbGr Th
	{0x7a, 0x30},
	{0x7b, 0x20},
	{0x7c, 0xf4}, //Dark Dy Th B[7:4]
	{0x7d, 0x02},
	{0x7e, 0xb0},
	{0x7f, 0x10},
	///// PAGE 11 END /////

	///// PAGE 12 START /////
	{0x03, 0x12}, //page 12

	//YC2D
	{0x10, 0x03}, //Y DPC Enable
	{0x11, 0x08}, //
	{0x12, 0x10}, //0x30 -> 0x10
	{0x20, 0x53}, //Y_lpf_enable
	{0x21, 0x03}, //C_lpf_enable_on
	{0x22, 0xe6}, //YC2D_CrCbY_Dy

	{0x23, 0x14}, //Outdoor Dy Th
	{0x24, 0x30},//20}, //Indoor Dy Th // For reso Limit 0x20
	{0x25, 0x60},//30}, //Dark Dy Th

	//Outdoor LPF Flat
	{0x30, 0xff}, //Y Hi Th
	{0x31, 0x00}, //Y Lo Th
	{0x32, 0xf0}, //Std Hi Th //Reso Improve Th Low //50
	{0x33, 0x00}, //Std Lo Th
	{0x34, 0x00}, //Median ratio

	//Indoor LPF Flat
	{0x35, 0xff}, //Y Hi Th
	{0x36, 0x00}, //Y Lo Th
	{0x37, 0xff}, //Std Hi Th //Reso Improve Th Low //50
	{0x38, 0x00}, //Std Lo Th
	{0x39, 0x00}, //Median ratio

	//Dark LPF Flat
	{0x3a, 0xff}, //Y Hi Th
	{0x3b, 0x00}, //Y Lo Th
	{0x3c, 0x93}, //Std Hi Th //Reso Improve Th Low //50
	{0x3d, 0x00}, //Std Lo Th
	{0x3e, 0x00}, //Median ratio

	//Outdoor Cindition
	{0x46, 0xa0}, //Out Lum Hi
	{0x47, 0x40}, //Out Lum Lo

	//Indoor Cindition
	{0x4c, 0xb0}, //Indoor Lum Hi
	{0x4d, 0x40}, //Indoor Lum Lo

	//Dark Cindition
	{0x52, 0xb0}, //Dark Lum Hi
	{0x53, 0x50}, //Dark Lum Lo

	//C-Filter
	{0x70, 0x10}, //Outdoor(2:1) AWM Th Horizontal
	{0x71, 0x0a}, //Outdoor(2:1) Diff Th Vertical
	{0x72, 0x20},//10}, //Indoor,Dark1 AWM Th Horizontal
	{0x73, 0x0a}, //Indoor,Dark1 Diff Th Vertical
	{0x74, 0x20},//18}, //Dark(2:3) AWM Th Horizontal
	{0x75, 0x0f}, //Dark(2:3) Diff Th Vertical

	//DPC
	{0x90, 0x3d}, //don't touch register_SCH //7d},
	{0x91, 0x34},
	{0x99, 0x14}, //don't touch register_SCH //28},
	{0x9c, 0x0a}, //20131107 Flat DPC value 0x14 -> 0x00 -> 0x0a
	{0x9d, 0x15},
	{0x9e, 0x28},
	{0x9f, 0x28},
	{0xb0, 0x0e}, //Zipper noise Detault change (0x75->0x0e)
	{0xb8, 0x44},
	{0xb9, 0x15},
	///// PAGE 12 END /////

	///// PAGE 13 START /////
	{0x03, 0x13}, //page 13

	{0x80, 0xfd}, //Sharp2D enable _ YUYV Order
	{0x81, 0x07}, //Sharp2D Clip/Limit
	{0x82, 0x73}, //Sharp2D Filter
	{0x83, 0x00}, //Sharp2D Low Clip
	{0x85, 0x00},

	{0x92, 0x33}, //Sharp2D Slop n/p
	{0x93, 0x30}, //Sharp2D LClip
	{0x94, 0x02}, //Sharp2D HiClip1 Th
	{0x95, 0xf0}, //Sharp2D HiClip2 Th
	{0x96, 0x1e}, //Sharp2D HiClip2 Resolution
	{0x97, 0x40},
	{0x98, 0x80},
	{0x99, 0x40},

	//Sharp Lclp
	{0xa2, 0x03}, //Outdoor Lclip_N
	{0xa3, 0x04}, //Outdoor Lclip_P
	{0xa4, 0x02}, //Indoor Lclip_N 0x03 For reso Limit 0x0e
	{0xa5, 0x03}, //Indoor Lclip_P 0x0f For reso Limit 0x0f
	{0xa6, 0x80}, //Dark Lclip_N
	{0xa7, 0x80}, //Dark Lclip_P

	//Outdoor Slope
	{0xb6, 0x28}, //Lum negative Hi
	{0xb7, 0x20}, //Lum negative middle
	{0xb8, 0x24}, //Lum negative Low
	{0xb9, 0x28}, //Lum postive Hi
	{0xba, 0x20}, //Lum postive middle
	{0xbb, 0x24}, //Lum postive Low

	//Indoor Slope
	{0xbc, 0x20}, //Lum negative Hi
	{0xbd, 0x20}, //Lum negative middle
	{0xbe, 0x20}, //Lum negative Low
	{0xbf, 0x20}, //Lum postive Hi
	{0xc0, 0x20}, //Lum postive middle
	{0xc1, 0x20}, //Lum postive Low

	//Dark Slope
	{0xc2, 0x14}, //Lum negative Hi
	{0xc3, 0x24}, //Lum negative middle
	{0xc4, 0x1d}, //Lum negative Low
	{0xc5, 0x14}, //Lum postive Hi
	{0xc6, 0x24}, //Lum postive middle
	{0xc7, 0x1d}, //Lum postive Low
	///// PAGE 13 END /////

	///// PAGE 14 START /////
	{0x03, 0x14}, //page 14
	{0x10, 0x09},

	{0x20, 0x60},//80}, // //X-Center
	{0x21, 0x80},//80}, //Y-Center

	//{0x22, 0x78}, //LSC R 1b->15 20130125
	//{0x23, 0x68}, //LSC G
	//{0x24, 0x68}, //LSC B

	//CW//
	{0x22, 0x70},//75},///6d},//6c},//6a},//38}, //LSC R 1b->15 20130125
	{0x23, 0x4d},//4a},///49},//50},//50},//29}, //LSC G
	{0x24, 0x50},//4e},///4e},//4e},//4a},//28}, //LSC B
	//{0x22, 0x60},//56}, //LSC R 1b->15 20130125
	//{0x23, 0x45},//39}, //LSC G
	//{0x24, 0x49},//3f}, //LSC B
	//SKh//
	//{0x22, 0x5c}, //LSC R 1b->15 20130125
	//{0x23, 0x3f}, //LSC G
	//{0x24, 0x3b}, //LSC B

	{0x25, 0xf0}, //LSC Off
	{0x26, 0xf0}, //LSC On
	///// PAGE 14 END /////

	/////// PAGE 15 START ///////
	{0x03, 0x15}, //page 15
	{0x10, 0x21},
	{0x14, 0x46},
	{0x15, 0x36},
	{0x16, 0x26},
	{0x17, 0x3f},	//CMC SIGN
	//CMC
	{0x30, 0xcb},
	{0x31, 0x40},
	{0x32, 0x0b},
	{0x33, 0x22},
	{0x34, 0xdb},
	{0x35, 0x39},
	{0x36, 0x0b},
	{0x37, 0x5c},
	{0x38, 0xe7},
	//CMC OFS
	{0x40, 0x00},//90},
	{0x41, 0x00},//10},
	{0x42, 0x00},//00},
	{0x43, 0x00},//08},
	{0x44, 0x00},//12},
	{0x45, 0x00},//9a},
	{0x46, 0x00},//9a},
	{0x47, 0x00},//04},
	{0x48, 0x00},//16},
	//CMC POFS
	{0x50, 0x00},//04},//00},
	{0x51, 0x00},//08},
	{0x52, 0x00},//04},//18},
	{0x53, 0x00},//04},
	{0x54, 0x00},//00},
	{0x55, 0x00},//04},
	{0x56, 0x00},//02},
	{0x57, 0x00},//00},
	{0x58, 0x00},//02},

	///// PAGE 15 END /////

	///// PAGE 16 START /////
	{0x03, 0x16}, //page 16 Gamma
	{0x10, 0x21}, //31},
	{0x18, 0x5a}, //Double_AG 5e->37
	{0x19, 0x58}, //Double_AG 5e->36
	{0x1a, 0x0e},
	{0x1b, 0x01},
	{0x1c, 0xdc},
	{0x1d, 0xfe},

	//Indoor
	{0x30, 0x00},
	{0x31, 0x08},
	{0x32, 0x19},
	{0x33, 0x34},
	{0x34, 0x64},
	{0x35, 0x80},
	{0x36, 0x96},
	{0x37, 0xa7},
	{0x38, 0xb5},
	{0x39, 0xc1},
	{0x3a, 0xcc},
	{0x3b, 0xd5},
	{0x3c, 0xde},
	{0x3d, 0xe5},
	{0x3e, 0xeb},
	{0x3f, 0xf0},
	{0x40, 0xf6},
	{0x41, 0xfa},
	{0x42, 0xff},

	//Outdoor
	{0x50, 0x00},//0x00},
	{0x51, 0x08},//0x03},
	{0x52, 0x19},//0x10},
	{0x53, 0x34},//0x26},
	{0x54, 0x64},//0x43},
	{0x55, 0x80},//0x5d},
	{0x56, 0x96},//0x79},
	{0x57, 0xa7},//0x8c},
	{0x58, 0xb5},//0x9f},
	{0x59, 0xc1},//0xaa},
	{0x5a, 0xcc},//0xb6},
	{0x5b, 0xd5},//0xc3},
	{0x5c, 0xde},//0xce},
	{0x5d, 0xe5},//0xd9},
	{0x5e, 0xeb},//0xe1},
	{0x5f, 0xf0},//0xe9},
	{0x60, 0xf6},//0xf0},
	{0x61, 0xfa},//0xf4},
	{0x62, 0xff},//0xf5},

	//Dark
	{0x70, 0x00},//0x00},
	{0x71, 0x0b},//0x10},
	{0x72, 0x1c},//0x1c},
	{0x73, 0x3b},//0x2e},
	{0x74, 0x6b},//0x4e},
	{0x75, 0x88},//0x6c},
	{0x76, 0x9e},//0x82},
	{0x77, 0xae},//0x96},
	{0x78, 0xbc},//0xa7},
	{0x79, 0xc7},//0xb6},
	{0x7a, 0xd0},//0xc4},
	{0x7b, 0xd9},//0xd0},
	{0x7c, 0xe1},//0xda},
	{0x7d, 0xe7},//0xe2},
	{0x7e, 0xec},//0xea},
	{0x7f, 0xf1},//0xf0},
	{0x80, 0xf6},//0xf6},
	{0x81, 0xfa},//0xfa},
	{0x82, 0xff},//0xFF},
	///// PAGE 16 END /////

	///// PAGE 17 START /////
	{0x03, 0x17}, //page 17
	{0xc1, 0x00},
	{0xC4, 0x6b},
	{0xC5, 0x59},
	{0xc6, 0x02},
	{0xc7, 0x20},
	///// PAGE 17 END /////

	///// PAGE 18 START /////
	{0x03, 0x18}, //page 18
	{0x10, 0x00},	//Scale Off
	{0x11, 0x00},
	{0x12, 0x58},
	{0x13, 0x01},
	{0x14, 0x0b},
	{0x15, 0x00},
	{0x16, 0x00},
	{0x17, 0x00},
	{0x18, 0x00},
	{0x19, 0x00},
	{0x1a, 0x00},
	{0x1b, 0x00},
	{0x1c, 0x00},
	{0x1d, 0x00},
	{0x1e, 0x00},
	{0x1f, 0x00},
	{0x20, 0x05},	//zoom wid
	{0x21, 0x00},
	{0x22, 0x01},	//zoom hgt
	{0x23, 0xe0},
	{0x24, 0x00},	//zoom start x
	{0x25, 0x00},
	{0x26, 0x00},	//zoom start y
	{0x27, 0x00},
	{0x28, 0x05},	//zoom end x
	{0x29, 0x00},
	{0x2a, 0x01},	//zoom end y
	{0x2b, 0xe0},
	{0x2c, 0x0a},	//zoom step vert
	{0x2d, 0x00},
	{0x2e, 0x0a},	//zoom step horz
	{0x2f, 0x00},
	{0x30, 0x44},	//zoom fifo

	///// PAGE 18 END /////

	{0x03, 0x19}, //Page 0x19
	{0x10, 0x7e},//7f}, //mcmc_ctl1 MCMC Enable B:[0]
	{0x11, 0x7f}, //mcmc_ctl2
	{0x12, 0x1e}, //mcmc_delta1
	{0x13, 0x72}, //mcmc_center1
	{0x14, 0x1e}, //mcmc_delta2
	{0x15, 0xec}, //mcmc_center2
	{0x16, 0x9e}, //mcmc_delta3
	{0x17, 0x56}, //mcmc_center3
	{0x18, 0x9e}, //mcmc_delta4
	{0x19, 0x36}, //mcmc_center4
	{0x1a, 0x1e}, //mcmc_delta5
	{0x1b, 0x52}, //mcmc_center5
	{0x1c, 0x1e}, //mcmc_delta6
	{0x1d, 0xa4}, //mcmc_center6
	{0x1e, 0x40}, //mcmc_sat_gain1
	{0x1f, 0x58}, //mcmc_sat_gain2
	{0x20, 0x40}, //mcmc_sat_gain3
	{0x21, 0x40}, //mcmc_sat_gain4
	{0x22, 0x40}, //mcmc_sat_gain5
	{0x23, 0x50}, //mcmc_sat_gain6
	{0x24, 0x00}, //mcmc_hue_angle1
	{0x25, 0x00}, //mcmc_hue_angle2
	{0x26, 0x00}, //mcmc_hue_angle3
	{0x27, 0x00}, //mcmc_hue_angle4
	{0x28, 0x00}, //mcmc_hue_angle5
	{0x29, 0x00}, //mcmc_hue_angle6
	{0x53, 0x10}, //mcmc_ctl3
	{0x6c, 0xff}, //mcmc_lum_ctl1 sat hue offset
	{0x6d, 0x3f}, //mcmc_lum_ctl2 gain
	{0x6e, 0x00}, //mcmc_lum_ctl3 hue
	{0x6f, 0x00}, //mcmc_lum_ctl4 rgb offset
	{0x70, 0x00}, //mcmc_lum_ctl5 rgb scale
	{0x71, 0x3f}, //mcmc_lum_gain_wgt_th1 R1 magenta
	{0x72, 0x3f}, //mcmc_lum_gain_wgt_th2 R1
	{0x73, 0x3f}, //mcmc_lum_gain_wgt_th3 R1
	{0x74, 0x3f}, //mcmc_lum_gain_wgt_th4 R1
	{0x75, 0x30}, //mcmc_rg1_lum_sp1	  R1
	{0x76, 0x50}, //mcmc_rg1_lum_sp2	  R1
	{0x77, 0x80}, //mcmc_rg1_lum_sp3	  R1
	{0x78, 0xb0}, //mcmc_rg1_lum_sp4	  R1
	{0x79, 0x3f}, //mcmc_lum_gain_wgt_th1 R2 bright green
	{0x7a, 0x3f}, //mcmc_lum_gain_wgt_th2 R2
	{0x7b, 0x3f}, //mcmc_lum_gain_wgt_th3 R2
	{0x7c, 0x3f}, //mcmc_lum_gain_wgt_th4 R2
	{0x7d, 0x28}, //mcmc_rg2_lum_sp1	  R2
	{0x7e, 0x50}, //mcmc_rg2_lum_sp2	  R2
	{0x7f, 0x80}, //mcmc_rg2_lum_sp3	  R2
	{0x80, 0xb0}, //mcmc_rg2_lum_sp4	  R2
	{0x81, 0x28}, //mcmc_lum_gain_wgt_th1 R3 dark green
	{0x82, 0x3f}, //mcmc_lum_gain_wgt_th2 R3
	{0x83, 0x3f}, //mcmc_lum_gain_wgt_th3 R3
	{0x84, 0x3f}, //mcmc_lum_gain_wgt_th4 R3
	{0x85, 0x28}, //mcmc_rg3_lum_sp1	  R3
	{0x86, 0x50}, //mcmc_rg3_lum_sp2	  R3
	{0x87, 0x80}, //mcmc_rg3_lum_sp3	  R3
	{0x88, 0xb0}, //mcmc_rg3_lum_sp4	  R3
	{0x89, 0x1a}, //mcmc_lum_gain_wgt_th1 R4 skin
	{0x8a, 0x28}, //mcmc_lum_gain_wgt_th2 R4
	{0x8b, 0x3f}, //mcmc_lum_gain_wgt_th3 R4
	{0x8c, 0x3f}, //mcmc_lum_gain_wgt_th4 R4
	{0x8d, 0x10}, //mcmc_rg3_lum_sp1	  R4
	{0x8e, 0x30}, //mcmc_rg3_lum_sp2	  R4
	{0x8f, 0x60}, //mcmc_rg3_lum_sp3	  R4
	{0x90, 0x90}, //mcmc_rg3_lum_sp4	  R4
	{0x91, 0x1a}, //mcmc_rg5_gain_wgt_th1 R5 cyan
	{0x92, 0x28}, //mcmc_rg5_gain_wgt_th2 R5
	{0x93, 0x3f}, //mcmc_rg5_gain_wgt_th3 R5
	{0x94, 0x3f}, //mcmc_rg5_gain_wgt_th4 R5
	{0x95, 0x28}, //mcmc_rg5_lum_sp1	  R5
	{0x96, 0x50}, //mcmc_rg5_lum_sp2	  R5
	{0x97, 0x80}, //mcmc_rg5_lum_sp3	  R5
	{0x98, 0xb0}, //mcmc_rg5_lum_sp4	  R5
	{0x99, 0x1a}, //mcmc_rg6_gain_wgt_th1 R6 blue
	{0x9a, 0x28}, //mcmc_rg6_gain_wgt_th2 R6
	{0x9b, 0x3f}, //mcmc_rg6_gain_wgt_th3 R6
	{0x9c, 0x3f}, //mcmc_rg6_gain_wgt_th4 R6
	{0x9d, 0x28}, //mcmc_rg6_lum_sp1	  R6
	{0x9e, 0x50}, //mcmc_rg6_lum_sp2	  R6
	{0x9f, 0x80}, //mcmc_rg6_lum_sp3	  R6
	{0xa0, 0xb0}, //mcmc_rg6_lum_sp4	  R6

	{0xe5, 0x80}, //add 20120709 Bit[7] On MCMC --> YC2D_LPF

	/////// PAGE 20 START ///////
	{0x03, 0x20},
	{0x10, 0x0c},
	{0x11, 0x0c}, //131002 14 -> 0c
	{0x18, 0x30},
	{0x20, 0x25}, //8x8 Ae weight 0~7 Outdoor / Weight Outdoor On B[5]
	{0x21, 0x30},
	{0x22, 0x10},
	{0x23, 0x00},

	{0x28, 0xf7},
	{0x29, 0x0d},
	{0x2a, 0xff},
	{0x2b, 0x34},//04}, //Adaptive Off,1/100 Flicker

	{0x2c, 0x83}, //AE After CI
	{0x2d, 0xe3},
	{0x2e, 0x13},
	{0x2f, 0x0b},

	{0x30, 0x78},
	{0x31, 0xd7},
	{0x32, 0x10},
	{0x33, 0x2e},
	{0x34, 0x20},
	{0x35, 0xd4},
	{0x36, 0xfe},
	{0x37, 0x32},
	{0x38, 0x04},
	{0x39, 0x22},
	{0x3a, 0xde},
	{0x3b, 0x22},
	{0x3c, 0xde},
	{0x3d, 0xe1},

	{0x3e, 0xc9}, //Option of changing Exp max
	{0x41, 0x23}, //Option of changing Exp max

	{0x50, 0x45},
	{0x51, 0x88},

	{0x56, 0x1f}, // for tracking
	{0x57, 0xa6}, // for tracking
	{0x58, 0x1a}, // for tracking
	{0x59, 0x7a}, // for tracking

	{0x5a, 0x04},
	{0x5b, 0x04},

	{0x5e, 0xc7},
	{0x5f, 0x95},

	{0x62, 0x10},
	{0x63, 0xc0},
	{0x64, 0x10},
	{0x65, 0x8a},
	{0x66, 0x58},
	{0x67, 0x58},

	{0x70, 0x40},//3b}, //54->46
	{0x71, 0x80},//82}, //_140416 //89}, //81(+4),89(-4)

	{0x76, 0x32},
	{0x77, 0x81}, //141218 //a2}, //140416 //a1},
	{0x78, 0x32}, //141218 //22 //24
	{0x79, 0x26}, //141218 //27}, //30}, // Y Target 70 => 25, 72 => 26 //
	{0x7a, 0x23}, //23
	{0x7b, 0x22}, //22
	{0x7d, 0x23},

	{0x83, 0x03}, //EXP Normal 30.00 fps
	{0x84, 0x09},
	{0x85, 0x88},
	{0x86, 0x01}, //EXPMin 21582.73 fps
	{0x87, 0x16},
	{0x88, 0x03}, //EXP Max 60hz 30.00 fps
	{0x89, 0x09},
	{0x8a, 0x88},
	{0xa5, 0x02}, //EXP Max 50hz 33.33 fps
	{0xa6, 0xbc},
	{0xa7, 0x6e},
	{0x8B, 0xe9}, //EXP100
	{0x8C, 0x7a},
	{0x8D, 0xc2}, //EXP120
	{0x8E, 0x62},
	{0x91, 0x01}, //EXP Fix 30.02 fps
	{0x92, 0x86},
	{0x93, 0x65},
	{0x9c, 0x0e}, //EXP Limit 1660.21 fps
	{0x9d, 0x1e},
	{0x9e, 0x01}, //EXP Unit
	{0x9f, 0x16},
	{0xa3, 0x00}, //Outdoor Int
	{0xa4, 0xc2},

	{0xb0, 0x15},
	{0xb1, 0x14},
	{0xb2, 0xc0},
	{0xb3, 0x15},
	{0xb4, 0x16},
	{0xb5, 0x3c},
	{0xb6, 0x29},
	{0xb7, 0x23},
	{0xb8, 0x54},
	{0xb9, 0x50},
	{0xba, 0x4d},
	{0xbb, 0x4b},
	{0xbc, 0x4a},
	{0xbd, 0x49},

	{0xc0, 0x10},
	{0xc1, 0x40},
	{0xc2, 0x40},
	{0xc3, 0x40},
	{0xc4, 0x04},

	{0xc6, 0x80}, //Exp max 1frame target AG

	{0xc8, 0x80},
	{0xc9, 0x80},
	///// PAGE 20 END /////

	///// PAGE 21 START /////
	{0x03, 0x21}, //page 21

	//Indoor Weight
	{0x20, 0x00},//11},
	{0x21, 0x00},//11},
	{0x22, 0x00},//11},
	{0x23, 0x00},//11},
	{0x24, 0x00},//14},
	{0x25, 0x01},//44},
	{0x26, 0x10},//44},
	{0x27, 0x00},//41},
	{0x28, 0x00},//14},
	{0x29, 0x12},//44},
	{0x2a, 0x21},//44},
	{0x2b, 0x00},//41},
	{0x2c, 0x01},//14},
	{0x2d, 0x27},//47},
	{0x2e, 0x72},//74},
	{0x2f, 0x10},//41},
	{0x30, 0x01},//14},
	{0x31, 0x27},//47},
	{0x32, 0x72},//74},
	{0x33, 0x10},//41},
	{0x34, 0x00},//14},
	{0x35, 0x12},//44},
	{0x36, 0x21},//44},
	{0x37, 0x00},//41},
	{0x38, 0x00},//14},
	{0x39, 0x01},//44},
	{0x3a, 0x10},//44},
	{0x3b, 0x00},//41},
	{0x3c, 0x00},//11},
	{0x3d, 0x00},//11},
	{0x3e, 0x00},//11},
	{0x3f, 0x00},//11},

	//Outdoor Weight
	{0x40, 0x00},//11},
	{0x41, 0x00},//11},
	{0x42, 0x00},//11},
	{0x43, 0x00},//11},
	{0x44, 0x00},//13},
	{0x45, 0x01},//33},
	{0x46, 0x10},//33},
	{0x47, 0x00},//31},
	{0x48, 0x00},//13},
	{0x49, 0x12},//44},
	{0x4a, 0x21},//44},
	{0x4b, 0x00},//31},
	{0x4c, 0x01},//14},
	{0x4d, 0x57},//47},
	{0x4e, 0x75},//74},
	{0x4f, 0x10},//41},
	{0x50, 0x01},//14},
	{0x51, 0x57},//47},
	{0x52, 0x75},//74},
	{0x53, 0x10},//41},
	{0x54, 0x00},//14},
	{0x55, 0x12},//57},
	{0x56, 0x21},//75},
	{0x57, 0x00},//41},
	{0x58, 0x00},//24},
	{0x59, 0x01},//56},
	{0x5a, 0x10},//65},
	{0x5b, 0x00},//42},
	{0x5c, 0x00},//23},
	{0x5d, 0x00},//34},
	{0x5e, 0x00},//43},
	{0x5f, 0x00},//32},


	///// PAGE 22 START /////
	{0x03, 0x22}, //page 22
	{0x10, 0xfd},
	{0x11, 0x2e},
	{0x19, 0x02},
	{0x20, 0x30}, //For AWB Speed
	{0x21, 0x80},
	{0x22, 0x00},
	{0x23, 0x00},
	{0x24, 0x01},
	{0x25, 0x4f}, //2013-09-13 AWB Hunting

	{0x30, 0x80},
	{0x31, 0x80},
	{0x38, 0x11},
	{0x39, 0x34},
	{0x40, 0xe4}, //Stb Yth
	{0x41, 0x33}, //Stb cdiff
	{0x42, 0x22}, //Stb csum
	{0x43, 0xf3}, //Unstb Yth
	{0x44, 0x55}, //Unstb cdiff
	{0x45, 0x33}, //Unstb csum
	{0x46, 0x00},
	{0x47, 0x09}, //2013-09-13 AWB Hunting
	{0x48, 0x00}, //2013-09-13 AWB Hunting
	{0x49, 0x0a},

	{0x60, 0x04}, //awb_x_start full mode
	{0x61, 0xc4}, //awb_x_stop full mode
	{0x62, 0x04}, //awb_y_start full mode
	{0x63, 0x92}, //awb_y_stop full mode
	{0x66, 0x04}, //awb_x_start pxl windowing
	{0x67, 0xc4}, //awb_x_stop pxl windowing
	{0x68, 0x04}, //awb_y_start pxl windowing
	{0x69, 0x92}, //awb_y_stop pxl windowing

	{0x80, 0x36}, //r_gain
	{0x81, 0x20}, //g_gain
	{0x82, 0x2a}, //b_gain

	{0x83, 0x56},//58}, //awb_r_gain_max normal
	{0x84, 0x21},//25},//22},//16}, //awb_r_gain_min normal
	{0x85, 0x3a},//3c},//42},//4f}, //awb_b_gain_max normal
	{0x86, 0x15},//15}, //awb_b_gain_min normal

	{0x87, 0x46}, //3b->46 awb_r_gain_max middle
	{0x88, 0x3b}, //30->3b awb_r_gain_min middle
	{0x89, 0x2e}, //29->2c awb_b_gain_max middle
	{0x8a, 0x1c}, //18->1b awb_b_gain_min middle

	{0x8b, 0x44}, //45}, //3c->45 awb_r_gain_max outdoor
	{0x8c, 0x3b}, //32->3b awb_r_gain_min outdoor
	{0x8d, 0x2e}, //2a->2c awb_b_gain_max outdoor
	{0x8e, 0x22}, //1c}, //1b->1b awb_b_gain_min outdoor

	{0x8f, 0x50},//50},//4f}, // 56},// 4d}, //4e awb_slope_th0
	{0x90, 0x4a},//4b},//48}, // 4f},// 46}, //4d awb_slope_th1
	{0x91, 0x42},//40},//42}, // 49},// 40}, //4c awb_slope_th2
	{0x92, 0x3a},//30},//3c}, // 43},// 3a}, //4a awb_slope_th3
	{0x93, 0x31},//2a},//31}, // 38},// 2f}, //46 awb_slope_th4
	{0x94, 0x28},//26},//23}, // 2a},// 21}, // awb_slope_th5
	{0x95, 0x21},//22},//1b}, // 22},// 19}, // awb_slope_th6
	{0x96, 0x1c},//1e},//18}, // 1f},// 16}, // awb_slope_th7
	{0x97, 0x18},//1b},//15}, // 1c},// 13}, // awb_slope_th8
	{0x98, 0x15},//17},//14}, // 1b},// 12}, // awb_slope_th9
	{0x99, 0x13},//14},//13}, // 1a},// 11}, // awb_slope_th10
	{0x9a, 0x11},//11},//12}, // 19},// 10}, // awb_slope_th11

	{0x9b, 0x88},//88}, //awb_slope_delta1
	{0x9c, 0x88},//77}, //awb_slope_delta2
	{0x9d, 0x48}, //rgain_ofs1
	{0x9e, 0x38}, //rgain_ofs2
	{0x9f, 0x30}, //rgain_ofs3

	{0xa0, 0x70},
	{0xa1, 0x54},
	{0xa2, 0x6f},
	{0xa3, 0xff},

	{0xa4, 0x14}, //1536fps
	{0xa5, 0x2c}, //698fps
	{0xa6, 0xcf}, //148fps

	{0xad, 0x2e},
	{0xae, 0x2a},

	{0xaf, 0x28}, //Low temp Rgain
	{0xb0, 0x26}, //Low temp Rgain

	{0xb1, 0x08},
	{0xb4, 0xbf}, //For Tracking AWB Weight
	{0xb8, 0x91}, //(0+,1-)High Cb , (0+,1-)Low Cr
	{0xb9, 0xb0},
	/////// PAGE 22 END ///////

	//// MIPI Setting /////
	{0x03, 0x48},
	{0x39, 0x4f}, //lvds_bias_ctl	 [2:0]mipi_tx_bias	 [4:3]mipi_vlp_sel	 [6:5]mipi_vcm_sel
	{0x10, 0x1c}, //lvds_ctl_1		 [5]mipi_pad_disable [4]lvds_en [0]serial_data_len
	{0x11, 0x00}, //lvds_ctl_2		 [4]mipi continous mode setting
	//{0x14, 0x00} //ser_out_ctl_1	[2:0]serial_sout_a_phase   [6:4]serial_cout_a_phase

	{0x16, 0x00}, //lvds_inout_ctl1  [0]vs_packet_pos_sel [1]data_neg_sel [4]first_vsync_end_opt
	{0x18, 0x80}, //lvds_inout_ctl3
	{0x19, 0x00}, //lvds_inout_ctl4
	{0x1a, 0xf0}, //lvds_time_ctl
	{0x24, 0x1e}, //long_packet_id

	//====== MIPI Timing Setting =========
	{0x36, 0x01}, //clk_tlpx_time_dp
	{0x37, 0x05}, //clk_tlpx_time_dn
	{0x34, 0x03}, //clk_prepare_time
	{0x32, 0x15}, //clk_zero_time
	{0x35, 0x03}, //clk_trail_time
	{0x33, 0x0d}, //clk_post_time

	{0x1c, 0x08}, //tlps_time_l_dp
	{0x1d, 0x0c}, //tlps_time_l_dn
	{0x1e, 0x06}, //hs_zero_time
	{0x1f, 0x0a}, //hs_trail_time

	//long_packet word count
	{0x30, 0x06},
	{0x31, 0x40}, //long_packet word count

	/////// PAGE 20 ///////
	{0x03, 0x20},
	{0x10, 0x8c}, //9c}, //AE On 50hz

	/////// PAGE 22 ///////
	{0x03, 0x22},
	{0x10, 0xe9}, //AWB On

	{0x03, 0x00},
	{0x01, 0x00}, //Sleep Off
};

static struct msm_camera_i2c_reg_conf HI258_reg_exposure_compensation[5][2] = {
	/* -2 */
	{
		{0x03, 0x10},
		{0x40, 0xc0},
	},
	/* -1 */
	{
		{0x03, 0x10},
		{0x40, 0xa0},
	},
	/* 0 */
	{
		{0x03, 0x10},
		{0x40, 0x00},
	},
	/* 1 */
	{
		{0x03, 0x10},
		{0x40, 0x20},
	},
	/* 2 */
	{
		{0x03, 0x10},
		{0x40, 0x40},
	},
};

#if 0 //                                                                    
static struct msm_camera_i2c_reg_conf HI258_reg_effect_normal[] = {
	/* normal: */
};

static struct msm_camera_i2c_reg_conf HI258_reg_effect_black_white[] = {
	/* B&W: */
};

static struct msm_camera_i2c_reg_conf HI258_reg_effect_negative[] = {
	/* Negative: */
};

static struct msm_camera_i2c_reg_conf HI258_reg_effect_old_movie[] = {
	/* Sepia(antique): */

};

static struct msm_camera_i2c_reg_conf HI258_reg_effect_solarize[] = {

};

static struct msm_camera_i2c_reg_conf HI258_reg_scene_auto[] = {
	/* <SCENE_auto> */

};

static struct msm_camera_i2c_reg_conf HI258_reg_scene_portrait[] = {
	/* <CAMTUNING_SCENE_PORTRAIT> */

};

static struct msm_camera_i2c_reg_conf HI258_reg_scene_landscape[] = {
	/* <CAMTUNING_SCENE_LANDSCAPE> */

};

static struct msm_camera_i2c_reg_conf HI258_reg_scene_night[] = {
	/* <SCENE_NIGHT> */

};

static struct msm_camera_i2c_reg_conf HI258_reg_wb_auto[] = {
	/* Auto: */

};

static struct msm_camera_i2c_reg_conf HI258_reg_wb_sunny[] = {
	/* Sunny: */

};

static struct msm_camera_i2c_reg_conf HI258_reg_wb_cloudy[] = {
	/* Cloudy: */

};

static struct msm_camera_i2c_reg_conf HI258_reg_wb_office[] = {
	/* Office: */

};

static struct msm_camera_i2c_reg_conf HI258_reg_wb_home[] = {
	/* Home: */

};
#endif //                                                                    

#endif	/* HI258_REG_H */
