/* Copyright (c) 2011-2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {7978, 7975, 7969, 7960, 7934},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{964, 193, 100, 92, 91},
				{870, 195, 101, 93, 92},
				{870, 195, 101, 93, 92},
				{836, 197, 102, 95, 92},
				{796, 202, 106, 98, 95},
				{795, 212, 108, 101, 97},
				{798, 215, 112, 102, 100},
				{808, 221, 118, 107, 103},
				{818, 214, 117, 106, 101},
				{832, 208, 104, 97, 95},
				{858, 214, 104, 97, 95},
				{886, 223, 106, 97, 96},
				{910, 234, 108, 101, 98},
				{941, 251, 110, 102, 101},
				{974, 270, 112, 102, 98},
				{1015, 292, 114, 103, 100},
				{1063, 315, 118, 106, 102},
				{1121, 336, 120, 107, 103},
				{1174, 360, 120, 108, 104},
				{1221, 384, 124, 110, 107},
				{1237, 392, 128, 113, 108},
				{1303, 408, 130, 114, 109},
				{1409, 424, 132, 117, 113},
				{1532, 440, 135, 118, 114},
				{1669, 452, 135, 119, 114},
				{1854, 467, 136, 119, 114},
				{2107, 482, 139, 120, 115},
				{2439, 504, 143, 125, 120},
				{2948, 540, 153, 134, 126},
				{4082, 614, 193, 178, 158}
	}
};


static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4311, 4311, 4308, 4306, 4302},
				{4232, 4243, 4245, 4244, 4242},
				{4169, 4187, 4191, 4190, 4188},
				{4117, 4134, 4138, 4138, 4136},
				{4057, 4085, 4089, 4088, 4087},
				{4007, 4037, 4043, 4042, 4041},
				{3961, 3988, 3996, 3997, 3996},
				{3923, 3948, 3959, 3959, 3958},
				{3881, 3898, 3908, 3909, 3907},
				{3848, 3858, 3864, 3864, 3865},
				{3826, 3832, 3837, 3838, 3838},
				{3807, 3811, 3815, 3816, 3816},
				{3790, 3795, 3797, 3798, 3797},
				{3774, 3780, 3782, 3782, 3782},
				{3759, 3766, 3768, 3765, 3761},
				{3740, 3749, 3752, 3748, 3741},
				{3716, 3727, 3730, 3725, 3718},
				{3686, 3701, 3696, 3691, 3685},
				{3667, 3688, 3684, 3680, 3674},
				{3657, 3681, 3681, 3677, 3672},
				{3652, 3678, 3679, 3676, 3670},
				{3645, 3673, 3677, 3674, 3668},
				{3637, 3667, 3674, 3670, 3664},
				{3625, 3657, 3667, 3663, 3657},
				{3606, 3637, 3649, 3643, 3635},
				{3575, 3604, 3614, 3606, 3598},
				{3533, 3558, 3564, 3555, 3548},
				{3476, 3497, 3499, 3490, 3484},
				{3397, 3416, 3413, 3403, 3397},
				{3277, 3295, 3287, 3273, 3271},
				{3000, 3000, 3000, 3000, 3000}
	}
};


struct bms_battery_data LGE_BL_T13_8000mAh_LG_Chem_data = {
	.fcc				= 8000,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 82,
	.flat_ocv_threshold_uv	= 3800000,
};
