/* Copyright (c) 2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {1447, 1456, 1458, 1458, 1456},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{1042, 288, 100, 84, 84},
				{1014, 305, 105, 87, 86},
				{1018, 304, 104, 87, 85},
				{1015, 311, 108, 89, 87},
				{1025, 317, 112, 92, 90},
				{1041, 325, 119, 95, 92},
				{1066, 332, 127, 100, 95},
				{1093, 338, 134, 107, 99},
				{1123, 346, 127, 110, 103},
				{1159, 358, 116, 101, 98},
				{1199, 372, 115, 93, 92},
				{1253, 393, 118, 96, 95},
				{1353, 418, 123, 100, 98},
				{1521, 444, 130, 103, 101},
				{1732, 471, 138, 106, 102},
				{2007, 499, 146, 107, 99},
				{2405, 539, 150, 107, 100},
				{2933, 587, 150, 108, 101},
				{3487, 633, 153, 108, 102},
				{3921, 666, 157, 110, 103},
				{4260, 686, 162, 113, 105},
				{4679, 706, 168, 116, 107},
				{5099, 725, 175, 119, 108},
				{5675, 740, 183, 124, 113},
				{6488, 754, 192, 128, 117},
				{7153, 728, 185, 120, 109},
				{8975, 742, 180, 118, 108},
				{21801, 775, 187, 123, 113},
				{62336, 820, 203, 133, 116},
				{95900, 999, 229, 141, 126},
					}
};

static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4168, 4167, 4162, 4157, 4150},
				{4096, 4103, 4104, 4103, 4099},
				{4036, 4059, 4063, 4061, 4056},
				{3980, 4010, 4020, 4020, 4017},
				{3937, 3968, 3983, 3984, 3981},
				{3901, 3933, 3953, 3952, 3949},
				{3870, 3901, 3925, 3924, 3920},
				{3844, 3870, 3898, 3898, 3894},
				{3823, 3843, 3862, 3869, 3866},
				{3805, 3821, 3829, 3834, 3833},
				{3789, 3803, 3807, 3807, 3805},
				{3774, 3790, 3792, 3792, 3790},
				{3761, 3779, 3781, 3780, 3778},
				{3746, 3768, 3773, 3770, 3768},
				{3731, 3754, 3766, 3761, 3754},
				{3713, 3736, 3755, 3748, 3733},
				{3690, 3720, 3735, 3726, 3711},
				{3664, 3709, 3704, 3697, 3683},
				{3636, 3700, 3688, 3681, 3669},
				{3615, 3694, 3680, 3673, 3662},
				{3599, 3689, 3678, 3671, 3660},
				{3579, 3684, 3676, 3670, 3658},
				{3559, 3678, 3674, 3668, 3656},
				{3532, 3668, 3669, 3663, 3649},
				{3495, 3657, 3663, 3656, 3640},
				{3451, 3636, 3642, 3630, 3609},
				{3383, 3603, 3599, 3583, 3561},
				{3294, 3553, 3538, 3523, 3500},
				{3224, 3478, 3456, 3442, 3414},
				{3174, 3354, 3333, 3312, 3274},
				{3000, 3000, 3000, 3000, 3000}
	}
};

struct bms_battery_data LGC_BL44JR_1540_data = {
	.fcc				= 1540,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 212
};

