/* Copyright (c) 2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/err.h>
#include <linux/ctype.h>
#include <linux/io.h>
#include <linux/spinlock.h>
#include <linux/delay.h>
#include <linux/clk.h>
#include <linux/iopoll.h>
#include <linux/regulator/consumer.h>

#include <mach/rpm-regulator-smd.h>
#include <mach/socinfo.h>
#include <mach/rpm-smd.h>

#include "clock-local2.h"
#include "clock-pll.h"
#include "clock-rpm.h"
#include "clock-voter.h"
#include "clock.h"

/*
 * TODO: Drivers need to fill in the clock names and device names for the clocks
 *       they need to control.
 */
static struct clk_lookup msm_clocks_8084[] = {
	CLK_DUMMY("core_clk",   BLSP1_UART_CLK, "f991f000.serial", OFF),
	CLK_DUMMY("iface_clk",  BLSP1_UART_CLK, "f991f000.serial", OFF),
	CLK_DUMMY("core_clk",	SDC1_CLK,	"msm_sdcc.1", OFF),
	CLK_DUMMY("iface_clk",	SDC1_P_CLK,	"msm_sdcc.1", OFF),
	CLK_DUMMY("core_clk",	SDC2_CLK,	"msm_sdcc.2", OFF),
	CLK_DUMMY("iface_clk",	SDC2_P_CLK,	"msm_sdcc.2", OFF),
	CLK_DUMMY("xo",   NULL, "f9200000.qcom,ssusb", OFF),
	CLK_DUMMY("core_clk",   NULL, "f9200000.qcom,ssusb", OFF),
	CLK_DUMMY("iface_clk",  NULL, "f9200000.qcom,ssusb", OFF),
	CLK_DUMMY("sleep_clk",  NULL, "f9200000.qcom,ssusb", OFF),
	CLK_DUMMY("sleep_a_clk",   NULL, "f9200000.qcom,ssusb", OFF),
	CLK_DUMMY("utmi_clk",   NULL, "f9200000.qcom,ssusb", OFF),
	CLK_DUMMY("ref_clk",    NULL, "f9200000.qcom,ssusb", OFF),
	CLK_DUMMY("dfab_clk",	DFAB_CLK,	"msm_sps", OFF),
	CLK_DUMMY("dma_bam_pclk",	DMA_BAM_P_CLK,	"msm_sps", OFF),
	CLK_DUMMY("",	ufs_axi_clk_src.c,	"", OFF),
	CLK_DUMMY("",	usb30_master_clk_src.c,	"", OFF),
	CLK_DUMMY("",	usb30_sec_master_clk_src.c,	"", OFF),
	CLK_DUMMY("",	usb_hsic_ahb_clk_src.c,	"", OFF),
	CLK_DUMMY("",	sata_asic0_clk_src.c,	"", OFF),
	CLK_DUMMY("",	sata_pmalive_clk_src.c,	"", OFF),
	CLK_DUMMY("",	sata_rx_clk_src.c,	"", OFF),
	CLK_DUMMY("",	sata_rx_oob_clk_src.c,	"", OFF),
	CLK_DUMMY("",	sdcc1_apps_clk_src.c,	"", OFF),
	CLK_DUMMY("",	sdcc2_apps_clk_src.c,	"", OFF),
	CLK_DUMMY("",	sdcc3_apps_clk_src.c,	"", OFF),
	CLK_DUMMY("",	sdcc4_apps_clk_src.c,	"", OFF),
	CLK_DUMMY("",	tsif_ref_clk_src.c,	"", OFF),
	CLK_DUMMY("",	ufs_rx_cfg_postdiv_clk_src.c,	"", OFF),
	CLK_DUMMY("",	ufs_tx_cfg_postdiv_clk_src.c,	"", OFF),
	CLK_DUMMY("",	usb30_mock_utmi_clk_src.c,	"", OFF),
	CLK_DUMMY("",	usb30_sec_mock_utmi_clk_src.c,	"", OFF),
	CLK_DUMMY("",	usb_hs_system_clk_src.c,	"", OFF),
	CLK_DUMMY("",	usb_hsic_clk_src.c,	"", OFF),
	CLK_DUMMY("",	usb_hsic_io_cal_clk_src.c,	"", OFF),
	CLK_DUMMY("",	usb_hsic_mock_utmi_clk_src.c,	"", OFF),
	CLK_DUMMY("",	usb_hsic_system_clk_src.c,	"", OFF),
	CLK_DUMMY("",	gcc_bam_dma_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_bam_dma_inactivity_timers_clk.c,	"", OFF),
	CLK_DUMMY("iface_clk",	gcc_blsp1_ahb_clk.c,	"f9925000.i2c", OFF),
	CLK_DUMMY("",	gcc_blsp1_qup1_i2c_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp1_qup1_spi_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp1_qup2_i2c_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp1_qup2_spi_apps_clk.c,	"", OFF),
	CLK_DUMMY("core_clk",	gcc_blsp1_qup3_i2c_apps_clk.c,	"f9925000.i2c",
									OFF),
	CLK_DUMMY("",	gcc_blsp1_qup3_spi_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp1_qup4_i2c_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp1_qup4_spi_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp1_qup5_i2c_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp1_qup5_spi_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp1_qup6_i2c_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp1_qup6_spi_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp1_uart1_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp1_uart2_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp1_uart3_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp1_uart4_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp1_uart5_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp1_uart6_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_qup1_i2c_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_qup1_spi_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_qup2_i2c_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_qup2_spi_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_qup3_i2c_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_qup3_spi_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_qup4_i2c_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_qup4_spi_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_qup5_i2c_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_qup5_spi_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_qup6_i2c_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_qup6_spi_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_uart1_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_uart2_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_uart3_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_uart4_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_uart5_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_blsp2_uart6_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_boot_rom_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ce1_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ce1_axi_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ce1_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ce2_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ce2_axi_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ce2_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ce3_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ce3_axi_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ce3_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_copss_smmu_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_copss_smmu_axi_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_dcd_xo_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_bimc_gfx_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_xo_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_xo_div4_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_gp1_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_gp2_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_gp3_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_lpass_mport_axi_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_lpass_q6_axi_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_lpass_sway_clk.c,	"", OFF),
	CLK_DUMMY("mem_iface_clk",	gcc_mmss_bimc_gfx_clk.c,
				     "fdb00000.qcom,kgsl-3d0", OFF),
	CLK_DUMMY("",	gcc_mmss_vpu_maple_sys_noc_axi_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ocmem_noc_cfg_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_msg_ram_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_pdm2_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_pdm_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_pdm_xo4_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_periph_noc_usb_hsic_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_prng_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sata_asic0_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sata_axi_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sata_cfg_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sata_pmalive_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sata_rx_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sata_rx_oob_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sdcc1_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sdcc1_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sdcc1_cdccal_ff_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sdcc1_cdccal_sleep_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sdcc2_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sdcc2_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sdcc2_inactivity_timers_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sdcc3_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sdcc3_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sdcc3_inactivity_timers_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sdcc4_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sdcc4_apps_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sdcc4_inactivity_timers_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_spss_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_sys_noc_ufs_axi_clk.c,	"", OFF),
	CLK_DUMMY("mem_iface_clk",	gcc_sys_noc_usb3_axi_clk.c,
			"f9304000.qcom,usbbam", OFF),
	CLK_DUMMY("",	gcc_sys_noc_usb3_sec_axi_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_tsif_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_tsif_inactivity_timers_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_tsif_ref_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ufs_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ufs_axi_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ufs_rx_cfg_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ufs_rx_symbol_0_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ufs_rx_symbol_1_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ufs_tx_cfg_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ufs_tx_symbol_0_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_ufs_tx_symbol_1_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_usb2a_phy_sleep_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_usb2b_phy_sleep_clk.c,	"", OFF),
	CLK_DUMMY("mem_clk",	gcc_usb30_master_clk.c,	"f9304000.qcom,usbbam",
			OFF),
	CLK_DUMMY("",	gcc_usb30_mock_utmi_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_usb30_sleep_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_usb30_sec_master_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_usb30_sec_mock_utmi_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_usb30_sec_sleep_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_usb_hs_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_usb_hs_inactivity_timers_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_usb_hs_system_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_usb_hsic_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_usb_hsic_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_usb_hsic_io_cal_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_usb_hsic_io_cal_sleep_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_usb_hsic_mock_utmi_clk.c,	"", OFF),
	CLK_DUMMY("",	gcc_usb_hsic_system_clk.c,	"", OFF),

	CLK_DUMMY("",	axi_clk_src.c,	"", OFF),
	CLK_DUMMY("",	mmpll0_pll_clk_src.c,	"", OFF),
	CLK_DUMMY("",	mmpll1_pll_clk_src.c,	"", OFF),
	CLK_DUMMY("",	mmpll2_pll_clk_src.c,	"", OFF),
	CLK_DUMMY("",	mmpll3_pll_clk_src.c,	"", OFF),
	CLK_DUMMY("",	mmpll4_pll_clk_src.c,	"", OFF),
	CLK_DUMMY("",	csi0_clk_src.c,	"", OFF),
	CLK_DUMMY("",	csi1_clk_src.c,	"", OFF),
	CLK_DUMMY("",	csi2_clk_src.c,	"", OFF),
	CLK_DUMMY("",	csi3_clk_src.c,	"", OFF),
	CLK_DUMMY("",	vcodec0_clk_src.c,	"", OFF),
	CLK_DUMMY("",	vfe0_clk_src.c,	"", OFF),
	CLK_DUMMY("",	vfe1_clk_src.c,	"", OFF),
	CLK_DUMMY("",	edppixel_clk_src.c,	"", OFF),
	CLK_DUMMY("",	extpclk_clk_src.c,	"", OFF),
	CLK_DUMMY("",	mdp_clk_src.c,	"", OFF),
	CLK_DUMMY("",	pclk0_clk_src.c,	"", OFF),
	CLK_DUMMY("",	pclk1_clk_src.c,	"", OFF),
	CLK_DUMMY("",	ocmemnoc_clk_src.c,	"", OFF),
	CLK_DUMMY("",	gfx3d_clk_src.c,	"", OFF),
	CLK_DUMMY("",	vp_clk_src.c,	"", OFF),
	CLK_DUMMY("",	cci_clk_src.c,	"", OFF),
	CLK_DUMMY("",	gp0_clk_src.c,	"", OFF),
	CLK_DUMMY("",	gp1_clk_src.c,	"", OFF),
	CLK_DUMMY("",	jpeg0_clk_src.c,	"", OFF),
	CLK_DUMMY("",	jpeg1_clk_src.c,	"", OFF),
	CLK_DUMMY("",	jpeg2_clk_src.c,	"", OFF),
	CLK_DUMMY("",	mclk0_clk_src.c,	"", OFF),
	CLK_DUMMY("",	mclk1_clk_src.c,	"", OFF),
	CLK_DUMMY("",	mclk2_clk_src.c,	"", OFF),
	CLK_DUMMY("",	mclk3_clk_src.c,	"", OFF),
	CLK_DUMMY("",	csi0phytimer_clk_src.c,	"", OFF),
	CLK_DUMMY("",	csi1phytimer_clk_src.c,	"", OFF),
	CLK_DUMMY("",	csi2phytimer_clk_src.c,	"", OFF),
	CLK_DUMMY("",	cpp_clk_src.c,	"", OFF),
	CLK_DUMMY("",	byte0_clk_src.c,	"", OFF),
	CLK_DUMMY("",	byte1_clk_src.c,	"", OFF),
	CLK_DUMMY("",	edpaux_clk_src.c,	"", OFF),
	CLK_DUMMY("",	edplink_clk_src.c,	"", OFF),
	CLK_DUMMY("",	esc0_clk_src.c,	"", OFF),
	CLK_DUMMY("",	esc1_clk_src.c,	"", OFF),
	CLK_DUMMY("",	hdmi_clk_src.c,	"", OFF),
	CLK_DUMMY("",	vsync_clk_src.c,	"", OFF),
	CLK_DUMMY("",	rbbmtimer_clk_src.c,	"", OFF),
	CLK_DUMMY("",	maple_clk_src.c,	"", OFF),
	CLK_DUMMY("",	vdp_clk_src.c,	"", OFF),
	CLK_DUMMY("",	vpu_bus_clk_src.c,	"", OFF),
	CLK_DUMMY("",	dsi0_phy_pll_out_byteclk.c,	"", OFF),
	CLK_DUMMY("",	dsi0_phy_pll_out_dsiclk.c,	"", OFF),
	CLK_DUMMY("",	dsi1_phy_pll_out_byteclk.c,	"", OFF),
	CLK_DUMMY("",	dsi1_phy_pll_out_dsiclk.c,	"", OFF),
	CLK_DUMMY("",	edpphy_cc_link_clk.c,	"", OFF),
	CLK_DUMMY("",	edpphy_cc_vco_div_clk.c,	"", OFF),
	CLK_DUMMY("",	hdmi_phy_pll_out.c,	"", OFF),
	CLK_DUMMY("",	csiphy_bist_clk.c,	"", OFF),
	CLK_DUMMY("",	avsync_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	avsync_edppixel_clk.c,	"", OFF),
	CLK_DUMMY("",	avsync_extpclk_clk.c,	"", OFF),
	CLK_DUMMY("",	avsync_pclk0_clk.c,	"", OFF),
	CLK_DUMMY("",	avsync_pclk1_clk.c,	"", OFF),
	CLK_DUMMY("",	avsync_vp_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_cci_cci_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_cci_cci_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi0_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi0_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi0phy_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi0pix_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi0rdi_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi1_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi1_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi1phy_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi1pix_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi1rdi_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi2_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi2_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi2phy_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi2pix_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi2rdi_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi3_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi3_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi3phy_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi3pix_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi3rdi_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi_vfe0_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_csi_vfe1_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_gp0_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_gp1_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_ispif_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_jpeg_jpeg0_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_jpeg_jpeg1_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_jpeg_jpeg2_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_jpeg_jpeg_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_jpeg_jpeg_axi_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_mclk0_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_mclk1_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_mclk2_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_mclk3_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_micro_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_phy0_csi0phytimer_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_phy1_csi1phytimer_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_phy2_csi2phytimer_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_top_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_vfe_cpp_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_vfe_cpp_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_vfe_vfe0_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_vfe_vfe1_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_vfe_vfe_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	camss_vfe_vfe_axi_clk.c,	"", OFF),
	CLK_DUMMY("iface_clk", mdss_ahb_clk.c, "fd900000.qcom,mdss_mdp", OFF),
	CLK_DUMMY("bus_clk", mdss_axi_clk.c, "fd900000.qcom,mdss_mdp", OFF),
	CLK_DUMMY("core_clk_src", mdp_clk_src.c, "fd900000.qcom,mdss_mdp", OFF),
	CLK_DUMMY("",	mdss_edpaux_clk.c,	"", OFF),
	CLK_DUMMY("",	mdss_edplink_clk.c,	"", OFF),
	CLK_DUMMY("",	mdss_edppixel_clk.c,	"", OFF),
	CLK_DUMMY("byte_clk", mdss_byte0_clk.c, "fd922800.qcom,mdss_dsi", OFF),
	CLK_DUMMY("byte_clk", mdss_byte1_clk.c, "fd922e00.qcom,mdss_dsi", OFF),
	CLK_DUMMY("core_clk", mdss_esc0_clk.c, "fd922800.qcom,mdss_dsi", OFF),
	CLK_DUMMY("core_clk", mdss_esc1_clk.c, "fd922e00.qcom,mdss_dsi", OFF),
	CLK_DUMMY("iface_clk", mdss_ahb_clk.c, "fd922800.qcom,mdss_dsi", OFF),
	CLK_DUMMY("iface_clk", mdss_ahb_clk.c, "fd922e00.qcom,mdss_dsi", OFF),
	CLK_DUMMY("bus_clk", mdss_axi_clk.c, "fd922800.qcom,mdss_dsi", OFF),
	CLK_DUMMY("bus_clk", mdss_axi_clk.c, "fd922e00.qcom,mdss_dsi", OFF),
	CLK_DUMMY("pixel_clk", mdss_pclk0_clk.c, "fd922800.qcom,mdss_dsi", OFF),
	CLK_DUMMY("pixel_clk", mdss_pclk1_clk.c, "fd922e00.qcom,mdss_dsi", OFF),
	CLK_DUMMY("",	mdss_extpclk_clk.c,	"", OFF),
	CLK_DUMMY("",	mdss_hdmi_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	mdss_hdmi_clk.c,	"", OFF),
	CLK_DUMMY("core_clk", mdss_mdp_clk.c, "fd900000.qcom,mdss_mdp", OFF),
	CLK_DUMMY("lut_clk", mdss_mdp_lut_clk.c, "fd900000.qcom,mdss_mdp", OFF),
	CLK_DUMMY("vsync_clk", mdss_vsync_clk.c, "fd900000.qcom,mdss_mdp", OFF),
	CLK_DUMMY("",	mmss_misc_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	mmss_mmssnoc_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	mmss_mmssnoc_axi_clk.c,	"", OFF),
	CLK_DUMMY("",	mmss_s0_axi_clk.c,	"", OFF),
	CLK_DUMMY("core_clk",  ocmemgx_core_clk.c, "fdd00000.qcom,ocmem", OFF),
	CLK_DUMMY("iface_clk",	ocmemcx_ocmemnoc_clk.c,
						"fdd00000.qcom,ocmem", OFF),
	CLK_DUMMY("",	oxili_ocmemgx_clk.c,	"", OFF),
	CLK_DUMMY("core_clk",	oxili_gfx3d_clk.c,
				     "fdb00000.qcom,kgsl-3d0", OFF),
	CLK_DUMMY("",	oxili_rbbmtimer_clk.c,	"", OFF),
	CLK_DUMMY("iface_clk",	oxilicx_ahb_clk.c,
				     "fdb00000.qcom,kgsl-3d0", OFF),
	CLK_DUMMY("",	venus0_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	venus0_axi_clk.c,	"", OFF),
	CLK_DUMMY("",	venus0_core0_vcodec_clk.c,	"", OFF),
	CLK_DUMMY("",	venus0_core1_vcodec_clk.c,	"", OFF),
	CLK_DUMMY("",	venus0_ocmemnoc_clk.c,	"", OFF),
	CLK_DUMMY("",	venus0_vcodec0_clk.c,	"", OFF),
	CLK_DUMMY("iface_clk",	venus0_ahb_clk.c, "fdce0000.qcom,venus", OFF),
	CLK_DUMMY("bus_clk",	venus0_axi_clk.c, "fdce0000.qcom,venus", OFF),
	CLK_DUMMY("mem_clk",	venus0_ocmemnoc_clk.c,
						 "fdce0000.qcom,venus", OFF),
	CLK_DUMMY("core_clk",	venus0_vcodec0_clk.c,
						 "fdce0000.qcom,venus", OFF),
	CLK_DUMMY("",	vpu_ahb_clk.c,	"", OFF),
	CLK_DUMMY("",	vpu_axi_clk.c,	"", OFF),
	CLK_DUMMY("",	vpu_bus_clk.c,	"", OFF),
	CLK_DUMMY("",	vpu_cxo_clk.c,	"", OFF),
	CLK_DUMMY("",	vpu_maple_clk.c,	"", OFF),
	CLK_DUMMY("",	vpu_sleep_clk.c,	"", OFF),
	CLK_DUMMY("",	vpu_vdp_clk.c,	"", OFF),
	CLK_DUMMY("iface_clk", NULL, "fda64000.qcom,iommu", OFF),
	CLK_DUMMY("core_clk", NULL, "fda64000.qcom,iommu", OFF),
	CLK_DUMMY("alt_core_clk", NULL, "fda64000.qcom,iommu", OFF),
	CLK_DUMMY("iface_clk", NULL, "fda44000.qcom,iommu", OFF),
	CLK_DUMMY("core_clk", NULL, "fda44000.qcom,iommu", OFF),
	CLK_DUMMY("alt_core_clk", NULL, "fda44000.qcom,iommu", OFF),
	CLK_DUMMY("iface_clk", NULL, "fd928000.qcom,iommu", OFF),
	CLK_DUMMY("core_clk", NULL, "fd928000.qcom,iommu", oFF),
	CLK_DUMMY("core_clk", NULL, "fdb10000.qcom,iommu", OFF),
	CLK_DUMMY("iface_clk", NULL, "fdb10000.qcom,iommu", OFF),
	CLK_DUMMY("iface_clk", NULL, "fdc84000.qcom,iommu", OFF),
	CLK_DUMMY("alt_core_clk", NULL, "fdc84000.qcom,iommu", OFF),
	CLK_DUMMY("core_clk", NULL, "fdc84000.qcom,iommu", OFF),
	CLK_DUMMY("iface_clk", NULL, "f9bc4000.qcom,iommu", OFF),
	CLK_DUMMY("core_clk", NULL, "f9bc4000.qcom,iommu", OFF),
	CLK_DUMMY("iface_clk", NULL, "fdee4000.qcom,iommu", OFF),
	CLK_DUMMY("core_clk", NULL, "fdee4000.qcom,iommu", OFF),
	CLK_DUMMY("iface_clk", NULL, "fe054000.qcom,iommu", OFF),
	CLK_DUMMY("core_clk", NULL, "fe054000.qcom,iommu", OFF),
	CLK_DUMMY("iface_clk", NULL, "fe064000.qcom,iommu", OFF),
	CLK_DUMMY("core_clk", NULL, "fe064000.qcom,iommu", OFF),

	/* CoreSight clocks */
	CLK_DUMMY("core_clk", qdss_clk.c, "fc326000.tmc", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc324000.replicator", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc325000.tmc", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc323000.funnel", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc321000.funnel", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc322000.funnel", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc345000.funnel", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc355000.funnel", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc36c000.funnel", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc302000.stm", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc34c000.etm", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc34d000.etm", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc34e000.etm", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc34f000.etm", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc310000.cti", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc311000.cti", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc312000.cti", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc313000.cti", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc314000.cti", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc315000.cti", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc316000.cti", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc317000.cti", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc318000.cti", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc340000.cti", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc341000.cti", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc342000.cti", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc343000.cti", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fc344000.cti", OFF),
	CLK_DUMMY("core_clk", qdss_clk.c, "fd828018.hwevent", OFF),

	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc326000.tmc", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc324000.replicator", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc325000.tmc", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc323000.funnel", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc321000.funnel", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc322000.funnel", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc345000.funnel", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc355000.funnel", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc36c000.funnel", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc302000.stm", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc34c000.etm", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc34d000.etm", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc34e000.etm", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc34f000.etm", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc310000.cti", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc311000.cti", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc312000.cti", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc313000.cti", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc314000.cti", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc315000.cti", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc316000.cti", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc317000.cti", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc318000.cti", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc340000.cti", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc341000.cti", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc342000.cti", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc343000.cti", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fc344000.cti", OFF),
	CLK_DUMMY("core_a_clk", qdss_a_clk.c, "fd828018.hwevent", OFF),

	CLK_DUMMY("core_mmss_clk", mmss_misc_ahb_clk.c, "fd828018.hwevent",
		  OFF),

	CLK_DUMMY("iface_clk", gcc_prng_ahb_clk.c,
					"f9bff000.qcom,msm-rng", OFF),
};

struct clock_init_data msm8084_clock_init_data __initdata = {
	.table = msm_clocks_8084,
	.size = ARRAY_SIZE(msm_clocks_8084),
};
