#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/mman.h>

#include <cutils/properties.h>
#include <sys/atomics.h>

#define _REALLY_INCLUDE_SYS__SYSTEM_PROPERTIES_H_
#include <sys/_system_properties.h>

// sungrae.jo 2013.10.21 add type def for prop_info START
#if 0
struct prop_info {
    char name[PROP_NAME_MAX];
    unsigned volatile serial;
    char value[PROP_VALUE_MAX];
};
#else
struct prop_info {
    unsigned volatile serial;
    char value[PROP_VALUE_MAX];
    char name[0];
};
#endif
// sungrae.jo 2013.10.21 add type def for prop_info END

#if defined(NO_STATIC_LIBC)
unsigned dummy_props = 0;

prop_area *__system_property_area__ = (void*) &dummy_props;

int __system_properties_init(void)
{
    prop_area *pa;
    int s, fd;
    unsigned sz;
    char *env;

    env = getenv("ANDROID_PROPERTY_WORKSPACE");
    if (!env) {
        return -1;
    }
    fd = atoi(env);
    env = strchr(env, ',');
    if (!env) {
        return -1;
    }
    sz = atoi(env + 1);

    pa = mmap(0, sz, PROT_READ, MAP_SHARED, fd, 0);

    if(pa == MAP_FAILED) {
        return -1;
    }

    if((pa->magic != PROP_AREA_MAGIC) || (pa->version != PROP_AREA_VERSION)) {
        munmap(pa, sz);
        return -1;
    }

    __system_property_area__ = pa;

    return 0;
}

const prop_info *__system_property_find(const char *name)
{
    prop_area *pa = __system_property_area__;
    unsigned count = pa->count;
    unsigned *toc = pa->toc;
    unsigned len = strlen(name);
    prop_info *pi;

    while(count--) {
        unsigned entry = *toc++;
        if(TOC_NAME_LEN(entry) != len) continue;

        pi = TOC_TO_INFO(pa, entry);
        if(memcmp(name, pi->name, len)) continue;

        return pi;
    }

    return 0;
}
#endif
const char* propertyget(const char *name)
{
    prop_info *pi;

    if(strlen(name) >= PROP_NAME_MAX) return 0;

    pi = (prop_info*) __system_property_find(name);

    if(pi != 0) {
        return pi->value;
    } else {
        return 0;
    }
}
//#endif
#if 0
int main(int argc, char *argv[])
{
    char value[PROPERTY_VALUE_MAX];

    __system_properties_init();
    printf("%s\n",propertyget("ro.build.version.release"));

    return 0;
}

#endif

const char *getfirmware()
{
    __system_properties_init();
    return propertyget("ro.build.version.release");
}
