LOCAL_PATH:= $(call my-dir)
commands_brd_local_path := $(LOCAL_PATH)
#############################################################################
# Add Tar libdl gzip
#subdirs := $(addprefix $(LOCAL_PATH)/,$(addsuffix /Android.mk, \
                tar \
                libdl \
                gzip \
		zlib \
		libs \
        ))

#include $(subdirs)

include $(call all-makefiles-under,$(LOCAL_PATH))
#############################################################################

LOCAL_PATH:= $(commands_brd_local_path)

include $(CLEAR_VARS)


LOCAL_SRC_FILES := \
	server.cpp\
	hw_key.c\
	getproperty.c\
	crypt.c\
	list.cpp

#LOCAL_CFLAGS += -O2 -g -DADB_HOST=0 -Wall -Wno-unused-parameter -DLGE_BNR -DUI_IMAGE
LOCAL_CFLAGS += -DRECOVERY_API_VERSION=$(RECOVERY_API_VERSION)
#LOCAL_CFLAGS += -DLGE_BNR -DUI_IMAGE
LOCAL_CFLAGS += -DLGE_BNR

LOCAL_C_INCLUDES += external/openssl/include

# This binary is in the recovery ramdisk, which is otherwise a copy of root.
# It gets copied there in config/Makefile.  LOCAL_MODULE_TAGS suppresses
# a (redundant) copy of the binary in /system/bin for user builds.
# TODO: Build the ramdisk image in a more principled way.
LOCAL_MODULE_TAGS := optional

LOCAL_MODULE := brd

LOCAL_MODULE_PATH := $(TARGET_ROOT_OUT_SBIN)
LOCAL_UNSTRIPPED_PATH := $(TARGET_ROOT_OUT_SBIN_UNSTRIPPED)

LOCAL_FORCE_STATIC_EXECUTABLE := true

RECOVERY_API_VERSION := 3
LOCAL_CFLAGS += -DRECOVERY_API_VERSION=$(RECOVERY_API_VERSION)

LOCAL_STATIC_LIBRARIES += $(TARGET_RECOVERY_UI_LIB)
LOCAL_STATIC_LIBRARIES += libminzip libunz libmtdutils libmincrypt
LOCAL_STATIC_LIBRARIES += libminui libpixelflinger_static libpng libcutils
LOCAL_STATIC_LIBRARIES += libstdc++ libc libz
LOCAL_STATIC_LIBRARIES += libcrypto_bnr

include $(BUILD_EXECUTABLE)

###############################################################################
# clearlock
include $(CLEAR_VARS)
LOCAL_C_INCLUDES := \
        external/sqlite/dist

# NOTE the following flags,
#   SQLITE_TEMP_STORE=3 causes all TEMP files to go into RAM. and thats the behavior we want
#   SQLITE_ENABLE_FTS3   enables usage of FTS3 - NOT FTS1 or 2.
#   SQLITE_DEFAULT_AUTOVACUUM=1  causes the databases to be subject to auto-vacuum
LOCAL_CFLAGS += -DHAVE_USLEEP=1 -DSQLITE_DEFAULT_JOURNAL_SIZE_LIMIT=1048576 -DSQLITE_THREADSAFE=1 -DNDEBUG=1 -DSQLITE_ENABLE_MEMORY_MANAGEMENT=1 -DSQLITE_DEFAULT_AUTOVACUUM=1 -DSQLITE_TEMP_STORE=3 -DSQLITE_ENABLE_FTS3 -DSQLITE_ENABLE_FTS3_BACKWARDS
LOCAL_CFLAGS += -O3 -fno-unwind-tables -DUSE_WAL_AS_DEFAULT -DUSE_DB_WAL_SYNC -DSQLITE_DEFAULT_FILE_FORMAT=4 -Dfdatasync=fdatasync -D_GNU_SOURCE -DSQLITE_DEFAULT_PAGE_SIZE=4096 -DPREVENT_RESULTSET_FROM_CHECKPOINT
# Explanation of compile option from yi.jang
# Use "USE_WAL_AS_DEFAULT" to enable WAL journal mode as a default mode
# Use "USE_SYNC_NORMAL_IN_WAL" to change synchronous mode to NORMAL
# Use "USE_DB_WAL_SYNC" to clear existing journal files(journal, wal, shm) when create a new database file
# End

LOCAL_SRC_FILES := clearlock.c sqlite3.c

LOCAL_MODULE := clearlock

LOCAL_MODULE_PATH := $(TARGET_ROOT_OUT_SBIN)

LOCAL_UNSTRIPPED_PATH := $(TARGET_ROOT_OUT_SBIN_UNSTRIPPED)

LOCAL_FORCE_STATIC_EXECUTABLE := true

LOCAL_MODULE_TAGS := optional

LOCAL_STATIC_LIBRARIES += libc libstdc++ libdl libdl libm libcutils libutils_bnr
#LOCAL_SHARED_LIBRARIES += libutils

LOCAL_LDLIBS += -lpthread -ldl

include $(BUILD_EXECUTABLE)
###############################################################################
