# Copyright (C) 2009 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
LOCAL_PATH := $(call my-dir)

include $(CLEAR_VARS)

LOCAL_MODULE    := libWbxmlParser

LOCAL_MODULE_TAGS := optional

LOCAL_PRELINK_MODULE := false

LOCAL_CFLAGS    += 	-I$(LOCAL_PATH)/libwbxml\

LOCAL_SRC_FILES :=		libwbxml/wbxml_base64.c\
					libwbxml/wbxml_buffers.c\
					libwbxml/wbxml_charset.c\
					libwbxml/wbxml_conv.c\
					libwbxml/wbxml_elt.c\
					libwbxml/wbxml_encoder.c\
					libwbxml/wbxml_errors.c\
					libwbxml/wbxml_lists.c\
					libwbxml/wbxml_log.c\
					libwbxml/wbxml_mem.c\
					libwbxml/wbxml_parser.c\
					libwbxml/wbxml_tables.c\
					libwbxml/wbxml_tree.c\
					libwbxml/wbxml_tree_clb_wbxml.c\
					libwbxml/wbxml_tree_clb_xml.c\
					libwbxml/wbxml_wrap_syncml.c\


LOCAL_LDLIBS	:= \
					-nostdlib \
					-Wl,-shared,-Bsymbolic \
					-Wl,--no-undefined \
					-fno-rtti -fno-exceptions \
					-L$(SYSROOT)/usr/lib -llog
					
					
					
#					-Xlinker --start-group \
#					-lBhComposer -lBrowserInterface -lCryptoComponent -lEFCInterface -lEmailPlugin -lEmbiderVectorEngine -lHTMLViewer \
#					-lLangPlugin -lMMIFramework -lMessaging -lMiddlewareComponent -lNetworkComponent -lPorting -lSQLComponent -lSecureProtocolPlugin \
#					-lStorageComponent -lXFWComponent -lXWHTMLComponent \
#					-Xlinker --end-group \
					
# LIBS :=	-L$(SYSROOT)/usr/lib -llog

include $(BUILD_SHARED_LIBRARY)