#ifndef __LEDS_QPNP_H_INCLUDED
#define __LEDS_QPNP_H_INCLUDED

/*  duty pcts array is...
 *   0......62
 *   LUT TABLE
 *   63      64    65    66
 *   START, LENGTH, DUTY, PAUSE [RED]
 *   67     68     69    70
 *   START, LENGTH, DUTY, PAUSE [GREEN]
 *   71      72     73    74
 *   START, LENGTH, DUTY, PAUSE [BLUE]
 *   75   76   77    78
 *   R_FLAG G_FLAG B_FLAG RAMP_STEP_MS
 */

/* Default */
static int leds_pwm_duty_pcts0[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 0, 0,
	1, 1, 0, 0,
	1, 1, 0, 0,
	0, 0, 0, 65
};

/* #1 ID_POWER_ON (GB) */
static int leds_pwm_duty_pcts1[79] = {
/*	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,*/	/* R : 0 */ // original
	  0,  2,  6, 10, 18, 25, 31, 38, 45, 52,
	 58, 65, 71, 75, 82, 86, 91, 94, 97, 99,
	100,	/* R : 0 ~ 255 */// for single led
	0, 3, 6, 12, 18, 25, 31, 37, 43, 48,
	53, 57, 61, 65, 68, 71, 74, 74, 75, 73,
	72,	/* G : 183 ~ 255 */
	0, 0, 0, 0, 0, 0, 0, 4, 8, 14,
	19, 28, 36, 43, 50, 56, 61, 71, 81, 91,
	100,	/* B : 0 ~ 85 */
/*	0, 21, 0, 0,*/ // red original
	0, 21, 255, 0, // for single led
	21, 21, 255, 0,
	42, 21, 85, 0,
	7, 7, 7, 50
};

/* #2 ID_LCD_ON (RGB) - A1 not use */
static int leds_pwm_duty_pcts2[79] = {
	100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
	100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
	100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
	100, 100, 100, 100,  99,  98,  95,  90,  85,  79,
	 73,  65,  58,  50,  42,  35,  27,  21,  15,  10,
	  5,   2,   1,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,
	  1,  54,  19,  0,
	  1,  54,  19,  0,
	  1,  54,  19,  0,
	  2,   2,   2, 65
};

/* #3 ID_CHARGING (R) */
static int leds_pwm_duty_pcts3[79] = {
#if !defined(NOT_USE_ILLUMINANCE_SENSOR)
	10, 10, 11, 12, 13, 15, 16, 18, 20, 23,
	26, 31, 35, 42, 48, 54, 60, 66, 72, 77,
	82, 87, 92, 95, 98, 99, 100, 100, 100, 100,
	100, 100, 100,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 0 */
	0, 33, 255, 0,
	0, 33, 0, 0,
	0, 33, 0, 0,
	7, 7, 7, 90
#else
	10, 10, 10, 11, 11, 12, 12, 14, 15, 18,
	21, 24, 27, 30, 32, 35, 37, 39, 41, 43,
	45, 46, 47, 48, 49, 50, 50, 50, 50, 50,
	50, 50, 50,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 0 */
	0, 33, 255, 0,
	0, 33, 0, 0,
	0, 33, 0, 0,
	7, 7, 7, 90
#endif
};

/* #4 ID_CHARGING_FULL (RG) */
static int leds_pwm_duty_pcts4[79] = {
#if !defined(NOT_USE_ILLUMINANCE_SENSOR)
/*	43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
	43,	*/ /* R : 122 */ // red original
	90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
	90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
	90,	/* R : 122 */ // for single led
	90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
	90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
	90,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
/*	0, 21, 122, 0,*/ // red original
	0, 21, 255, 0, // for single led
	21, 21, 255, 0,
	42, 21, 0, 0,
	3, 3, 3, 90
#else
/*	43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
	43,	*/ /* R : 122 */ // red original
	45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
	45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
	45,	/* R : 122 */ // for single led
	45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
	45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
	45,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
/*	0, 21, 122, 0,*/ // red original
	0, 21, 255, 0, // for single led
	21, 21, 255, 0,
	42, 21, 0, 0,
	3, 3, 3, 90
#endif
};

/* #5 ID_CALENDAR_REMIND (GB) - A1 use framework pattern */
static int leds_pwm_duty_pcts5[79] = {
	100, 99, 98, 97, 95, 93, 90, 88, 84, 81,
	77, 73, 68, 64, 59, 54, 48, 43, 37, 31,
	25, 19, 13, 6, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 100, 99, 98, 97, 95,
	93, 90, 88, 84, 81, 77, 73, 68, 64, 59,
	54, 48, 43, 37, 31, 25, 19, 13, 6, 0, 0, 0, 0,
/*	1, 60, 0, 0,*/ // red original
	1, 60, 12, 0, // for single led
	1, 60, 12, 0,
	1, 60, 12, 0,
	2, 2, 2, 65
};

/* #6 ID_POWER_OFF (GB) */
static int leds_pwm_duty_pcts6[79] = {
/*	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	*/ /* R : 0 */ // red original
	  0,  2,  6, 10, 18, 25, 31, 38, 45, 52,
	 58, 65, 71, 75, 82, 86, 91, 94, 97, 99,
	100,	/* R : 0 ~ 255 */// for single led
	0, 3, 6, 12, 18, 25, 31, 37, 43, 48,
	53, 57, 61, 65, 68, 71, 74, 74, 75, 73,
	72,	/* G : 183 ~ 255 */
	0, 0, 0, 0, 0, 0, 0, 4, 8, 14,
	19, 28, 36, 43, 50, 56, 61, 71, 81, 91,
	100,	/* B : 0 ~ 85 */
/*	0, 21, 0, 0,*/ // red original
	0, 21, 255, 0, // for single led
	21, 21, 255, 0,
	42, 21, 85, 0,
	7, 7, 7, 50
};

/* #7 ID_MISSED_NOTI (G) */
static int leds_pwm_duty_pcts7[79] = {
/*	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, */	/* R : 0 */ // red original
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */ // for single led
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
/*	0, 21, 0, 11475, */ // red original
	21, 21, 255, 11475, // for single led
	21, 21, 255, 11475,
	42, 21, 0, 11475,
	11, 11, 11, 25
};

/* #8 ID_ALARM (RG) - A1 use framework pattern */
static int leds_pwm_duty_pcts8[79] = {
	100, 100, 100, 100, 98, 96, 90, 84, 83, 81,
	80, 77, 73, 69, 64, 60, 55, 50, 45, 40,
	34, 29, 23, 17, 12, 6, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 3, 5, 8, 10, 13,
	18, 23, 25, 27, 29, 31, 33, 34, 35, 30,
	26, 23, 21, 20, 19, 10, 8, 5, 1, 0, 0, 0, 0,
	1, 31, 36, 8,
	32, 31, 36, 8,
	32, 1, 0, 8,
	11, 11, 11, 65
};

/* #12 ID_VOLUME_UP (RB) -A1 not use */
static int leds_pwm_duty_pcts12[79] = {
	100, 100, 99, 98, 96, 94, 91, 88, 84, 81,
	76, 72, 67, 63, 58, 53, 47, 42, 37, 33,
	28, 24, 19, 16, 12, 9, 6, 4, 2, 1,
	0, 71, 70, 70, 69, 68, 66, 64, 62, 60,
	57, 54, 51, 48, 44, 41, 37, 34, 30, 26,
	23, 20, 17, 14, 11, 9, 6, 4, 3, 2, 1, 0, 0,
	1, 31, 26, 0,
	32, 1, 0, 0,
	32, 31, 26, 0,
	2, 2, 2, 65
};

/* #13 ID_VOLUME_DOWN (GB) -A1 not use*/
static int leds_pwm_duty_pcts13[79] = {
	49, 49, 49, 48, 47, 46, 45, 43, 42, 40,
	38, 36, 33, 31, 28, 26, 23, 21, 19, 16,
	14, 12, 10, 8, 6, 4, 3, 2, 1, 1,
	0, 100, 100, 99, 98, 96, 94, 91, 88, 84,
	81, 76, 72, 67, 63, 58, 53, 47, 42, 37,
	33, 28, 24, 19, 16, 12, 9, 6, 4, 2, 1, 0, 0,
/*	1, 1, 0, 0, */ // red original
	32, 31, 26, 0, // for single led
	1, 31, 26, 0,
	32, 31, 26, 0,
	2, 2, 2, 65
};

/* #14 ID_FAVORITE_MISSED_NOTI (RGB) -A1 not use */
static int leds_pwm_duty_pcts14[79] = {
	100, 100, 100, 100, 100, 92, 84, 76, 68, 60,
	52, 44, 36, 28, 20, 100, 100, 100, 100, 100,
	90, 80, 70, 60, 50, 40, 30, 20, 10, 0,
	40, 40, 40, 40, 40, 37, 34, 30, 27, 24,
	21, 18, 14, 11, 8, 40, 40, 40, 40, 40,
	36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 0, 0, 0,
	0, 30, 47, 2590,
	30, 30, 47, 2590,
	30, 30, 47, 2590,
	11, 11, 11, 65
};

/* #17 ID_MISSED_NOTI_BLUE (GB) */
static int leds_pwm_duty_pcts17[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 30, 29, 28, 22, 15, 7, 0, 0, 0,
	0, 0, 0, 0, 30, 29, 28, 22, 15, 7,
	0,	/* G : 77 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* B : 255 */
/*	0, 21, 0, 11475, */ //red original
	42, 21, 255, 11475, // for single led
	21, 21, 77, 11475,
	42, 21, 255, 11475,
	11, 11, 11, 25
};

/* #18 ID_MISSED_NOTI_PINK (RGB) */
static int leds_pwm_duty_pcts18[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 26, 25, 24, 19, 12, 6, 0, 0, 0,
	0, 0, 0, 0, 26, 25, 24, 19, 12, 6,
	0,	/* G : 65 */
	0, 26, 25, 24, 19, 12, 6, 0, 0, 0,
	0, 0, 0, 0, 26, 25, 24, 19, 12, 6,
	0,	/* B : 65 */
	0, 21, 255, 11475,
	21, 21, 65, 11475,
	42, 21, 65, 11475,
	11, 11, 11, 25
};

/* #19 ID_MISSED_NOTI_YELLOW (RG) */
static int leds_pwm_duty_pcts19[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 90, 89, 88, 66, 44, 22, 0, 0, 0,
	0, 0, 0, 0, 90, 89, 88, 66, 44, 22,
	0,	/* G : 230 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 230, 11475,
	42, 21, 0, 11475,
	11, 11, 11, 25
};

/* #20 ID_MISSED_NOTI_ORANGE (RG) */
static int leds_pwm_duty_pcts20[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 40, 39, 38, 29, 20, 10, 0, 0, 0,
	0, 0, 0, 0, 40, 39, 38, 29, 20, 10,
	0,	/* G : 102 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 102, 11475,
	42, 21, 0, 11475,
	11, 11, 11, 25
};

/* #29 ID_MISSED_NOTI_TURQUOISE (GB) */
static int leds_pwm_duty_pcts29[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 48, 47, 46, 35, 23, 11, 0, 0, 0,
	0, 0, 0, 0, 48, 47, 46, 35, 23, 11,
	0,	/* B : 122 */
/*	0, 21, 0, 11475, */ // red original
	21, 21, 255, 11475, // for single led
	21, 21, 255, 11475,
	42, 21, 122, 11475,
	11, 11, 11, 25
};

/* #30 ID_MISSED_NOTI_PURPLE (RGB) */
static int leds_pwm_duty_pcts30[79] = {
	0, 69, 68, 67, 50, 33, 16, 0, 0, 0,
	0, 0, 0, 0, 69, 68, 67, 50, 33, 16,
	0,	/* R : 175 */
	0, 10, 9, 8, 7, 4, 2, 0, 0, 0,
	0, 0, 0, 0, 10, 9, 8, 7, 4, 2,
	0,	/* G : 25 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* B : 255 */
/*	0, 21, 175, 11475, */ //red original
	42, 21, 255, 11475, // for single led
	21, 21, 25, 11475,
	42, 21, 255, 11475,
	11, 11, 11, 25
};

/* #31 ID_MISSED_NOTI_RED (R) */
static int leds_pwm_duty_pcts31[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 0, 11475,
	42, 21, 0, 11475,
	11, 11, 11, 25
};

/* #32 ID_MISSED_NOTI_LIME (RG) */
static int leds_pwm_duty_pcts32[79] = {
	0, 53, 52, 51, 39, 26, 13, 0,  0,  0,
	0, 0,  0,  0,  53, 52, 51, 39, 26, 13,
	0,	/* R : 135 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
/*	0, 21, 135, 11475, */ // red original
	21, 21, 255, 11475, // for single red
	21, 21, 255, 11475,
	42, 21, 0, 11475,
	11, 11, 11, 25
};

/* #37 ID_URGENT_CALL_MISSED_NOTI (R) */
static int leds_pwm_duty_pcts37[79] = {
	  0,100, 99, 98, 73, 49, 24,  0,  0,  0,
	100, 99, 98, 73, 49, 24,  0,  0,  0,100,
	 99, 98, 73, 49, 24,  0,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	  0,  0,  0,  0,  0,  0,  0,
	  0, 26,255, 11350, /* R : 255 */
	  0,  1,  0, 11975,
	  0,  1,  0, 11975,
	 11, 11, 11, 25
};

/* #39 ID_MISSED_NOTI_ONCE (G) */
static int leds_pwm_duty_pcts39[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
/*	0, 21, 0, 0, */ // red original
	21, 21, 255, 0, // for single led
	21, 21, 255, 0,
	42, 21, 0, 0,
	2, 2, 2, 25
};

/* #40 ID_MISSED_NOTI_BLUE_ONCE (GB) */
static int leds_pwm_duty_pcts40[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 30, 29, 28, 22, 15, 7, 0, 0, 0,
	0, 0, 0, 0, 30, 29, 28, 22, 15, 7,
	0,	/* G : 77 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* B : 255 */
/*	0, 21, 0, 0, */ //red original
	42, 21, 255, 0, // for single led
	21, 21, 77, 0,
	42, 21, 255, 0,
	2, 2, 2, 25
};

/* #41 ID_MISSED_NOTI_PINK_ONCE (RGB) */
static int leds_pwm_duty_pcts41[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 26, 25, 24, 19, 12, 6, 0, 0, 0,
	0, 0, 0, 0, 26, 25, 24, 19, 12, 6,
	0,	/* G : 65 */
	0, 26, 25, 24, 19, 12, 6, 0, 0, 0,
	0, 0, 0, 0, 26, 25, 24, 19, 12, 6,
	0,	/* B : 65 */
	0, 21, 255, 0,
	21, 21, 65, 0,
	42, 21, 65, 0,
	2, 2, 2, 25
};

/* #42 ID_MISSED_NOTI_YELLOW_ONCE (RG) */
static int leds_pwm_duty_pcts42[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 90, 89, 88, 66, 44, 22, 0, 0, 0,
	0, 0, 0, 0, 90, 89, 88, 66, 44, 22,
	0,	/* G : 230 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 230, 0,
	42, 21, 0, 0,
	2, 2, 2, 25
};

/* #43 ID_MISSED_NOTI_ORANGE_ONCE (RG) */
static int leds_pwm_duty_pcts43[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 40, 39, 38, 29, 20, 10, 0, 0, 0,
	0, 0, 0, 0, 40, 39, 38, 29, 20, 10,
	0,	/* G : 102 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 102, 0,
	42, 21, 0, 0,
	2, 2, 2, 25
};

/* #44 ID_MISSED_NOTI_TURQUOISE_ONCE (GB) */
static int leds_pwm_duty_pcts44[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 48, 47, 46, 35, 23, 11, 0, 0, 0,
	0, 0, 0, 0, 48, 47, 46, 35, 23, 11,
	0,	/* B : 122 */
/*	0, 21, 0, 0, */ //red original
	21, 21, 255, 0, // for single led
	21, 21, 255, 0,
	42, 21, 122, 0,
	2, 2, 2, 25
};

/* #45 ID_MISSED_NOTI_PURPLE_ONCE (RGB) */
static int leds_pwm_duty_pcts45[79] = {
	0, 69, 68, 67, 50, 33, 16, 0, 0, 0,
	0, 0, 0, 0, 69, 68, 67, 50, 33, 16,
	0,	/* R : 175 */
	0, 10, 9, 8, 7, 4, 2, 0, 0, 0,
	0, 0, 0, 0, 10, 9, 8, 7, 4, 2,
	0,	/* G : 25 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* B : 255 */
/*	0, 21, 175, 0, */ // red original
	42, 21, 255, 0, // for single led
	21, 21, 25, 0,
	42, 21, 255, 0,
	2, 2, 2, 25
};

/* #46 ID_MISSED_NOTI_RED_ONCE (R) */
static int leds_pwm_duty_pcts46[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 0, 0,
	42, 21, 0, 0,
	2, 2, 2, 25
};

/* #47 ID_MISSED_NOTI_LIME_ONCE (RG) */
static int leds_pwm_duty_pcts47[79] = {
	0, 53, 52, 51, 39, 26, 13, 0, 0, 0,
	0, 0, 0, 0, 53, 52, 51, 39, 26, 13,
	0,	/* R : 135 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
/*	0, 21, 135, 0, */ //red original
	21, 21, 255, 0, // for single led
	21, 21, 255, 0,
	42, 21, 0, 0,
	2, 2, 2, 25
};

/* #101 ID_FELICA_ON (GB)  */
static int leds_pwm_duty_pcts101[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 100, 100, 100, 100, 100, 100, 100, 100, 100,
	100, 84, 68, 46, 23, 12, 0, 0, 0, 0,
	0,	/* G : 255 */
	0, 100, 100, 100, 100, 100, 100, 100, 100, 100,
	100, 84, 68, 46, 23, 12, 0, 0, 0, 0,
	0,	/* B : 255 */
/*	0, 21, 0, 0, */ // red original
	21, 21, 255, 0, // for single led
	21, 21, 255, 0,
	42, 21, 255, 0,
	2, 2, 2, 50
};

/* #102 ID_GPS_ENABLED (B) */
static int leds_pwm_duty_pcts102[79] = {
	50, 50, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 50, 0, 50, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* R : 0 */
	0, 0, 0, 0, 0, 50, 0, 50, 50, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 255 */
/*	0, 63, 0, 0, */ //red original
	0, 63, 255, 0, // for single led
	0, 63, 0, 0,
	0, 63, 255, 0,
	3, 3, 3, 97
};

static struct pwm_duty_cycles leds_pwm_duty_cycles = {
	.duty_pcts0 = (int *)&leds_pwm_duty_pcts0,
	.duty_pcts1 = (int *)&leds_pwm_duty_pcts1,
	.duty_pcts2 = (int *)&leds_pwm_duty_pcts2,
	.duty_pcts3 = (int *)&leds_pwm_duty_pcts3,
	.duty_pcts4 = (int *)&leds_pwm_duty_pcts4,
	.duty_pcts5 = (int *)&leds_pwm_duty_pcts5,
	.duty_pcts6 = (int *)&leds_pwm_duty_pcts6,
	.duty_pcts7 = (int *)&leds_pwm_duty_pcts7,
	.duty_pcts8 = (int *)&leds_pwm_duty_pcts8,
	.duty_pcts12 = (int *)&leds_pwm_duty_pcts12,
	.duty_pcts13 = (int *)&leds_pwm_duty_pcts13,
	.duty_pcts14 = (int *)&leds_pwm_duty_pcts14,
	.duty_pcts17 = (int *)&leds_pwm_duty_pcts17,
	.duty_pcts18 = (int *)&leds_pwm_duty_pcts18,
	.duty_pcts19 = (int *)&leds_pwm_duty_pcts19,
	.duty_pcts20 = (int *)&leds_pwm_duty_pcts20,
	.duty_pcts29 = (int *)&leds_pwm_duty_pcts29,
	.duty_pcts30 = (int *)&leds_pwm_duty_pcts30,
	.duty_pcts31 = (int *)&leds_pwm_duty_pcts31,
	.duty_pcts32 = (int *)&leds_pwm_duty_pcts32,
	.duty_pcts37 = (int *)&leds_pwm_duty_pcts37,
	.duty_pcts39 = (int *)&leds_pwm_duty_pcts39,
	.duty_pcts40 = (int *)&leds_pwm_duty_pcts40,
	.duty_pcts41 = (int *)&leds_pwm_duty_pcts41,
	.duty_pcts42 = (int *)&leds_pwm_duty_pcts42,
	.duty_pcts43 = (int *)&leds_pwm_duty_pcts43,
	.duty_pcts44 = (int *)&leds_pwm_duty_pcts44,
	.duty_pcts45 = (int *)&leds_pwm_duty_pcts45,
	.duty_pcts46 = (int *)&leds_pwm_duty_pcts46,
	.duty_pcts47 = (int *)&leds_pwm_duty_pcts47,
	.duty_pcts101 = (int *)&leds_pwm_duty_pcts101,
	.duty_pcts102 = (int *)&leds_pwm_duty_pcts102,
	.num_duty_pcts = ARRAY_SIZE(leds_pwm_duty_pcts0),
};


#if defined(CONFIG_LEDS_WINDOW_COLOR)
/*
* G3 brightness tunning value
* front window (WHITE) - green MAX : 79
*		R/G/B = 87/79/88
* front window (BLACK) - green MAX : 12
* 		R/G/B = ??/12/??
*/

/* for WHITE pattern START */
/* #1 ID_POWER_ON (GB) */
static int leds_pwm_duty_pcts1_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 3, 6, 12, 18, 25, 31, 37, 43, 48,
	53, 57, 61, 65, 68, 71, 74, 74, 75, 73,
	72,	/* G : 183 ~ 255 */
	0, 0, 0, 0, 0, 0, 0, 4, 8, 14,
	19, 28, 36, 43, 50, 56, 61, 71, 81, 91,
	100,	/* B : 0 ~ 85 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 85, 0,
	7, 7, 7, 50
};

/* #3 ID_CHARGING (R) */
static int leds_pwm_duty_pcts3_wh[79] = {
#if !defined(NOT_USE_ILLUMINANCE_SENSOR)
	10, 10, 11, 12, 13, 15, 16, 18, 20, 23,
	26, 31, 35, 42, 48, 54, 60, 66, 72, 77,
	82, 87, 92, 95, 98, 99, 100, 100, 100, 100,
	100, 100, 100,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 0 */
	0, 33, 255, 0,
	0, 33, 0, 0,
	0, 33, 0, 0,
	7, 7, 7, 90
#else
	10, 10, 10, 11, 11, 12, 12, 14, 15, 18,
	21, 24, 27, 30, 32, 35, 37, 39, 41, 43,
	45, 46, 47, 48, 49, 50, 50, 50, 50, 50,
	50, 50, 50,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 0 */
	0, 33, 255, 0,
	0, 33, 0, 0,
	0, 33, 0, 0,
	7, 7, 7, 90
#endif
};

/* #4 ID_CHARGING_FULL (RG) */
static int leds_pwm_duty_pcts4_wh[79] = {
#if !defined(NOT_USE_ILLUMINANCE_SENSOR)
	43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
	43,	/* R : 122 */
	90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
	90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
	90,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 122, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	3, 3, 3, 90
#else
	22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
	22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
	22,	/* R : 122 */
	45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
	45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
	45,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 122, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	3, 3, 3, 90
#endif
};

/* #6 ID_POWER_OFF (GB) */
static int leds_pwm_duty_pcts6_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 3, 6, 12, 18, 25, 31, 37, 43, 48,
	53, 57, 61, 65, 68, 71, 74, 74, 75, 73,
	72,	/* G : 183 ~ 255 */
	0, 0, 0, 0, 0, 0, 0, 4, 8, 14,
	19, 28, 36, 43, 50, 56, 61, 71, 81, 91,
	100,	/* B : 0 ~ 85 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 85, 0,
	7, 7, 7, 50
};

/* #7 ID_MISSED_NOTI (G) */
static int leds_pwm_duty_pcts7_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 11475,
	21, 21, 255, 11475,
	42, 21, 0, 11475,
	11, 11, 11, 25
};

/* #17 ID_MISSED_NOTI_BLUE (GB) */
static int leds_pwm_duty_pcts17_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 30, 29, 28, 22, 15, 7, 0, 0, 0,
	0, 0, 0, 0, 30, 29, 28, 22, 15, 7,
	0,	/* G : 77 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* B : 255 */
	0, 21, 0, 11475,
	21, 21, 77, 11475,
	42, 21, 255, 11475,
	11, 11, 11, 25
};

/* #18 ID_MISSED_NOTI_PINK (RGB) */
static int leds_pwm_duty_pcts18_wh[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 26, 25, 24, 19, 12, 6, 0, 0, 0,
	0, 0, 0, 0, 26, 25, 24, 19, 12, 6,
	0,	/* G : 65 */
	0, 26, 25, 24, 19, 12, 6, 0, 0, 0,
	0, 0, 0, 0, 26, 25, 24, 19, 12, 6,
	0,	/* B : 65 */
	0, 21, 255, 11475,
	21, 21, 65, 11475,
	42, 21, 65, 11475,
	11, 11, 11, 25
};

/* #19 ID_MISSED_NOTI_YELLOW (RG) */
static int leds_pwm_duty_pcts19_wh[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 90, 89, 88, 66, 44, 22, 0, 0, 0,
	0, 0, 0, 0, 90, 89, 88, 66, 44, 22,
	0,	/* G : 230 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 230, 11475,
	42, 21, 0, 11475,
	11, 11, 11, 25
};

/* #20 ID_MISSED_NOTI_ORANGE (RG) */
static int leds_pwm_duty_pcts20_wh[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 40, 39, 38, 29, 20, 10, 0, 0, 0,
	0, 0, 0, 0, 40, 39, 38, 29, 20, 10,
	0,	/* G : 102 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 102, 11475,
	42, 21, 0, 11475,
	11, 11, 11, 25
};

/* #29 ID_MISSED_NOTI_TURQUOISE (GB) */
static int leds_pwm_duty_pcts29_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 48, 47, 46, 35, 23, 11, 0, 0, 0,
	0, 0, 0, 0, 48, 47, 46, 35, 23, 11,
	0,	/* B : 122 */
	0, 21, 0, 11475,
	21, 21, 255, 11475,
	42, 21, 122, 11475,
	11, 11, 11, 25
};

/* #30 ID_MISSED_NOTI_PURPLE (RGB) */
static int leds_pwm_duty_pcts30_wh[79] = {
	0, 69, 68, 67, 50, 33, 16, 0, 0, 0,
	0, 0, 0, 0, 69, 68, 67, 50, 33, 16,
	0,	/* R : 175 */
	0, 10, 9, 8, 7, 4, 2, 0, 0, 0,
	0, 0, 0, 0, 10, 9, 8, 7, 4, 2,
	0,	/* G : 25 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* B : 255 */
	0, 21, 175, 11475,
	21, 21, 25, 11475,
	42, 21, 255, 11475,
	11, 11, 11, 25
};

/* #31 ID_MISSED_NOTI_RED (R) */
static int leds_pwm_duty_pcts31_wh[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 0, 11475,
	42, 21, 0, 11475,
	11, 11, 11, 25
};

/* #32 ID_MISSED_NOTI_LIME (RG) */
static int leds_pwm_duty_pcts32_wh[79] = {
	0, 53, 52, 51, 39, 26, 13, 0, 0, 0,
	0, 0, 0, 0, 53, 52, 51, 39, 26, 13,
	0,	/* R : 135 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 135, 11475,
	21, 21, 255, 11475,
	42, 21, 0, 11475,
	11, 11, 11, 25
};

/* #37 ID_URGENT_CALL_MISSED_NOTI (R) */
static int leds_pwm_duty_pcts37_wh[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	100, 99, 98, 73, 49, 24, 0, 0, 0, 100,
	99, 98, 73, 49, 24, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0,	/* R : 255 */
	0, 26, 255, 11350,
	0, 1, 0, 11975,
	0, 1, 0, 11975,
	11, 11, 11, 25
};

/* #39 ID_MISSED_NOTI_ONCE (G) */
static int leds_pwm_duty_pcts39_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	2, 2, 2, 25
};

/* #40 ID_MISSED_NOTI_BLUE_ONCE (GB) */
static int leds_pwm_duty_pcts40_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 30, 29, 28, 22, 15, 7, 0, 0, 0,
	0, 0, 0, 0, 30, 29, 28, 22, 15, 7,
	0,	/* G : 77 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* B : 255 */
	0, 21, 0, 0,
	21, 21, 77, 0,
	42, 21, 255, 0,
	2, 2, 2, 25
};

/* #41 ID_MISSED_NOTI_PINK_ONCE (RGB) */
static int leds_pwm_duty_pcts41_wh[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 26, 25, 24, 19, 12, 6, 0, 0, 0,
	0, 0, 0, 0, 26, 25, 24, 19, 12, 6,
	0,	/* G : 65 */
	0, 26, 25, 24, 19, 12, 6, 0, 0, 0,
	0, 0, 0, 0, 26, 25, 24, 19, 12, 6,
	0,	/* B : 65 */
	0, 21, 255, 0,
	21, 21, 65, 0,
	42, 21, 65, 0,
	2, 2, 2, 25
};

/* #42 ID_MISSED_NOTI_YELLOW_ONCE (RG) */
static int leds_pwm_duty_pcts42_wh[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 90, 89, 88, 66, 44, 22, 0, 0, 0,
	0, 0, 0, 0, 90, 89, 88, 66, 44, 22,
	0,	/* G : 230 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 230, 0,
	42, 21, 0, 0,
	2, 2, 2, 25
};

/* #43 ID_MISSED_NOTI_ORANGE_ONCE (RG) */
static int leds_pwm_duty_pcts43_wh[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 40, 39, 38, 29, 20, 10, 0, 0, 0,
	0, 0, 0, 0, 40, 39, 38, 29, 20, 10,
	0,	/* G : 102 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 102, 0,
	42, 21, 0, 0,
	2, 2, 2, 25
};

/* #44 ID_MISSED_NOTI_TURQUOISE_ONCE (GB) */
static int leds_pwm_duty_pcts44_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 48, 47, 46, 35, 23, 11, 0, 0, 0,
	0, 0, 0, 0, 48, 47, 46, 35, 23, 11,
	0,	/* B : 122 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 122, 0,
	2, 2, 2, 25
};

/* #45 ID_MISSED_NOTI_PURPLE_ONCE (RGB) */
static int leds_pwm_duty_pcts45_wh[79] = {
	0, 69, 68, 67, 50, 33, 16, 0, 0, 0,
	0, 0, 0, 0, 69, 68, 67, 50, 33, 16,
	0,	/* R : 175 */
	0, 10, 9, 8, 7, 4, 2, 0, 0, 0,
	0, 0, 0, 0, 10, 9, 8, 7, 4, 2,
	0,	/* G : 25 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* B : 255 */
	0, 21, 175, 0,
	21, 21, 25, 0,
	42, 21, 255, 0,
	2, 2, 2, 25
};

/* #46 ID_MISSED_NOTI_RED_ONCE (R) */
static int leds_pwm_duty_pcts46_wh[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 0, 0,
	42, 21, 0, 0,
	2, 2, 2, 25
};

/* #47 ID_MISSED_NOTI_LIME_ONCE (RG) */
static int leds_pwm_duty_pcts47_wh[79] = {
	0, 53, 52, 51, 39, 26, 13, 0, 0, 0,
	0, 0, 0, 0, 53, 52, 51, 39, 26, 13,
	0,	/* R : 135 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 135, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	2, 2, 2, 25
};

/* #101 ID_FELICA_ON (GB)  */
static int leds_pwm_duty_pcts101_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 100, 100, 100, 100, 100, 100, 100, 100, 100,
	100, 84, 68, 46, 23, 12, 0, 0, 0, 0,
	0,	/* G : 255 */
	0, 100, 100, 100, 100, 100, 100, 100, 100, 100,
	100, 84, 68, 46, 23, 12, 0, 0, 0, 0,
	0,	/* B : 255 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 255, 0,
	2, 2, 2, 50
};

/* #102 ID_GPS_ENABLED (B) */
static int leds_pwm_duty_pcts102_wh[79] = {
	50, 50, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 50, 0, 50, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* R : 0 */
	0, 0, 0, 0, 0, 50, 0, 50, 50, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 255 */
	0, 63, 0, 0,
	0, 63, 0, 0,
	0, 63, 255, 0,
	3, 3, 3, 97
};

/* for BLACK pattern START */
/* #1 ID_POWER_ON (GB) */
static int leds_pwm_duty_pcts1_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 3, 6, 12, 18, 25, 31, 37, 43, 48,
	53, 57, 61, 65, 68, 71, 74, 74, 75, 73,
	72,	/* G : 183 ~ 255 */
	0, 0, 0, 0, 0, 0, 0, 4, 8, 14,
	19, 28, 36, 43, 50, 56, 61, 71, 81, 91,
	100,	/* B : 0 ~ 85 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 85, 0,
	7, 7, 7, 50
};

/* #3 ID_CHARGING (R) */
static int leds_pwm_duty_pcts3_bk[79] = {
#if !defined(NOT_USE_ILLUMINANCE_SENSOR)
	10, 10, 11, 12, 13, 15, 16, 18, 20, 23,
	26, 31, 35, 42, 48, 54, 60, 66, 72, 77,
	82, 87, 92, 95, 98, 99, 100, 100, 100, 100,
	100, 100, 100,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 0 */
	0, 33, 255, 0,
	0, 33, 0, 0,
	0, 33, 0, 0,
	7, 7, 7, 90
#else
	10, 10, 10, 11, 11, 12, 12, 14, 15, 18,
	21, 24, 27, 30, 32, 35, 37, 39, 41, 43,
	45, 46, 47, 48, 49, 50, 50, 50, 50, 50,
	50, 50, 50,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 0 */
	0, 33, 255, 0,
	0, 33, 0, 0,
	0, 33, 0, 0,
	7, 7, 7, 90
#endif
};

/* #4 ID_CHARGING_FULL (RG) */
static int leds_pwm_duty_pcts4_bk[79] = {
#if !defined(NOT_USE_ILLUMINANCE_SENSOR)
	43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
	43,	/* R : 122 */
	90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
	90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
	90,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 122, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	3, 3, 3, 90
#else
	22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
	22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
	22,	/* R : 122 */
	45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
	45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
	45,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 122, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	3, 3, 3, 90
#endif
};

/* #6 ID_POWER_OFF (GB) */
static int leds_pwm_duty_pcts6_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 3, 6, 12, 18, 25, 31, 37, 43, 48,
	53, 57, 61, 65, 68, 71, 74, 74, 75, 73,
	72,	/* G : 183 ~ 255 */
	0, 0, 0, 0, 0, 0, 0, 4, 8, 14,
	19, 28, 36, 43, 50, 56, 61, 71, 81, 91,
	100,	/* B : 0 ~ 85 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 85, 0,
	7, 7, 7, 50
};

/* #7 ID_MISSED_NOTI (G) */
static int leds_pwm_duty_pcts7_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 11475,
	21, 21, 255, 11475,
	42, 21, 0, 11475,
	11, 11, 11, 25
};

/* #17 ID_MISSED_NOTI_BLUE (GB) */
static int leds_pwm_duty_pcts17_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 30, 29, 28, 22, 15, 7, 0, 0, 0,
	0, 0, 0, 0, 30, 29, 28, 22, 15, 7,
	0,	/* G : 77 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* B : 255 */
	0, 21, 0, 11475,
	21, 21, 77, 11475,
	42, 21, 255, 11475,
	11, 11, 11, 25
};

/* #18 ID_MISSED_NOTI_PINK (RGB) */
static int leds_pwm_duty_pcts18_bk[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 26, 25, 24, 19, 12, 6, 0, 0, 0,
	0, 0, 0, 0, 26, 25, 24, 19, 12, 6,
	0,	/* G : 65 */
	0, 26, 25, 24, 19, 12, 6, 0, 0, 0,
	0, 0, 0, 0, 26, 25, 24, 19, 12, 6,
	0,	/* B : 65 */
	0, 21, 255, 11475,
	21, 21, 65, 11475,
	42, 21, 65, 11475,
	11, 11, 11, 25
};

/* #19 ID_MISSED_NOTI_YELLOW (RG) */
static int leds_pwm_duty_pcts19_bk[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 90, 89, 88, 66, 44, 22, 0, 0, 0,
	0, 0, 0, 0, 90, 89, 88, 66, 44, 22,
	0,	/* G : 230 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 230, 11475,
	42, 21, 0, 11475,
	11, 11, 11, 25
};

/* #20 ID_MISSED_NOTI_ORANGE (RG) */
static int leds_pwm_duty_pcts20_bk[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 40, 39, 38, 29, 20, 10, 0, 0, 0,
	0, 0, 0, 0, 40, 39, 38, 29, 20, 10,
	0,	/* G : 102 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 102, 11475,
	42, 21, 0, 11475,
	11, 11, 11, 25
};

/* #29 ID_MISSED_NOTI_TURQUOISE (GB) */
static int leds_pwm_duty_pcts29_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 48, 47, 46, 35, 23, 11, 0, 0, 0,
	0, 0, 0, 0, 48, 47, 46, 35, 23, 11,
	0,	/* B : 122 */
	0, 21, 0, 11475,
	21, 21, 255, 11475,
	42, 21, 122, 11475,
	11, 11, 11, 25
};

/* #30 ID_MISSED_NOTI_PURPLE (RGB) */
static int leds_pwm_duty_pcts30_bk[79] = {
	0, 69, 68, 67, 50, 33, 16, 0, 0, 0,
	0, 0, 0, 0, 69, 68, 67, 50, 33, 16,
	0,	/* R : 175 */
	0, 10, 9, 8, 7, 4, 2, 0, 0, 0,
	0, 0, 0, 0, 10, 9, 8, 7, 4, 2,
	0,	/* G : 25 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* B : 255 */
	0, 21, 175, 11475,
	21, 21, 25, 11475,
	42, 21, 255, 11475,
	11, 11, 11, 25
};

/* #31 ID_MISSED_NOTI_RED (R) */
static int leds_pwm_duty_pcts31_bk[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 0, 11475,
	42, 21, 0, 11475,
	11, 11, 11, 25
};

/* #32 ID_MISSED_NOTI_LIME (RG) */
static int leds_pwm_duty_pcts32_bk[79] = {
	0, 53, 52, 51, 39, 26, 13, 0, 0, 0,
	0, 0, 0, 0, 53, 52, 51, 39, 26, 13,
	0,	/* R : 135 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 135, 11475,
	21, 21, 255, 11475,
	42, 21, 0, 11475,
	11, 11, 11, 25
};

/* #37 ID_URGENT_CALL_MISSED_NOTI (R) */
static int leds_pwm_duty_pcts37_bk[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	100, 99, 98, 73, 49, 24, 0, 0, 0, 100,
	99, 98, 73, 49, 24, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0,	/* R : 255 */
	0, 26, 255, 11350,
	0, 1, 0, 11975,
	0, 1, 0, 11975,
	11, 11, 11, 25
};

/* #39 ID_MISSED_NOTI_ONCE (G) */
static int leds_pwm_duty_pcts39_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	2, 2, 2, 25
};

/* #40 ID_MISSED_NOTI_BLUE_ONCE (GB) */
static int leds_pwm_duty_pcts40_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 30, 29, 28, 22, 15, 7, 0, 0, 0,
	0, 0, 0, 0, 30, 29, 28, 22, 15, 7,
	0,	/* G : 77 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* B : 255 */
	0, 21, 0, 0,
	21, 21, 77, 0,
	42, 21, 255, 0,
	2, 2, 2, 25
};

/* #41 ID_MISSED_NOTI_PINK_ONCE (RGB) */
static int leds_pwm_duty_pcts41_bk[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 26, 25, 24, 19, 12, 6, 0, 0, 0,
	0, 0, 0, 0, 26, 25, 24, 19, 12, 6,
	0,	/* G : 65 */
	0, 26, 25, 24, 19, 12, 6, 0, 0, 0,
	0, 0, 0, 0, 26, 25, 24, 19, 12, 6,
	0,	/* B : 65 */
	0, 21, 255, 0,
	21, 21, 65, 0,
	42, 21, 65, 0,
	2, 2, 2, 25
};

/* #42 ID_MISSED_NOTI_YELLOW_ONCE (RG) */
static int leds_pwm_duty_pcts42_bk[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 90, 89, 88, 66, 44, 22, 0, 0, 0,
	0, 0, 0, 0, 90, 89, 88, 66, 44, 22,
	0,	/* G : 230 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 230, 0,
	42, 21, 0, 0,
	2, 2, 2, 25
};

/* #43 ID_MISSED_NOTI_ORANGE_ONCE (RG) */
static int leds_pwm_duty_pcts43_bk[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 40, 39, 38, 29, 20, 10, 0, 0, 0,
	0, 0, 0, 0, 40, 39, 38, 29, 20, 10,
	0,	/* G : 102 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 102, 0,
	42, 21, 0, 0,
	2, 2, 2, 25
};

/* #44 ID_MISSED_NOTI_TURQUOISE_ONCE (GB) */
static int leds_pwm_duty_pcts44_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 48, 47, 46, 35, 23, 11, 0, 0, 0,
	0, 0, 0, 0, 48, 47, 46, 35, 23, 11,
	0,	/* B : 122 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 122, 0,
	2, 2, 2, 25
};

/* #45 ID_MISSED_NOTI_PURPLE_ONCE (RGB) */
static int leds_pwm_duty_pcts45_bk[79] = {
	0, 69, 68, 67, 50, 33, 16, 0, 0, 0,
	0, 0, 0, 0, 69, 68, 67, 50, 33, 16,
	0,	/* R : 175 */
	0, 10, 9, 8, 7, 4, 2, 0, 0, 0,
	0, 0, 0, 0, 10, 9, 8, 7, 4, 2,
	0,	/* G : 25 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* B : 255 */
	0, 21, 175, 0,
	21, 21, 25, 0,
	42, 21, 255, 0,
	2, 2, 2, 25
};

/* #46 ID_MISSED_NOTI_RED_ONCE (R) */
static int leds_pwm_duty_pcts46_bk[79] = {
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 0, 0,
	42, 21, 0, 0,
	2, 2, 2, 25
};

/* #47 ID_MISSED_NOTI_LIME_ONCE (RG) */
static int leds_pwm_duty_pcts47_bk[79] = {
	0, 53, 52, 51, 39, 26, 13, 0, 0, 0,
	0, 0, 0, 0, 53, 52, 51, 39, 26, 13,
	0,	/* R : 135 */
	0, 100, 99, 98, 73, 49, 24, 0, 0, 0,
	0, 0, 0, 0, 100, 99, 98, 73, 49, 24,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 135, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	2, 2, 2, 25
};

/* #101 ID_FELICA_ON (GB)  */
static int leds_pwm_duty_pcts101_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 100, 100, 100, 100, 100, 100, 100, 100, 100,
	100, 84, 68, 46, 23, 12, 0, 0, 0, 0,
	0,	/* G : 255 */
	0, 100, 100, 100, 100, 100, 100, 100, 100, 100,
	100, 84, 68, 46, 23, 12, 0, 0, 0, 0,
	0,	/* B : 255 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 255, 0,
	2, 2, 2, 50
};

/* #102 ID_GPS_ENABLED (B) */
static int leds_pwm_duty_pcts102_bk[79] = {
	50, 50, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 50, 0, 50, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* R : 0 */
	0, 0, 0, 0, 0, 50, 0, 50, 50, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 255 */
	0, 63, 0, 0,
	0, 63, 0, 0,
	0, 63, 255, 0,
	3, 3, 3, 97
};

static struct pwm_duty_cycles leds_pwm_duty_cycles_wh = {
	.duty_pcts0 = (int *)&leds_pwm_duty_pcts0,
	.duty_pcts1 = (int *)&leds_pwm_duty_pcts1_wh,
	.duty_pcts2 = (int *)&leds_pwm_duty_pcts2,
	.duty_pcts3 = (int *)&leds_pwm_duty_pcts3_wh,
	.duty_pcts4 = (int *)&leds_pwm_duty_pcts4_wh,
	.duty_pcts5 = (int *)&leds_pwm_duty_pcts5,
	.duty_pcts6 = (int *)&leds_pwm_duty_pcts6_wh,
	.duty_pcts7 = (int *)&leds_pwm_duty_pcts7_wh,
	.duty_pcts8 = (int *)&leds_pwm_duty_pcts8,
	.duty_pcts12 = (int *)&leds_pwm_duty_pcts12,
	.duty_pcts13 = (int *)&leds_pwm_duty_pcts13,
	.duty_pcts14 = (int *)&leds_pwm_duty_pcts14,
	.duty_pcts17 = (int *)&leds_pwm_duty_pcts17_wh,
	.duty_pcts18 = (int *)&leds_pwm_duty_pcts18_wh,
	.duty_pcts19 = (int *)&leds_pwm_duty_pcts19_wh,
	.duty_pcts20 = (int *)&leds_pwm_duty_pcts20_wh,
	.duty_pcts29 = (int *)&leds_pwm_duty_pcts29_wh,
	.duty_pcts30 = (int *)&leds_pwm_duty_pcts30_wh,
	.duty_pcts31 = (int *)&leds_pwm_duty_pcts31_wh,
	.duty_pcts32 = (int *)&leds_pwm_duty_pcts32_wh,
	.duty_pcts37 = (int *)&leds_pwm_duty_pcts37_wh,
	.duty_pcts39 = (int *)&leds_pwm_duty_pcts39_wh,
	.duty_pcts40 = (int *)&leds_pwm_duty_pcts40_wh,
	.duty_pcts41 = (int *)&leds_pwm_duty_pcts41_wh,
	.duty_pcts42 = (int *)&leds_pwm_duty_pcts42_wh,
	.duty_pcts43 = (int *)&leds_pwm_duty_pcts43_wh,
	.duty_pcts44 = (int *)&leds_pwm_duty_pcts44_wh,
	.duty_pcts45 = (int *)&leds_pwm_duty_pcts45_wh,
	.duty_pcts46 = (int *)&leds_pwm_duty_pcts46_wh,
	.duty_pcts47 = (int *)&leds_pwm_duty_pcts47_wh,
	.duty_pcts101 = (int *)&leds_pwm_duty_pcts101_wh,
	.duty_pcts102 = (int *)&leds_pwm_duty_pcts102_wh,
	.num_duty_pcts = ARRAY_SIZE(leds_pwm_duty_pcts0),
};

static struct pwm_duty_cycles leds_pwm_duty_cycles_bk = {
	.duty_pcts0 = (int *)&leds_pwm_duty_pcts0,
	.duty_pcts1 = (int *)&leds_pwm_duty_pcts1_bk,
	.duty_pcts2 = (int *)&leds_pwm_duty_pcts2,
	.duty_pcts3 = (int *)&leds_pwm_duty_pcts3_bk,
	.duty_pcts4 = (int *)&leds_pwm_duty_pcts4_bk,
	.duty_pcts5 = (int *)&leds_pwm_duty_pcts5,
	.duty_pcts6 = (int *)&leds_pwm_duty_pcts6_bk,
	.duty_pcts7 = (int *)&leds_pwm_duty_pcts7_bk,
	.duty_pcts8 = (int *)&leds_pwm_duty_pcts8,
	.duty_pcts12 = (int *)&leds_pwm_duty_pcts12,
	.duty_pcts13 = (int *)&leds_pwm_duty_pcts13,
	.duty_pcts14 = (int *)&leds_pwm_duty_pcts14,
	.duty_pcts17 = (int *)&leds_pwm_duty_pcts17_bk,
	.duty_pcts18 = (int *)&leds_pwm_duty_pcts18_bk,
	.duty_pcts19 = (int *)&leds_pwm_duty_pcts19_bk,
	.duty_pcts20 = (int *)&leds_pwm_duty_pcts20_bk,
	.duty_pcts29 = (int *)&leds_pwm_duty_pcts29_bk,
	.duty_pcts30 = (int *)&leds_pwm_duty_pcts30_bk,
	.duty_pcts31 = (int *)&leds_pwm_duty_pcts31_bk,
	.duty_pcts32 = (int *)&leds_pwm_duty_pcts32_bk,
	.duty_pcts37 = (int *)&leds_pwm_duty_pcts37_bk,
	.duty_pcts39 = (int *)&leds_pwm_duty_pcts39_bk,
	.duty_pcts40 = (int *)&leds_pwm_duty_pcts40_bk,
	.duty_pcts41 = (int *)&leds_pwm_duty_pcts41_bk,
	.duty_pcts42 = (int *)&leds_pwm_duty_pcts42_bk,
	.duty_pcts43 = (int *)&leds_pwm_duty_pcts43_bk,
	.duty_pcts44 = (int *)&leds_pwm_duty_pcts44_bk,
	.duty_pcts45 = (int *)&leds_pwm_duty_pcts45_bk,
	.duty_pcts46 = (int *)&leds_pwm_duty_pcts46_bk,
	.duty_pcts47 = (int *)&leds_pwm_duty_pcts47_bk,
	.duty_pcts101 = (int *)&leds_pwm_duty_pcts101_bk,
	.duty_pcts102 = (int *)&leds_pwm_duty_pcts102_bk,
	.num_duty_pcts = ARRAY_SIZE(leds_pwm_duty_pcts0),
};
#endif

#endif	/* __LEDS_QPNP_H_INCLUDED */
