/* Copyright (c) 2011-2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {4635, 4639, 4636, 4625, 4586},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{1115, 209, 100, 91, 92},
				{1115, 209, 100, 91, 92},
				{1133, 216, 101, 92, 92},
				{1178, 222, 103, 94, 94},
				{1088, 240, 106, 95, 95},
				{1106, 250, 110, 98, 96},
				{1110, 248, 113, 100, 97},
				{1121, 247, 120, 103, 99},
				{1147, 229, 127, 109, 103},
				{1186, 223, 105, 95, 94},
				{1235, 226, 103, 94, 94},
				{1290, 232, 106, 96, 95},
				{1353, 241, 107, 97, 96},
				{1432, 256, 108, 99, 97},
				{1520, 280, 110, 96, 94},
				{1610, 309, 111, 96, 94},
				{1709, 345, 112, 97, 95},
				{1788, 377, 115, 98, 94},
				{1848, 414, 117, 99, 96},
				{1842, 442, 121, 100, 96},
				{1855, 459, 124, 102, 96},
				{1894, 480, 126, 102, 98},
				{1941, 505, 130, 102, 98},
				{1997, 527, 130, 102, 97},
				{2060, 544, 128, 102, 97},
				{2140, 562, 131, 103, 98},
				{2321, 593, 134, 104, 99},
				{2769, 635, 141, 108, 101},
				{3503, 693, 150, 115, 105},
				{4852, 784, 176, 140, 123},
	}
};

static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4280, 4278, 4273, 4269, 4262},
				{4187, 4209, 4210, 4208, 4203},
				{4124, 4155, 4156, 4154, 4150},
				{4078, 4104, 4105, 4104, 4100},
				{3991, 4058, 4060, 4057, 4053},
				{3950, 4007, 4013, 4012, 4010},
				{3908, 3963, 3974, 3974, 3970},
				{3871, 3922, 3939, 3939, 3935},
				{3844, 3877, 3900, 3902, 3900},
				{3826, 3844, 3852, 3852, 3851},
				{3810, 3819, 3826, 3826, 3825},
				{3795, 3800, 3807, 3806, 3806},
				{3780, 3786, 3790, 3790, 3789},
				{3764, 3776, 3776, 3776, 3775},
				{3747, 3766, 3766, 3760, 3750},
				{3728, 3750, 3753, 3743, 3729},
				{3705, 3723, 3728, 3719, 3707},
				{3682, 3698, 3695, 3687, 3671},
				{3662, 3685, 3679, 3672, 3661},
				{3647, 3678, 3675, 3669, 3658},
				{3638, 3674, 3673, 3667, 3656},
				{3626, 3670, 3671, 3664, 3653},
				{3612, 3664, 3666, 3659, 3647},
				{3595, 3651, 3655, 3645, 3629},
				{3572, 3628, 3626, 3615, 3596},
				{3543, 3591, 3583, 3572, 3552},
				{3505, 3540, 3529, 3517, 3498},
				{3451, 3474, 3460, 3449, 3430},
				{3374, 3384, 3369, 3358, 3340},
				{3252, 3250, 3238, 3226, 3212},
				{3000, 3000, 3000, 3000, 3000}
	}
};

struct bms_battery_data LGE_LGC_4600mAH_data = {
	.fcc				= 4600,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 102,
	.flat_ocv_threshold_uv	= 3800000,
};
