#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {4120, 4122, 4121, 4113, 4080},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{1082, 225, 100, 89, 89},
				{1085, 238, 103, 92, 90},
				{1085, 238, 103, 92, 90},
				{1073, 247, 106, 93, 91},
				{1086, 253, 110, 96, 92},
				{1096, 258, 113, 98, 94},
				{1106, 261, 118, 101, 95},
				{1124, 260, 125, 105, 98},
				{1144, 261, 120, 106, 98},
				{1165, 263, 107, 94, 92},
				{1189, 270, 106, 92, 91},
				{1230, 284, 107, 96, 92},
				{1278, 304, 110, 98, 94},
				{1333, 329, 115, 100, 95},
				{1399, 354, 119, 98, 94},
				{1471, 381, 119, 97, 92},
				{1560, 410, 119, 98, 93},
				{1641, 448, 118, 97, 92},
				{1707, 487, 120, 98, 93},
				{1751, 519, 125, 101, 94},
				{1767, 535, 128, 103, 94},
				{1764, 544, 132, 105, 95},
				{1738, 544, 135, 105, 96},
				{1784, 561, 138, 105, 95},
				{1844, 579, 136, 102, 94},
				{1956, 596, 133, 102, 95},
				{2228, 616, 135, 105, 96},
				{2568, 646, 141, 107, 99},
				{3093, 687, 151, 116, 105},
				{4274, 772, 195, 140, 128}
	}
};


static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4170, 4168, 4164, 4160, 4154},
				{4102, 4108, 4108, 4106, 4103},
				{4045, 4067, 4067, 4065, 4060},
				{3986, 4017, 4023, 4022, 4021},
				{3946, 3977, 3986, 3986, 3985},
				{3912, 3942, 3955, 3954, 3952},
				{3881, 3909, 3926, 3925, 3922},
				{3855, 3876, 3898, 3898, 3895},
				{3832, 3846, 3861, 3864, 3862},
				{3811, 3821, 3828, 3828, 3828},
				{3792, 3803, 3807, 3807, 3807},
				{3776, 3788, 3792, 3793, 3792},
				{3760, 3777, 3780, 3780, 3779},
				{3744, 3766, 3772, 3770, 3767},
				{3729, 3755, 3764, 3758, 3749},
				{3711, 3739, 3750, 3742, 3729},
				{3690, 3720, 3727, 3718, 3705},
				{3668, 3704, 3698, 3691, 3681},
				{3647, 3692, 3683, 3676, 3665},
				{3630, 3683, 3679, 3673, 3662},
				{3620, 3677, 3677, 3672, 3661},
				{3610, 3672, 3676, 3670, 3659},
				{3600, 3665, 3673, 3666, 3655},
				{3585, 3654, 3666, 3659, 3645},
				{3568, 3636, 3648, 3638, 3621},
				{3543, 3608, 3611, 3598, 3581},
				{3511, 3567, 3560, 3547, 3531},
				{3467, 3510, 3495, 3481, 3467},
				{3401, 3431, 3408, 3395, 3382},
				{3290, 3308, 3279, 3268, 3257},
				{3000, 3000, 3000, 3000, 3000}
	}
};


struct bms_battery_data LGE_LGC_4200mAh_data = {
	.fcc				= 4200,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 139
};
