#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {2042, 2094, 2100, 2096, 2080},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{971, 294, 100, 78, 70},
				{935, 294, 100, 78, 70},
				{900, 300, 104, 81, 71},
				{847, 299, 107, 83, 73},
				{798, 300, 111, 85, 75},
				{779, 270, 114, 86, 76},
				{764, 258, 119, 89, 78},
				{767, 248, 121, 94, 81},
				{806, 242, 105, 90, 77},
				{864, 240, 96, 78, 72},
				{918, 239, 97, 80, 73},
				{966, 257, 99, 82, 76},
				{1035, 295, 100, 84, 78},
				{1176, 337, 102, 82, 77},
				{1352, 372, 107, 80, 73},
				{1623, 402, 111, 82, 73},
				{2097, 436, 113, 83, 74},
				{2723, 470, 120, 88, 76},
				{3311, 476, 126, 93, 79},
				{3651, 470, 132, 96, 89},
				{3594, 476, 141, 104, 92},
				{3993, 473, 149, 106, 94},
				{4629, 477, 159, 110, 95},
				{5452, 486, 169, 113, 98},
				{6620, 501, 180, 120, 102},
				{8246, 528, 194, 131, 107},
				{10434, 607, 210, 144, 115},
				{13119, 784, 226, 159, 125},
				{16455, 1087, 245, 175, 140},
				{21505, 1741, 365, 241, 201}
			}
};


static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4324, 4323, 4317, 4311, 4302},
				{4181, 4222, 4237, 4237, 4233},
				{4094, 4149, 4173, 4175, 4172},
				{4024, 4089, 4116, 4121, 4119},
				{3951, 4043, 4070, 4075, 4076},
				{3900, 3980, 4027, 4031, 4030},
				{3854, 3933, 3984, 3987, 3986},
				{3819, 3891, 3940, 3944, 3943},
				{3800, 3854, 3887, 3895, 3891},
				{3782, 3822, 3847, 3851, 3853},
				{3763, 3795, 3820, 3825, 3826},
				{3741, 3779, 3798, 3802, 3803},
				{3717, 3767, 3780, 3783, 3783},
				{3686, 3754, 3766, 3765, 3761},
				{3652, 3733, 3753, 3745, 3733},
				{3610, 3700, 3727, 3719, 3705},
				{3556, 3665, 3688, 3684, 3673},
				{3502, 3640, 3667, 3668, 3660},
				{3454, 3616, 3655, 3660, 3650},
				{3416, 3594, 3634, 3633, 3617},
				{3392, 3573, 3613, 3611, 3593},
				{3363, 3540, 3587, 3584, 3565},
				{3330, 3501, 3557, 3552, 3532},
				{3291, 3458, 3522, 3515, 3497},
				{3246, 3410, 3480, 3476, 3461},
				{3202, 3357, 3434, 3435, 3424},
				{3159, 3302, 3386, 3392, 3382},
				{3116, 3245, 3329, 3341, 3332},
				{3071, 3184, 3255, 3269, 3260},
				{3031, 3107, 3154, 3163, 3152},
				{3000, 3000, 3000, 3000, 3000}
	}
};

struct bms_battery_data LGE_Hitaci_2040mAh_data = {
	.fcc				= 2040,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 217
};
