#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {2350, 2376, 2374, 2364, 2351},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{1164, 344, 100, 74, 69},
				{1129, 350, 101, 76, 70},
				{1134, 349, 101, 76, 70},
				{1100, 351, 104, 78, 71},
				{1076, 349, 109, 80, 72},
				{1062, 341, 115, 83, 74},
				{1056, 336, 124, 88, 77},
				{1057, 334, 125, 94, 81},
				{1065, 333, 111, 89, 78},
				{1083, 336, 102, 78, 71},
				{1113, 341, 103, 80, 72},
				{1158, 355, 107, 82, 74},
				{1215, 376, 111, 85, 77},
				{1287, 395, 115, 84, 76},
				{1372, 407, 119, 82, 74},
				{1572, 403, 127, 83, 74},
				{1988, 414, 125, 83, 73},
				{2550, 464, 139, 92, 78},
				{3109, 506, 155, 103, 83},
				{3723, 536, 170, 112, 90},
				{4032, 550, 176, 118, 95},
				{4406, 564, 176, 121, 99},
				{5027, 578, 176, 127, 103},
				{5647, 592, 175, 131, 109},
				{6289, 630, 183, 136, 113},
				{7445, 669, 192, 142, 121},
				{8637, 681, 205, 150, 129},
				{10300, 805, 236, 165, 140},
				{13167, 1336, 290, 193, 162},
				{16980, 2264, 432, 280, 276},
	}
};

static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4325, 4327, 4323, 4318, 4309},
				{4180, 4237, 4253, 4252, 4247},
				{4082, 4174, 4195, 4195, 4190},
				{4001, 4115, 4140, 4140, 4136},
				{3931, 4059, 4087, 4089, 4084},
				{3872, 4003, 4038, 4040, 4036},
				{3820, 3951, 3993, 3995, 3992},
				{3775, 3904, 3944, 3949, 3948},
				{3735, 3862, 3892, 3900, 3900},
				{3699, 3826, 3851, 3856, 3856},
				{3666, 3795, 3823, 3828, 3828},
				{3637, 3773, 3800, 3805, 3805},
				{3609, 3757, 3781, 3785, 3785},
				{3583, 3737, 3766, 3766, 3763},
				{3557, 3711, 3749, 3747, 3737},
				{3526, 3670, 3725, 3724, 3713},
				{3490, 3622, 3682, 3684, 3676},
				{3451, 3585, 3662, 3670, 3662},
				{3417, 3545, 3634, 3649, 3647},
				{3384, 3511, 3605, 3618, 3610},
				{3368, 3491, 3587, 3603, 3591},
				{3349, 3457, 3550, 3572, 3568},
				{3323, 3424, 3513, 3535, 3528},
				{3296, 3390, 3476, 3499, 3489},
				{3269, 3344, 3427, 3454, 3449},
				{3226, 3298, 3378, 3402, 3398},
				{3181, 3250, 3327, 3349, 3346},
				{3129, 3200, 3273, 3289, 3283},
				{3082, 3146, 3207, 3216, 3203},
				{3041, 3084, 3120, 3119, 3099},
				{3000, 3000, 3000, 3000, 3000}
	}
};

struct bms_battery_data LGE_BL_54SH_2540mAh_LG_Sanyo_data = {
	.fcc				= 2540,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 155
};
