#ifndef __LEDS_QPNP_H_INCLUDED
#define __LEDS_QPNP_H_INCLUDED

/*  duty pcts array is...
 *   0......62
 *   LUT TABLE
 *   63      64    65    66
 *   START, LENGTH, DUTY, PAUSE [RED]
 *   67     68     69    70
 *   START, LENGTH, DUTY, PAUSE [GREEN]
 *   71      72     73    74
 *   START, LENGTH, DUTY, PAUSE [BLUE]
 *   75   76   77    78
 *   R_FLAG G_FLAG B_FLAG RAMP_STEP_MS
 */

/* Default */
static int leds_pwm_duty_pcts0[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 0, 0,
	1, 1, 0, 0,
	1, 1, 0, 0,
	0, 0, 0, 65
};

/* #1 ID_POWER_ON (GB) */
static int leds_pwm_duty_pcts1[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 8, 15, 31, 46, 64, 79, 94, 110, 122,
	135, 145, 156, 166, 173, 181, 189, 189, 191, 186,
	184,	/* G : 183 ~ 255 */
	0, 0, 0, 0, 0, 0, 0, 10, 20, 36,
	48, 71, 92, 110, 128, 143, 156, 181, 207, 232,
	255,	/* B : 0 ~ 255 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 85, 0,
	71, 71, 71, 50
};

/* #2 ID_LCD_ON (RGB) - A1 not use */
static int leds_pwm_duty_pcts2[79] = {
	100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
	100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
	100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
	100, 100, 100, 100, 99, 98, 95, 90, 85, 79,
	73, 65, 58, 50, 42, 35, 27, 21, 15, 10,
	5, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	1, 54, 19, 0,
	1, 54, 19, 0,
	1, 54, 19, 0,
	2, 2, 2, 65
};

/* #3 ID_CHARGING (R) */
static int leds_pwm_duty_pcts3[79] = {
#if defined(LED_BRIGHTNESS_CONTROL_BY_ILLUMINANCE_SENSOR)
	26, 26, 28, 31, 33, 38, 41, 46, 51, 59,
	66, 79, 89, 107, 122, 138, 153, 168, 184, 196,
	209, 222, 235, 242, 250, 252, 255, 255, 255, 255,
	255, 255, 255,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 0 */
	0, 33, 255, 0,
	0, 33, 0, 0,
	0, 33, 0, 0,
	71, 71, 71, 90
#else
	26, 26, 26, 28, 28, 31, 31, 36, 38, 46,
	54, 61, 69, 77, 82, 89, 94, 99, 105, 110,
	115, 117, 120, 122, 125, 128, 128, 128, 128, 128,
	128, 128, 128,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 0 */
	0, 33, 255, 0,
	0, 33, 0, 0,
	0, 33, 0, 0,
	71, 71, 71, 90
#endif
};

/* #4 ID_CHARGING_FULL (RG) */
static int leds_pwm_duty_pcts4[79] = {
#if defined(LED_BRIGHTNESS_CONTROL_BY_ILLUMINANCE_SENSOR)
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	230, 230, 230, 230, 230, 230, 230, 230, 230, 230,
	230, 230, 230, 230, 230, 230, 230, 230, 230, 230,
	230,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	67, 67, 67, 90
#else
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
	115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
	115,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	67, 67, 67, 90
#endif
};

/* #5 ID_CALENDAR_REMIND (GB) - A1 use framework pattern */
static int leds_pwm_duty_pcts5[79] = {
	100, 99, 98, 97, 95, 93, 90, 88, 84, 81,
	77, 73, 68, 64, 59, 54, 48, 43, 37, 31,
	25, 19, 13, 6, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 100, 99, 98, 97, 95,
	93, 90, 88, 84, 81, 77, 73, 68, 64, 59,
	54, 48, 43, 37, 31, 25, 19, 13, 6, 0, 0, 0, 0,
	1, 60, 0, 0,
	1, 60, 12, 0,
	1, 60, 12, 0,
	2, 2, 2, 65
};

/* #6 ID_POWER_OFF (GB) */
static int leds_pwm_duty_pcts6[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 8, 15, 31, 46, 64, 79, 94, 110, 122,
	135, 145, 156, 166, 173, 181, 189, 189, 191, 186,
	184,	/* G : 183 ~ 255 */
	0, 0, 0, 0, 0, 0, 0, 10, 20, 36,
	48, 71, 92, 110, 128, 143, 156, 181, 207, 232,
	255,	/* B : 0 ~ 255 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 85, 0,
	71, 71, 71, 50
};

/* #7 ID_MISSED_NOTI (G) */
static int leds_pwm_duty_pcts7[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 11475,
	21, 21, 255, 11475,
	42, 21, 0, 11475,
	75, 75, 75, 25
};

/* #8 ID_ALARM (RG) - A1 use framework pattern */
static int leds_pwm_duty_pcts8[79] = {
	100, 100, 100, 100, 98, 96, 90, 84, 83, 81,
	80, 77, 73, 69, 64, 60, 55, 50, 45, 40,
	34, 29, 23, 17, 12, 6, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 3, 5, 8, 10, 13,
	18, 23, 25, 27, 29, 31, 33, 34, 35, 30,
	26, 23, 21, 20, 19, 10, 8, 5, 1, 0, 0, 0, 0,
	1, 31, 36, 8,
	32, 31, 36, 8,
	32, 1, 0, 8,
	11, 11, 11, 65
};

/* #12 ID_VOLUME_UP (RB) -A1 not use */
static int leds_pwm_duty_pcts12[79] = {
	100, 100, 99, 98, 96, 94, 91, 88, 84, 81,
	76, 72, 67, 63, 58, 53, 47, 42, 37, 33,
	28, 24, 19, 16, 12, 9, 6, 4, 2, 1,
	0, 71, 70, 70, 69, 68, 66, 64, 62, 60,
	57, 54, 51, 48, 44, 41, 37, 34, 30, 26,
	23, 20, 17, 14, 11, 9, 6, 4, 3, 2, 1, 0, 0,
	1, 31, 26, 0,
	32, 1, 0, 0,
	32, 31, 26, 0,
	2, 2, 2, 65
};

/* #13 ID_VOLUME_DOWN (GB) -A1 not use*/
static int leds_pwm_duty_pcts13[79] = {
	49, 49, 49, 48, 47, 46, 45, 43, 42, 40,
	38, 36, 33, 31, 28, 26, 23, 21, 19, 16,
	14, 12, 10, 8, 6, 4, 3, 2, 1, 1,
	0, 100, 100, 99, 98, 96, 94, 91, 88, 84,
	81, 76, 72, 67, 63, 58, 53, 47, 42, 37,
	33, 28, 24, 19, 16, 12, 9, 6, 4, 2, 1, 0, 0,
	1, 1, 0, 0,
	1, 31, 26, 0,
	32, 31, 26, 0,
	2, 2, 2, 65
};

/* #14 ID_FAVORITE_MISSED_NOTI (RGB) -A1 not use */
static int leds_pwm_duty_pcts14[79] = {
	100, 100, 100, 100, 100, 92, 84, 76, 68, 60,
	52, 44, 36, 28, 20, 100, 100, 100, 100, 100,
	90, 80, 70, 60, 50, 40, 30, 20, 10, 0,
	40, 40, 40, 40, 40, 37, 34, 30, 27, 24,
	21, 18, 14, 11, 8, 40, 40, 40, 40, 40,
	36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 0, 0, 0,
	0, 30, 47, 2590,
	30, 30, 47, 2590,
	30, 30, 47, 2590,
	11, 11, 11, 65
};

/* #17 ID_MISSED_NOTI_PINK (RGB) */
static int leds_pwm_duty_pcts17[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 66, 64, 61, 48, 31, 15, 0, 0, 0,
	0, 0, 0, 0, 66, 64, 61, 48, 31, 15,
	0,	/* G : 65 */
	0, 66, 64, 61, 48, 31, 15, 0, 0, 0,
	0, 0, 0, 0, 66, 64, 61, 48, 31, 15,
	0,	/* B : 65 */
	0, 21, 255, 11475,
	21, 21, 65, 11475,
	42, 21, 65, 11475,
	75, 75, 75, 25
};

/* #18 ID_MISSED_NOTI_BLUE (GB) */
static int leds_pwm_duty_pcts18[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 77, 74, 71, 56, 38, 18, 0, 0, 0,
	0, 0, 0, 0, 77, 74, 71, 56, 38, 18,
	0,	/* G : 77 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* B : 255 */
	0, 21, 0, 11475,
	21, 21, 77, 11475,
	42, 21, 255, 11475,
	75, 75, 75, 25
};

/* #19 ID_MISSED_NOTI_ORANGE (RG) */
static int leds_pwm_duty_pcts19[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 102, 99, 97, 74, 51, 26, 0, 0, 0,
	0, 0, 0, 0, 102, 99, 97, 74, 51, 26,
	0,	/* G : 102 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 102, 11475,
	42, 21, 0, 11475,
	75, 75, 75, 25
};

/* #20 ID_MISSED_NOTI_YELLOW (RG) */
static int leds_pwm_duty_pcts20[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 230, 227, 224, 168, 112, 56, 0, 0, 0,
	0, 0, 0, 0, 230, 227, 224, 168, 112, 56,
	0,	/* G : 230 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 230, 11475,
	42, 21, 0, 11475,
	75, 75, 75, 25
};

/* #29 ID_MISSED_NOTI_TURQUOISE (GB) */
static int leds_pwm_duty_pcts29[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 122, 120, 117, 89, 59, 28, 0, 0, 0,
	0, 0, 0, 0, 122, 120, 117, 89, 59, 28,
	0,	/* B : 122 */
	0, 21, 0, 11475,
	21, 21, 255, 11475,
	42, 21, 122, 11475,
	75, 75, 75, 25
};

/* #30 ID_MISSED_NOTI_PURPLE (RGB) */
static int leds_pwm_duty_pcts30[79] = {
	0, 176, 173, 171, 128, 84, 41, 0, 0, 0,
	0, 0, 0, 0, 176, 173, 171, 128, 84, 41,
	0,	/* R : 175 */
	0, 26, 23, 20, 18, 10, 5, 0, 0, 0,
	0, 0, 0, 0, 26, 23, 20, 18, 10, 5,
	0,	/* G : 25 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* B : 255 */
	0, 21, 175, 11475,
	21, 21, 25, 11475,
	42, 21, 255, 11475,
	75, 75, 75, 25
};

/* #31 ID_MISSED_NOTI_RED (R) */
static int leds_pwm_duty_pcts31[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 0, 11475,
	42, 21, 0, 11475,
	75, 75, 75, 25
};

/* #32 ID_MISSED_NOTI_LIME (RG) */
static int leds_pwm_duty_pcts32[79] = {
	0, 135, 133, 130, 99, 66, 33, 0, 0, 0,
	0, 0, 0, 0, 135, 133, 130, 99, 66, 33,
	0,	/* R : 135 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 135, 11475,
	21, 21, 255, 11475,
	42, 21, 0, 11475,
	75, 75, 75, 25
};

/* #37 ID_URGENT_CALL_MISSED_NOTI (R) */
static int leds_pwm_duty_pcts37[79] = {
	0, 255, 252, 250, 286, 125, 61, 0, 0, 0,
	255, 252, 250, 286, 125, 61, 0, 0, 0, 255,
	252, 250, 286, 125, 61, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0,	/* R : 255 */
	0, 26, 255, 11350,
	0, 1, 0, 11975,
	0, 1, 0, 11975,
	75, 75, 75, 25
};

/* #39 ID_MISSED_NOTI_ONCE (G) */
static int leds_pwm_duty_pcts39[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	66, 66, 66, 25
};

/* #40 ID_MISSED_NOTI_PINK_ONCE (RGB) */
static int leds_pwm_duty_pcts40[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 66, 64, 61, 48, 31, 15, 0, 0, 0,
	0, 0, 0, 0, 66, 64, 61, 48, 31, 15,
	0,	/* G : 65 */
	0, 66, 64, 61, 48, 31, 15, 0, 0, 0,
	0, 0, 0, 0, 66, 64, 61, 48, 31, 15,
	0,	/* B : 65 */
	0, 21, 255, 0,
	21, 21, 65, 0,
	42, 21, 65, 0,
	66, 66, 66, 25
};

/* #41 ID_MISSED_NOTI_BLUE_ONCE (GB) */
static int leds_pwm_duty_pcts41[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 77, 74, 71, 56, 38, 18, 0, 0, 0,
	0, 0, 0, 0, 77, 74, 71, 56, 38, 18,
	0,	/* G : 77 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* B : 255 */
	0, 21, 0, 0,
	21, 21, 77, 0,
	42, 21, 255, 0,
	66, 66, 66, 25
};

/* #42 ID_MISSED_NOTI_ORANGE_ONCE (RG) */
static int leds_pwm_duty_pcts42[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 102, 99, 97, 74, 51, 26, 0, 0, 0,
	0, 0, 0, 0, 102, 99, 97, 74, 51, 26,
	0,	/* G : 102 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 102, 0,
	42, 21, 0, 0,
	66, 66, 66, 25
};

/* #43 ID_MISSED_NOTI_YELLOW_ONCE (RG) */
static int leds_pwm_duty_pcts43[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 230, 227, 224, 168, 112, 56, 0, 0, 0,
	0, 0, 0, 0, 230, 227, 224, 168, 112, 56,
	0,	/* G : 230 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 230, 0,
	42, 21, 0, 0,
	66, 66, 66, 25
};

/* #44 ID_MISSED_NOTI_TURQUOISE_ONCE (GB) */
static int leds_pwm_duty_pcts44[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 122, 120, 117, 89, 59, 28, 0, 0, 0,
	0, 0, 0, 0, 122, 120, 117, 89, 59, 28,
	0,	/* B : 122 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 122, 0,
	66, 66, 66, 25
};

/* #45 ID_MISSED_NOTI_PURPLE_ONCE (RGB) */
static int leds_pwm_duty_pcts45[79] = {
	0, 176, 173, 171, 128, 84, 41, 0, 0, 0,
	0, 0, 0, 0, 176, 173, 171, 128, 84, 41,
	0,	/* R : 175 */
	0, 26, 23, 20, 18, 10, 5, 0, 0, 0,
	0, 0, 0, 0, 26, 23, 20, 18, 10, 5,
	0,	/* G : 25 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* B : 255 */
	0, 21, 175, 0,
	21, 21, 25, 0,
	42, 21, 255, 0,
	66, 66, 66, 25
};

/* #46 ID_MISSED_NOTI_RED_ONCE (R) */
static int leds_pwm_duty_pcts46[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 0, 0,
	42, 21, 0, 0,
	66, 66, 66, 25
};

/* #47 ID_MISSED_NOTI_LIME_ONCE (RG) */
static int leds_pwm_duty_pcts47[79] = {
	0, 135, 133, 130, 99, 66, 33, 0, 0, 0,
	0, 0, 0, 0, 135, 133, 130, 99, 66, 33,
	0,	/* R : 135 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 135, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	66, 66, 66, 25
};

/* #101 ID_FELICA_ON (GB)  */
static int leds_pwm_duty_pcts101[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 214, 173, 117, 59, 31, 0, 0, 0, 0,
	0,	/* G : 255 */
	0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 214, 173, 117, 59, 31, 0, 0, 0, 0,
	0,	/* B : 255 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 255, 0,
	66, 66, 66, 50
};

/* #102 ID_GPS_ENABLED (B) */
static int leds_pwm_duty_pcts102[79] = {
	128, 128, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 128, 0, 128, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* R : 0 */
	0, 0, 0, 0, 0, 128, 0, 128, 128, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 255 */
	0, 63, 0, 0,
	0, 63, 0, 0,
	0, 63, 255, 0,
	67, 67, 67, 97
};

static struct pwm_duty_cycles leds_pwm_duty_cycles = {
	.duty_pcts0 = (int *)&leds_pwm_duty_pcts0,
	.duty_pcts1 = (int *)&leds_pwm_duty_pcts1,
	.duty_pcts2 = (int *)&leds_pwm_duty_pcts2,
	.duty_pcts3 = (int *)&leds_pwm_duty_pcts3,
	.duty_pcts4 = (int *)&leds_pwm_duty_pcts4,
	.duty_pcts5 = (int *)&leds_pwm_duty_pcts5,
	.duty_pcts6 = (int *)&leds_pwm_duty_pcts6,
	.duty_pcts7 = (int *)&leds_pwm_duty_pcts7,
	.duty_pcts8 = (int *)&leds_pwm_duty_pcts8,
	.duty_pcts12 = (int *)&leds_pwm_duty_pcts12,
	.duty_pcts13 = (int *)&leds_pwm_duty_pcts13,
	.duty_pcts14 = (int *)&leds_pwm_duty_pcts14,
	.duty_pcts17 = (int *)&leds_pwm_duty_pcts17,
	.duty_pcts18 = (int *)&leds_pwm_duty_pcts18,
	.duty_pcts19 = (int *)&leds_pwm_duty_pcts19,
	.duty_pcts20 = (int *)&leds_pwm_duty_pcts20,
	.duty_pcts29 = (int *)&leds_pwm_duty_pcts29,
	.duty_pcts30 = (int *)&leds_pwm_duty_pcts30,
	.duty_pcts31 = (int *)&leds_pwm_duty_pcts31,
	.duty_pcts32 = (int *)&leds_pwm_duty_pcts32,
	.duty_pcts37 = (int *)&leds_pwm_duty_pcts37,
	.duty_pcts39 = (int *)&leds_pwm_duty_pcts39,
	.duty_pcts40 = (int *)&leds_pwm_duty_pcts40,
	.duty_pcts41 = (int *)&leds_pwm_duty_pcts41,
	.duty_pcts42 = (int *)&leds_pwm_duty_pcts42,
	.duty_pcts43 = (int *)&leds_pwm_duty_pcts43,
	.duty_pcts44 = (int *)&leds_pwm_duty_pcts44,
	.duty_pcts45 = (int *)&leds_pwm_duty_pcts45,
	.duty_pcts46 = (int *)&leds_pwm_duty_pcts46,
	.duty_pcts47 = (int *)&leds_pwm_duty_pcts47,
	.duty_pcts101 = (int *)&leds_pwm_duty_pcts101,
	.duty_pcts102 = (int *)&leds_pwm_duty_pcts102,
	.num_duty_pcts = ARRAY_SIZE(leds_pwm_duty_pcts0),
};


#if defined(CONFIG_LEDS_WINDOW_COLOR)

#if defined(CONFIG_MACH_MSM8974_B1_KR) || defined(CONFIG_MACH_MSM8974_B1W)
/*
* B1_KR brightness tunning value
* front window (WHITE) - green MAX : 79
*		R/G/B = 87/79/88
* front window (BLACK) - green MAX : 107
* 		R/G/B = 70/107/52
*/

/* for WHITE pattern START */
/* #1 ID_POWER_ON (GB) */
static int leds_pwm_duty_pcts1_b1_wh[79] = {
	0, 6, 11, 17, 22, 28, 34, 39, 45, 50,
	56, 62, 67, 72, 75, 80, 83, 88, 91, 94,
	97, 100, 103, 106, 109, 111, 113, 116, 116, 117,
	121, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 2, 4, 7, 10, 14, 18,
	22, 26, 31, 36, 44, 48, 54, 60, 67, 74, 81, 84, 0,
	1, 1, 0, 0,
	0, 31, 32, 0,
	31, 31, 32, 0,
	71, 71, 71, 33
};

/* #3 ID_CHARGING (R) */
static int leds_pwm_duty_pcts3_b1_wh[79] = {
#if 0
	2, 3, 3, 4, 4, 5, 5, 6, 6, 7,
	7, 8, 9, 10, 11, 12, 13, 14, 14, 15,
	17, 18, 20, 21, 22, 24, 26, 28, 30, 32,
	34, 35, 37, 39, 41, 43, 45, 47, 49, 50,
	53, 56, 58, 61, 64, 67, 70, 74, 78, 82,
	86, 91, 96, 101, 107, 112, 114, 115, 117, 118, 119, 119, 119,
#else
	1, 1, 1, 1, 1, 2, 2, 2, 2, 2,
	2, 3, 3, 3, 4, 4, 4, 5, 5, 5,
	6, 6, 7, 7, 7, 8, 9, 9, 10, 11,
	11, 12, 12, 13, 14, 14, 15, 16, 16, 17,
	18, 19, 19, 21, 22, 23, 24, 25, 26, 28,
	29, 31, 32, 34, 36, 38, 38, 39, 39, 40, 40, 40, 40,
#endif
	0, 61, 256, 600,
	1, 1, 0, 0,
	1, 1, 0, 0,
	79, 79, 79, 44
};

/* #4 ID_CHARGING_FULL (G) */
static int leds_pwm_duty_pcts4_b1_wh[79] = {
	79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
	79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
	79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
	79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
	79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
	79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
	1, 1, 0, 0,
	1, 60, 30, 0,
	1, 1, 0, 0,
	67, 67, 67, 65
};

/* #6 ID_POWER_OFF (GB) */
static int leds_pwm_duty_pcts6_b1_wh[79] = {
#if 0
	0, 6, 11, 17, 22, 28, 34, 39, 45, 50,
	56, 62, 67, 72, 75, 80, 83, 88, 91, 94,
	97, 100, 103, 106, 109, 111, 113, 116, 116, 117,
	121, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 2, 4, 7, 10, 14, 18,
	22, 26, 31, 36, 44, 48, 54, 60, 67, 74, 81, 84, 0,
#else
	0, 4, 7, 11, 15, 19, 23, 26, 30, 34,
	38, 42, 45, 49, 51, 54, 56, 59, 61, 63,
	65, 68, 70, 72, 74, 75, 76, 78, 78, 79,
	82, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 2, 4, 7, 10, 15, 19,
	23, 27, 32, 38, 46, 50, 57, 63, 70, 78, 85, 88, 0,
#endif
	1, 1, 0, 0,
	0, 31, 32, 0,
	31, 31, 32, 0,
	71, 71, 71, 33
};

/* #7 ID_MISSED_NOTI (normal(G) */
static int leds_pwm_duty_pcts7_b1_wh[79] = {
#if 0
	0, 170, 168, 167, 165, 162, 158, 153, 150, 143,
	138, 131, 124, 116, 109, 100, 92, 82, 73, 63,
	53, 43, 32, 22, 10, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 170, 168, 167, 165,
	162, 158, 153, 150, 143, 138, 131, 124, 116, 109,
	100, 92, 82, 73, 63, 53, 43, 32, 22, 10, 0, 0, 0,
#else
	0, 79, 78, 78, 77, 75, 73, 71, 70, 66,
	64, 61, 58, 54, 51, 46, 43, 38, 34, 29,
	25, 20, 15, 10, 5, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 79, 78, 78, 77,
	75, 73, 71, 70, 66, 64, 61, 58, 54, 51,
	46, 43, 38, 34, 29, 25, 20, 15, 10, 5, 0, 0, 0,
#endif
	0, 61, 0, 2280,
	0, 61, 12, 2280,
	0, 61, 0, 2280,
	91, 91, 91, 12
};

/* #17 ID_MISSED_NOTI_PINK (RGB) */
static int leds_pwm_duty_pcts17_b1_wh[79] = {
#if 0
	0, 136, 129, 109, 82, 54, 27, 7, 0, 0, /* red*1.6 */
	0, 0, 136, 129, 109, 82, 54, 27, 7, 0,
	0, 41, 39, 33, 24, 16, 8, 2, 0, 0,
	0, 0, 41, 39, 33, 24, 16, 8, 2, 0,
	0, 23, 22, 18, 14, 9, 5, 1, 0, 0,
	0, 0, 23, 22, 18, 14, 9, 5, 1, 0, 0, 0, 0,
#else
	0, 87, 83, 70, 52, 35, 17, 4, 0, 0,
	0, 0, 87, 83, 70, 52, 35, 17, 4, 0,
	0, 39, 37, 31, 23, 15, 8, 2, 0, 0,
	0, 0, 39, 37, 31, 23, 15, 8, 2, 0,
	0, 44, 42, 34, 27, 17, 10, 2, 0, 0,
	0, 0, 44, 42, 34, 27, 17, 10, 2, 0, 0, 0, 0,

#endif
	0, 20, 408, 2280,
	20, 20, 122, 2280,
	40, 20, 69, 2280,
	91, 91, 91, 36
};

/* #18 ID_MISSED_NOTI_BLUE (GB) */
static int leds_pwm_duty_pcts18_b1_wh[79] = {
#if 0
	0, 51, 46, 39, 31, 26, 20, 14, 10, 7,
	3, 0, 0, 0, 0, 51, 46, 39, 31, 26,
	20, 14, 10, 7, 3, 0, 0, 0, 0, 0,
	0, 85, 77, 64, 51, 43, 32, 24, 16, 11,
	5, 0, 0, 0, 0, 85, 77, 64, 51, 43,
	32, 24, 16, 11, 5, 0, 0, 0, 0, 0, 0, 0, 0,
#else
	0, 40, 36, 31, 24, 20, 16, 11, 8, 5,
	2, 0, 0, 0, 0, 40, 36, 31, 24, 20,
	16, 11, 8, 5, 2, 0, 0, 0, 0, 0,
	0, 88, 80, 66, 53, 45, 33, 25, 17, 11,
	5, 0, 0, 0, 0, 88, 80, 66, 53, 45,
	33, 25, 17, 11, 5, 0, 0, 0, 0, 0, 0, 0, 0,

#endif
	0, 1, 0, 2280,
	0, 26, 154, 2280,
	30, 26, 255, 2280,
	91, 91, 91, 30
};

/* #19 ID_MISSED_NOTI_ORANGE (RG) */
static int leds_pwm_duty_pcts19_b1_wh[79] = {
#if 0
	0, 119, 107, 89, 71, 60, 45, 33, 23, 15, /* red*1.4 */
	7, 0, 0, 0, 0, 119, 107, 89, 71, 60,
	45, 33, 23, 15, 7, 0, 0, 0, 0, 0,
	0, 68, 61, 51, 41, 34, 26, 19, 13, 9,
	4, 0, 0, 0, 0, 68, 61, 51, 41, 34,
	26, 19, 13, 9, 4, 0, 0, 0, 0, 0, 0, 0, 0,
#else
	0, 87, 78, 65, 52, 44, 33, 24, 17, 11,
	5, 0, 0, 0, 0, 87, 78, 65, 52, 44,
	33, 24, 17, 11, 5, 0, 0, 0, 0, 0,
	0, 60, 65, 45, 36, 30, 23, 17, 12, 8,
	4, 0, 0, 0, 0, 60, 54, 45, 36, 30,
	23, 17, 12, 8, 4, 0, 0, 0, 0, 0, 0, 0, 0,

#endif
	0, 26, 408, 2280,
	30, 26, 204, 2280,
	0, 1, 0, 2280,
	91, 91, 91, 30
};

/* #20 ID_MISSED_NOTI_YELLOW (RG) */
static int leds_pwm_duty_pcts20_b1_wh[79] = {
#if 0
	0, 119, 107, 89, 71, 60, 45, 33, 23, 15, /* red*1.4 */
	7, 0, 0, 0, 0, 119, 107, 89, 71, 60,
	45, 33, 23, 15, 7, 0, 0, 0, 0, 0,
	0, 153, 138, 115, 92, 77, 58, 43, 29, 20,
	9, 0, 0, 0, 0, 153, 138, 115, 92, 77,
	58, 43, 29, 20, 9, 0, 0, 0, 0, 0, 0, 0, 0,
#else
	0, 87, 78, 65, 52, 44, 33, 24, 17, 11,
	5, 0, 0, 0, 0, 87, 78, 65, 52, 44,
	33, 24, 17, 11, 5, 0, 0, 0, 0, 0,
	0, 79, 71, 59, 48, 40, 30, 22, 15, 10,
	5, 0, 0, 0, 0, 79, 71, 59, 48, 40,
	30, 22, 15, 10, 5, 0, 0, 0, 0, 0, 0, 0, 0,

#endif
	0, 26, 408, 2280,
	30, 26, 460, 2280,
	0, 1, 0, 2280,
	91, 91, 91, 30
};

/* #29 ID_MISSED_NOTI_TURQUOISE (GB) */
static int leds_pwm_duty_pcts29_b1_wh[79] = {
#if 0
	0, 170, 153, 128, 102, 85, 65, 48, 32, 22,
	10, 0, 0, 0, 0, 170, 153, 128, 102, 85,
	65, 48, 32, 22, 10, 0, 0, 0, 0, 0,
	0, 41, 37, 31, 24, 20, 15, 11, 8, 5,
	2, 0, 0, 0, 0, 41, 37, 31, 24, 20,
	15, 11, 8, 5, 2, 0, 0, 0, 0, 0, 0, 0, 0,
#else
	0, 79, 71, 59, 47, 40, 30, 22, 15, 10,
	5, 0, 0, 0, 0, 79, 71, 59, 47, 40,
	30, 22, 15, 10, 5, 0, 0, 0, 0, 0,
	0, 44, 40, 33, 26, 21, 16, 12, 9, 5,
	2, 0, 0, 0, 0, 44, 40, 33, 26, 21,
	16, 12, 9, 5, 2, 0, 0, 0, 0, 0, 0, 0, 0,

#endif
	0, 1, 0, 2280,
	0, 26, 510, 2280,
	30, 26, 122, 2280,
	91, 91, 91, 30
};

/* #30 ID_MISSED_NOTI_PURPLE (RGB) */
static int leds_pwm_duty_pcts30_b1_wh[79] = {
#if 0
	0, 95, 91, 76, 57, 38, 19, 5, 0, 0, /* red*1.6 */
	0, 0, 95, 91, 76, 57, 38, 19, 5, 0,
	0, 17, 16, 13, 10, 7, 3, 1, 0, 0,
	0, 0, 17, 16, 13, 10, 7, 3, 1, 0,
	0, 85, 81, 68, 51, 34, 17, 4, 0, 0,
	0, 0, 85, 81, 68, 51, 34, 17, 4, 0, 0, 0, 0,
#else
	0, 80, 77, 64, 48, 32, 16, 4, 0, 0,
	0, 0, 80, 77, 64, 48, 32, 16, 4, 0,
	0, 10, 9, 8, 6, 4, 2, 1, 0, 0,
	0, 0, 10, 9, 8, 6, 4, 2, 1, 0,
	0, 88, 84, 70, 53, 35, 18, 4, 0, 0,
	0, 0, 88, 84, 70, 53, 35, 18, 4, 0, 0, 0, 0,
#endif
	0, 20, 268, 2280,
	20, 20, 50, 2280,
	40, 20, 255, 2280,
	91, 91, 91, 36
};

/* #31 ID_MISSED_NOTI_RED (R) */
static int leds_pwm_duty_pcts31_b1_wh[79] = {
#if 0
	0, 136, 135, 133, 132, 129, 126, 122, 120, 114,
	110, 105, 99, 92, 87, 80, 73, 65, 58, 50,
	42, 34, 26, 18, 8, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 136, 135, 133, 132,
	129, 126, 122, 120, 114, 110, 105, 99, 92, 87,
	80, 73, 65, 58, 50, 42, 34, 26, 18, 8, 0, 0, 0,
#else
	0, 87, 86, 85, 84, 83, 81, 78, 77, 73,
	70, 67, 63, 59, 56, 51, 47, 42, 37, 32,
	27, 22, 17, 12, 5, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 87, 86, 85, 84,
	83, 81, 78, 77, 73, 70, 67, 63, 59, 56,
	51, 47, 42, 37, 32, 27, 22, 17, 12, 5, 0, 0, 0,
#endif
	0, 61, 408, 2280,
	0, 61, 0, 2280,
	0, 61, 0, 2280,
	91, 91, 91, 12
};

/* #32 ID_MISSED_NOTI_LIME (RG) */
static int leds_pwm_duty_pcts32_b1_wh[79] = {
#if 0
	0, 71, 64, 53, 43, 36, 27, 20, 13, 9, /* red*1.4 */
	4, 0, 0, 0, 0, 71, 64, 53, 43, 36,
	27, 20, 13, 9, 4, 0, 0, 0, 0, 0,
	0, 170, 153, 128, 102, 85, 65, 48, 32, 22,
	10, 0, 0, 0, 0, 170, 153, 128, 102, 85,
	65, 48, 32, 22, 10, 0, 0, 0, 0, 0, 0, 0, 0,
#else
	0, 50, 45, 37, 30, 25, 19, 14, 9, 6,
	3, 0, 0, 0, 0, 50, 45, 37, 30, 25,
	19, 14, 9, 6, 3, 0, 0, 0, 0, 0,
	0, 79, 71, 59, 47, 40, 30, 22, 15, 10,
	5, 0, 0, 0, 0, 79, 71, 59, 47, 40,
	30, 22, 15, 10, 5, 0, 0, 0, 0, 0, 0, 0, 0,
#endif
	0, 26, 244, 2280,
	30, 26, 510, 2280,
	0, 1, 0, 2280,
	91, 91, 91, 30
};

/* #37 Call_Urgent ID_MISSED_NOTI (RG) */
static int leds_pwm_duty_pcts37_b1_wh[79] = {
	0, 87, 87, 87, 87, 50, 30, 10, 0, 0,
	0, 87, 87, 87, 87, 50, 30, 10, 0, 0,
	0, 87, 87, 87, 87, 50, 30, 10, 0, 0,

	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 40, 40, 40, 40, 30, 20, 10, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

	0, 29, 510, 1780,
	30, 29, 244, 1780,
	0, 1, 0, 1780,
	91, 91, 91, 26
};

/* for BLACK pattern START */
/* #1 ID_POWER_ON (GB) */
static int leds_pwm_duty_pcts1_b1_bk[79] = {
#if 0
	0, 6, 11, 17, 22, 28, 34, 39, 45, 50,
	56, 62, 67, 72, 75, 80, 83, 88, 91, 94,
	97, 100, 103, 106, 109, 111, 113, 116, 116, 117,
	121, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 2, 4, 7, 10, 14, 18,
	22, 26, 31, 36, 44, 48, 54, 60, 67, 74, 81, 84, 0,
#else
	0, 6, 11, 17, 22, 28, 34, 39, 45, 50,
	56, 62, 67, 72, 75, 80, 83, 88, 91, 94,
	97, 100, 103, 106, 109, 111, 113, 116, 116, 117,
	121, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 2, 4, 7, 10, 14, 18,
	22, 26, 31, 36, 44, 48, 54, 60, 67, 74, 81, 84, 0,
#endif
	1, 1, 0, 0,
	0, 31, 32, 0,
	31, 31, 32, 0,
	71, 71, 71, 33
};

/* #3 ID_CHARGING (R) */
static int leds_pwm_duty_pcts3_b1_bk[79] = {
#if 0
	2, 3, 3, 4, 4, 5, 5, 6, 6, 7,
	7, 8, 9, 10, 11, 12, 13, 14, 14, 15,
	17, 18, 20, 21, 22, 24, 26, 28, 30, 32,
	34, 35, 37, 39, 41, 43, 45, 47, 49, 50,
	53, 56, 58, 61, 64, 67, 70, 74, 78, 82,
	86, 91, 96, 101, 107, 112, 114, 115, 117, 118, 119, 119, 119,
#else
	1, 1, 1, 1, 1, 1, 1, 2, 2, 2,
	2, 2, 3, 3, 3, 4, 4, 4, 4, 4,
	5, 5, 6, 6, 6, 7, 8, 8, 9, 9,
	10, 10, 11, 11, 12, 13, 13, 14, 14, 15,
	16, 16, 17, 18, 19, 20, 21, 22, 23, 24,
	25, 27, 28, 30, 31, 33, 34, 34, 34, 35, 35, 35, 35,
#endif
	0, 61, 256, 600,
	1, 1, 0, 0,
	1, 1, 0, 0,
	79, 79, 79, 44
};

/* #4 ID_CHARGING_FULL (G) */
static int leds_pwm_duty_pcts4_b1_bk[79] = {
#if 0
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
#else
	107, 107, 107, 107, 107, 107, 107, 107, 107, 107,
	107, 107, 107, 107, 107, 107, 107, 107, 107, 107,
	107, 107, 107, 107, 107, 107, 107, 107, 107, 107,
	107, 107, 107, 107, 107, 107, 107, 107, 107, 107,
	107, 107, 107, 107, 107, 107, 107, 107, 107, 107,
	107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107,
#endif
	1, 1, 0, 0,
	1, 60, 30, 0,
	1, 1, 0, 0,
	67, 67, 67, 65
};

/* #6 ID_POWER_OFF (GB) */
static int leds_pwm_duty_pcts6_b1_bk[79] = {
#if 0
	0, 6, 11, 17, 22, 28, 34, 39, 45, 50,
	56, 62, 67, 72, 75, 80, 83, 88, 91, 94,
	97, 100, 103, 106, 109, 111, 113, 116, 116, 117,
	121, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 2, 4, 7, 10, 14, 18,
	22, 26, 31, 36, 44, 48, 54, 60, 67, 74, 81, 84, 0,
#else
	0, 6, 11, 17, 22, 28, 34, 39, 45, 50,
	56, 62, 67, 72, 75, 80, 83, 88, 91, 94,
	97, 100, 103, 106, 109, 111, 113, 116, 116, 117,
	121, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 2, 4, 7, 10, 14, 18,
	22, 26, 31, 36, 44, 48, 54, 60, 67, 74, 81, 84, 0,
#endif
	1, 1, 0, 0,
	0, 31, 32, 0,
	31, 31, 32, 0,
	71, 71, 71, 33
};

/* #7 ID_MISSED_NOTI (normal(G) */
static int leds_pwm_duty_pcts7_b1_bk[79] = {
#if 0
	0, 170, 168, 167, 165, 162, 158, 153, 150, 143,
	138, 131, 124, 116, 109, 100, 92, 82, 73, 63,
	53, 43, 32, 22, 10, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 170, 168, 167, 165,
	162, 158, 153, 150, 143, 138, 131, 124, 116, 109,
	100, 92, 82, 73, 63, 53, 43, 32, 22, 10, 0, 0, 0,
#else
	0, 107, 106, 105, 104, 102, 99, 96, 94, 90,
	87, 82, 78, 73, 69, 63, 58, 52, 46, 40,
	33, 27, 20, 14, 6, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 107, 106, 105, 104,
	102, 99, 96, 94, 90, 87, 82, 78, 73, 69,
	63, 58, 52, 46, 40, 33, 27, 20, 14, 6, 0, 0, 0,
#endif
	0, 61, 0, 2280,
	0, 61, 12, 2280,
	0, 61, 0, 2280,
	91, 91, 91, 12
};

/* #17 ID_MISSED_NOTI_PINK (RGB) */
static int leds_pwm_duty_pcts17_b1_bk[79] = {
#if 0
	0, 136, 129, 109, 82, 54, 27, 7, 0, 0, /* red*1.6 */
	0, 0, 136, 129, 109, 82, 54, 27, 7, 0,
	0, 41, 39, 33, 24, 16, 8, 2, 0, 0,
	0, 0, 41, 39, 33, 24, 16, 8, 2, 0,
	0, 23, 22, 18, 14, 9, 5, 1, 0, 0,
	0, 0, 23, 22, 18, 14, 9, 5, 1, 0, 0, 0, 0,
#else
	0, 70, 66, 56, 42, 28, 14, 4, 0, 0,
	0, 0, 70, 66, 56, 42, 28, 14, 4, 0,
	0, 53, 50, 43, 31, 21, 10, 3, 0, 0,
	0, 0, 53, 50, 43, 31, 21, 10, 3, 0,
	0, 27, 26, 21, 16, 11, 6, 1, 0, 0,
	0, 0, 27, 26, 21, 16, 11, 6, 1, 0, 0, 0, 0,
#endif
	0, 20, 408, 2280,
	20, 20, 122, 2280,
	40, 20, 69, 2280,
	91, 91, 91, 36
};

/* #18 ID_MISSED_NOTI_BLUE (GB) */
static int leds_pwm_duty_pcts18_b1_bk[79] = {
#if 0
	0, 51, 46, 39, 31, 26, 20, 14, 10, 7,
	3, 0, 0, 0, 0, 51, 46, 39, 31, 26,
	20, 14, 10, 7, 3, 0, 0, 0, 0, 0,
	0, 85, 77, 64, 51, 43, 32, 24, 16, 11,
	5, 0, 0, 0, 0, 85, 77, 64, 51, 43,
	32, 24, 16, 11, 5, 0, 0, 0, 0, 0, 0, 0, 0,
#else
	0, 53, 48, 41, 32, 27, 21, 15, 10, 7,
	3, 0, 0, 0, 0, 53, 48, 41, 32, 27,
	21, 15, 10, 7, 3, 0, 0, 0, 0, 0,
	0, 52, 47, 39, 31, 26, 20, 15, 10, 7,
	3, 0, 0, 0, 0, 52, 47, 39, 31, 26,
	20, 15, 10, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0,
#endif
	0, 1, 0, 2280,
	0, 26, 154, 2280,
	30, 26, 255, 2280,
	91, 91, 91, 30
};

/* #19 ID_MISSED_NOTI_ORANGE (RG) */
static int leds_pwm_duty_pcts19_b1_bk[79] = {
#if 0
	0, 119, 107, 89, 71, 60, 45, 33, 23, 15, /* red*1.4 */
	7, 0, 0, 0, 0, 119, 107, 89, 71, 60,
	45, 33, 23, 15, 7, 0, 0, 0, 0, 0,
	0, 68, 61, 51, 41, 34, 26, 19, 13, 9,
	4, 0, 0, 0, 0, 68, 61, 51, 41, 34,
	26, 19, 13, 9, 4, 0, 0, 0, 0, 0, 0, 0, 0,
#else
	0, 70, 63, 52, 42, 35, 26, 19, 14, 9,
	4, 0, 0, 0, 0, 70, 63, 52, 42, 35,
	26, 19, 14, 9, 4, 0, 0, 0, 0, 0,
	0, 66, 60, 50, 40, 33, 25, 19, 13, 9,
	4, 0, 0, 0, 0, 66, 60, 50, 40, 33,
	25, 19, 13, 9, 4, 0, 0, 0, 0, 0, 0, 0, 0,
#endif
	0, 26, 408, 2280,
	30, 26, 204, 2280,
	0, 1, 0, 2280,
	91, 91, 91, 30
};

/* #20 ID_MISSED_NOTI_YELLOW (RG) */
static int leds_pwm_duty_pcts20_b1_bk[79] = {
#if 0
	0, 119, 107, 89, 71, 60, 45, 33, 23, 15, /* red*1.4 */
	7, 0, 0, 0, 0, 119, 107, 89, 71, 60,
	45, 33, 23, 15, 7, 0, 0, 0, 0, 0,
	0, 153, 138, 115, 92, 77, 58, 43, 29, 20,
	9, 0, 0, 0, 0, 153, 138, 115, 92, 77,
	58, 43, 29, 20, 9, 0, 0, 0, 0, 0, 0, 0, 0,
#else
	0, 70, 63, 52, 42, 35, 26, 19, 14, 9,
	4, 0, 0, 0, 0, 70, 63, 52, 42, 35,
	26, 19, 14, 9, 4, 0, 0, 0, 0, 0,
	0, 107, 97, 80, 64, 54, 41, 30, 20, 14,
	6, 0, 0, 0, 0, 107, 97, 80, 64, 54,
	41, 30, 20, 14, 6, 0, 0, 0, 0, 0, 0, 0, 0,
#endif
	0, 26, 408, 2280,
	30, 26, 460, 2280,
	0, 1, 0, 2280,
	91, 91, 91, 30
};

/* #29 ID_MISSED_NOTI_TURQUOISE (GB) */
static int leds_pwm_duty_pcts29_b1_bk[79] = {
#if 0
	0, 170, 153, 128, 102, 85, 65, 48, 32, 22,
	10, 0, 0, 0, 0, 170, 153, 128, 102, 85,
	65, 48, 32, 22, 10, 0, 0, 0, 0, 0,
	0, 41, 37, 31, 24, 20, 15, 11, 8, 5,
	2, 0, 0, 0, 0, 41, 37, 31, 24, 20,
	15, 11, 8, 5, 2, 0, 0, 0, 0, 0, 0, 0, 0,
#else
	0, 107, 96, 81, 64, 54, 41, 30, 20, 14,
	6, 0, 0, 0, 0, 107, 96, 81, 64, 54,
	41, 30, 20, 14, 6, 0, 0, 0, 0, 0,
	0, 27, 24, 20, 16, 13, 10, 7, 5, 3,
	1, 0, 0, 0, 0, 27, 24, 20, 16, 13,
	10, 7, 5, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0,
#endif
	0, 1, 0, 2280,
	0, 26, 510, 2280,
	30, 26, 122, 2280,
	91, 91, 91, 30
};

/* #30 ID_MISSED_NOTI_PURPLE (RGB) */
static int leds_pwm_duty_pcts30_b1_bk[79] = {
#if 0
	0, 95, 91, 76, 57, 38, 19, 5, 0, 0, /* red*1.6 */
	0, 0, 95, 91, 76, 57, 38, 19, 5, 0,
	0, 17, 16, 13, 10, 7, 3, 1, 0, 0,
	0, 0, 17, 16, 13, 10, 7, 3, 1, 0,
	0, 85, 81, 68, 51, 34, 17, 4, 0, 0,
	0, 0, 85, 81, 68, 51, 34, 17, 4, 0, 0, 0, 0,
#else
	0, 50, 48, 40, 30, 20, 10, 3, 0, 0,
	0, 0, 50, 48, 40, 30, 20, 10, 3, 0,
	0, 6, 6, 5, 4, 2, 1, 0, 0, 0,
	0, 0, 6, 6, 5, 4, 2, 1, 0, 0,
	0, 52, 50, 42, 31, 21, 10, 2, 0, 0,
	0, 0, 52, 50, 42, 31, 21, 10, 2, 0, 0, 0, 0,
#endif
	0, 20, 268, 2280,
	20, 20, 50, 2280,
	40, 20, 255, 2280,
	91, 91, 91, 36
};

/* #31 ID_MISSED_NOTI_RED (R) */
static int leds_pwm_duty_pcts31_b1_bk[79] = {
#if 0
	0, 136, 135, 133, 132, 129, 126, 122, 120, 114,
	110, 105, 99, 92, 87, 80, 73, 65, 58, 50,
	42, 34, 26, 18, 8, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 136, 135, 133, 132,
	129, 126, 122, 120, 114, 110, 105, 99, 92, 87,
	80, 73, 65, 58, 50, 42, 34, 26, 18, 8, 0, 0, 0,
#else
	0, 70, 69, 68, 68, 66, 65, 63, 62, 59,
	57, 54, 51, 47, 45, 41, 38, 33, 30, 26,
	22, 18, 13, 9, 4, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 70, 69, 68, 68,
	66, 65, 63, 62, 59, 57, 54, 51, 47, 45,
	41, 38, 33, 30, 26, 22, 18, 13, 9, 4, 0, 0, 0,
#endif
	0, 61, 408, 2280,
	0, 61, 0, 2280,
	0, 61, 0, 2280,
	91, 91, 91, 12
};

/* #32 ID_MISSED_NOTI_LIME (RG) */
static int leds_pwm_duty_pcts32_b1_bk[79] = {
#if 0
	0, 71, 64, 53, 43, 36, 27, 20, 13, 9, /* red*1.4 */
	4, 0, 0, 0, 0, 71, 64, 53, 43, 36,
	27, 20, 13, 9, 4, 0, 0, 0, 0, 0,
	0, 170, 153, 128, 102, 85, 65, 48, 32, 22,
	10, 0, 0, 0, 0, 170, 153, 128, 102, 85,
	65, 48, 32, 22, 10, 0, 0, 0, 0, 0, 0, 0, 0,
#else
	0, 30, 27, 22, 18, 15, 11, 8, 5, 4,
	2, 0, 0, 0, 0, 30, 27, 22, 18, 15,
	11, 8, 5, 4, 2, 0, 0, 0, 0, 0,
	0, 107, 96, 81, 64, 54, 41, 30, 20, 14,
	6, 0, 0, 0, 0, 107, 96, 81, 64, 54,
	41, 30, 20, 14, 6, 0, 0, 0, 0, 0, 0, 0, 0,
#endif
	0, 26, 244, 2280,
	30, 26, 510, 2280,
	0, 1, 0, 2280,
	91, 91, 91, 30
};

/* #37 Call_Urgent ID_MISSED_NOTI (RG) */
static int leds_pwm_duty_pcts37_b1_bk[79] = {
	0, 70, 70, 70, 70, 50, 30, 10, 0, 0,
	0, 70, 70, 70, 70, 50, 30, 10, 0, 0,
	0, 70, 70, 70, 70, 50, 30, 10, 0, 0,

	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 44, 44, 44, 44, 30, 20, 10, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

	0, 29, 510, 1780,
	30, 29, 244, 1780,
	0, 1, 0, 1780,
	91, 91, 91, 26
};

static struct pwm_duty_cycles leds_pwm_duty_cycles_wh = {
	.duty_pcts0 = (int *)&leds_pwm_duty_pcts0,
	.duty_pcts1 = (int *)&leds_pwm_duty_pcts1_b1_wh,
	.duty_pcts2 = (int *)&leds_pwm_duty_pcts2,
	.duty_pcts3 = (int *)&leds_pwm_duty_pcts3_b1_wh,
	.duty_pcts4 = (int *)&leds_pwm_duty_pcts4_b1_wh,
	.duty_pcts5 = (int *)&leds_pwm_duty_pcts5,
	.duty_pcts6 = (int *)&leds_pwm_duty_pcts6_b1_wh,
	.duty_pcts7 = (int *)&leds_pwm_duty_pcts7_b1_wh,
	.duty_pcts8 = (int *)&leds_pwm_duty_pcts8,
	.duty_pcts12 = (int *)&leds_pwm_duty_pcts12,
	.duty_pcts13 = (int *)&leds_pwm_duty_pcts13,
	.duty_pcts14 = (int *)&leds_pwm_duty_pcts14,
	.duty_pcts17 = (int *)&leds_pwm_duty_pcts17_b1_wh,
	.duty_pcts18 = (int *)&leds_pwm_duty_pcts18_b1_wh,
	.duty_pcts19 = (int *)&leds_pwm_duty_pcts19_b1_wh,
	.duty_pcts20 = (int *)&leds_pwm_duty_pcts20_b1_wh,
	.duty_pcts29 = (int *)&leds_pwm_duty_pcts29_b1_wh,
	.duty_pcts30 = (int *)&leds_pwm_duty_pcts30_b1_wh,
	.duty_pcts31 = (int *)&leds_pwm_duty_pcts31_b1_wh,
	.duty_pcts32 = (int *)&leds_pwm_duty_pcts32_b1_wh,
	.duty_pcts37 = (int *)&leds_pwm_duty_pcts37_b1_wh,
	.duty_pcts101 = (int *)&leds_pwm_duty_pcts101,
	.duty_pcts102 = (int *)&leds_pwm_duty_pcts102,
	.num_duty_pcts = ARRAY_SIZE(leds_pwm_duty_pcts0),
};

static struct pwm_duty_cycles leds_pwm_duty_cycles_bk = {
	.duty_pcts0 = (int *)&leds_pwm_duty_pcts0,
	.duty_pcts1 = (int *)&leds_pwm_duty_pcts1_b1_bk,
	.duty_pcts2 = (int *)&leds_pwm_duty_pcts2,
	.duty_pcts3 = (int *)&leds_pwm_duty_pcts3_b1_bk,
	.duty_pcts4 = (int *)&leds_pwm_duty_pcts4_b1_bk,
	.duty_pcts5 = (int *)&leds_pwm_duty_pcts5,
	.duty_pcts6 = (int *)&leds_pwm_duty_pcts6_b1_bk,
	.duty_pcts7 = (int *)&leds_pwm_duty_pcts7_b1_bk,
	.duty_pcts8 = (int *)&leds_pwm_duty_pcts8,
	.duty_pcts12 = (int *)&leds_pwm_duty_pcts12,
	.duty_pcts13 = (int *)&leds_pwm_duty_pcts13,
	.duty_pcts14 = (int *)&leds_pwm_duty_pcts14,
	.duty_pcts17 = (int *)&leds_pwm_duty_pcts17_b1_bk,
	.duty_pcts18 = (int *)&leds_pwm_duty_pcts18_b1_bk,
	.duty_pcts19 = (int *)&leds_pwm_duty_pcts19_b1_bk,
	.duty_pcts20 = (int *)&leds_pwm_duty_pcts20_b1_bk,
	.duty_pcts29 = (int *)&leds_pwm_duty_pcts29_b1_bk,
	.duty_pcts30 = (int *)&leds_pwm_duty_pcts30_b1_bk,
	.duty_pcts31 = (int *)&leds_pwm_duty_pcts31_b1_bk,
	.duty_pcts32 = (int *)&leds_pwm_duty_pcts32_b1_bk,
	.duty_pcts37 = (int *)&leds_pwm_duty_pcts37_b1_bk,
	.duty_pcts101 = (int *)&leds_pwm_duty_pcts101,
	.duty_pcts102 = (int *)&leds_pwm_duty_pcts102,
	.num_duty_pcts = ARRAY_SIZE(leds_pwm_duty_pcts0),
};
#else
/*
* G3 brightness tunning value
* front window (WHITE) - green MAX : 79
*		R/G/B = 87/79/88
* front window (BLACK) - green MAX : 12
* 		R/G/B = ??/12/??
*/

/* for WHITE pattern START */
/* #1 ID_POWER_ON (GB) */
static int leds_pwm_duty_pcts1_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 8, 15, 31, 46, 64, 79, 94, 110, 122,
	135, 145, 156, 166, 173, 181, 189, 189, 191, 186,
	184,	/* G : 183 ~ 255 */
	0, 0, 0, 0, 0, 0, 0, 10, 20, 36,
	48, 71, 92, 110, 128, 143, 156, 181, 207, 232,
	255,	/* B : 0 ~ 255 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 85, 0,
	71, 71, 71, 50
};

/* #3 ID_CHARGING (R) */
static int leds_pwm_duty_pcts3_wh[79] = {
#if defined(LED_BRIGHTNESS_CONTROL_BY_ILLUMINANCE_SENSOR)
	26, 26, 28, 31, 33, 38, 41, 46, 51, 59,
	66, 79, 89, 107, 122, 138, 153, 168, 184, 196,
	209, 222, 235, 242, 250, 252, 255, 255, 255, 255,
	255, 255, 255,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 0 */
	0, 33, 255, 0,
	0, 33, 0, 0,
	0, 33, 0, 0,
	71, 71, 71, 90
#else
	26, 26, 26, 28, 28, 31, 31, 36, 38, 46,
	54, 61, 69, 77, 82, 89, 94, 99, 105, 110,
	115, 117, 120, 122, 125, 128, 128, 128, 128, 128,
	128, 128, 128,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 0 */
	0, 33, 255, 0,
	0, 33, 0, 0,
	0, 33, 0, 0,
	71, 71, 71, 90
#endif
};

/* #4 ID_CHARGING_FULL (RG) */
static int leds_pwm_duty_pcts4_wh[79] = {
#if defined(LED_BRIGHTNESS_CONTROL_BY_ILLUMINANCE_SENSOR)
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	230, 230, 230, 230, 230, 230, 230, 230, 230, 230,
	230, 230, 230, 230, 230, 230, 230, 230, 230, 230,
	230,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	67, 67, 67, 90
#else
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
	115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
	115,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	67, 67, 67, 90
#endif
};

/* #6 ID_POWER_OFF (GB) */
static int leds_pwm_duty_pcts6_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 8, 15, 31, 46, 64, 79, 94, 110, 122,
	135, 145, 156, 166, 173, 181, 189, 189, 191, 186,
	184,	/* G : 183 ~ 255 */
	0, 0, 0, 0, 0, 0, 0, 10, 20, 36,
	48, 71, 92, 110, 128, 143, 156, 181, 207, 232,
	255,	/* B : 0 ~ 255 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 85, 0,
	71, 71, 71, 50
};

/* #7 ID_MISSED_NOTI (G) */
static int leds_pwm_duty_pcts7_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 11475,
	21, 21, 255, 11475,
	42, 21, 0, 11475,
	75, 75, 75, 25
};

/* #17 ID_MISSED_NOTI_PINK (RGB) */
static int leds_pwm_duty_pcts17_wh[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 66, 64, 61, 48, 31, 15, 0, 0, 0,
	0, 0, 0, 0, 66, 64, 61, 48, 31, 15,
	0,	/* G : 65 */
	0, 66, 64, 61, 48, 31, 15, 0, 0, 0,
	0, 0, 0, 0, 66, 64, 61, 48, 31, 15,
	0,	/* B : 65 */
	0, 21, 255, 11475,
	21, 21, 65, 11475,
	42, 21, 65, 11475,
	75, 75, 75, 25
};

/* #18 ID_MISSED_NOTI_BLUE (GB) */
static int leds_pwm_duty_pcts18_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 77, 74, 71, 56, 38, 18, 0, 0, 0,
	0, 0, 0, 0, 77, 74, 71, 56, 38, 18,
	0,	/* G : 77 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* B : 255 */
	0, 21, 0, 11475,
	21, 21, 77, 11475,
	42, 21, 255, 11475,
	75, 75, 75, 25
};

/* #19 ID_MISSED_NOTI_ORANGE (RG) */
static int leds_pwm_duty_pcts19_wh[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 102, 99, 97, 74, 51, 26, 0, 0, 0,
	0, 0, 0, 0, 102, 99, 97, 74, 51, 26,
	0,	/* G : 102 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 102, 11475,
	42, 21, 0, 11475,
	75, 75, 75, 25
};

/* #20 ID_MISSED_NOTI_YELLOW (RG) */
static int leds_pwm_duty_pcts20_wh[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 230, 227, 224, 168, 112, 56, 0, 0, 0,
	0, 0, 0, 0, 230, 227, 224, 168, 112, 56,
	0,	/* G : 230 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 230, 11475,
	42, 21, 0, 11475,
	75, 75, 75, 25
};

/* #29 ID_MISSED_NOTI_TURQUOISE (GB) */
static int leds_pwm_duty_pcts29_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 122, 120, 117, 89, 59, 28, 0, 0, 0,
	0, 0, 0, 0, 122, 120, 117, 89, 59, 28,
	0,	/* B : 122 */
	0, 21, 0, 11475,
	21, 21, 255, 11475,
	42, 21, 122, 11475,
	75, 75, 75, 25
};

/* #30 ID_MISSED_NOTI_PURPLE (RGB) */
static int leds_pwm_duty_pcts30_wh[79] = {
	0, 176, 173, 171, 128, 84, 41, 0, 0, 0,
	0, 0, 0, 0, 176, 173, 171, 128, 84, 41,
	0,	/* R : 175 */
	0, 26, 23, 20, 18, 10, 5, 0, 0, 0,
	0, 0, 0, 0, 26, 23, 20, 18, 10, 5,
	0,	/* G : 25 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* B : 255 */
	0, 21, 175, 11475,
	21, 21, 25, 11475,
	42, 21, 255, 11475,
	75, 75, 75, 25
};

/* #31 ID_MISSED_NOTI_RED (R) */
static int leds_pwm_duty_pcts31_wh[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 0, 11475,
	42, 21, 0, 11475,
	75, 75, 75, 25
};

/* #32 ID_MISSED_NOTI_LIME (RG) */
static int leds_pwm_duty_pcts32_wh[79] = {
	0, 135, 133, 130, 99, 66, 33, 0, 0, 0,
	0, 0, 0, 0, 135, 133, 130, 99, 66, 33,
	0,	/* R : 135 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 135, 11475,
	21, 21, 255, 11475,
	42, 21, 0, 11475,
	75, 75, 75, 25
};

/* #37 ID_URGENT_CALL_MISSED_NOTI (R) */
static int leds_pwm_duty_pcts37_wh[79] = {
	0, 255, 252, 250, 286, 125, 61, 0, 0, 0,
	255, 252, 250, 286, 125, 61, 0, 0, 0, 255,
	252, 250, 286, 125, 61, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0,	/* R : 255 */
	0, 26, 255, 11350,
	0, 1, 0, 11975,
	0, 1, 0, 11975,
	75, 75, 75, 25
};

/* #39 ID_MISSED_NOTI_ONCE (G) */
static int leds_pwm_duty_pcts39_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	66, 66, 66, 25
};

/* #40 ID_MISSED_NOTI_PINK_ONCE (RGB) */
static int leds_pwm_duty_pcts40_wh[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 66, 64, 61, 48, 31, 15, 0, 0, 0,
	0, 0, 0, 0, 66, 64, 61, 48, 31, 15,
	0,	/* G : 65 */
	0, 66, 64, 61, 48, 31, 15, 0, 0, 0,
	0, 0, 0, 0, 66, 64, 61, 48, 31, 15,
	0,	/* B : 65 */
	0, 21, 255, 0,
	21, 21, 65, 0,
	42, 21, 65, 0,
	66, 66, 66, 25
};

/* #41 ID_MISSED_NOTI_BLUE_ONCE (GB) */
static int leds_pwm_duty_pcts41_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 77, 74, 71, 56, 38, 18, 0, 0, 0,
	0, 0, 0, 0, 77, 74, 71, 56, 38, 18,
	0,	/* G : 77 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* B : 255 */
	0, 21, 0, 0,
	21, 21, 77, 0,
	42, 21, 255, 0,
	66, 66, 66, 25
};

/* #42 ID_MISSED_NOTI_ORANGE_ONCE (RG) */
static int leds_pwm_duty_pcts42_wh[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 102, 99, 97, 74, 51, 26, 0, 0, 0,
	0, 0, 0, 0, 102, 99, 97, 74, 51, 26,
	0,	/* G : 102 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 102, 0,
	42, 21, 0, 0,
	66, 66, 66, 25
};

/* #43 ID_MISSED_NOTI_YELLOW_ONCE (RG) */
static int leds_pwm_duty_pcts43_wh[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 230, 227, 224, 168, 112, 56, 0, 0, 0,
	0, 0, 0, 0, 230, 227, 224, 168, 112, 56,
	0,	/* G : 230 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 230, 0,
	42, 21, 0, 0,
	66, 66, 66, 25
};

/* #44 ID_MISSED_NOTI_TURQUOISE_ONCE (GB) */
static int leds_pwm_duty_pcts44_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 122, 120, 117, 89, 59, 28, 0, 0, 0,
	0, 0, 0, 0, 122, 120, 117, 89, 59, 28,
	0,	/* B : 122 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 122, 0,
	66, 66, 66, 25
};

/* #45 ID_MISSED_NOTI_PURPLE_ONCE (RGB) */
static int leds_pwm_duty_pcts45_wh[79] = {
	0, 176, 173, 171, 128, 84, 41, 0, 0, 0,
	0, 0, 0, 0, 176, 173, 171, 128, 84, 41,
	0,	/* R : 175 */
	0, 26, 23, 20, 18, 10, 5, 0, 0, 0,
	0, 0, 0, 0, 26, 23, 20, 18, 10, 5,
	0,	/* G : 25 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* B : 255 */
	0, 21, 175, 0,
	21, 21, 25, 0,
	42, 21, 255, 0,
	66, 66, 66, 25
};

/* #46 ID_MISSED_NOTI_RED_ONCE (R) */
static int leds_pwm_duty_pcts46_wh[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 0, 0,
	42, 21, 0, 0,
	66, 66, 66, 25
};

/* #47 ID_MISSED_NOTI_LIME_ONCE (RG) */
static int leds_pwm_duty_pcts47_wh[79] = {
	0, 135, 133, 130, 99, 66, 33, 0, 0, 0,
	0, 0, 0, 0, 135, 133, 130, 99, 66, 33,
	0,	/* R : 135 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 135, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	66, 66, 66, 25
};

/* #101 ID_FELICA_ON (GB)  */
static int leds_pwm_duty_pcts101_wh[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 214, 173, 117, 59, 31, 0, 0, 0, 0,
	0,	/* G : 255 */
	0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 214, 173, 117, 59, 31, 0, 0, 0, 0,
	0,	/* B : 255 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 255, 0,
	66, 66, 66, 50
};

/* #102 ID_GPS_ENABLED (B) */
static int leds_pwm_duty_pcts102_wh[79] = {
	128, 128, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 128, 0, 128, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* R : 0 */
	0, 0, 0, 0, 0, 128, 0, 128, 128, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 255 */
	0, 63, 0, 0,
	0, 63, 0, 0,
	0, 63, 255, 0,
	67, 67, 67, 97
};

/* for BLACK pattern START */
/* #1 ID_POWER_ON (GB) */
static int leds_pwm_duty_pcts1_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 8, 15, 31, 46, 64, 79, 94, 110, 122,
	135, 145, 156, 166, 173, 181, 189, 189, 191, 186,
	184,	/* G : 183 ~ 255 */
	0, 0, 0, 0, 0, 0, 0, 10, 20, 36,
	48, 71, 92, 110, 128, 143, 156, 181, 207, 232,
	255,	/* B : 0 ~ 255 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 85, 0,
	71, 71, 71, 50
};

/* #3 ID_CHARGING (R) */
static int leds_pwm_duty_pcts3_bk[79] = {
#if defined(LED_BRIGHTNESS_CONTROL_BY_ILLUMINANCE_SENSOR)
	26, 26, 28, 31, 33, 38, 41, 46, 51, 59,
	66, 79, 89, 107, 122, 138, 153, 168, 184, 196,
	209, 222, 235, 242, 250, 252, 255, 255, 255, 255,
	255, 255, 255,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 0 */
	0, 33, 255, 0,
	0, 33, 0, 0,
	0, 33, 0, 0,
	71, 71, 71, 90
#else
	26, 26, 26, 28, 28, 31, 31, 36, 38, 46,
	54, 61, 69, 77, 82, 89, 94, 99, 105, 110,
	115, 117, 120, 122, 125, 128, 128, 128, 128, 128,
	128, 128, 128,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 0 */
	0, 33, 255, 0,
	0, 33, 0, 0,
	0, 33, 0, 0,
	71, 71, 71, 90
#endif
};

/* #4 ID_CHARGING_FULL (RG) */
static int leds_pwm_duty_pcts4_bk[79] = {
#if defined(LED_BRIGHTNESS_CONTROL_BY_ILLUMINANCE_SENSOR)
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	230, 230, 230, 230, 230, 230, 230, 230, 230, 230,
	230, 230, 230, 230, 230, 230, 230, 230, 230, 230,
	230,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	67, 67, 67, 90
#else
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
	115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
	115,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	67, 67, 67, 90
#endif
};

/* #6 ID_POWER_OFF (GB) */
static int leds_pwm_duty_pcts6_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 8, 15, 31, 46, 64, 79, 94, 110, 122,
	135, 145, 156, 166, 173, 181, 189, 189, 191, 186,
	184,	/* G : 183 ~ 255 */
	0, 0, 0, 0, 0, 0, 0, 10, 20, 36,
	48, 71, 92, 110, 128, 143, 156, 181, 207, 232,
	255,	/* B : 0 ~ 255 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 85, 0,
	71, 71, 71, 50
};

/* #7 ID_MISSED_NOTI (G) */
static int leds_pwm_duty_pcts7_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 11475,
	21, 21, 255, 11475,
	42, 21, 0, 11475,
	75, 75, 75, 25
};

/* #17 ID_MISSED_NOTI_PINK (RGB) */
static int leds_pwm_duty_pcts17_bk[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 66, 64, 61, 48, 31, 15, 0, 0, 0,
	0, 0, 0, 0, 66, 64, 61, 48, 31, 15,
	0,	/* G : 65 */
	0, 66, 64, 61, 48, 31, 15, 0, 0, 0,
	0, 0, 0, 0, 66, 64, 61, 48, 31, 15,
	0,	/* B : 65 */
	0, 21, 255, 11475,
	21, 21, 65, 11475,
	42, 21, 65, 11475,
	75, 75, 75, 25
};

/* #18 ID_MISSED_NOTI_BLUE (GB) */
static int leds_pwm_duty_pcts18_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 77, 74, 71, 56, 38, 18, 0, 0, 0,
	0, 0, 0, 0, 77, 74, 71, 56, 38, 18,
	0,	/* G : 77 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* B : 255 */
	0, 21, 0, 11475,
	21, 21, 77, 11475,
	42, 21, 255, 11475,
	75, 75, 75, 25
};

/* #19 ID_MISSED_NOTI_ORANGE (RG) */
static int leds_pwm_duty_pcts19_bk[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 102, 99, 97, 74, 51, 26, 0, 0, 0,
	0, 0, 0, 0, 102, 99, 97, 74, 51, 26,
	0,	/* G : 102 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 102, 11475,
	42, 21, 0, 11475,
	75, 75, 75, 25
};

/* #20 ID_MISSED_NOTI_YELLOW (RG) */
static int leds_pwm_duty_pcts20_bk[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 230, 227, 224, 168, 112, 56, 0, 0, 0,
	0, 0, 0, 0, 230, 227, 224, 168, 112, 56,
	0,	/* G : 230 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 230, 11475,
	42, 21, 0, 11475,
	75, 75, 75, 25
};

/* #29 ID_MISSED_NOTI_TURQUOISE (GB) */
static int leds_pwm_duty_pcts29_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 122, 120, 117, 89, 59, 28, 0, 0, 0,
	0, 0, 0, 0, 122, 120, 117, 89, 59, 28,
	0,	/* B : 122 */
	0, 21, 0, 11475,
	21, 21, 255, 11475,
	42, 21, 122, 11475,
	75, 75, 75, 25
};

/* #30 ID_MISSED_NOTI_PURPLE (RGB) */
static int leds_pwm_duty_pcts30_bk[79] = {
	0, 176, 173, 171, 128, 84, 41, 0, 0, 0,
	0, 0, 0, 0, 176, 173, 171, 128, 84, 41,
	0,	/* R : 175 */
	0, 26, 23, 20, 18, 10, 5, 0, 0, 0,
	0, 0, 0, 0, 26, 23, 20, 18, 10, 5,
	0,	/* G : 25 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* B : 255 */
	0, 21, 175, 11475,
	21, 21, 25, 11475,
	42, 21, 255, 11475,
	75, 75, 75, 25
};

/* #31 ID_MISSED_NOTI_RED (R) */
static int leds_pwm_duty_pcts31_bk[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 11475,
	21, 21, 0, 11475,
	42, 21, 0, 11475,
	75, 75, 75, 25
};

/* #32 ID_MISSED_NOTI_LIME (RG) */
static int leds_pwm_duty_pcts32_bk[79] = {
	0, 135, 133, 130, 99, 66, 33, 0, 0, 0,
	0, 0, 0, 0, 135, 133, 130, 99, 66, 33,
	0,	/* R : 135 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 135, 11475,
	21, 21, 255, 11475,
	42, 21, 0, 11475,
	75, 75, 75, 25
};

/* #37 ID_URGENT_CALL_MISSED_NOTI (R) */
static int leds_pwm_duty_pcts37_bk[79] = {
	0, 255, 252, 250, 286, 125, 61, 0, 0, 0,
	255, 252, 250, 286, 125, 61, 0, 0, 0, 255,
	252, 250, 286, 125, 61, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0,	/* R : 255 */
	0, 26, 255, 11350,
	0, 1, 0, 11975,
	0, 1, 0, 11975,
	75, 75, 75, 25
};

/* #39 ID_MISSED_NOTI_ONCE (G) */
static int leds_pwm_duty_pcts39_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	66, 66, 66, 25
};

/* #40 ID_MISSED_NOTI_PINK_ONCE (RGB) */
static int leds_pwm_duty_pcts40_bk[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 66, 64, 61, 48, 31, 15, 0, 0, 0,
	0, 0, 0, 0, 66, 64, 61, 48, 31, 15,
	0,	/* G : 65 */
	0, 66, 64, 61, 48, 31, 15, 0, 0, 0,
	0, 0, 0, 0, 66, 64, 61, 48, 31, 15,
	0,	/* B : 65 */
	0, 21, 255, 0,
	21, 21, 65, 0,
	42, 21, 65, 0,
	66, 66, 66, 25
};

/* #41 ID_MISSED_NOTI_BLUE_ONCE (GB) */
static int leds_pwm_duty_pcts41_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 77, 74, 71, 56, 38, 18, 0, 0, 0,
	0, 0, 0, 0, 77, 74, 71, 56, 38, 18,
	0,	/* G : 77 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* B : 255 */
	0, 21, 0, 0,
	21, 21, 77, 0,
	42, 21, 255, 0,
	66, 66, 66, 25
};

/* #42 ID_MISSED_NOTI_ORANGE_ONCE (RG) */
static int leds_pwm_duty_pcts42_bk[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 102, 99, 97, 74, 51, 26, 0, 0, 0,
	0, 0, 0, 0, 102, 99, 97, 74, 51, 26,
	0,	/* G : 102 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 102, 0,
	42, 21, 0, 0,
	66, 66, 66, 25
};

/* #43 ID_MISSED_NOTI_YELLOW_ONCE (RG) */
static int leds_pwm_duty_pcts43_bk[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 230, 227, 224, 168, 112, 56, 0, 0, 0,
	0, 0, 0, 0, 230, 227, 224, 168, 112, 56,
	0,	/* G : 230 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 230, 0,
	42, 21, 0, 0,
	66, 66, 66, 25
};

/* #44 ID_MISSED_NOTI_TURQUOISE_ONCE (GB) */
static int leds_pwm_duty_pcts44_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 122, 120, 117, 89, 59, 28, 0, 0, 0,
	0, 0, 0, 0, 122, 120, 117, 89, 59, 28,
	0,	/* B : 122 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 122, 0,
	66, 66, 66, 25
};

/* #45 ID_MISSED_NOTI_PURPLE_ONCE (RGB) */
static int leds_pwm_duty_pcts45_bk[79] = {
	0, 176, 173, 171, 128, 84, 41, 0, 0, 0,
	0, 0, 0, 0, 176, 173, 171, 128, 84, 41,
	0,	/* R : 175 */
	0, 26, 23, 20, 18, 10, 5, 0, 0, 0,
	0, 0, 0, 0, 26, 23, 20, 18, 10, 5,
	0,	/* G : 25 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* B : 255 */
	0, 21, 175, 0,
	21, 21, 25, 0,
	42, 21, 255, 0,
	66, 66, 66, 25
};

/* #46 ID_MISSED_NOTI_RED_ONCE (R) */
static int leds_pwm_duty_pcts46_bk[79] = {
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* R : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 255, 0,
	21, 21, 0, 0,
	42, 21, 0, 0,
	66, 66, 66, 25
};

/* #47 ID_MISSED_NOTI_LIME_ONCE (RG) */
static int leds_pwm_duty_pcts47_bk[79] = {
	0, 135, 133, 130, 99, 66, 33, 0, 0, 0,
	0, 0, 0, 0, 135, 133, 130, 99, 66, 33,
	0,	/* R : 135 */
	0, 255, 252, 250, 186, 125, 61, 0, 0, 0,
	0, 0, 0, 0, 255, 252, 250, 186, 125, 61,
	0,	/* G : 255 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* B : 0 */
	0, 21, 135, 0,
	21, 21, 255, 0,
	42, 21, 0, 0,
	66, 66, 66, 25
};

/* #101 ID_FELICA_ON (GB)  */
static int leds_pwm_duty_pcts101_bk[79] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0,	/* R : 0 */
	0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 214, 173, 117, 59, 31, 0, 0, 0, 0,
	0,	/* G : 255 */
	0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 214, 173, 117, 59, 31, 0, 0, 0, 0,
	0,	/* B : 255 */
	0, 21, 0, 0,
	21, 21, 255, 0,
	42, 21, 255, 0,
	66, 66, 66, 50
};

/* #102 ID_GPS_ENABLED (B) */
static int leds_pwm_duty_pcts102_bk[79] = {
	128, 128, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 128, 0, 128, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* R : 0 */
	0, 0, 0, 0, 0, 128, 0, 128, 128, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* G : 0 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* B : 255 */
	0, 63, 0, 0,
	0, 63, 0, 0,
	0, 63, 255, 0,
	67, 67, 67, 97
};

static struct pwm_duty_cycles leds_pwm_duty_cycles_wh = {
	.duty_pcts0 = (int *)&leds_pwm_duty_pcts0,
	.duty_pcts1 = (int *)&leds_pwm_duty_pcts1_wh,
	.duty_pcts2 = (int *)&leds_pwm_duty_pcts2,
	.duty_pcts3 = (int *)&leds_pwm_duty_pcts3_wh,
	.duty_pcts4 = (int *)&leds_pwm_duty_pcts4_wh,
	.duty_pcts5 = (int *)&leds_pwm_duty_pcts5,
	.duty_pcts6 = (int *)&leds_pwm_duty_pcts6_wh,
	.duty_pcts7 = (int *)&leds_pwm_duty_pcts7_wh,
	.duty_pcts8 = (int *)&leds_pwm_duty_pcts8,
	.duty_pcts12 = (int *)&leds_pwm_duty_pcts12,
	.duty_pcts13 = (int *)&leds_pwm_duty_pcts13,
	.duty_pcts14 = (int *)&leds_pwm_duty_pcts14,
	.duty_pcts17 = (int *)&leds_pwm_duty_pcts17_wh,
	.duty_pcts18 = (int *)&leds_pwm_duty_pcts18_wh,
	.duty_pcts19 = (int *)&leds_pwm_duty_pcts19_wh,
	.duty_pcts20 = (int *)&leds_pwm_duty_pcts20_wh,
	.duty_pcts29 = (int *)&leds_pwm_duty_pcts29_wh,
	.duty_pcts30 = (int *)&leds_pwm_duty_pcts30_wh,
	.duty_pcts31 = (int *)&leds_pwm_duty_pcts31_wh,
	.duty_pcts32 = (int *)&leds_pwm_duty_pcts32_wh,
	.duty_pcts37 = (int *)&leds_pwm_duty_pcts37_wh,
	.duty_pcts39 = (int *)&leds_pwm_duty_pcts39_wh,
	.duty_pcts40 = (int *)&leds_pwm_duty_pcts40_wh,
	.duty_pcts41 = (int *)&leds_pwm_duty_pcts41_wh,
	.duty_pcts42 = (int *)&leds_pwm_duty_pcts42_wh,
	.duty_pcts43 = (int *)&leds_pwm_duty_pcts43_wh,
	.duty_pcts44 = (int *)&leds_pwm_duty_pcts44_wh,
	.duty_pcts45 = (int *)&leds_pwm_duty_pcts45_wh,
	.duty_pcts46 = (int *)&leds_pwm_duty_pcts46_wh,
	.duty_pcts47 = (int *)&leds_pwm_duty_pcts47_wh,
	.duty_pcts101 = (int *)&leds_pwm_duty_pcts101_wh,
	.duty_pcts102 = (int *)&leds_pwm_duty_pcts102_wh,
	.num_duty_pcts = ARRAY_SIZE(leds_pwm_duty_pcts0),
};

static struct pwm_duty_cycles leds_pwm_duty_cycles_bk = {
	.duty_pcts0 = (int *)&leds_pwm_duty_pcts0,
	.duty_pcts1 = (int *)&leds_pwm_duty_pcts1_bk,
	.duty_pcts2 = (int *)&leds_pwm_duty_pcts2,
	.duty_pcts3 = (int *)&leds_pwm_duty_pcts3_bk,
	.duty_pcts4 = (int *)&leds_pwm_duty_pcts4_bk,
	.duty_pcts5 = (int *)&leds_pwm_duty_pcts5,
	.duty_pcts6 = (int *)&leds_pwm_duty_pcts6_bk,
	.duty_pcts7 = (int *)&leds_pwm_duty_pcts7_bk,
	.duty_pcts8 = (int *)&leds_pwm_duty_pcts8,
	.duty_pcts12 = (int *)&leds_pwm_duty_pcts12,
	.duty_pcts13 = (int *)&leds_pwm_duty_pcts13,
	.duty_pcts14 = (int *)&leds_pwm_duty_pcts14,
	.duty_pcts17 = (int *)&leds_pwm_duty_pcts17_bk,
	.duty_pcts18 = (int *)&leds_pwm_duty_pcts18_bk,
	.duty_pcts19 = (int *)&leds_pwm_duty_pcts19_bk,
	.duty_pcts20 = (int *)&leds_pwm_duty_pcts20_bk,
	.duty_pcts29 = (int *)&leds_pwm_duty_pcts29_bk,
	.duty_pcts30 = (int *)&leds_pwm_duty_pcts30_bk,
	.duty_pcts31 = (int *)&leds_pwm_duty_pcts31_bk,
	.duty_pcts32 = (int *)&leds_pwm_duty_pcts32_bk,
	.duty_pcts37 = (int *)&leds_pwm_duty_pcts37_bk,
	.duty_pcts39 = (int *)&leds_pwm_duty_pcts39_bk,
	.duty_pcts40 = (int *)&leds_pwm_duty_pcts40_bk,
	.duty_pcts41 = (int *)&leds_pwm_duty_pcts41_bk,
	.duty_pcts42 = (int *)&leds_pwm_duty_pcts42_bk,
	.duty_pcts43 = (int *)&leds_pwm_duty_pcts43_bk,
	.duty_pcts44 = (int *)&leds_pwm_duty_pcts44_bk,
	.duty_pcts45 = (int *)&leds_pwm_duty_pcts45_bk,
	.duty_pcts46 = (int *)&leds_pwm_duty_pcts46_bk,
	.duty_pcts47 = (int *)&leds_pwm_duty_pcts47_bk,
	.duty_pcts101 = (int *)&leds_pwm_duty_pcts101_bk,
	.duty_pcts102 = (int *)&leds_pwm_duty_pcts102_bk,
	.num_duty_pcts = ARRAY_SIZE(leds_pwm_duty_pcts0),
};
#endif
#endif
#endif	/* __LEDS_QPNP_H_INCLUDED */
